/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.actions.test;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.starters.shared.TextValidationFunction;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.actions.KtorActionUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ktor/actions/test/TestActionsUtils;", "", "<init>", "()V", "Companion", "intellij.ktor"})
public final class TestActionsUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KTOR_TEMPLATE_METHOD_NAME = "NAME";
    @NotNull
    private static final String KTOR_TEMPLATE_HTTP_METHOD = "HTTP_METHOD";
    @NotNull
    private static final String KTOR_TEMPLATE_ROUTE = "ROUTE";
    @NotNull
    private static final String KTOR_TEMPLATE_PACKAGE = "PACKAGE_NAME";
    @NotNull
    private static final String KTOR_TEMPLATE_BODY = "BODY";
    @NotNull
    private static final String KTOR_TEST_IMPORTS = "\nimport io.ktor.http.*\nimport io.ktor.server.testing.*\nimport kotlin.test.Test\n";
    @NotNull
    private static final String KTOR_TEST_IMPORTS_200 = "\nimport io.ktor.client.plugins.websocket.*\nimport io.ktor.client.request.*\nimport io.ktor.server.testing.*\nimport kotlin.test.Test\n";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final TextValidationFunction CHECK_NO_SLASHES;

    private static final String CHECK_NO_SLASHES$lambda$0(String fieldText) {
        if (fieldText != null && (StringsKt.contains$default((CharSequence)fieldText, (char)'/', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fieldText, (CharSequence)"'", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fieldText, (CharSequence)"\"", (boolean)false, (int)2, null))) {
            Object[] objectArray = new Object[]{fieldText};
            return KtorStarterBundle.INSTANCE.message("ktor.message.symbols.not.allowed.in.testfun", objectArray);
        }
        return null;
    }

    static {
        Logger logger = Logger.getInstance(TestActionsUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        CHECK_NO_SLASHES = TestActionsUtils::CHECK_NO_SLASHES$lambda$0;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J8\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J2\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006/"}, d2={"Lcom/intellij/ktor/actions/test/TestActionsUtils$Companion;", "", "<init>", "()V", "KTOR_TEMPLATE_METHOD_NAME", "", "KTOR_TEMPLATE_HTTP_METHOD", "KTOR_TEMPLATE_ROUTE", "KTOR_TEMPLATE_PACKAGE", "KTOR_TEMPLATE_BODY", "KTOR_TEST_IMPORTS", "KTOR_TEST_IMPORTS_200", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createTestMethodText", "descriptor", "Lcom/intellij/testIntegration/TestFramework;", "project", "Lcom/intellij/openapi/project/Project;", "name", "requestPath", "requestMethod", "ktorMajorVersion", "", "createTestClassFromCodeTemplate", "Lorg/jetbrains/uast/UClass;", "className", "fileTemplateDescriptor", "Lcom/intellij/ide/fileTemplates/FileTemplateDescriptor;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "srcPackage", "dstPackage", "fixImports", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "CHECK_NO_SLASHES", "Lcom/intellij/ide/starters/shared/TextValidationFunction;", "getCHECK_NO_SLASHES", "()Lcom/intellij/ide/starters/shared/TextValidationFunction;", "calculateTestName", "route", "methodName", "intellij.ktor"})
    @SourceDebugExtension(value={"SMAP\nTestActionsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestActionsUtils.kt\ncom/intellij/ktor/actions/test/TestActionsUtils$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n12033#2,10:184\n14060#2:194\n14061#2:197\n12043#2:198\n212#3:195\n212#3:200\n212#3:201\n1#4:196\n1#4:199\n*S KotlinDebug\n*F\n+ 1 TestActionsUtils.kt\ncom/intellij/ktor/actions/test/TestActionsUtils$Companion\n*L\n112#1:184,10\n112#1:194\n112#1:197\n112#1:198\n112#1:195\n139#1:200\n140#1:201\n112#1:196\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String createTestMethodText(@Nullable TestFramework descriptor, @NotNull Project project, @NotNull String name, @NotNull String requestPath, @NotNull String requestMethod, int ktorMajorVersion) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)requestPath, (String)"requestPath");
            Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
            TestFramework testFramework = descriptor;
            Intrinsics.checkNotNull((Object)testFramework);
            FileTemplateDescriptor templateDesc = TestIntegrationUtils.MethodKind.TEST.getFileTemplateDescriptor(testFramework);
            String string2 = templateDesc.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
            String templateName = string2;
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate(templateName);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getCodeTemplate(...)");
            FileTemplate fileTemplate2 = fileTemplate;
            try {
                String string3;
                Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
                Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
                Properties properties2 = properties;
                properties2.setProperty(TestActionsUtils.KTOR_TEMPLATE_METHOD_NAME, name);
                if (ktorMajorVersion >= 2) {
                    String string4 = requestMethod.toLowerCase(Locale.ROOT);
                    string3 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                } else {
                    string3 = KtorActionUtilsKt.camelCase$default(requestMethod, false, 2, null);
                }
                properties2.setProperty(TestActionsUtils.KTOR_TEMPLATE_HTTP_METHOD, string3);
                properties2.setProperty(TestActionsUtils.KTOR_TEMPLATE_ROUTE, requestPath);
                string = fileTemplate2.getText(properties2);
                Intrinsics.checkNotNull((Object)string);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                String string5 = fileTemplate2.getText();
                Intrinsics.checkNotNull((Object)string5);
                string = string5;
            }
            String templateText = string;
            String string6 = StringUtil.replace((String)templateText, (String)"${BODY}", (String)"");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"replace(...)");
            templateText = string6;
            return templateText;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final UClass createTestClassFromCodeTemplate(@NotNull String className, @NotNull FileTemplateDescriptor fileTemplateDescriptor, @NotNull PsiDirectory targetDirectory, @NotNull String srcPackage, @NotNull String dstPackage, int ktorMajorVersion) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)fileTemplateDescriptor, (String)"fileTemplateDescriptor");
            Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
            Intrinsics.checkNotNullParameter((Object)srcPackage, (String)"srcPackage");
            Intrinsics.checkNotNullParameter((Object)dstPackage, (String)"dstPackage");
            String string = fileTemplateDescriptor.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String templateName = string;
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)targetDirectory.getProject()).getCodeTemplate(templateName);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getCodeTemplate(...)");
            FileTemplate fileTemplate2 = fileTemplate;
            Properties properties = FileTemplateManager.getInstance((Project)targetDirectory.getProject()).getDefaultProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
            Properties defaultProperties = properties;
            Properties properties2 = new Properties(defaultProperties);
            properties2.setProperty(TestActionsUtils.KTOR_TEMPLATE_METHOD_NAME, className);
            properties2.setProperty("CLASS_NAME", className);
            properties2.setProperty(TestActionsUtils.KTOR_TEMPLATE_BODY, "");
            String fileName = className + ".kt";
            PsiFile psiFile = targetDirectory.findFile(fileName);
            if (psiFile != null) {
                Object object;
                PsiElement classPsi;
                UClass existingClass;
                Editor editor2;
                block19: {
                    Collection<Object> collection;
                    PsiFile existingFile;
                    block18: {
                        Object[] $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        existingFile = psiFile;
                        boolean bl = false;
                        properties2.setProperty(TestActionsUtils.KTOR_TEMPLATE_PACKAGE, "");
                        PsiElement[] psiElementArray = existingFile.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                        if (((Object[])psiElementArray).length == 0) {
                            existingFile.delete();
                            return Companion.createTestClassFromCodeTemplate(className, fileTemplateDescriptor, targetDirectory, srcPackage, dstPackage, ktorMajorVersion);
                        }
                        Project project = targetDirectory.getProject();
                        PsiElement[] psiElementArray2 = existingFile.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                        editor2 = CodeInsightUtil.positionCursor((Project)project, (PsiFile)existingFile, (PsiElement)((PsiElement)ArraysKt.first((Object[])psiElementArray2)));
                        PsiElement[] psiElementArray3 = existingFile.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"getChildren(...)");
                        Object[] objectArray = psiElementArray3;
                        boolean $i$f$mapNotNull22 = false;
                        void var19_26 = $this$mapNotNull$iv;
                        Collection<Object> destination$iv$iv2 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        int n = ((void)$this$forEach$iv$iv$iv).length;
                        for (int i = 0; i < n; ++i) {
                            UClass it$iv$iv;
                            void element$iv$iv$iv;
                            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                            boolean bl2 = false;
                            PsiElement it = (PsiElement)element$iv$iv;
                            boolean bl3 = false;
                            PsiElement $this$getUastParentOfType_u24default$iv = it;
                            boolean strict$iv = false;
                            boolean $i$f$getUastParentOfType = false;
                            if ((UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv) == null) continue;
                            boolean bl4 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        Iterable $i$f$mapNotNull22 = (List)destination$iv$iv2;
                        for (Collection<Object> destination$iv$iv2 : $i$f$mapNotNull22) {
                            UClass it = (UClass)destination$iv$iv2;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)className)) continue;
                            collection = destination$iv$iv2;
                            break block18;
                        }
                        collection = null;
                    }
                    existingClass = (UClass)collection;
                    if (existingClass == null) {
                        Editor editor3 = editor2;
                        Intrinsics.checkNotNull((Object)editor3);
                        editor3.getDocument().insertString(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)existingFile)), (CharSequence)fileTemplate2.getText(properties2));
                        PsiDocumentManager.getInstance((Project)targetDirectory.getProject()).commitDocument(editor2.getDocument());
                        return Companion.createTestClassFromCodeTemplate(className, fileTemplateDescriptor, targetDirectory, srcPackage, dstPackage, ktorMajorVersion);
                    }
                    PsiElement psiElement = existingClass.getSourcePsi();
                    if (psiElement == null) {
                        return null;
                    }
                    classPsi = psiElement;
                    PsiElement[] psiElementArray = classPsi.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    for (Object bl5 : (Object[])psiElementArray) {
                        PsiElement it = (PsiElement)bl5;
                        boolean bl = false;
                        String string2 = it.getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"KtClassBody", (boolean)false, (int)2, null)) continue;
                        object = bl5;
                        break block19;
                    }
                    object = null;
                }
                if (object == null) {
                    Editor editor4 = editor2;
                    Intrinsics.checkNotNull((Object)editor4);
                    editor4.getDocument().deleteString(PsiTreeUtilKt.getStartOffset((PsiElement)classPsi), PsiTreeUtilKt.getEndOffset((PsiElement)classPsi));
                    editor2.getDocument().insertString(PsiTreeUtilKt.getStartOffset((PsiElement)classPsi), (CharSequence)fileTemplate2.getText(properties2));
                    PsiDocumentManager.getInstance((Project)targetDirectory.getProject()).commitDocument(editor2.getDocument());
                    return Companion.createTestClassFromCodeTemplate(className, fileTemplateDescriptor, targetDirectory, srcPackage, dstPackage, ktorMajorVersion);
                }
                return existingClass;
            }
            try {
                PsiElement uClass;
                PsiElement psiElement;
                Object $this$getUastParentOfType_u24default$iv;
                PsiElement psiElement2;
                PsiElement psiElement3;
                block20: {
                    String string3;
                    String it = string3 = dstPackage;
                    boolean bl = false;
                    String packageName = ((CharSequence)it).length() > 0 ? string3 : null;
                    String string4 = packageName;
                    if (string4 == null) {
                        string4 = "";
                    }
                    properties2.setProperty(TestActionsUtils.KTOR_TEMPLATE_PACKAGE, string4);
                    PsiElement psiElement4 = FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate2, (String)fileName, (Properties)properties2, (PsiDirectory)targetDirectory);
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"createFromTemplate(...)");
                    PsiElement psiElement5 = psiElement3 = psiElement4;
                    if (psiElement5 instanceof PsiClass) {
                        PsiElement $this$getUastParentOfType_u24default$iv2 = psiElement3;
                        strict$iv = 0;
                        $i$f$getUastParentOfType = 0;
                        psiElement2 = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv2, UClass.class, strict$iv != 0);
                    } else if (psiElement5 instanceof PsiFile) {
                        PsiElement[] psiElementArray = ((PsiFile)psiElement3).getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                        Object[] objectArray = psiElementArray;
                        $i$f$getUastParentOfType = objectArray.length;
                        for (strict$iv = 0; strict$iv < $i$f$getUastParentOfType; ++strict$iv) {
                            PsiElement it2 = (PsiElement)objectArray[strict$iv];
                            boolean bl6 = false;
                            $this$getUastParentOfType_u24default$iv = it2;
                            boolean strict$iv = false;
                            boolean $i$f$getUastParentOfType = false;
                            UClass uClass2 = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
                            psiElement2 = uClass2;
                            if (uClass2 == null) {
                                continue;
                            }
                            break block20;
                        }
                        psiElement2 = null;
                    } else {
                        psiElement2 = null;
                    }
                }
                if ((psiElement = (uClass = psiElement2)) != null && (psiElement = psiElement.getSourcePsi()) != null) {
                    void it;
                    PsiElement psiClass = psiElement;
                    boolean bl = false;
                    Editor editor5 = CodeInsightUtil.positionCursor((Project)targetDirectory.getProject(), (PsiFile)psiElement3.getContainingFile(), (PsiElement)psiClass);
                    PsiFile psiFile2 = psiElement3.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                    Editor editor6 = editor5;
                    Intrinsics.checkNotNull((Object)editor6);
                    Project project = targetDirectory.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    String string5 = srcPackage;
                    $this$getUastParentOfType_u24default$iv = string5;
                    Project project2 = project;
                    Editor editor7 = editor6;
                    PsiFile psiFile3 = psiFile2;
                    Companion companion = Companion;
                    boolean bl7 = false;
                    boolean bl8 = !Intrinsics.areEqual((Object)it, (Object)dstPackage);
                    companion.fixImports(psiFile3, editor7, project2, bl8 ? string5 : null, ktorMajorVersion);
                }
                psiFile = uClass;
            }
            catch (Exception e) {
                psiFile = null;
            }
            return psiFile;
        }

        private final void fixImports(PsiFile file, Editor editor2, Project project, String srcPackage, int ktorMajorVersion) {
            block2: {
                Object object;
                block1: {
                    PsiElement[] psiElementArray = file.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    for (Object object2 : (Object[])psiElementArray) {
                        PsiElement it = (PsiElement)object2;
                        boolean bl = false;
                        String string = it.getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Import", (boolean)false, (int)2, null)) continue;
                        object = object2;
                        break block1;
                    }
                    object = null;
                }
                PsiElement psiElement = (PsiElement)object;
                if (psiElement == null) break block2;
                int offset = PsiTreeUtilKt.getEndOffset((PsiElement)psiElement);
                boolean bl = false;
                editor2.getDocument().insertString(offset, (CharSequence)(ktorMajorVersion >= 2 ? TestActionsUtils.KTOR_TEST_IMPORTS_200 : TestActionsUtils.KTOR_TEST_IMPORTS));
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
            }
        }

        @NotNull
        public final TextValidationFunction getCHECK_NO_SLASHES() {
            return CHECK_NO_SLASHES;
        }

        @NotNull
        public final String calculateTestName(@NotNull String route, @NotNull String methodName) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            return "test" + KtorActionUtilsKt.calculateRouteMethodName(route, methodName, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

