/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelHost;
import org.jetbrains.kotlinx.jupyter.api.LibraryLoader;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesDefinitionDeclaration;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesInstantiable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesProducerDeclaration;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesScanResult;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinitionProducer;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.util.AcceptanceRule;
import org.jetbrains.kotlinx.jupyter.util.AcceptanceRulesKt;
import org.slf4j.Logger;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\f\b\u0000\u0010\u0013*\u0006\u0012\u0002\b\u00030\u0014*\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\fj\u0002`\r0\u00190\u0015H\u0002J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012*\b\u0012\u0004\u0012\u00020\u001b0\u0015H\u0002JN\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0#2\u0018\b\u0002\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\fj\u0002`\r0\u00190\u0012J<\u0010$\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0#2\u0006\u0010%\u001a\u00020&H\u0016J2\u0010'\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0018\b\u0002\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\fj\u0002`\r0\u00190\u0012H\u0002J:\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0#H\u0002J9\u0010*\u001a\u0004\u0018\u0001H+\"\u0004\b\u0000\u0010+2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0\u00142\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0012H\u0002\u00a2\u0006\u0002\u0010/J\u001e\u0010*\u001a\u00020.*\u0006\u0012\u0002\b\u0003002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner;", "Lorg/jetbrains/kotlinx/jupyter/api/LibraryLoader;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;)V", "logger", "Lorg/slf4j/Logger;", "jsonParser", "Lkotlinx/serialization/json/Json;", "processedFQNs", "", "", "Lorg/jetbrains/kotlinx/jupyter/api/TypeName;", "discardedFQNs", "processedDescriptors", "Lkotlinx/serialization/json/JsonElement;", "filterNamesToLoad", "", "I", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesInstantiable;", "", "host", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelHost;", "integrationTypeNameRules", "Lorg/jetbrains/kotlinx/jupyter/util/AcceptanceRule;", "filterDescriptorsToLoad", "Lkotlinx/serialization/json/JsonObject;", "addLibrariesFromClassLoader", "", "classLoader", "Ljava/lang/ClassLoader;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "libraryOptions", "", "addLibrariesByScanResult", "scanResult", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesScanResult;", "scanForLibraries", "instantiateLibraries", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "instantiate", "T", "data", "arguments", "", "(Ljava/lang/ClassLoader;Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesInstantiable;Ljava/util/List;)Ljava/lang/Object;", "Ljava/lang/Class;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nLibrariesScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibrariesScanner.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,229:1\n777#2:230\n873#2,2:231\n777#2:233\n873#2,2:234\n1586#2:237\n1661#2,2:238\n1663#2:241\n1651#2:242\n1915#2:243\n1916#2:245\n1652#2:246\n1915#2,2:247\n1915#2:249\n1916#2:254\n1786#2,3:256\n1915#2,2:261\n205#3:236\n222#3:240\n1#4:244\n129#5:250\n158#5,3:251\n6720#6:255\n37#7,2:259\n*S KotlinDebug\n*F\n+ 1 LibrariesScanner.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner\n*L\n40#1:230\n40#1:231,2\n64#1:233\n64#1:234,2\n104#1:237\n104#1:238,2\n104#1:241\n149#1:242\n149#1:243\n149#1:245\n149#1:246\n155#1:247,2\n165#1:249\n165#1:254\n210#1:256,3\n158#1:261,2\n76#1:236\n106#1:240\n149#1:244\n167#1:250\n167#1:251,3\n197#1:255\n216#1:259,2\n*E\n"})
public final class LibrariesScanner
implements LibraryLoader {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Json jsonParser;
    @NotNull
    private final Set<String> processedFQNs;
    @NotNull
    private final Set<String> discardedFQNs;
    @NotNull
    private final Set<JsonElement> processedDescriptors;

    public LibrariesScanner(@NotNull KernelLoggerFactory loggerFactory) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        this.jsonParser = JsonKt.Json$default(null, LibrariesScanner::jsonParser$lambda$0, (int)1, null);
        this.processedFQNs = new LinkedHashSet();
        this.discardedFQNs = new LinkedHashSet();
        this.processedDescriptors = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    private final <I extends LibrariesInstantiable<?>> List<I> filterNamesToLoad(Iterable<? extends I> $this$filterNamesToLoad, KotlinKernelHost host2, Iterable<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$filterTo$iv$iv;
        Iterable<? extends I> $this$filter$iv = $this$filterNamesToLoad;
        boolean $i$f$filter = false;
        Iterable<? extends I> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            LibrariesInstantiable it = (LibrariesInstantiable)element$iv$iv;
            boolean bl2 = false;
            String typeName = it.getFqn();
            Object object = new Boolean[]{host2.acceptsIntegrationTypeName(typeName), AcceptanceRulesKt.accepts(integrationTypeNameRules, typeName)};
            Boolean acceptance = AcceptanceRulesKt.unionAcceptance(object);
            this.logger.debug("Acceptance result for " + typeName + ": " + acceptance);
            object = acceptance;
            if (Intrinsics.areEqual((Object)object, (Object)true)) {
                bl = this.processedFQNs.add(typeName);
            } else if (Intrinsics.areEqual((Object)object, (Object)false)) {
                this.discardedFQNs.add(typeName);
                bl = false;
            } else if (object == null) {
                bl = !this.discardedFQNs.contains(typeName) && this.processedFQNs.add(typeName);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsonObject> filterDescriptorsToLoad(Iterable<JsonObject> $this$filterDescriptorsToLoad) {
        void $this$filterTo$iv$iv;
        Iterable<JsonObject> $this$filter$iv = $this$filterDescriptorsToLoad;
        boolean $i$f$filter = false;
        Iterable<JsonObject> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonObject it = (JsonObject)element$iv$iv;
            boolean bl = false;
            if (!this.processedDescriptors.add((JsonElement)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void addLibrariesFromClassLoader(@NotNull ClassLoader classLoader, @NotNull KotlinKernelHost host2, @NotNull Notebook notebook, @NotNull Map<String, String> libraryOptions, @NotNull List<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter(libraryOptions, (String)"libraryOptions");
        Intrinsics.checkNotNullParameter(integrationTypeNameRules, (String)"integrationTypeNameRules");
        LibrariesScanResult scanResult = this.scanForLibraries(classLoader, host2, integrationTypeNameRules);
        Json json = (Json)Json.Default;
        LibrariesScanResult value$iv = scanResult;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        this.logger.debug("Scanning for libraries is done. Detected FQNs: " + this_$iv.encodeToString((SerializationStrategy)LibrariesScanResult.Companion.serializer(), (Object)value$iv));
        List<LibraryDefinition> libraries = this.instantiateLibraries(classLoader, scanResult, notebook, libraryOptions);
        this.logger.debug("Number of detected definitions: " + libraries.size());
        host2.addLibraries((Collection<? extends LibraryDefinition>)libraries);
    }

    public static /* synthetic */ void addLibrariesFromClassLoader$default(LibrariesScanner librariesScanner, ClassLoader classLoader, KotlinKernelHost kotlinKernelHost, Notebook notebook, Map map, List list, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        librariesScanner.addLibrariesFromClassLoader(classLoader, kotlinKernelHost, notebook, map, list);
    }

    @Override
    public void addLibrariesByScanResult(@NotNull KotlinKernelHost host2, @NotNull Notebook notebook, @NotNull ClassLoader classLoader, @NotNull Map<String, String> libraryOptions, @NotNull LibrariesScanResult scanResult) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(libraryOptions, (String)"libraryOptions");
        Intrinsics.checkNotNullParameter((Object)scanResult, (String)"scanResult");
        host2.scheduleExecution(arg_0 -> LibrariesScanner.addLibrariesByScanResult$lambda$0(this, classLoader, scanResult, notebook, libraryOptions, host2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final LibrariesScanResult scanForLibraries(ClassLoader classLoader, KotlinKernelHost host2, List<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Enumeration<URL> enumeration = classLoader.getResources("META-INF/kotlin-jupyter-libraries/libraries.json");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable iterable = arrayList;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void this_$iv;
            void url;
            URL uRL = (URL)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)url);
            Json json = url;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)json);
            String contents = new String(byArray, charset);
            json = this.jsonParser;
            String string$iv = contents;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            collection.add((LibrariesScanResult)this_$iv.decodeFromString((DeserializationStrategy)LibrariesScanResult.Companion.serializer(), string$iv));
        }
        List results = (List)destination$iv$iv;
        List definitions = new ArrayList();
        List producers = new ArrayList();
        List descriptors = new ArrayList();
        for (LibrariesScanResult result2 : results) {
            definitions.addAll((Collection)result2.getDefinitions());
            producers.addAll((Collection)result2.getProducers());
            descriptors.addAll((Collection)result2.getDescriptors());
        }
        return new LibrariesScanResult(LibrariesScanner.scanForLibraries$filterNames(definitions, this, host2, integrationTypeNameRules), LibrariesScanner.scanForLibraries$filterNames(producers, this, host2, integrationTypeNameRules), this.filterDescriptorsToLoad(descriptors));
    }

    static /* synthetic */ LibrariesScanResult scanForLibraries$default(LibrariesScanner librariesScanner, ClassLoader classLoader, KotlinKernelHost kotlinKernelHost, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return librariesScanner.scanForLibraries(classLoader, kotlinKernelHost, list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LibraryDefinition> instantiateLibraries(ClassLoader classLoader, LibrariesScanResult scanResult, Notebook notebook, Map<String, String> libraryOptions) {
        Object declaration;
        void $this$mapNotNullTo$iv;
        List definitions = new ArrayList();
        Object object = new Object[]{notebook, libraryOptions};
        List arguments = CollectionsKt.listOf((Object[])object);
        object = scanResult.getDefinitions();
        Collection destination$iv = definitions;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            LibraryDefinition it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            declaration = (LibrariesDefinitionDeclaration)element$iv;
            boolean bl2 = false;
            if ((LibraryDefinition)LibrariesScanner.instantiateLibraries$withErrorsHandling(this, (LibrariesInstantiable)declaration, () -> LibrariesScanner.instantiateLibraries$lambda$0$0(this, classLoader, (LibrariesDefinitionDeclaration)declaration, arguments)) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Iterable $this$forEach$iv = scanResult.getProducers();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LibrariesProducerDeclaration declaration2 = (LibrariesProducerDeclaration)element$iv;
            boolean bl = false;
            LibrariesScanner.instantiateLibraries$withErrorsHandling(this, declaration2, () -> LibrariesScanner.instantiateLibraries$lambda$1$0(this, classLoader, declaration2, arguments, notebook, definitions));
        }
        $this$forEach$iv = scanResult.getDescriptors();
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            JsonObject it = (JsonObject)element$iv;
            boolean bl = false;
            LibraryDescriptor descriptor = ParsingKt.parseLibraryDescriptor(it);
            Map<String, String> $this$map$iv = libraryOptions;
            boolean $i$f$map = false;
            declaration = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add(new Variable(name, value, false, 4, null));
            }
            List arguments2 = (List)destination$iv$iv;
            LibraryDefinition definition = LibraryDescriptor.convertToDefinition$default(descriptor, arguments2, null, 2, null);
            definitions.add(definition);
        }
        return definitions;
    }

    private final <T> T instantiate(ClassLoader classLoader, LibrariesInstantiable<T> data, List<? extends Object> arguments) {
        Class<?> clazz = classLoader.loadClass(data.getFqn());
        if (clazz == null) {
            this.logger.warn("Library " + data.getFqn() + " wasn't found in classloader " + classLoader);
            return null;
        }
        return (T)this.instantiate(clazz, arguments);
    }

    /*
     * WARNING - void declaration
     */
    private final Object instantiate(Class<?> $this$instantiate, List<? extends Object> arguments) {
        void $this$sortedByDescending$iv;
        Object obj;
        Object object = obj = JvmClassMappingKt.getKotlinClass($this$instantiate).getObjectInstance();
        if (object != null) {
            return object;
        }
        int argsCount = arguments.size();
        Constructor<?>[] constructorArray = $this$instantiate.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
        Object[] objectArray = constructorArray;
        boolean $i$f$sortedByDescending = false;
        List myConstructors = ArraysKt.sortedWith((Object[])$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Constructor it = (Constructor)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getParameterCount());
                it = (Constructor)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getParameterCount()));
            }
        });
        StringBuilder errorStringBuilder = new StringBuilder();
        for (Constructor constructor : myConstructors) {
            boolean isSuitable;
            int parameterCount;
            block7: {
                boolean bl;
                void $this$all$iv;
                parameterCount = constructor.getParameterCount();
                if (parameterCount > argsCount) {
                    errorStringBuilder.append("\t" + constructor + ": more than " + argsCount + " parameters").append('\n');
                    continue;
                }
                Class<?>[] classArray = constructor.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                Iterable iterable = ArraysKt.zip((Object[])classArray, (Iterable)arguments);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Object arg;
                        Pair pair2 = (Pair)element$iv;
                        boolean bl2 = false;
                        Class paramType = (Class)pair2.component1();
                        if (paramType.isInstance(arg = pair2.component2())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = isSuitable = true;
                }
            }
            if (!isSuitable) {
                errorStringBuilder.append("\t" + constructor + ": wrong parameter types").append('\n');
                continue;
            }
            Collection $this$toTypedArray$iv = CollectionsKt.take((Iterable)arguments, (int)parameterCount);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            Object t = constructor.newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
            return t;
        }
        Object notFoundReason = myConstructors.isEmpty() ? "no single constructor found" : "no single constructor is applicable\n" + errorStringBuilder;
        throw new ReplException("No suitable constructor found. Reason: " + (String)notFoundReason, null, 2, null);
    }

    private static final Unit jsonParser$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final Unit addLibrariesByScanResult$lambda$0(LibrariesScanner this$0, ClassLoader $classLoader, LibrariesScanResult $scanResult, Notebook $notebook, Map $libraryOptions, KotlinKernelHost $host, KotlinKernelHost $this$scheduleExecution) {
        Intrinsics.checkNotNullParameter((Object)$this$scheduleExecution, (String)"$this$scheduleExecution");
        List<LibraryDefinition> libraries = this$0.instantiateLibraries($classLoader, $scanResult, $notebook, $libraryOptions);
        $host.addLibraries((Collection<? extends LibraryDefinition>)libraries);
        return Unit.INSTANCE;
    }

    private static final <I extends LibrariesInstantiable<?>> List<I> scanForLibraries$filterNames(Iterable<? extends I> $this$scanForLibraries_u24filterNames, LibrariesScanner this$0, KotlinKernelHost $host, List<? extends AcceptanceRule<String>> $integrationTypeNameRules) {
        return this$0.filterNamesToLoad($this$scanForLibraries_u24filterNames, $host, (Iterable<? extends AcceptanceRule<String>>)$integrationTypeNameRules);
    }

    private static final LibraryDefinition instantiateLibraries$lambda$0$0(LibrariesScanner this$0, ClassLoader $classLoader, LibrariesDefinitionDeclaration $declaration, List $arguments) {
        return (LibraryDefinition)this$0.instantiate($classLoader, $declaration, $arguments);
    }

    private static final Unit instantiateLibraries$lambda$1$0(LibrariesScanner this$0, ClassLoader $classLoader, LibrariesProducerDeclaration $declaration, List $arguments, Notebook $notebook, List $definitions) {
        block1: {
            LibraryDefinitionProducer libraryDefinitionProducer;
            LibraryDefinitionProducer libraryDefinitionProducer2 = (LibraryDefinitionProducer)this$0.instantiate($classLoader, $declaration, $arguments);
            if (libraryDefinitionProducer2 == null) break block1;
            LibraryDefinitionProducer $this$instantiateLibraries_u24lambda_u241_u240_u240 = libraryDefinitionProducer = libraryDefinitionProducer2;
            boolean bl = false;
            Iterable $this$forEach$iv = $this$instantiateLibraries_u24lambda_u241_u240_u240.getDefinitions($notebook);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryDefinition it = (LibraryDefinition)element$iv;
                boolean bl2 = false;
                $definitions.add(it);
            }
        }
        return Unit.INSTANCE;
    }

    private static final <T> T instantiateLibraries$withErrorsHandling(LibrariesScanner this$0, LibrariesInstantiable<?> declaration, Function0<? extends T> action) {
        Object object;
        try {
            object = action.invoke();
        }
        catch (Throwable e) {
            String errorMessage = "Failed to load library integration class '" + declaration.getFqn() + "'";
            LoggingKt.errorForUser$default(this$0.logger, null, errorMessage, e, 1, null);
            throw new ReplException(errorMessage, e);
        }
        return (T)object;
    }
}

