/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageData;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHeader;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterReceiveSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSendSocket;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImpl;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001a,\u0010\u0004\u001a\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001ah\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00022\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u001a*\u0010\u0018\u001a\u00020\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010!\u001a\u0004\u0018\u00010\u0010\u001a\u0012\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010\f\u001a\u00020\u0001\u001a\n\u0010%\u001a\u00020\u0001*\u00020&\"\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u001d\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"toMessage", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "toRawMessage", "makeRawMessage", "zmqIdentities", "", "", "dataJson", "Lkotlinx/serialization/json/JsonObject;", "buffers", "makeReplyMessage", "msg", "msgType", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageType;", "sessionId", "", "header", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageHeader;", "parentHeader", "metadata", "Lkotlinx/serialization/json/JsonElement;", "content", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageContent;", "makeHeader", "incomingMsg", "ISO8601DateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "ISO8601DateNow", "getISO8601DateNow", "()Ljava/lang/String;", "type", "username", "sendMessage", "", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSendSocket;", "receiveMessage", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterReceiveSocket;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Message.kt\norg/jetbrains/kotlinx/jupyter/messaging/MessageKt\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n335#2:125\n324#2:126\n335#2:127\n335#2:129\n1#3:128\n*S KotlinDebug\n*F\n+ 1 Message.kt\norg/jetbrains/kotlinx/jupyter/messaging/MessageKt\n*L\n43#1:125\n50#1:126\n81#1:127\n93#1:129\n*E\n"})
public final class MessageKt {
    private static final DateTimeFormatter ISO8601DateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSxxx'['VV']'");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Message toMessage(@NotNull RawMessage $this$toMessage) {
        void $this$decodeFromJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toMessage, (String)"<this>");
        List list = $this$toMessage.getZmqIdentities();
        Json json = RawMessageImplKt.getMessageFormat();
        JsonElement json$iv = (JsonElement)RawMessageImplKt.getData((RawMessage)$this$toMessage);
        boolean $i$f$decodeFromJsonElement = false;
        $this$decodeFromJsonElement$iv.getSerializersModule();
        return new Message(list, (MessageData)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)MessageData.Companion.serializer(), json$iv), $this$toMessage.getBuffers());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RawMessage toRawMessage(@NotNull Message $this$toRawMessage) {
        void $this$encodeToJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toRawMessage, (String)"<this>");
        List<byte[]> list = $this$toRawMessage.getZmqIdentities();
        Json json = RawMessageImplKt.getMessageFormat();
        MessageData value$iv = $this$toRawMessage.getData();
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        return MessageKt.makeRawMessage(list, JsonElementKt.getJsonObject((JsonElement)$this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)MessageData.Companion.serializer(), (Object)value$iv)), $this$toRawMessage.getBuffers());
    }

    @NotNull
    public static final RawMessage makeRawMessage(@NotNull List<byte[]> zmqIdentities, @NotNull JsonObject dataJson, @NotNull List<byte[]> buffers) {
        Intrinsics.checkNotNullParameter(zmqIdentities, (String)"zmqIdentities");
        Intrinsics.checkNotNullParameter((Object)dataJson, (String)"dataJson");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        Object object = dataJson.get((Object)"header");
        Intrinsics.checkNotNull((Object)object);
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)((JsonElement)object));
        Object object2 = dataJson.get((Object)"parent_header");
        JsonObject jsonObject2 = object2 instanceof JsonObject ? (JsonObject)object2 : null;
        object2 = dataJson.get((Object)"metadata");
        JsonObject jsonObject3 = object2 instanceof JsonObject ? (JsonObject)object2 : null;
        Object object3 = dataJson.get((Object)"content");
        Intrinsics.checkNotNull((Object)object3);
        return (RawMessage)new RawMessageImpl(zmqIdentities, jsonObject, jsonObject2, jsonObject3, (JsonElement)object3, buffers);
    }

    public static /* synthetic */ RawMessage makeRawMessage$default(List list, JsonObject jsonObject, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return MessageKt.makeRawMessage(list, jsonObject, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Message makeReplyMessage(@NotNull RawMessage msg, @Nullable MessageType msgType, @Nullable String sessionId, @Nullable MessageHeader header, @Nullable MessageHeader parentHeader, @Nullable JsonElement metadata, @Nullable MessageContent content, @Nullable List<byte[]> buffers) {
        MessageHeader messageHeader;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        List list = msg.getZmqIdentities();
        MessageHeader messageHeader2 = header;
        if (messageHeader2 == null) {
            messageHeader2 = MessageKt.makeHeader(msgType, msg, sessionId);
        }
        if ((messageHeader = parentHeader) == null) {
            void $this$decodeFromJsonElement$iv;
            Json json = RawMessageImplKt.getMessageFormat();
            JsonElement json$iv = (JsonElement)msg.getHeader();
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            messageHeader = (MessageHeader)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)MessageHeader.Companion.serializer(), json$iv);
        }
        MessageData messageData = new MessageData(messageHeader2, messageHeader, metadata, content);
        List list2 = buffers;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return new Message(list, messageData, list2);
    }

    public static /* synthetic */ Message makeReplyMessage$default(RawMessage rawMessage, MessageType messageType, String string, MessageHeader messageHeader, MessageHeader messageHeader2, JsonElement jsonElement, MessageContent messageContent, List list, int n, Object object) {
        if ((n & 2) != 0) {
            messageType = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            messageHeader = null;
        }
        if ((n & 0x10) != 0) {
            messageHeader2 = null;
        }
        if ((n & 0x20) != 0) {
            jsonElement = null;
        }
        if ((n & 0x40) != 0) {
            messageContent = null;
        }
        if ((n & 0x80) != 0) {
            list = null;
        }
        return MessageKt.makeReplyMessage(rawMessage, messageType, string, messageHeader, messageHeader2, jsonElement, messageContent, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MessageHeader makeHeader(@Nullable MessageType msgType, @Nullable RawMessage incomingMsg, @Nullable String sessionId) {
        Object object;
        Object object2;
        MessageType messageType;
        MessageHeader parentHeader;
        MessageHeader messageHeader;
        RawMessage rawMessage = incomingMsg;
        if (rawMessage != null && (rawMessage = rawMessage.getHeader()) != null) {
            void $this$decodeFromJsonElement$iv;
            RawMessage it = rawMessage;
            boolean bl = false;
            Json json = RawMessageImplKt.getMessageFormat();
            JsonElement json$iv = (JsonElement)it;
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            messageHeader = (MessageHeader)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)MessageHeader.Companion.serializer(), json$iv);
        } else {
            messageHeader = parentHeader = null;
        }
        if ((messageType = msgType) == null) {
            messageType = MessageType.NONE;
        }
        if ((object2 = parentHeader) == null || (object2 = ((MessageHeader)object2).getSession()) == null) {
            object2 = sessionId;
        }
        if ((object = parentHeader) == null || (object = ((MessageHeader)object).getUsername()) == null) {
            object = "kernel";
        }
        return MessageKt.makeHeader(messageType, (String)object2, (String)object);
    }

    public static /* synthetic */ MessageHeader makeHeader$default(MessageType messageType, RawMessage rawMessage, String string, int n, Object object) {
        if ((n & 1) != 0) {
            messageType = null;
        }
        if ((n & 2) != 0) {
            rawMessage = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return MessageKt.makeHeader(messageType, rawMessage, string);
    }

    @NotNull
    public static final String getISO8601DateNow() {
        String string = ZonedDateTime.now().format(ISO8601DateFormatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final MessageHeader makeHeader(@NotNull MessageType type2, @Nullable String sessionId, @Nullable String username) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new MessageHeader(string, type2, sessionId, username, "5.3", MessageKt.getISO8601DateNow());
    }

    public static final void sendMessage(@NotNull JupyterSendSocket $this$sendMessage, @NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)$this$sendMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        $this$sendMessage.sendRawMessage(MessageKt.toRawMessage(msg));
    }

    @NotNull
    public static final Message receiveMessage(@NotNull JupyterReceiveSocket $this$receiveMessage) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)$this$receiveMessage, (String)"<this>");
        return MessageKt.toMessage($this$receiveMessage.receiveRawMessage());
    }
}

