/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.ws;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.messaging.MessageKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketTypeKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.slf4j.Logger;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/jupyter/ws/WsMessageHandler;", "", "logger", "Lorg/slf4j/Logger;", "onMessageReceive", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "", "<init>", "(Lorg/slf4j/Logger;Lkotlin/jvm/functions/Function2;)V", "onMessage", "message", "", "Ljava/nio/ByteBuffer;", "handleMessage", "byteBuffers", "", "", "ws-server"})
@SourceDebugExtension(value={"SMAP\nWsMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WsMessageHandler.kt\norg/jetbrains/kotlinx/jupyter/ws/WsMessageHandler\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n222#2:79\n296#3,2:80\n*S KotlinDebug\n*F\n+ 1 WsMessageHandler.kt\norg/jetbrains/kotlinx/jupyter/ws/WsMessageHandler\n*L\n54#1:79\n62#1:80,2\n*E\n"})
public final class WsMessageHandler {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Function2<JupyterSocketType, RawMessage, Unit> onMessageReceive;

    public WsMessageHandler(@NotNull Logger logger, @NotNull Function2<? super JupyterSocketType, ? super RawMessage, Unit> onMessageReceive) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(onMessageReceive, (String)"onMessageReceive");
        this.logger = logger;
        this.onMessageReceive = onMessageReceive;
    }

    public final void onMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.handleMessage(message, CollectionsKt.emptyList());
    }

    public final void onMessage(@NotNull ByteBuffer message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IntBuffer intBuffer = message.asIntBuffer();
        int buffersAmount = intBuffer.get() - 1;
        int n = 0;
        int n2 = buffersAmount + 1;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = intBuffer.get();
        }
        int[] offsets = nArray;
        Iterator buffers = SequencesKt.zipWithNext((Sequence)SequencesKt.plus((Sequence)ArraysKt.asSequence((int[])offsets), (Object)message.limit()), (arg_0, arg_1) -> WsMessageHandler.onMessage$lambda$0(message, arg_0, arg_1)).iterator();
        String message2 = StringsKt.decodeToString((byte[])((byte[])buffers.next()));
        this.handleMessage(message2, SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)buffers)));
    }

    /*
     * WARNING - void declaration
     */
    private final void handleMessage(String message, List<byte[]> byteBuffers) {
        Object v2;
        Object channel;
        JsonObject json;
        block3: {
            void this_$iv;
            Json json2 = (Json)Json.Default;
            String string$iv = message;
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv.getSerializersModule();
            KType kType = Reflection.typeOf(JsonElement.class);
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            json = JsonElementKt.getJsonObject((JsonElement)((JsonElement)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv)));
            Object object = (JsonElement)json.get((Object)"channel");
            if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
                WsMessageHandler $this$handleMessage_u24lambda_u240 = this;
                boolean bl = false;
                $this$handleMessage_u24lambda_u240.logger.warn("No channel specified.");
                return;
            }
            channel = object;
            Iterable $this$firstOrNull$iv = (Iterable)JupyterSocketType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JupyterSocketType it = (JupyterSocketType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)JupyterSocketTypeKt.getJupyterName((JupyterSocketType)it), (Object)channel)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        JupyterSocketType jupyterSocketType = v2;
        if (jupyterSocketType == null) {
            WsMessageHandler $this$handleMessage_u24lambda_u242 = this;
            boolean bl = false;
            $this$handleMessage_u24lambda_u242.logger.warn("Unknown channel: " + (String)channel);
            return;
        }
        JupyterSocketType socketType = jupyterSocketType;
        RawMessage rawMessage = MessageKt.makeRawMessage(CollectionsKt.emptyList(), json, byteBuffers);
        this.onMessageReceive.invoke((Object)socketType, (Object)rawMessage);
    }

    private static final byte[] onMessage$lambda$0(ByteBuffer $message, int start2, int end) {
        byte[] byArray;
        $message.position(start2);
        byte[] it = byArray = new byte[end - start2];
        boolean bl = false;
        $message.get(it);
        return byArray;
    }
}

