/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.startup.importSettings.data.DialogImportItem;
import com.intellij.ide.startup.importSettings.data.IconProductSize;
import com.intellij.ide.startup.importSettings.data.ImportFromProduct;
import com.intellij.ide.startup.importSettings.data.SettingsContributor;
import com.intellij.ide.startup.importSettings.jb.JbProductInfo;
import com.intellij.ide.startup.importSettings.jb.NameMappings;
import com.intellij.ide.startup.importSettings.transfer.IconExKt;
import com.intellij.ide.startup.importSettings.transfer.ProgressIndicatorAdapter;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsContributor;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsProgressIndicator;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.openapi.progress.ProgressIndicator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/TransferSettingsProgress;", "Lcom/intellij/ide/startup/importSettings/data/ImportFromProduct;", "from", "Lcom/intellij/ide/startup/importSettings/data/DialogImportItem;", "<init>", "(Lcom/intellij/ide/startup/importSettings/data/DialogImportItem;)V", "sourceIdeVersion", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "(Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;)V", "productInfo", "Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;", "(Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;)V", "getFrom", "()Lcom/intellij/ide/startup/importSettings/data/DialogImportItem;", "message", "", "getMessage", "()Ljava/lang/Void;", "progress", "Lcom/intellij/ide/startup/importSettings/transfer/TransferSettingsProgressIndicator;", "getProgress", "()Lcom/intellij/ide/startup/importSettings/transfer/TransferSettingsProgressIndicator;", "to", "getTo", "createProgressIndicatorAdapter", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.ide.startup.importSettings"})
public final class TransferSettingsProgress
implements ImportFromProduct {
    @NotNull
    private final DialogImportItem from;
    @Nullable
    private final Void message;
    @NotNull
    private final TransferSettingsProgressIndicator progress;
    @NotNull
    private final DialogImportItem to;

    public TransferSettingsProgress(@NotNull DialogImportItem from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this.from = from;
        this.progress = new TransferSettingsProgressIndicator();
        this.to = DialogImportItem.Companion.self();
    }

    @Override
    @NotNull
    public DialogImportItem getFrom() {
        return this.from;
    }

    public TransferSettingsProgress(@NotNull IdeVersion sourceIdeVersion) {
        Intrinsics.checkNotNullParameter((Object)sourceIdeVersion, (String)"sourceIdeVersion");
        SettingsContributor settingsContributor = new TransferSettingsContributor(sourceIdeVersion);
        Icon icon = IconExKt.icon(sourceIdeVersion.getTransferableId(), IconProductSize.LARGE);
        if (icon == null) {
            Icon icon2 = AllIcons.Actions.Stub;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Stub");
        }
        this(new DialogImportItem(settingsContributor, icon));
    }

    public TransferSettingsProgress(@NotNull JbProductInfo productInfo) {
        Intrinsics.checkNotNullParameter((Object)productInfo, (String)"productInfo");
        SettingsContributor settingsContributor = productInfo;
        Icon icon = NameMappings.INSTANCE.getIcon(productInfo.getCodeName$intellij_ide_startup_importSettings(), IconProductSize.LARGE);
        if (icon == null) {
            Icon icon2 = AllIcons.Actions.Stub;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Stub");
        }
        this(new DialogImportItem(settingsContributor, icon));
    }

    @Nullable
    public Void getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    public TransferSettingsProgressIndicator getProgress() {
        return this.progress;
    }

    @Override
    @NotNull
    public DialogImportItem getTo() {
        return this.to;
    }

    @NotNull
    public final ProgressIndicator createProgressIndicatorAdapter() {
        return new ProgressIndicatorAdapter(this.getProgress());
    }
}

