/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jdbc.inspection;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.spring.data.jdbc.SpringDataJdbcUtilsKt;
import com.intellij.spring.data.jdbc.orm.SpringDataJdbcOrmSearcher;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/spring/data/jdbc/inspection/SpringDataJdbcEntityInSeveralAggregatesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "ormSearcher", "Lcom/intellij/spring/data/jdbc/orm/SpringDataJdbcOrmSearcher;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getProblemDescriptor", "field", "Lorg/jetbrains/uast/UField;", "psiClass", "Lcom/intellij/psi/PsiClass;", "getFieldTypeClass", "getDifferentAggregate", "Lkotlin/Pair;", "", "Lorg/jetbrains/uast/UVariable;", "entityClass", "firstRootClass", "SafeDeleteFieldFix", "NavigateToOtherAggregateFix", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringDataJdbcEntityInSeveralAggregatesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataJdbcEntityInSeveralAggregatesInspection.kt\ncom/intellij/spring/data/jdbc/inspection/SpringDataJdbcEntityInSeveralAggregatesInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SUastUtils.kt\ncom/intellij/jpa/jpb/model/util/SUastUtils\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,125:1\n1#2:126\n108#3:127\n37#4,2:128\n24#5:130\n*S KotlinDebug\n*F\n+ 1 SpringDataJdbcEntityInSeveralAggregatesInspection.kt\ncom/intellij/spring/data/jdbc/inspection/SpringDataJdbcEntityInSeveralAggregatesInspection\n*L\n34#1:127\n39#1:128,2\n74#1:130\n*E\n"})
public final class SpringDataJdbcEntityInSeveralAggregatesInspection
extends LocalInspectionTool {
    @NotNull
    private final SpringDataJdbcOrmSearcher ormSearcher = new SpringDataJdbcOrmSearcher();

    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Module module = PsiUtilsKt.module((PsiFile)file);
        if (module != null) {
            Module it = module;
            int n = 0;
            bl = SpringDataJdbcUtilsKt.hasSpringDataJdbcSupport(it);
        } else {
            bl = false;
        }
        if (!bl) {
            return new ProblemDescriptor[0];
        }
        PsiClass[] psiClassArray = file instanceof PsiClassOwner ? (PsiClass[])file : null;
        if (psiClassArray == null || (psiClassArray = psiClassArray.getClasses()) == null) {
            return new ProblemDescriptor[0];
        }
        PsiClass[] classes = psiClassArray;
        List result = new ArrayList();
        for (PsiClass clazz : classes) {
            UClass uClass;
            Intrinsics.checkNotNull((Object)clazz);
            if (!this.ormSearcher.isEntity(clazz)) continue;
            PsiElement $this$toUElementWithType$iv = (PsiElement)clazz;
            boolean $i$f$toUElementWithType = false;
            if ((UClass)UastContextKt.toUElement((PsiElement)$this$toUElementWithType$iv, UClass.class) == null) continue;
            for (UField field : uClass.getFields()) {
                ProblemDescriptor it;
                if (this.getProblemDescriptor(field, clazz, manager, isOnTheFly) == null) continue;
                boolean bl2 = false;
                result.add(it);
            }
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProblemDescriptor[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private final ProblemDescriptor getProblemDescriptor(UField field, PsiClass psiClass, InspectionManager manager, boolean isOnTheFly) {
        Object[] objectArray;
        boolean isMappedCollection = false;
        for (UAnnotation annotation : field.getUAnnotations()) {
            block11: {
                objectArray = annotation.getQualifiedName();
                if (objectArray == null) continue;
                switch (objectArray.hashCode()) {
                    case 893265142: {
                        if (objectArray.equals("org.springframework.data.relational.core.mapping.MappedCollection")) break;
                        break block11;
                    }
                    case -1857907365: {
                        if (objectArray.equals("org.springframework.data.relational.core.mapping.Column")) return null;
                        break block11;
                    }
                    case -1628278961: {
                        if (objectArray.equals("org.springframework.data.relational.core.mapping.Embedded")) {
                            return null;
                        }
                        break block11;
                    }
                }
                isMappedCollection = true;
            }
        }
        PsiClass psiClass2 = this.getFieldTypeClass(field, psiClass);
        if (psiClass2 == null) {
            return null;
        }
        PsiClass fieldTargetClass = psiClass2;
        if (!isMappedCollection && !this.ormSearcher.isEntity(fieldTargetClass)) {
            return null;
        }
        Pair<String, UVariable> pair = this.getDifferentAggregate(fieldTargetClass, psiClass);
        if (pair == null) {
            return null;
        }
        Pair<String, UVariable> differentAggregate = pair;
        TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance((PsiElement)psiClass);
        if ((templateHelper == null || (templateHelper = templateHelper.getTypeElement((UVariable)field)) == null) && (templateHelper = field.getSourcePsi()) == null) {
            return null;
        }
        objectArray = new Object[]{fieldTargetClass.getName(), differentAggregate.getFirst()};
        String string = SpringDataBundle.message("spring.data.jdbc.entity.in.several.aggregates.inspection.description", objectArray);
        objectArray = new LocalQuickFix[]{new SafeDeleteFieldFix(), new NavigateToOtherAggregateFix((String)differentAggregate.getFirst(), (UVariable)differentAggregate.getSecond())};
        return manager.createProblemDescriptor((PsiElement)templateHelper, string, isOnTheFly, (LocalQuickFix[])objectArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private final PsiClass getFieldTypeClass(UField field, PsiClass psiClass) {
        PsiType fieldType = field.getType();
        Fqn fqn = Fqn.Companion.ofType(fieldType, field.getSourcePsi(), psiClass);
        if (Datatypes.BasicDatatype.isKnownType((String)fqn.getName(true))) {
            return null;
        }
        if (Intrinsics.areEqual((Object)fqn.getExternalFullName(), (Object)"org.springframework.data.jdbc.core.mapping.AggregateReference")) {
            return null;
        }
        if (fqn.getGenerics().isEmpty()) {
            PsiClassType psiClassType = fieldType instanceof PsiClassType ? (PsiClassType)fieldType : null;
            return psiClassType != null ? psiClassType.resolve() : null;
        }
        Fqn fqn2 = fqn.getInner();
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return fqn2.toPsiClass(project);
    }

    private final Pair<String, UVariable> getDifferentAggregate(PsiClass entityClass, PsiClass firstRootClass) {
        Query query = ReferencesSearch.search((PsiElement)((PsiElement)entityClass), (SearchScope)((SearchScope)GlobalSearchScope.projectScope((Project)entityClass.getProject())), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        for (PsiReference ref : (Iterable)query) {
            UClass psiClass;
            boolean bl = false;
            UElement uElement = UastContextKt.toUElement((PsiElement)ref.getElement());
            if (uElement == null) continue;
            UElement $this$getParentOfType_u24default$iv = uElement;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uElement = (UVariable)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UVariable.class, (boolean)strict$iv);
            if (uElement == null) {
                continue;
            }
            UElement uVariable = uElement;
            if (!(uVariable instanceof UField)) {
                boolean bl2;
                if (uVariable.getSourcePsi() != null) {
                    PsiElement psi;
                    boolean bl3 = false;
                    TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance(psi);
                    bl2 = Intrinsics.areEqual((Object)(templateHelper != null ? Boolean.valueOf(templateHelper.isPrimaryConstructorParameter((UVariable)uVariable)) : null), (Object)true);
                } else {
                    bl2 = false;
                }
                if (!bl2) continue;
            }
            if (UastUtils.getContainingUClass((UElement)uVariable) == null || Intrinsics.areEqual((Object)psiClass.getSourcePsi(), (Object)firstRootClass) || Intrinsics.areEqual((Object)psiClass.getJavaPsi(), (Object)firstRootClass) || !this.ormSearcher.isEntity(psiClass.getJavaPsi())) continue;
            String string = psiClass.getJavaPsi().getName();
            if (string == null) {
                string = "";
            }
            return TuplesKt.to((Object)string, (Object)uVariable);
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spring/data/jdbc/inspection/SpringDataJdbcEntityInSeveralAggregatesInspection$NavigateToOtherAggregateFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "className", "", "uVariable", "Lorg/jetbrains/uast/UVariable;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/uast/UVariable;)V", "getClassName", "()Ljava/lang/String;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.spring.data"})
    private static final class NavigateToOtherAggregateFix
    implements LocalQuickFix {
        @NotNull
        private final String className;
        @NotNull
        private final SmartPsiElementPointer<UVariable> pointer;

        public NavigateToOtherAggregateFix(@NotNull String className, @NotNull UVariable uVariable) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)uVariable, (String)"uVariable");
            this.className = className;
            this.pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)uVariable));
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final SmartPsiElementPointer<UVariable> getPointer() {
            return this.pointer;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.className};
            String string = SpringDataBundle.message("spring.data.jdbc.navigate.to.aggregate.fix.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                UVariable uVariable = (UVariable)this.pointer.getElement();
                PsiElement psiElement = uVariable != null ? uVariable.getSourcePsi() : null;
                Navigatable navigatable = psiElement instanceof Navigatable ? (Navigatable)psiElement : null;
                if (navigatable == null) break block0;
                navigatable.navigate(true);
            }
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spring/data/jdbc/inspection/SpringDataJdbcEntityInSeveralAggregatesInspection$SafeDeleteFieldFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.spring.data"})
    @SourceDebugExtension(value={"SMAP\nSpringDataJdbcEntityInSeveralAggregatesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataJdbcEntityInSeveralAggregatesInspection.kt\ncom/intellij/spring/data/jdbc/inspection/SpringDataJdbcEntityInSeveralAggregatesInspection$SafeDeleteFieldFix\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,125:1\n24#2:126\n*S KotlinDebug\n*F\n+ 1 SpringDataJdbcEntityInSeveralAggregatesInspection.kt\ncom/intellij/spring/data/jdbc/inspection/SpringDataJdbcEntityInSeveralAggregatesInspection$SafeDeleteFieldFix\n*L\n93#1:126\n*E\n"})
    private static final class SafeDeleteFieldFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = SpringDataBundle.message("spring.data.jdbc.entity.in.several.aggregates.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            UElement uElement;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    uElement = UastContextKt.toUElement((PsiElement)descriptor.getPsiElement());
                    if (uElement == null) break block2;
                    UElement $this$getParentOfType_u24default$iv = uElement;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    uElement = (UVariable)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UVariable.class, (boolean)strict$iv);
                    if (uElement != null && (uElement = uElement.getSourcePsi()) != null) break block3;
                }
                return;
            }
            UElement field = uElement;
            ApplicationManager.getApplication().invokeLater(() -> SafeDeleteFieldFix.applyFix$lambda$0(project, (PsiElement)field), project.getDisposed());
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }

        private static final void applyFix$lambda$0(Project $project, PsiElement $field) {
            PsiElement[] psiElementArray = new PsiElement[]{$field};
            SafeDeleteHandler.invoke((Project)$project, (PsiElement[])psiElementArray, (boolean)false, null);
        }
    }
}

