/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript.providers;

import com.intellij.configurationScript.BeanConstructorKt;
import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.configurationScript.schemaGenerators.RunConfigurationJsonSchemaGeneratorKt;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B?\u00126\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J(\u0010\u0017\u001a\u00020\t2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00192\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002R>\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/configurationScript/providers/RunConfigurationListReader;", "", "processor", "Lkotlin/Function2;", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "Lkotlin/ParameterName;", "name", "factory", "state", "", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "read", "parentNode", "Lorg/snakeyaml/engine/v2/nodes/MappingNode;", "isTemplatesOnly", "", "readFactoryGroup", "type", "Lcom/intellij/execution/configurations/ConfigurationType;", "readRunConfigurationGroup", "node", "Lorg/snakeyaml/engine/v2/nodes/Node;", "readRunConfiguration", "optionsClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/components/BaseState;", "intellij.configurationScript"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationListReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationListReader.kt\ncom/intellij/configurationScript/providers/RunConfigurationListReader\n+ 2 RunConfigurationJsonSchemaGenerator.kt\ncom/intellij/configurationScript/schemaGenerators/RunConfigurationJsonSchemaGeneratorKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n17#2,11:121\n1#3:132\n82#4,3:133\n*S KotlinDebug\n*F\n+ 1 RunConfigurationListReader.kt\ncom/intellij/configurationScript/providers/RunConfigurationListReader\n*L\n41#1:121,11\n98#1:133,3\n*E\n"})
public final class RunConfigurationListReader {
    @NotNull
    private final Function2<ConfigurationFactory, Object, Unit> processor;

    public RunConfigurationListReader(@NotNull Function2<? super ConfigurationFactory, Object, Unit> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.processor = processor;
    }

    /*
     * WARNING - void declaration
     */
    public final void read(@NotNull MappingNode parentNode, boolean isTemplatesOnly) {
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        Map keyToType = null;
        for (NodeTuple tuple : parentNode.getValue()) {
            ConfigurationType configurationType;
            Node keyNode = tuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode)) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unexpected keyNode type: " + keyNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)((ScalarNode)keyNode).getValue(), (Object)"templates")) {
                if (!isTemplatesOnly) continue;
                Node node = tuple.getValueNode();
                MappingNode mappingNode = node instanceof MappingNode ? (MappingNode)node : null;
                if (mappingNode == null) continue;
                this.read(mappingNode, false);
                continue;
            }
            if (keyToType == null) {
                keyToType = CollectionFactory.createSmallMemoryFootprintMap();
                boolean $i$f$processConfigurationTypes = false;
                for (ConfigurationType type$iv : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
                    void propertyName;
                    CharSequence propertyName$iv;
                    Intrinsics.checkNotNull((Object)type$iv);
                    if (RunConfigurationJsonSchemaGeneratorKt.rcTypeIdToPropertyName(type$iv) == null) continue;
                    ConfigurationFactory[] factories$iv = type$iv.getConfigurationFactories();
                    Intrinsics.checkNotNull((Object)factories$iv);
                    if (factories$iv.length == 0) {
                        IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration type \"" + type$iv.getDisplayName() + "\" is not valid: factory list is empty");
                        continue;
                    }
                    CharSequence charSequence = propertyName$iv;
                    ConfigurationType configurationType2 = type$iv;
                    boolean bl = false;
                    keyToType.put(propertyName.toString(), configurationType2);
                }
            }
            if ((configurationType = (ConfigurationType)keyToType.get(((ScalarNode)keyNode).getValue())) == null) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unknown run configuration type: " + ((ScalarNode)keyNode).getValue());
                continue;
            }
            Object[] factories = configurationType.getConfigurationFactories();
            Intrinsics.checkNotNull((Object)factories);
            if (factories.length == 0) continue;
            Node valueNode = tuple.getValueNode();
            if (factories.length > 1) {
                if (!(valueNode instanceof MappingNode)) {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unexpected valueNode type: " + valueNode);
                    continue;
                }
                this.readFactoryGroup((MappingNode)valueNode, configurationType);
                continue;
            }
            Node node = tuple.getValueNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getValueNode(...)");
            Object object = ArraysKt.first((Object[])factories);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            this.readRunConfigurationGroup(node, (ConfigurationFactory)object);
        }
    }

    private final void readFactoryGroup(MappingNode parentNode, ConfigurationType type) {
        for (NodeTuple tuple : parentNode.getValue()) {
            Object object;
            Node keyNode;
            block4: {
                keyNode = tuple.getKeyNode();
                if (!(keyNode instanceof ScalarNode)) {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unexpected keyNode type: " + keyNode);
                    continue;
                }
                String factoryKey = ((ScalarNode)keyNode).getValue();
                ConfigurationFactory[] configurationFactoryArray = type.getConfigurationFactories();
                Intrinsics.checkNotNullExpressionValue((Object)configurationFactoryArray, (String)"getConfigurationFactories(...)");
                for (Object object2 : (Object[])configurationFactoryArray) {
                    ConfigurationFactory factory = (ConfigurationFactory)object2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)factory);
                    if (!Intrinsics.areEqual((Object)factoryKey, (Object)RunConfigurationJsonSchemaGeneratorKt.rcFactoryIdToPropertyName(factory))) continue;
                    object = object2;
                    break block4;
                }
                object = null;
            }
            ConfigurationFactory factory = (ConfigurationFactory)object;
            if (factory == null) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().warn("Unknown run configuration factory: " + ((ScalarNode)keyNode).getValue());
                continue;
            }
            Node node = tuple.getValueNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getValueNode(...)");
            this.readRunConfigurationGroup(node, factory);
        }
    }

    private final void readRunConfigurationGroup(Node node, ConfigurationFactory factory) {
        Class<RunConfigurationOptions> optionsClass;
        Class<RunConfigurationOptions> clazz = factory.getOptionsClass();
        if (clazz == null) {
            clazz = optionsClass = RunConfigurationOptions.class;
        }
        if (node instanceof MappingNode) {
            Object object;
            Logger $this$runAndLogException$iv = IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG();
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl2 = false;
                this.readRunConfiguration(optionsClass, (MappingNode)node, factory);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        } else if (node instanceof SequenceNode) {
            for (Node itemNode : ((SequenceNode)node).getValue()) {
                if (!(itemNode instanceof MappingNode)) continue;
                this.readRunConfiguration(optionsClass, (MappingNode)itemNode, factory);
            }
        }
    }

    private final void readRunConfiguration(Class<? extends BaseState> optionsClass, MappingNode node, ConfigurationFactory factory) {
        Object object = ReflectionUtil.newInstance(optionsClass);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(...)");
        BaseState instance = (BaseState)object;
        if (instance instanceof RunConfigurationOptions) {
            ((RunConfigurationOptions)instance).setAllowRunningInParallel(factory.getSingletonPolicy().isAllowRunningInParallel());
        }
        List list = node.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValue(...)");
        this.processor.invoke((Object)factory, (Object)BeanConstructorKt.readIntoObject$default(instance, list, null, 4, null));
    }
}

