/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.mysqlbase.types.MysqlBinaryType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/mysqlbase/types/MysqlBaseTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getNormalizedTypeName", "", "name", "doNormalizeTypeName", "normalizeType", "Lcom/intellij/database/model/DataType;", "type", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "normalizeSuffix", "suffix", "moveToSuffix", "", "suffixes", "", "s", "doCreateArrayType", "Lcom/intellij/database/dialects/mysqlbase/types/MysqlBinaryType;", "componentType", "Lcom/intellij/database/types/DasType;", "intellij.database.dialects.mysqlbase"})
@SourceDebugExtension(value={"SMAP\nMysqlBaseTypeSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseTypeSystem.kt\ncom/intellij/database/dialects/mysqlbase/types/MysqlBaseTypeSystem\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,79:1\n106#2:80\n78#2,22:81\n*S KotlinDebug\n*F\n+ 1 MysqlBaseTypeSystem.kt\ncom/intellij/database/dialects/mysqlbase/types/MysqlBaseTypeSystem\n*L\n40#1:80\n40#1:81,22\n*E\n"})
public final class MysqlBaseTypeSystem
extends DasTypeSystemImpl {
    public MysqlBaseTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (this.doNormalizeTypeName(name2)) {
            case "nchar varying" -> "varchar";
            case "nvarchar" -> "varchar";
            case "nchar" -> "char";
            case "character varying" -> "varchar";
            case "char varying" -> "varchar";
            case "character" -> "char";
            case "long" -> "mediumtext";
            case "integer" -> "int";
            case "boolean" -> "tinyint";
            case "bool" -> "tinyint";
            case "dec" -> "decimal";
            case "numeric" -> "decimal";
            case "fixed" -> "decimal";
            case "double precision" -> "double";
            case "real" -> "double";
            default -> {
                void var2_2;
                yield var2_2;
            }
        };
    }

    private final String doNormalizeTypeName(String name2) {
        String $this$trim$iv = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)super.getNormalizedTypeName(name2), (CharSequence)"national "), (CharSequence)" zerofill"), (CharSequence)" signed"), (CharSequence)" unsigned");
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @NotNull
    public DataType normalizeType(@NotNull DataType type) {
        DataType dataType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        DataType normalized = super.normalizeType(type);
        String origSuffix = normalized.suffix;
        String string = type.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
        String suffix = this.normalizeSuffix(string, origSuffix);
        if (!Intrinsics.areEqual((Object)suffix, (Object)origSuffix)) {
            DataType dataType2 = DataTypeFactory.withSuffix((DataType)normalized, (String)suffix);
            dataType = dataType2;
            Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"withSuffix(...)");
        } else {
            dataType = normalized;
        }
        return dataType;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)cat, (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "int";
            case 2 -> "decimal";
            case 3 -> "varchar";
            case 4 -> "tinyint";
            case 5 -> "datetime";
            case 6 -> "date";
            case 7 -> "time";
            case 8 -> "timestamp";
            case 9 -> "interval";
            case 10 -> "binary";
            default -> null;
        };
    }

    private final String normalizeSuffix(String name2, String suffix) {
        List list;
        String string = suffix;
        if (string == null) {
            list = CollectionsKt.emptyList();
        } else {
            List list2 = StringUtil.split((String)StringUtil.toLowerCase((String)string), (String)" ");
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"split(...)");
        }
        TreeSet suffices = new TreeSet(list);
        suffices.remove("signed");
        this.moveToSuffix(name2, suffices, "unsigned");
        this.moveToSuffix(name2, suffices, "zerofill");
        return suffices.isEmpty() ? null : StringUtil.join((Collection)suffices, (String)" ");
    }

    private final void moveToSuffix(String name2, Set<String> suffixes, String s) {
        if (StringUtil.containsIgnoreCase((String)name2, (String)s)) {
            suffixes.add(s);
        }
    }

    @NotNull
    protected MysqlBinaryType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new MysqlBinaryType(componentType);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

