/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.splitApi.frontend;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.dashboard.RunDashboardManagerProxy;
import com.intellij.execution.dashboard.RunDashboardService;
import com.intellij.execution.dashboard.RunDashboardUiManager;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.platform.execution.dashboard.BackendRunDashboardManagerState;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.platform.execution.dashboard.RunDashboardTypePanel;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.frontend.FrontendRunDashboardManager;
import com.intellij.platform.execution.dashboard.splitApi.frontend.FrontendRunDashboardService;
import com.intellij.platform.execution.dashboard.splitApi.frontend.PanelContentUI;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardComponentWrapper;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardGroupingRule;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardUiUtils;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.FrontendRunConfigurationNode;
import com.intellij.platform.execution.serviceView.ServiceViewImplementationChooserKt;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.platform.ide.productMode.IdeProductMode;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RunDashboardUiManagerImpl
implements RunDashboardUiManager {
    private final Project myProject;
    private final ContentManager myContentManager;
    private final ContentManagerListener myServiceContentManagerListener;
    private String myToolWindowId;
    private RunDashboardComponentWrapper myContentWrapper;
    private JComponent myEmptyContent;
    private RunDashboardTypePanel myTypeContent;

    public RunDashboardUiManagerImpl(Project project) {
        this.myProject = project;
        ContentFactory contentFactory = ContentFactory.getInstance();
        this.myContentManager = contentFactory.createContentManager((ContentUI)new PanelContentUI(), false, project);
        this.myServiceContentManagerListener = new ServiceContentManagerListener();
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
        this.initExtensionPointListeners();
    }

    @ApiStatus.Internal
    @NotNull
    public static RunDashboardUiManagerImpl getInstance(@NotNull Project project) {
        if (project == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(0);
        }
        RunDashboardUiManagerImpl runDashboardUiManagerImpl = (RunDashboardUiManagerImpl)RunDashboardUiManager.getInstance((Project)project);
        if (runDashboardUiManagerImpl == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(1);
        }
        return runDashboardUiManagerImpl;
    }

    private void initExtensionPointListeners() {
        ExtensionPointListener frontendDashboardUpdater = new ExtensionPointListener(){

            public void extensionAdded(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                RunDashboardUiManagerImpl.this.updateDashboard(true);
            }

            public void extensionRemoved(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ((ServiceEventListener)RunDashboardUiManagerImpl.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createUnloadSyncResetEvent(RunDashboardServiceViewContributor.class));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/platform/execution/dashboard/splitApi/frontend/RunDashboardUiManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        RunDashboardGroupingRule.GROUPING_RULE_EP_NAME.addExtensionPointListener(frontendDashboardUpdater, (Disposable)this.myProject);
    }

    @NotNull
    public ContentManager getDashboardContentManager() {
        ContentManager contentManager = this.myContentManager;
        if (contentManager == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(2);
        }
        return contentManager;
    }

    @NotNull
    public String getToolWindowId() {
        if (this.myToolWindowId == null) {
            String toolWindowId;
            this.myToolWindowId = LightEdit.owns((Project)this.myProject) ? "Services" : ((toolWindowId = ServiceViewManager.getInstance((Project)this.myProject).getToolWindowId(RunDashboardServiceViewContributor.class)) != null ? toolWindowId : "Services");
        }
        String string = this.myToolWindowId;
        if (string == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = AllIcons.Toolwindows.ToolWindowServices;
        if (icon == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(4);
        }
        return icon;
    }

    private void updateDashboard(boolean withStructure) {
        FrontendRunDashboardManager.getInstance(this.myProject).updateDashboard(withStructure);
    }

    @NotNull
    public Predicate<Content> getReuseCondition() {
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(5);
        }
        return condition;
    }

    public boolean syncContentsFromBackend() {
        FrontendRunDashboardManager frontendManager = FrontendRunDashboardManager.getInstance(this.myProject);
        Set<String> types = frontendManager.getTypes();
        Set<Content> managedContents = Set.of(this.myContentManager.getContents());
        HashSet<Content> toRemove = new HashSet<Content>();
        for (Content content : managedContents) {
            String typeId;
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
            if (descriptor == null || (typeId = descriptor.getRunConfigurationTypeId()) == null || types.contains(typeId)) continue;
            toRemove.add(content);
        }
        this.moveRemovedContent(toRemove);
        RunContentManager runContentManager = RunContentManager.getInstance((Project)this.myProject);
        HashSet<Content> toAdd = new HashSet<Content>();
        for (RunContentDescriptor descriptor : runContentManager.getRunContentDescriptors()) {
            Content content;
            String typeId = descriptor.getRunConfigurationTypeId();
            if (typeId == null || !types.contains(typeId) || (content = descriptor.getAttachedContent()) == null || managedContents.contains(content) || content.getManager() == this.myContentManager) continue;
            toAdd.add(content);
        }
        this.moveAddedContent(toAdd);
        return !toRemove.isEmpty() || !toAdd.isEmpty();
    }

    private void moveRemovedContent(Collection<Content> contents) {
        RunContentManagerImpl runContentManager = (RunContentManagerImpl)RunContentManager.getInstance((Project)this.myProject);
        for (Content content : contents) {
            Executor executor;
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
            if (descriptor == null || (executor = RunContentManagerImpl.getExecutorByContent((Content)content)) == null) continue;
            descriptor.setContentToolWindowId(null);
            RunDashboardUiUtils.updateContentToolbar(content, true);
            runContentManager.moveContent(executor, descriptor);
        }
    }

    private void moveAddedContent(Collection<Content> contents) {
        RunContentManagerImpl runContentManager = (RunContentManagerImpl)RunContentManager.getInstance((Project)this.myProject);
        for (Content content : contents) {
            Executor executor;
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
            if (descriptor == null || (executor = RunContentManagerImpl.getExecutorByContent((Content)content)) == null) continue;
            descriptor.setContentToolWindowId(this.getToolWindowId());
            runContentManager.moveContent(executor, descriptor);
        }
    }

    public void setSelectedContent(@NotNull Content content) {
        ContentManager contentManager;
        if (content == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(6);
        }
        if ((contentManager = content.getManager()) == null || content == contentManager.getSelectedContent()) {
            return;
        }
        if (contentManager != this.myContentManager) {
            contentManager.setSelectedContent(content);
            return;
        }
        this.myContentManager.removeContentManagerListener(this.myServiceContentManagerListener);
        this.myContentManager.setSelectedContent(content);
        RunDashboardUiUtils.updateContentToolbar(content, false);
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
    }

    public void removeFromSelection(@NotNull Content content) {
        ContentManager contentManager;
        if (content == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(7);
        }
        if ((contentManager = content.getManager()) == null || content != contentManager.getSelectedContent()) {
            return;
        }
        if (contentManager != this.myContentManager) {
            contentManager.removeFromSelection(content);
            return;
        }
        this.myContentManager.removeContentManagerListener(this.myServiceContentManagerListener);
        this.myContentManager.removeFromSelection(content);
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
    }

    @ApiStatus.Internal
    @NotNull
    public JComponent getEmptyContent() {
        if (this.myEmptyContent == null) {
            JBPanelWithEmptyText textPanel = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.configurations.message", (Object[])new Object[0]));
            textPanel.setFocusable(true);
            JComponent wrapped = UiDataProvider.wrapComponent((JComponent)textPanel, sink -> sink.set(PlatformDataKeys.TREE_EXPANDER_HIDE_ACTIONS_IF_NO_EXPANDER, (Object)true));
            NonOpaquePanel mainPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
            mainPanel.add((Component)wrapped, "Center");
            RunDashboardUiUtils.setupToolbar((JPanel)mainPanel, wrapped, this.myProject);
            this.myEmptyContent = mainPanel;
        }
        JComponent jComponent = this.myEmptyContent;
        if (jComponent == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    @ApiStatus.Internal
    @NotNull
    public RunDashboardTypePanel getTypeContent() {
        if (this.myTypeContent == null) {
            this.myTypeContent = new RunDashboardTypePanel(this.myProject);
        }
        RunDashboardTypePanel runDashboardTypePanel = this.myTypeContent;
        if (runDashboardTypePanel == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(9);
        }
        return runDashboardTypePanel;
    }

    public void contentReused(@NotNull Content content, @NotNull RunContentDescriptor oldDescriptor) {
        if (content == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(10);
        }
        if (oldDescriptor == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(11);
        }
        if (content.getManager() == this.myContentManager) {
            RunDashboardManagerProxy.getInstance((Project)this.myProject).updateServiceRunContentDescriptor(content, oldDescriptor);
        }
    }

    public boolean isSupported(@NotNull Executor executor) {
        if (executor == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(12);
        }
        return IdeProductMode.isMonolith() || IdeProductMode.isBackend() && ServiceViewImplementationChooserKt.isOldMonolithServiceViewEnabled() || "Debug".equals(executor.getId()) || "Run".equals(executor.getId()) && ServiceViewImplementationChooserKt.isShowLuxedRunToolwindowInServicesView();
    }

    public void navigateToServiceOnRun(@NotNull RunContentDescriptorId descriptorId, Boolean focus) {
        if (descriptorId == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(13);
        }
        if (IdeProductMode.isFrontend()) {
            return;
        }
        RunDashboardManagerImpl runDashboardManager = RunDashboardManagerImpl.getInstance(this.myProject);
        runDashboardManager.navigateToServiceOnRun(descriptorId, focus);
    }

    @ApiStatus.Internal
    @NotNull
    public RunDashboardComponentWrapper getContentWrapper() {
        if (this.myContentWrapper == null) {
            this.myContentWrapper = new RunDashboardComponentWrapper();
            ClientProperty.put((JComponent)((Object)this.myContentWrapper), (Key)ServiceViewDescriptor.ACTION_HOLDER_KEY, (Object)Boolean.TRUE);
        }
        RunDashboardComponentWrapper runDashboardComponentWrapper = this.myContentWrapper;
        if (runDashboardComponentWrapper == null) {
            RunDashboardUiManagerImpl.$$$reportNull$$$0(14);
        }
        return runDashboardComponentWrapper;
    }

    @Nullable
    private FrontendRunDashboardService findService(Content content) {
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
        if (descriptor == null) {
            return null;
        }
        RunContentDescriptorId contentId = descriptor.getId();
        if (contentId == null) {
            return null;
        }
        List<@NotNull FrontendRunDashboardService> services = FrontendRunDashboardManager.getInstance(this.myProject).getServicePresentations();
        return (FrontendRunDashboardService)ContainerUtil.find(services, service -> contentId.equals((Object)service.getRunDashboardServiceDto().getContentId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/splitApi/frontend/RunDashboardUiManagerImpl";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/splitApi/frontend/RunDashboardUiManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDashboardContentManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReuseCondition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeContent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFromSelection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contentReused";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "navigateToServiceOnRun";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 9, 14 -> new IllegalStateException(string);
        };
    }

    private final class ServiceContentManagerListener
    implements ContentManagerListener {
        private volatile Content myPreviousSelection = null;

        private ServiceContentManagerListener() {
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ServiceContentManagerListener.$$$reportNull$$$0(0);
            }
            boolean onAdd = event.getOperation() == ContentManagerEvent.ContentOperation.add;
            Content content = event.getContent();
            if (onAdd) {
                RunDashboardUiUtils.updateContentToolbar(content, false);
            }
            FrontendRunDashboardManager.getInstance(RunDashboardUiManagerImpl.this.myProject).updateDashboard(true);
            if (onAdd) {
                FrontendRunDashboardService service = RunDashboardUiManagerImpl.this.findService(content);
                if (service != null) {
                    RunDashboardServiceDto dto = service.getRunDashboardServiceDto();
                    ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)RunDashboardUiManagerImpl.this.myProject)).trackingSelect((Object)new FrontendRunConfigurationNode(RunDashboardUiManagerImpl.this.myProject, service), RunDashboardServiceViewContributor.class, dto.isActivateToolWindowBeforeRun(), dto.isFocusToolWindowBeforeRun()).onSuccess(selected -> {
                        if (selected != Boolean.TRUE) {
                            this.selectPreviousContent();
                        }
                    }).onError(t -> this.selectPreviousContent());
                }
            } else {
                this.myPreviousSelection = content;
            }
        }

        private void selectPreviousContent() {
            Content previousSelection = this.myPreviousSelection;
            if (previousSelection != null) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)previousSelection)).submit(() -> RunDashboardUiManagerImpl.this.setSelectedContent(previousSelection));
            }
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            RunContentDescriptorId descriptorId;
            if (event == null) {
                ServiceContentManagerListener.$$$reportNull$$$0(1);
            }
            Content content = event.getContent();
            if (IdeProductMode.isFrontend()) {
                FrontendRunDashboardManager.getInstance(RunDashboardUiManagerImpl.this.myProject).attachServiceRunContentDescriptor(content);
                return;
            }
            RunDashboardManagerImpl runDashboardManager = RunDashboardManagerImpl.getInstance(RunDashboardUiManagerImpl.this.myProject);
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
            RunContentDescriptorId runContentDescriptorId = descriptorId = descriptor == null ? null : descriptor.getId();
            if (descriptorId == null) {
                return;
            }
            RunDashboardService backendService = runDashboardManager.attachServiceRunContentDescriptor(descriptorId);
            if (IdeProductMode.isMonolith() && runDashboardManager.isOpenRunningConfigInNewTab() && backendService != null) {
                RunDashboardServiceDto dto = BackendRunDashboardManagerState.createServiceDto(backendService);
                FrontendRunDashboardService frontendService = new FrontendRunDashboardService(dto);
                ServiceViewManager.getInstance((Project)RunDashboardUiManagerImpl.this.myProject).extract((Object)new FrontendRunConfigurationNode(RunDashboardUiManagerImpl.this.myProject, frontendService), RunDashboardServiceViewContributor.class);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            RunContentDescriptorId descriptorId;
            Content content;
            if (event == null) {
                ServiceContentManagerListener.$$$reportNull$$$0(2);
            }
            if (this.myPreviousSelection == (content = event.getContent())) {
                this.myPreviousSelection = null;
            }
            if (IdeProductMode.isFrontend()) {
                FrontendRunDashboardManager.getInstance(RunDashboardUiManagerImpl.this.myProject).detachServiceRunContentDescriptor(content);
                return;
            }
            RunDashboardManagerImpl runDashboardManager = RunDashboardManagerImpl.getInstance(RunDashboardUiManagerImpl.this.myProject);
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
            RunContentDescriptorId runContentDescriptorId = descriptorId = descriptor == null ? null : descriptor.getId();
            if (descriptorId == null) {
                return;
            }
            runDashboardManager.detachServiceRunContentDescriptor(descriptorId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/platform/execution/dashboard/splitApi/frontend/RunDashboardUiManagerImpl$ServiceContentManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

