/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.NetUtils;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerAuth;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u001a\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"TOKEN_PARAM_NAME", "", "TOKEN_HEADER_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "acquireToken", "compareNameAndProjectBasePath", "", "projectName", "project", "Lcom/intellij/openapi/project/Project;", "findIndexFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basedir", "Ljava/nio/file/Path;", "isOwnHostName", "host", "redirectToDirectory", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nBuiltInWebServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInWebServer.kt\norg/jetbrains/builtInWebServer/BuiltInWebServerKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 path.kt\ncom/intellij/util/io/PathKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,328:1\n42#2,3:329\n175#3,6:332\n13#4:338\n*S KotlinDebug\n*F\n+ 1 BuiltInWebServer.kt\norg/jetbrains/builtInWebServer/BuiltInWebServerKt\n*L\n237#1:329,3\n273#1:332,6\n43#1:338\n*E\n"})
public final class BuiltInWebServerKt {
    @NotNull
    public static final String TOKEN_PARAM_NAME = "_ijt";
    @NotNull
    public static final String TOKEN_HEADER_NAME = "x-ijt";
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @Deprecated(message="Please use `BuiltInWebServerAuth.acquireToken` instead")
    @NotNull
    public static final String acquireToken() {
        boolean $i$f$service = false;
        Class<BuiltInWebServerAuth> serviceClass$iv = BuiltInWebServerAuth.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((BuiltInWebServerAuth)object).acquireToken();
    }

    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String basePath = project.getBasePath();
        return basePath != null && FileUtilKt.endsWithName((String)basePath, (String)projectName);
    }

    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        VirtualFile[] children;
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        VirtualFile[] objectArray = children = basedir.getChildren();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        for (String string : stringArray) {
            VirtualFile index = null;
            String preferredName = string + "html";
            for (VirtualFile child : children) {
                String name;
                if (child.isDirectory()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)child.getName(), (String)"getName(...)");
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)string, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final Path findIndexFile(@NotNull Path basedir) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        String[] stringArray = basedir;
        Function1 filter$iv = BuiltInWebServerKt::findIndexFile$lambda$0;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            object2 = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, PathKt.makeFilter((Function1)filter$iv));
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)object2;
                boolean bl = false;
                object = CollectionsKt.toList((Iterable)it);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
            object2 = object;
        }
        catch (NoSuchFileException noSuchFileException) {
            object2 = null;
        }
        Closeable closeable = object2;
        if (closeable == null) {
            return null;
        }
        Closeable children = closeable;
        stringArray = new String[]{"index.", "default."};
        for (String indexNamePrefix : stringArray) {
            Path index = null;
            String preferredName = indexNamePrefix + "html";
            object = children.iterator();
            while (object.hasNext()) {
                Path child = (Path)object.next();
                Intrinsics.checkNotNull((Object)child);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(child, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                String name = ((Object)child.getFileName()).toString();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOwnHostName(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress())) return true;
            if (StringsKt.equals((String)host, (String)address.getCanonicalHostName(), (boolean)true)) {
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            if (StringsKt.equals((String)localHostName, (String)host, (boolean)true)) return true;
            if (!StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2, null)) return false;
            Intrinsics.checkNotNull((Object)localHostName);
            if (!StringsKt.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(host.length() - 6), (boolean)true)) return false;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static final void redirectToDirectory(@NotNull HttpRequest request, @NotNull Channel channel, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.MOVED_PERMANENTLY;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"MOVED_PERMANENTLY");
        HttpResponse response = Responses.response$default((HttpResponseStatus)httpResponseStatus, (HttpRequest)request, null, (int)2, null);
        String string = NettyKt.getUriScheme((Channel)channel);
        String string2 = NettyKt.getHost((HttpRequest)request);
        Intrinsics.checkNotNull((Object)string2);
        URI uRI = VfsUtil.toUri((String)(string + "://" + string2 + new URI(request.uri()).getPath() + "/"));
        Intrinsics.checkNotNull((Object)uRI);
        URI url = uRI;
        response.headers().add((CharSequence)HttpHeaderNames.LOCATION, (Object)url.toASCIIString());
        Responses.send((HttpResponse)response, (Channel)channel, (HttpRequest)request, (HttpHeaders)extraHeaders);
    }

    private static final boolean findIndexFile$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String name = ((Object)it.getFileName()).toString();
        return StringsKt.startsWith$default((String)name, (String)"index.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"default.", (boolean)false, (int)2, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuiltInWebServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

