/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.generator.producers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.GrantsProducer;
import com.intellij.database.dialects.postgresbase.generator.PgBaseScriptGeneratorHelper;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseRoutineProducersKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseLanguage;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrant;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrantController;
import com.intellij.database.dialects.postgresbase.model.properties.PgPrivilege;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0014J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/postgresbase/generator/producers/PgBaseGrantsProducer;", "Lcom/intellij/database/dialects/base/generator/producers/GrantsProducer;", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrant;", "Lcom/intellij/database/model/basic/BasicGrantee;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "grantee", "grants", "", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/basic/BasicGrantee;Ljava/util/Collection;)V", "ctl", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrantController;", "getCtl", "()Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrantController;", "grantType", "", "produce", "", "allGrants", "produceOnClause", "produceToClause", "g", "isDefaultPrivilege", "", "item", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseGrantProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseGrantProducers.kt\ncom/intellij/database/dialects/postgresbase/generator/producers/PgBaseGrantsProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ScriptingContext.kt\ncom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter\n*L\n1#1,90:1\n1#2:91\n263#3:92\n250#3,8:93\n263#3:101\n250#3,8:102\n*S KotlinDebug\n*F\n+ 1 PgBaseGrantProducers.kt\ncom/intellij/database/dialects/postgresbase/generator/producers/PgBaseGrantsProducer\n*L\n60#1:92\n60#1:93,8\n73#1:101\n73#1:102,8\n*E\n"})
public class PgBaseGrantsProducer
extends GrantsProducer<PgObjectGrant, BasicGrantee> {
    public PgBaseGrantsProducer(@NotNull ScriptingContext context, @Nullable BasicElement element, @Nullable BasicGrantee grantee, @NotNull Collection<PgObjectGrant> grants) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(grants, (String)"grants");
        super(context, element, grantee, grants);
    }

    @NotNull
    public PgObjectGrantController getCtl() {
        return PgObjectGrantController.INSTANCE;
    }

    @Nullable
    protected String grantType() {
        String string;
        BasicElement element = this.getElement();
        if (element instanceof PgBaseAggregate) {
            string = "function";
        } else if (element instanceof PgBaseRoutine) {
            string = StringUtil.toLowerCase((String)((PgBaseRoutine)element).getRoutineKind().name());
        } else if (element instanceof PgBaseLikeDatabase) {
            string = "database";
        } else if (element instanceof PgBaseDefType) {
            string = ((PgBaseDefType)element).getSubKind() == PgDataTypeSubKind.DOMAIN ? "domain" : "type";
        } else if (element instanceof PgBaseLanguage) {
            string = "language";
        } else if (element instanceof PgBaseSchema) {
            string = "schema";
        } else {
            ObjectKind objectKind;
            BasicElement basicElement = element;
            Object object = objectKind = basicElement != null ? basicElement.getKind() : null;
            string = Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_DATA_WRAPPER) ? "foreign data wrapper" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SERVER) ? "foreign server" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE) ? "sequence" : null));
        }
        return string;
    }

    protected void produce(@NotNull Collection<PgObjectGrant> allGrants) {
        Intrinsics.checkNotNullParameter(allGrants, (String)"allGrants");
        JBIterable jBIterable = JBIterable.from((Iterable)allGrants).filter(arg_0 -> PgBaseGrantsProducer.produce$lambda$1(arg_0 -> PgBaseGrantsProducer.produce$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable nonDefGrants = jBIterable;
        if (Intrinsics.areEqual((Object)ScriptingTaskKt.getDbms((ScriptingTask)this.getTask()), (Object)Dbms.REDSHIFT)) {
            List list = nonDefGrants.filter(arg_0 -> PgBaseGrantsProducer.produce$lambda$3(PgBaseGrantsProducer::produce$lambda$2, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            super.produce((Collection)list);
            List list2 = nonDefGrants.filter(arg_0 -> PgBaseGrantsProducer.produce$lambda$5(PgBaseGrantsProducer::produce$lambda$4, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
            super.produce((Collection)list2);
        } else {
            List list = nonDefGrants.toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            super.produce((Collection)list);
        }
    }

    protected void produceOnClause() {
        this.sqlClause(arg_0 -> PgBaseGrantsProducer.produceOnClause$lambda$0(this, arg_0));
    }

    protected void produceToClause(@NotNull PgObjectGrant g, @Nullable BasicGrantee grantee) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)g), (String)"g");
        if (g.getGranteeId() == Long.MIN_VALUE) {
            string = "public";
        } else {
            BasicGrantee basicGrantee = grantee;
            if (basicGrantee != null) {
                BasicGrantee it = basicGrantee;
                boolean bl = false;
                string = BaseProducer.quote$default((BaseProducer)((BaseProducer)this), (BasicElement)((BasicElement)it), null, (int)2, null);
            } else {
                string = null;
            }
        }
        String granteeName = string;
        this.sqlClause(arg_0 -> PgBaseGrantsProducer.produceToClause$lambda$1(this, g, granteeName, grantee, arg_0));
    }

    protected boolean isDefaultPrivilege(@NotNull PgObjectGrant item) {
        Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
        BasicElement element = this.getElement();
        if (element instanceof PgBaseObjectWithOwner && ((PgBaseObjectWithOwner)element).getOwnerRef() != null && Intrinsics.areEqual((Object)((PgBaseObjectWithOwner)element).getOwner(), (Object)this.getGrantee())) {
            return true;
        }
        if (item.getGranteeId() == Long.MIN_VALUE) {
            BasicElement basicElement = element;
            return basicElement instanceof PgBaseRoutine || basicElement instanceof PgBaseAggregate ? PgPrivilege.EXECUTE.match(item.getPermission()) : (basicElement instanceof PgBaseDatabase ? PgPrivilege.CONNECT.match(item.getPermission()) || PgPrivilege.TEMPORARY.match(item.getPermission()) : (basicElement instanceof PgBaseLanguage || basicElement instanceof PgBaseDefType ? PgPrivilege.USAGE.match(item.getPermission()) : false));
        }
        return false;
    }

    private static final boolean produce$lambda$0(PgBaseGrantsProducer this$0, PgObjectGrant it) {
        Intrinsics.checkNotNull((Object)((Object)it));
        return !this$0.isDefaultPrivilege(it);
    }

    private static final boolean produce$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean produce$lambda$2(PgObjectGrant it) {
        return !it.isSub();
    }

    private static final boolean produce$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean produce$lambda$4(PgObjectGrant it) {
        return it.isSub();
    }

    private static final boolean produce$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object produceOnClause$lambda$0$0$0(PgBaseGrantsProducer this$0, BasicElement $element) {
        return PgBaseRoutineProducersKt.argumentsDefinitionShort((ElementProducer)this$0, (PgBaseRoutine)$element);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object produceOnClause$lambda$0$0(PgBaseGrantsProducer this$0, ScriptingContext.NewCodingAdapter $this_sqlClause) {
        ScriptingContext.NewCodingAdapter newCodingAdapter;
        BasicElement element = this$0.getElement();
        if (element instanceof PgBaseRoutine) {
            newCodingAdapter = $this_sqlClause.minus($this_sqlClause.minus($this_sqlClause.unaryMinus((CharSequence)"("), () -> PgBaseGrantsProducer.produceOnClause$lambda$0$0$0(this$0, element)), (CharSequence)")");
        } else if (element instanceof PgBaseAggregate) {
            void $this$produceOnClause_u24lambda_u240_u240_u241;
            ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this_sqlClause.unaryMinus((CharSequence)"(");
            ScriptGeneratorHelper scriptGeneratorHelper = this$0.getContext().getHelper();
            Intrinsics.checkNotNull((Object)scriptGeneratorHelper, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.generator.PgBaseScriptGeneratorHelper");
            PgBaseScriptGeneratorHelper pgBaseScriptGeneratorHelper = (PgBaseScriptGeneratorHelper)scriptGeneratorHelper;
            ScriptingContext.NewCodingAdapter newCodingAdapter3 = newCodingAdapter2;
            ScriptingContext.NewCodingAdapter newCodingAdapter4 = $this_sqlClause;
            ScriptingContext.NewCodingAdapter newCodingAdapter5 = $this_sqlClause;
            boolean bl = false;
            String string = $this$produceOnClause_u24lambda_u240_u240_u241.aggregateArgumentsDefinition((ElementProducer)this$0, (PgBaseAggregate)element);
            newCodingAdapter = newCodingAdapter5.minus(newCodingAdapter4.minus(newCodingAdapter3, (CharSequence)string), (CharSequence)")");
        } else {
            newCodingAdapter = $this_sqlClause;
        }
        return newCodingAdapter;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit produceOnClause$lambda$0(PgBaseGrantsProducer this$0, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$sqlClause;
        BasicElement basicElement = this$0.getElement();
        String quotedName$iv = basicElement != null ? BaseProducer.currentScopeName$default((BaseProducer)((BaseProducer)this$0), (BasicElement)basicElement, null, (boolean)false, (int)3, null) : null;
        boolean $i$f$name = false;
        void var5_5 = this_$iv;
        String text$iv$iv = quotedName$iv;
        boolean $i$f$orError = false;
        $this$sqlClause.plus($this$sqlClause.plus($this$sqlClause.plus($this$sqlClause.plus($this$sqlClause, (CharSequence)"on"), (CharSequence)this$0.grantType()), (Function0)new Function0<Unit>(text$iv$iv, (ScriptingContext.NewCodingAdapter)this_$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default((ScriptingContext.NewCodingAdapter)this.this$0, (CharSequence)this.$text, null, null, (int)6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default((ScriptingContext.NewCodingAdapter)newCodingAdapter, (CharSequence)charSequence, kind, (String)string, (int)2, null);
                }
            }
        }), () -> PgBaseGrantsProducer.produceOnClause$lambda$0$0(this$0, $this$sqlClause));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit produceToClause$lambda$1(PgBaseGrantsProducer this$0, PgObjectGrant $g, String $granteeName, BasicGrantee $grantee, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        void this_$iv$iv;
        void this_$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        String string2 = string = "group";
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$sqlClause.plus($this$sqlClause, (CharSequence)this$0.toOrFrom($g));
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this$sqlClause;
        ScriptingContext.NewCodingAdapter newCodingAdapter3 = $this$sqlClause;
        boolean bl = false;
        BasicGrantee basicGrantee = $grantee;
        boolean bl2 = Intrinsics.areEqual((Object)(basicGrantee != null ? basicGrantee.getKind() : null), (Object)ObjectKind.GROUP);
        String string3 = bl2 ? string : null;
        string = $this$sqlClause;
        String quotedName$iv = $granteeName;
        boolean $i$f$name = false;
        void var8_12 = this_$iv;
        String text$iv$iv = quotedName$iv;
        boolean $i$f$orError = false;
        newCodingAdapter3.plus(newCodingAdapter2.plus(newCodingAdapter, (CharSequence)string3), (Function0)new Function0<Unit>(text$iv$iv, (ScriptingContext.NewCodingAdapter)this_$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default((ScriptingContext.NewCodingAdapter)this.this$0, (CharSequence)this.$text, null, null, (int)6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default((ScriptingContext.NewCodingAdapter)newCodingAdapter, (CharSequence)charSequence, kind, (String)string, (int)2, null);
                }
            }
        });
        return Unit.INSTANCE;
    }
}

