/*
 * Decompiled with CFR 0.152.
 */
package training.dsl.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.GotItComponentBuilder;
import com.intellij.ui.GotItTextBuilder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LearningBalloonConfig;
import training.dsl.TaskContext;
import training.dsl.impl.ExtractTaskPropertiesContext;
import training.dsl.impl.ExtractTextTaskContext;
import training.dsl.impl.LessonExecutor;
import training.dsl.impl.TaskProperties;
import training.learn.ActionsRecorder;
import training.ui.LearningUiHighlightingManager;
import training.ui.MessageFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fJ-\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ.\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ8\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006&"}, d2={"Ltraining/dsl/impl/LessonExecutorUtil;", "", "<init>", "()V", "taskProperties", "Ltraining/dsl/impl/TaskProperties;", "taskContent", "Lkotlin/Function1;", "Ltraining/dsl/TaskContext;", "", "Lkotlin/ExtensionFunctionType;", "project", "Lcom/intellij/openapi/project/Project;", "textMessages", "", "", "getTaskCallInfo", "showBalloonMessage", "text", "ui", "Ljavax/swing/JComponent;", "balloonConfig", "Ltraining/dsl/LearningBalloonConfig;", "actionsRecorder", "Ltraining/learn/ActionsRecorder;", "lessonExecutor", "Ltraining/dsl/impl/LessonExecutor;", "useAnimationCycle", "", "getPointForBalloon", "Lcom/intellij/ui/awt/RelativePoint;", "component", "side", "Lcom/intellij/openapi/ui/popup/Balloon$Position;", "getPosition", "Ljava/awt/Point;", "visibleRect", "Ljava/awt/Rectangle;", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLessonExecutorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LessonExecutorUtil.kt\ntraining/dsl/impl/LessonExecutorUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LessonExecutor.kt\ntraining/dsl/impl/LessonExecutor\n*L\n1#1,260:1\n1228#2:261\n1229#2:263\n1#3:262\n200#4,12:264\n*S KotlinDebug\n*F\n+ 1 LessonExecutorUtil.kt\ntraining/dsl/impl/LessonExecutorUtil\n*L\n50#1:261\n50#1:263\n81#1:264,12\n*E\n"})
public final class LessonExecutorUtil {
    @NotNull
    public static final LessonExecutorUtil INSTANCE = new LessonExecutorUtil();

    private LessonExecutorUtil() {
    }

    @NotNull
    public final TaskProperties taskProperties(@NotNull Function1<? super TaskContext, Unit> taskContent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(taskContent, (String)"taskContent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExtractTaskPropertiesContext fakeTaskContext = new ExtractTaskPropertiesContext(project);
        taskContent.invoke((Object)fakeTaskContext);
        return new TaskProperties(fakeTaskContext.getHasDetection(), fakeTaskContext.getTextCount());
    }

    @NotNull
    public final List<String> textMessages(@NotNull Function1<? super TaskContext, Unit> taskContent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(taskContent, (String)"taskContent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExtractTextTaskContext fakeTaskContext = new ExtractTextTaskContext(project);
        taskContent.invoke((Object)fakeTaskContext);
        return fakeTaskContext.getMessages();
    }

    @Nullable
    public final String getTaskCallInfo() {
        Object element$iv2;
        block2: {
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] $this$first$iv = stackTraceElementArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                StackTraceElement element = (StackTraceElement)element$iv2;
                boolean bl = false;
                String it = element.toString();
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(StringsKt.startsWith$default((String)it, (String)"training.learn.lesson", (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)it, (String)"training.", (boolean)false, (int)2, null))) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        StackTraceElement stackTraceElement = (StackTraceElement)element$iv2;
        return stackTraceElement != null ? stackTraceElement.toString() : null;
    }

    public final void showBalloonMessage(@NotNull String text, @NotNull JComponent ui, @NotNull LearningBalloonConfig balloonConfig, @NotNull ActionsRecorder actionsRecorder, @NotNull LessonExecutor lessonExecutor) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)balloonConfig, (String)"balloonConfig");
        Intrinsics.checkNotNullParameter((Object)actionsRecorder, (String)"actionsRecorder");
        Intrinsics.checkNotNullParameter((Object)lessonExecutor, (String)"lessonExecutor");
        if (balloonConfig.getDelayBeforeShow() == 0) {
            this.showBalloonMessage(text, ui, balloonConfig, actionsRecorder, lessonExecutor, true);
        } else {
            Function0 delayed = () -> LessonExecutorUtil.showBalloonMessage$lambda$0(actionsRecorder, text, ui, balloonConfig, lessonExecutor);
            new Alarm().addRequest(() -> LessonExecutorUtil.showBalloonMessage$lambda$1(delayed), balloonConfig.getDelayBeforeShow());
        }
    }

    private final void showBalloonMessage(String text, JComponent ui, LearningBalloonConfig balloonConfig, ActionsRecorder actionsRecorder, LessonExecutor lessonExecutor, boolean useAnimationCycle) {
        Function0 scheduleShowBalloonLater = () -> LessonExecutorUtil.showBalloonMessage$lambda$2(lessonExecutor, actionsRecorder, text, ui, balloonConfig);
        if (this.getPointForBalloon(ui, balloonConfig.getSide()) == null) {
            scheduleShowBalloonLater.invoke();
            return;
        }
        Function1<GotItTextBuilder, String> textBuilder = MessageFactory.INSTANCE.convertToGotItFormat(text);
        GotItComponentBuilder balloonBuilder = new GotItComponentBuilder(textBuilder);
        if (balloonConfig.getWidth() > 0) {
            balloonBuilder.withMaxWidth(JBUI.scale((int)balloonConfig.getWidth()));
        }
        int stepNumber = RangesKt.coerceAtLeast((int)lessonExecutor.getVisualIndexNumber$intellij_featuresTrainer(), (int)1);
        Balloon balloon = balloonBuilder.withStepNumber(stepNumber).showButton(balloonConfig.getGotItCallBack() != null).withButtonLabel(balloonConfig.getButtonText()).onButtonClick(() -> LessonExecutorUtil.showBalloonMessage$lambda$3(balloonConfig)).requestFocus(balloonConfig.getGotItCallBack() != null).withContrastColors(true).build((Disposable)actionsRecorder, arg_0 -> LessonExecutorUtil.showBalloonMessage$lambda$4(balloonConfig, useAnimationCycle, arg_0));
        balloon.addListener(new JBPopupListener((Function0<Unit>)scheduleShowBalloonLater){
            final /* synthetic */ Function0<Unit> $scheduleShowBalloonLater;
            {
                this.$scheduleShowBalloonLater = $scheduleShowBalloonLater;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$scheduleShowBalloonLater.invoke();
            }
        });
        PositionTracker<Balloon> tracker2 = new PositionTracker<Balloon>(ui, balloonConfig){
            final /* synthetic */ JComponent $ui;
            final /* synthetic */ LearningBalloonConfig $balloonConfig;
            {
                this.$ui = $ui;
                this.$balloonConfig = $balloonConfig;
                super((Component)$ui);
            }

            public RelativePoint recalculateLocation(Balloon balloon) {
                RelativePoint relativePoint;
                Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
                RelativePoint it = relativePoint = LessonExecutorUtil.access$getPointForBalloon(LessonExecutorUtil.INSTANCE, this.$ui, this.$balloonConfig.getSide());
                boolean bl = false;
                if (it == null) {
                    balloon.hide();
                }
                return relativePoint;
            }
        };
        Disposer.register((Disposable)actionsRecorder, (Disposable)((Disposable)tracker2));
        balloon.show((PositionTracker)tracker2, balloonConfig.getSide());
    }

    private final RelativePoint getPointForBalloon(JComponent component2, Balloon.Position side) {
        RelativePoint relativePoint;
        boolean highlighted = LearningUiHighlightingManager.INSTANCE.getHighlightingComponents().contains(component2);
        Rectangle highlightedRect = LearningUiHighlightingManager.INSTANCE.getRectangle(component2);
        if (!component2.isShowing() || highlighted && highlightedRect == null) {
            relativePoint = null;
        } else {
            Rectangle rectangle = highlightedRect;
            if (rectangle == null) {
                rectangle = component2.getVisibleRect();
            }
            Rectangle rectangle2 = rectangle;
            Intrinsics.checkNotNull((Object)rectangle2);
            Point point = this.getPosition(rectangle2, side);
            relativePoint = new RelativePoint((Component)component2, point);
        }
        return relativePoint;
    }

    private final Point getPosition(Rectangle visibleRect, Balloon.Position side) {
        int xShift = switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> 0;
            case 2 -> visibleRect.width;
            case 3, 4 -> visibleRect.width / 2;
            default -> throw new NoWhenBranchMatchedException();
        };
        int yShift = switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 3 -> 0;
            case 4 -> visibleRect.height;
            case 1, 2 -> visibleRect.height / 2;
            default -> throw new NoWhenBranchMatchedException();
        };
        return new Point(visibleRect.x + xShift, visibleRect.y + yShift);
    }

    private static final Unit showBalloonMessage$lambda$0(ActionsRecorder $actionsRecorder, String $text, JComponent $ui, LearningBalloonConfig $balloonConfig, LessonExecutor $lessonExecutor) {
        if (!$actionsRecorder.getDisposed()) {
            INSTANCE.showBalloonMessage($text, $ui, $balloonConfig, $actionsRecorder, $lessonExecutor, true);
        }
        return Unit.INSTANCE;
    }

    private static final void showBalloonMessage$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void showBalloonMessage$lambda$2$0(LessonExecutor $lessonExecutor, ActionsRecorder $actionsRecorder, String $text, JComponent $ui, LearningBalloonConfig $balloonConfig) {
        LessonExecutor $this$iv = $lessonExecutor;
        ModalityState modalityState$iv = null;
        boolean $i$f$taskInvokeLater = false;
        ActionsKt.invokeLater(modalityState$iv, (Function0)((Function0)new Function0<Unit>($this$iv, $actionsRecorder, $text, $ui, $balloonConfig, $lessonExecutor){
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ ActionsRecorder $actionsRecorder$inlined;
            final /* synthetic */ String $text$inlined;
            final /* synthetic */ JComponent $ui$inlined;
            final /* synthetic */ LearningBalloonConfig $balloonConfig$inlined;
            final /* synthetic */ LessonExecutor $lessonExecutor$inlined;
            {
                this.this$0 = $receiver;
                this.$actionsRecorder$inlined = actionsRecorder;
                this.$text$inlined = string;
                this.$ui$inlined = jComponent;
                this.$balloonConfig$inlined = learningBalloonConfig;
                this.$lessonExecutor$inlined = lessonExecutor;
            }

            public final void invoke() {
                try {
                    if (!this.this$0.getHasBeenStopped()) {
                        boolean bl = false;
                        if (!this.$actionsRecorder$inlined.getDisposed()) {
                            LessonExecutorUtil.access$showBalloonMessage(LessonExecutorUtil.INSTANCE, this.$text$inlined, this.$ui$inlined, this.$balloonConfig$inlined, this.$actionsRecorder$inlined, this.$lessonExecutor$inlined, false);
                        }
                    }
                }
                catch (Throwable e) {
                    LessonExecutor $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LessonExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(this.this$0.getLessonInfoString(), e);
                }
            }
        }));
    }

    private static final Unit showBalloonMessage$lambda$2(LessonExecutor $lessonExecutor, ActionsRecorder $actionsRecorder, String $text, JComponent $ui, LearningBalloonConfig $balloonConfig) {
        new Alarm().addRequest(() -> LessonExecutorUtil.showBalloonMessage$lambda$2$0($lessonExecutor, $actionsRecorder, $text, $ui, $balloonConfig), 500);
        return Unit.INSTANCE;
    }

    private static final Unit showBalloonMessage$lambda$3(LearningBalloonConfig $balloonConfig) {
        block0: {
            Function0<Unit> function0 = $balloonConfig.getGotItCallBack();
            if (function0 == null) break block0;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final BalloonBuilder showBalloonMessage$lambda$4(LearningBalloonConfig $balloonConfig, boolean $useAnimationCycle, BalloonBuilder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $this$build.setCornerToPointerDistance(JBUI.scale((int)$balloonConfig.getCornerToPointerDistance()));
        $this$build.setAnimationCycle($useAnimationCycle ? $balloonConfig.getAnimationCycle() : 0);
        $this$build.setCloseButtonEnabled(false);
        BalloonBuilder balloonBuilder = $this$build.setHideOnCloseClick(false);
        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setHideOnCloseClick(...)");
        return balloonBuilder;
    }

    public static final /* synthetic */ RelativePoint access$getPointForBalloon(LessonExecutorUtil $this, JComponent component2, Balloon.Position side) {
        return $this.getPointForBalloon(component2, side);
    }

    public static final /* synthetic */ void access$showBalloonMessage(LessonExecutorUtil $this, String text, JComponent ui, LearningBalloonConfig balloonConfig, ActionsRecorder actionsRecorder, LessonExecutor lessonExecutor, boolean useAnimationCycle) {
        $this.showBalloonMessage(text, ui, balloonConfig, actionsRecorder, lessonExecutor, useAnimationCycle);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Balloon.Position.values().length];
            try {
                nArray[Balloon.Position.atLeft.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Balloon.Position.atRight.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Balloon.Position.above.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Balloon.Position.below.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

