/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.SuggesterSupport;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.TextFragment;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.BeforeEditorTextRemovedAction;
import training.featuresSuggester.suggesters.AbstractFeatureSuggester;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0003./0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u0019*\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u0019*\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0014\u0010 \u001a\u00020!*\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0014\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0014\u0010%\u001a\u00020!*\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0014\u0010&\u001a\u00020#*\u00020$2\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0014\u0010+\u001a\u00020#*\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010'\u001a\u00020\u0011*\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00061"}, d2={"Ltraining/featuresSuggester/suggesters/UnwrapSuggester;", "Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "suggestingActionDisplayName", "getSuggestingActionDisplayName", "message", "getMessage", "suggestingActionId", "getSuggestingActionId", "suggestingDocUrl", "getSuggestingDocUrl", "minSuggestingIntervalDays", "", "getMinSuggestingIntervalDays", "()I", "languages", "", "getLanguages", "()Ljava/util/List;", "getSuggestion", "Ltraining/featuresSuggester/Suggestion;", "action", "Ltraining/featuresSuggester/actions/Action;", "handleCloseBraceDeleted", "Ltraining/featuresSuggester/SuggesterSupport;", "Ltraining/featuresSuggester/actions/BeforeEditorTextRemovedAction;", "handleStatementStartDeleted", "handleCloseBraceDeletedFirst", "", "checkStatementStartDeleted", "", "Ltraining/featuresSuggester/suggesters/UnwrapSuggester$State;", "handleStatementStartDeletedFirst", "checkCloseBraceDeleted", "contentStartOffset", "Ltraining/featuresSuggester/TextFragment;", "getContentStartOffset", "(Ltraining/featuresSuggester/TextFragment;)I", "isSurroundingStatement", "psiElement", "Lcom/intellij/psi/PsiElement;", "State", "Companion", "Holder", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nUnwrapSuggester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnwrapSuggester.kt\ntraining/featuresSuggester/suggesters/UnwrapSuggester\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,148:1\n161#2,6:149\n*S KotlinDebug\n*F\n+ 1 UnwrapSuggester.kt\ntraining/featuresSuggester/suggesters/UnwrapSuggester\n*L\n132#1:149,6\n*E\n"})
public final class UnwrapSuggester
extends AbstractFeatureSuggester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String suggestingActionDisplayName = FeatureSuggesterBundle.INSTANCE.message("unwrap.name", new Object[0]);
    @NotNull
    private final String message = FeatureSuggesterBundle.INSTANCE.message("unwrap.message", new Object[0]);
    @NotNull
    private final String suggestingActionId;
    @NotNull
    private final String suggestingDocUrl;
    private final int minSuggestingIntervalDays;
    @NotNull
    private final List<String> languages;
    public static final long MAX_TIME_MILLIS_BETWEEN_ACTIONS = 7000L;

    public UnwrapSuggester() {
        this.id = "Unwrap";
        this.suggestingActionId = "Unwrap";
        this.suggestingDocUrl = "https://www.jetbrains.com/help/idea/working-with-source-code.html#unwrap_remove_statement";
        this.minSuggestingIntervalDays = 14;
        Object[] objectArray = new String[]{"JAVA", "kotlin", "JavaScript", "ECMAScript 6"};
        this.languages = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getSuggestingActionDisplayName() {
        return this.suggestingActionDisplayName;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    protected String getSuggestingActionId() {
        return this.suggestingActionId;
    }

    @Override
    @NotNull
    protected String getSuggestingDocUrl() {
        return this.suggestingDocUrl;
    }

    @Override
    public int getMinSuggestingIntervalDays() {
        return this.minSuggestingIntervalDays;
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    @NotNull
    public Suggestion getSuggestion(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Language language = action.getLanguage();
        if (language == null) {
            return NoSuggestion.INSTANCE;
        }
        Language language2 = language;
        SuggesterSupport suggesterSupport = SuggesterSupport.Companion.getForLanguage(language2);
        if (suggesterSupport == null) {
            return NoSuggestion.INSTANCE;
        }
        SuggesterSupport langSupport = suggesterSupport;
        if (action instanceof BeforeEditorTextRemovedAction) {
            String text = ((BeforeEditorTextRemovedAction)action).getTextFragment().getText();
            if (Intrinsics.areEqual((Object)text, (Object)"}")) {
                return this.handleCloseBraceDeleted(langSupport, (BeforeEditorTextRemovedAction)action);
            }
            CharSequence charSequence = text;
            if (Holder.INSTANCE.getSurroundingStatementStartRegex().matches(charSequence)) {
                return this.handleStatementStartDeleted(langSupport, (BeforeEditorTextRemovedAction)action);
            }
            State.INSTANCE.reset();
        }
        return NoSuggestion.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Suggestion handleCloseBraceDeleted(SuggesterSupport $this$handleCloseBraceDeleted, BeforeEditorTextRemovedAction action) {
        block7: {
            if (State.INSTANCE.isInitial()) {
                this.handleCloseBraceDeletedFirst($this$handleCloseBraceDeleted, action);
            } else {
                if (State.INSTANCE.getCloseBraceOffset() != -1) {
                    try {
                        if (this.checkCloseBraceDeleted(State.INSTANCE, action)) {
                            Suggestion suggestion = this.createSuggestion();
                            return suggestion;
                        }
                        break block7;
                    }
                    finally {
                        State.INSTANCE.reset();
                    }
                }
                State.INSTANCE.reset();
            }
        }
        return NoSuggestion.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Suggestion handleStatementStartDeleted(SuggesterSupport $this$handleStatementStartDeleted, BeforeEditorTextRemovedAction action) {
        block7: {
            if (State.INSTANCE.isInitial()) {
                this.handleStatementStartDeletedFirst($this$handleStatementStartDeleted, action);
            } else {
                if (State.INSTANCE.getSurroundingStatementStartOffset() != -1) {
                    try {
                        if (this.checkStatementStartDeleted(State.INSTANCE, action)) {
                            Suggestion suggestion = this.createSuggestion();
                            return suggestion;
                        }
                        break block7;
                    }
                    finally {
                        State.INSTANCE.reset();
                    }
                }
                State.INSTANCE.reset();
            }
        }
        return NoSuggestion.INSTANCE;
    }

    private final void handleCloseBraceDeletedFirst(SuggesterSupport $this$handleCloseBraceDeletedFirst, BeforeEditorTextRemovedAction action) {
        PsiFile psiFile = action.getPsiFile();
        if (psiFile == null || (psiFile = psiFile.findElementAt(action.getCaretOffset())) == null) {
            return;
        }
        PsiFile curElement = psiFile;
        PsiElement codeBlock = curElement.getParent();
        Intrinsics.checkNotNull((Object)codeBlock);
        if (!$this$handleCloseBraceDeletedFirst.isCodeBlock(codeBlock)) {
            return;
        }
        List<PsiElement> statements = $this$handleCloseBraceDeletedFirst.getStatements(codeBlock);
        if (!((Collection)statements).isEmpty()) {
            PsiElement psiElement = $this$handleCloseBraceDeletedFirst.getParentStatementOfBlock(codeBlock);
            if (psiElement == null) {
                return;
            }
            PsiElement statement = psiElement;
            if (this.isSurroundingStatement($this$handleCloseBraceDeletedFirst, statement)) {
                State.INSTANCE.setSurroundingStatementStartOffset(PsiTreeUtilKt.getStartOffset((PsiElement)statement));
                State.INSTANCE.setLastChangeTimeMillis(action.getTimeMillis());
            }
        }
    }

    private final boolean checkStatementStartDeleted(State $this$checkStatementStartDeleted, BeforeEditorTextRemovedAction action) {
        return !$this$checkStatementStartDeleted.isOutOfDate(action.getTimeMillis()) && $this$checkStatementStartDeleted.getSurroundingStatementStartOffset() == this.getContentStartOffset(action.getTextFragment());
    }

    private final void handleStatementStartDeletedFirst(SuggesterSupport $this$handleStatementStartDeletedFirst, BeforeEditorTextRemovedAction action) {
        TextFragment textFragment = action.getTextFragment();
        PsiFile psiFile = action.getPsiFile();
        if (psiFile == null || (psiFile = psiFile.findElementAt(this.getContentStartOffset(textFragment))) == null) {
            return;
        }
        PsiFile curElement = psiFile;
        PsiElement curStatement = curElement.getParent();
        Intrinsics.checkNotNull((Object)curStatement);
        if (this.isSurroundingStatement($this$handleStatementStartDeletedFirst, curStatement)) {
            PsiElement psiElement = $this$handleStatementStartDeletedFirst.getCodeBlock(curStatement);
            if (psiElement == null) {
                return;
            }
            PsiElement codeBlock = psiElement;
            List<PsiElement> statements = $this$handleStatementStartDeletedFirst.getStatements(codeBlock);
            if (!((Collection)statements).isEmpty()) {
                State.INSTANCE.setCloseBraceOffset(PsiTreeUtilKt.getEndOffset((PsiElement)curStatement) - textFragment.getText().length() - 1);
                State.INSTANCE.setLastChangeTimeMillis(action.getTimeMillis());
            }
        }
    }

    private final boolean checkCloseBraceDeleted(State $this$checkCloseBraceDeleted, BeforeEditorTextRemovedAction action) {
        return !$this$checkCloseBraceDeleted.isOutOfDate(action.getTimeMillis()) && action.getCaretOffset() == $this$checkCloseBraceDeleted.getCloseBraceOffset();
    }

    private final int getContentStartOffset(TextFragment $this$contentStartOffset) {
        int n;
        block1: {
            CharSequence $this$indexOfFirst$iv = $this$contentStartOffset.getText();
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != ' ' && it != '\n')) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int countOfStartDelimiters = n;
        return $this$contentStartOffset.getStartOffset() + countOfStartDelimiters;
    }

    private final boolean isSurroundingStatement(SuggesterSupport $this$isSurroundingStatement, PsiElement psiElement) {
        return $this$isSurroundingStatement.isIfStatement(psiElement) || $this$isSurroundingStatement.isForStatement(psiElement) || $this$isSurroundingStatement.isWhileStatement(psiElement);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltraining/featuresSuggester/suggesters/UnwrapSuggester$Companion;", "", "<init>", "()V", "MAX_TIME_MILLIS_BETWEEN_ACTIONS", "", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltraining/featuresSuggester/suggesters/UnwrapSuggester$Holder;", "", "<init>", "()V", "surroundingStatementStartRegex", "Lkotlin/text/Regex;", "getSurroundingStatementStartRegex", "()Lkotlin/text/Regex;", "intellij.featuresTrainer"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final Regex surroundingStatementStartRegex = new Regex("[ \\n]*(if|for|while)[ \\n]*\\(.*\\)[ \\n]*\\{[ \\n]*");

        private Holder() {
        }

        @NotNull
        public final Regex getSurroundingStatementStartRegex() {
            return surroundingStatementStartRegex;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u001a"}, d2={"Ltraining/featuresSuggester/suggesters/UnwrapSuggester$State;", "", "<init>", "()V", "surroundingStatementStartOffset", "", "getSurroundingStatementStartOffset", "()I", "setSurroundingStatementStartOffset", "(I)V", "closeBraceOffset", "getCloseBraceOffset", "setCloseBraceOffset", "lastChangeTimeMillis", "", "getLastChangeTimeMillis", "()J", "setLastChangeTimeMillis", "(J)V", "isInitial", "", "()Z", "isOutOfDate", "newChangeTimeMillis", "reset", "", "intellij.featuresTrainer"})
    private static final class State {
        @NotNull
        public static final State INSTANCE = new State();
        private static int surroundingStatementStartOffset = -1;
        private static int closeBraceOffset = -1;
        private static long lastChangeTimeMillis;

        private State() {
        }

        public final int getSurroundingStatementStartOffset() {
            return surroundingStatementStartOffset;
        }

        public final void setSurroundingStatementStartOffset(int n) {
            surroundingStatementStartOffset = n;
        }

        public final int getCloseBraceOffset() {
            return closeBraceOffset;
        }

        public final void setCloseBraceOffset(int n) {
            closeBraceOffset = n;
        }

        public final long getLastChangeTimeMillis() {
            return lastChangeTimeMillis;
        }

        public final void setLastChangeTimeMillis(long l) {
            lastChangeTimeMillis = l;
        }

        public final boolean isInitial() {
            return surroundingStatementStartOffset == -1 && closeBraceOffset == -1;
        }

        public final boolean isOutOfDate(long newChangeTimeMillis) {
            return newChangeTimeMillis - lastChangeTimeMillis > 7000L;
        }

        public final void reset() {
            surroundingStatementStartOffset = -1;
            closeBraceOffset = -1;
            lastChangeTimeMillis = 0L;
        }
    }
}

