/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.ide.ui.text.ActionKeyPopupKt;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.CodeTextPart;
import com.intellij.ide.ui.text.parts.IconTextPart;
import com.intellij.ide.ui.text.parts.IllustrationTextPart;
import com.intellij.ide.ui.text.parts.LinkTextPart;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.ShortcutTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.GotItTextBuilder;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonUtil;
import training.learn.LearnBundle;
import training.statistic.StatisticBase;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0010\u001a\u00020\rH\u0002J&\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0013\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u00140\u0012\u00a2\u0006\u0002\b\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltraining/ui/MessageFactory;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "convert", "", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "text", "", "parseXml", "Lorg/jdom/Element;", "convertParagraph", "Lcom/intellij/ide/ui/text/parts/TextPart;", "element", "convertToGotItFormat", "Lkotlin/Function1;", "Lcom/intellij/ui/GotItTextBuilder;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/ExtensionFunctionType;", "htmlText", "IftShortcutTextPart", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nMessageFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageFactory.kt\ntraining/ui/MessageFactory\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,209:1\n161#2,6:210\n161#2,6:216\n*S KotlinDebug\n*F\n+ 1 MessageFactory.kt\ntraining/ui/MessageFactory\n*L\n62#1:210,6\n133#1:216,6\n*E\n"})
public final class MessageFactory {
    @NotNull
    public static final MessageFactory INSTANCE = new MessageFactory();
    @NotNull
    private static final Logger LOG;

    private MessageFactory() {
    }

    @NotNull
    public final List<TextParagraph> convert(@Language(value="HTML") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String[] stringArray = new String[]{"\n"};
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null), MessageFactory::convert$lambda$0));
    }

    private final Element parseXml(@Language(value="HTML") String text) {
        String wrappedText;
        String string = wrappedText = "<root>" + text + "</root>";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Element element = JDOMUtil.load((InputStream)new ByteArrayInputStream(byArray));
        if (element == null) {
            throw new IllegalStateException(("Can't parse as XML:\n" + text).toString());
        }
        return element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<TextPart> convertParagraph(Element element) {
        List list = new ArrayList();
        for (Content content : element.getContent()) {
            if (content instanceof Text) {
                Object text = ((Text)content).getValue();
                if (Pattern.matches(" *\\p{IsPunctuation}.*", (CharSequence)text)) {
                    int n;
                    CharSequence $this$indexOfFirst$iv;
                    block45: {
                        String string = text;
                        Intrinsics.checkNotNull((Object)string);
                        $this$indexOfFirst$iv = string;
                        boolean $i$f$indexOfFirst = false;
                        int n2 = $this$indexOfFirst$iv.length();
                        for (int index$iv = 0; index$iv < n2; ++index$iv) {
                            char it = $this$indexOfFirst$iv.charAt(index$iv);
                            boolean bl = false;
                            if (!(it != ' ')) continue;
                            n = index$iv;
                            break block45;
                        }
                        n = -1;
                    }
                    int indexOfFirst = n;
                    String string = StringsKt.repeat((CharSequence)"\u00a0", (int)indexOfFirst);
                    $this$indexOfFirst$iv = text;
                    Intrinsics.checkNotNull((Object)$this$indexOfFirst$iv);
                    String string2 = ((String)$this$indexOfFirst$iv).substring(indexOfFirst);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    text = string + string2;
                }
                String indexOfFirst = text;
                Intrinsics.checkNotNull((Object)indexOfFirst);
                list.add(new RegularTextPart(indexOfFirst, false, 2, null));
                continue;
            }
            if (!(content instanceof Element)) continue;
            XMLOutputter outputter = new XMLOutputter();
            Intrinsics.checkNotNullExpressionValue((Object)Strings.unescapeXmlEntities((String)outputter.outputString(((Element)content).getContent())), (String)"unescapeXmlEntities(...)");
            String string = ((Element)content).getName();
            if (string == null) throw new IllegalStateException(("Unknown tag: " + ((Element)content).getName()).toString());
            int n = -1;
            switch (string.hashCode()) {
                case 97: {
                    if (string.equals("a")) {
                        n = 1;
                    }
                    break;
                }
                case -891980137: {
                    if (string.equals("strong")) {
                        n = 2;
                    }
                    break;
                }
                case 3059181: {
                    if (string.equals("code")) {
                        n = 3;
                    }
                    break;
                }
                case -342500282: {
                    if (string.equals("shortcut")) {
                        n = 4;
                    }
                    break;
                }
                case 3226745: {
                    if (string.equals("icon")) {
                        n = 5;
                    }
                    break;
                }
                case -172220347: {
                    if (string.equals("callback")) {
                        n = 6;
                    }
                    break;
                }
                case -1422950858: {
                    if (string.equals("action")) {
                        n = 7;
                    }
                    break;
                }
                case 891970896: {
                    if (string.equals("illustration")) {
                        n = 8;
                    }
                    break;
                }
                case 104106: {
                    if (string.equals("ide")) {
                        n = 9;
                    }
                    break;
                }
                case -737600009: {
                    if (string.equals("icon_idx")) {
                        n = 10;
                    }
                    break;
                }
                case 1457652349: {
                    if (string.equals("raw_shortcut")) {
                        n = 11;
                    }
                    break;
                }
            }
            TextPart newPart = switch (n) {
                case 5 -> throw new IllegalStateException("Need to return reflection-based icon processing".toString());
                case 10 -> {
                    Icon icon;
                    String text;
                    if ((Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)text) == null) {
                        throw new IllegalStateException(("Not found icon with id: " + text).toString());
                    }
                    yield (TextPart)new IconTextPart(icon);
                }
                case 8 -> {
                    Icon icon;
                    String text;
                    if ((Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)text) == null) {
                        throw new IllegalStateException(("Not found icon with id: " + text).toString());
                    }
                    yield (TextPart)new IllustrationTextPart(icon);
                }
                case 2 -> {
                    String text;
                    yield (TextPart)new RegularTextPart(text, true);
                }
                case 3 -> {
                    String text;
                    yield (TextPart)new CodeTextPart(text);
                }
                case 6 -> {
                    String text;
                    String id = ((Element)content).getAttributeValue("id");
                    if (id == null) throw new IllegalStateException(("'callback' tag with text '" + text + "' should contain 'id' attribute").toString());
                    Function0<Unit> callback = LearningUiManager.INSTANCE.getAndClearCallback(id);
                    if (callback == null) {
                        throw new IllegalStateException(("Unknown callback with id '" + id + "' and text '" + text + "'").toString());
                    }
                    yield (TextPart)new LinkTextPart(text, callback);
                }
                case 1 -> {
                    String link;
                    String text;
                    if (((Element)content).getAttributeValue("href") == null) {
                        throw new IllegalStateException(("'a' tag with text '" + text + "' should contain 'href' attribute").toString());
                    }
                    yield (TextPart)new LinkTextPart(text, () -> MessageFactory.convertParagraph$lambda$1(link));
                }
                case 7 -> {
                    String text;
                    yield (TextPart)new IftShortcutTextPart(text, false);
                }
                case 4 -> {
                    String text;
                    yield (TextPart)new IftShortcutTextPart(text, true);
                }
                case 11 -> {
                    String text;
                    yield (TextPart)new IftShortcutTextPart(text, true);
                }
                case 9 -> (TextPart)new RegularTextPart(LessonUtil.INSTANCE.getProductName(), false, 2, null);
                default -> throw new IllegalStateException(("Unknown tag: " + ((Element)content).getName()).toString());
            };
            list.add(newPart);
        }
        return list;
    }

    @NotNull
    public final Function1<GotItTextBuilder, String> convertToGotItFormat(@Language(value="HTML") @NotNull String htmlText) {
        Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
        return arg_0 -> MessageFactory.convertToGotItFormat$lambda$0(htmlText, arg_0);
    }

    private static final TextParagraph convert$lambda$0(String paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        Element textAsElement = INSTANCE.parseXml(paragraph);
        List<TextPart> parts = INSTANCE.convertParagraph(textAsElement);
        return new TextParagraph(parts);
    }

    private static final Unit convertParagraph$lambda$1(String $link) {
        try {
            UtilsKt.openLinkInBrowser($link);
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String convertToGotItFormat$lambda$0(String $htmlText, GotItTextBuilder gotItTextBuilder) {
        Intrinsics.checkNotNullParameter((Object)gotItTextBuilder, (String)"<this>");
        if (StringsKt.contains$default((CharSequence)$htmlText, (char)'\n', (boolean)false, (int)2, null)) {
            throw new IllegalStateException(("GotIt tooltip can contain only single paragraph, provided text:\n" + $htmlText).toString());
        }
        String spaces = "\u00a0\u00a0";
        String adjustedText = StringsKt.replace$default((String)StringsKt.replace$default((String)$htmlText, (String)(spaces + "<"), (String)"<", (boolean)false, (int)4, null), (String)(">" + spaces), (String)">", (boolean)false, (int)4, null);
        Element element = INSTANCE.parseXml(adjustedText);
        StringBuilder builder = new StringBuilder();
        for (Content content : element.getContent()) {
            String string;
            Object text;
            if (content instanceof Text) {
                text = ((Text)content).getValue();
                if (Pattern.matches(" *\\p{IsPunctuation}.*", (CharSequence)text)) {
                    int n;
                    block45: {
                        string = text;
                        Intrinsics.checkNotNull((Object)string);
                        CharSequence $this$indexOfFirst$iv = string;
                        boolean $i$f$indexOfFirst = false;
                        int n2 = $this$indexOfFirst$iv.length();
                        for (int index$iv = 0; index$iv < n2; ++index$iv) {
                            char it = $this$indexOfFirst$iv.charAt(index$iv);
                            boolean bl = false;
                            if (!(it != ' ')) continue;
                            n = index$iv;
                            break block45;
                        }
                        n = -1;
                    }
                    int indexOfFirst = n;
                    String string2 = StringsKt.repeat((CharSequence)"\u00a0", (int)indexOfFirst);
                    string = text;
                    Intrinsics.checkNotNull((Object)string);
                    String string3 = string.substring(indexOfFirst);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    text = string2 + string3;
                }
                builder.append((String)text);
                continue;
            }
            if (!(content instanceof Element)) continue;
            text = new XMLOutputter().outputString(((Element)content).getContent());
            string = ((Element)content).getName();
            if (string == null) throw new IllegalStateException(("Unknown tag: " + ((Element)content).getName()).toString());
            int n = -1;
            switch (string.hashCode()) {
                case 97: {
                    if (string.equals("a")) {
                        n = 1;
                    }
                    break;
                }
                case -891980137: {
                    if (string.equals("strong")) {
                        n = 2;
                    }
                    break;
                }
                case 3059181: {
                    if (string.equals("code")) {
                        n = 3;
                    }
                    break;
                }
                case -342500282: {
                    if (string.equals("shortcut")) {
                        n = 4;
                    }
                    break;
                }
                case 3226745: {
                    if (string.equals("icon")) {
                        n = 5;
                    }
                    break;
                }
                case -172220347: {
                    if (string.equals("callback")) {
                        n = 6;
                    }
                    break;
                }
                case -1422950858: {
                    if (string.equals("action")) {
                        n = 7;
                    }
                    break;
                }
                case 891970896: {
                    if (string.equals("illustration")) {
                        n = 8;
                    }
                    break;
                }
                case 104106: {
                    if (string.equals("ide")) {
                        n = 9;
                    }
                    break;
                }
                case -737600009: {
                    if (string.equals("icon_idx")) {
                        n = 10;
                    }
                    break;
                }
                case 1457652349: {
                    if (string.equals("raw_shortcut")) {
                        n = 11;
                    }
                    break;
                }
            }
            Object textToAppend = switch (n) {
                case 2 -> "<b>" + (String)text + "</b>";
                case 10 -> {
                    Icon icon;
                    if ((Icon)LearningUiManager.INSTANCE.getIconMap().get(text) == null) {
                        throw new IllegalStateException(("Not found icon with id: " + (String)text).toString());
                    }
                    yield gotItTextBuilder.icon(icon);
                }
                case 6 -> {
                    String id = ((Element)content).getAttributeValue("id");
                    if (id == null) throw new IllegalStateException(("'callback' tag with text '" + (String)text + "' should contain 'id' attribute").toString());
                    Function0<Unit> callback = LearningUiManager.INSTANCE.getAndClearCallback(id);
                    if (callback == null) throw new IllegalStateException(("Unknown callback with id '" + id + "' and text '" + (String)text + "'").toString());
                    Intrinsics.checkNotNull((Object)text);
                    yield gotItTextBuilder.link((String)text, callback);
                }
                case 1 -> {
                    String link;
                    if (((Element)content).getAttributeValue("href") == null) {
                        throw new IllegalStateException(("'a' tag with text '" + (String)text + "' should contain 'href' attribute").toString());
                    }
                    Intrinsics.checkNotNull((Object)text);
                    yield gotItTextBuilder.browserLink((String)text, new URL(link));
                }
                case 7 -> {
                    Intrinsics.checkNotNull((Object)text);
                    yield gotItTextBuilder.shortcut((String)text);
                }
                case 11 -> {
                    KeyStroke keyStroke;
                    if (KeyStroke.getKeyStroke((String)text) == null) {
                        throw new IllegalStateException(("Failed to parse key stroke, element: " + element).toString());
                    }
                    yield gotItTextBuilder.shortcut(keyStroke);
                }
                case 3 -> {
                    Intrinsics.checkNotNull((Object)text);
                    yield gotItTextBuilder.code((String)text);
                }
                case 9 -> LessonUtil.INSTANCE.getProductName();
                case 5 -> throw new IllegalStateException("Need to return reflection-based icon processing".toString());
                case 8 -> throw new IllegalStateException("Illustrations are not supported in Features Trainer GotIt tooltips for now".toString());
                case 4 -> throw new IllegalStateException(("Use 'raw_shortcut' with providing key stroke instead, element: " + element).toString());
                default -> throw new IllegalStateException(("Unknown tag: " + ((Element)content).getName()).toString());
            };
            builder.append((String)textToAppend);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        Logger logger = Logger.getInstance(MessageFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R=\u0010\b\u001a+\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Ltraining/ui/MessageFactory$IftShortcutTextPart;", "Lcom/intellij/ide/ui/text/parts/ShortcutTextPart;", "text", "", "isRaw", "", "<init>", "(Ljava/lang/String;Z)V", "onClickAction", "Lkotlin/Function3;", "Ljavax/swing/JTextPane;", "Ljava/awt/Point;", "", "Lkotlin/ParameterName;", "name", "height", "", "getOnClickAction", "()Lkotlin/jvm/functions/Function3;", "showActionKeyPopupExtended", "textPane", "point", "actionId", "intellij.featuresTrainer"})
    private static final class IftShortcutTextPart
    extends ShortcutTextPart {
        public IftShortcutTextPart(@NotNull String text, boolean isRaw) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, isRaw);
        }

        @Nullable
        public Function3<JTextPane, Point, Integer, Unit> getOnClickAction() {
            return !this.isRaw() ? (arg_0, arg_1, arg_2) -> IftShortcutTextPart._get_onClickAction_$lambda$0(this, arg_0, arg_1, arg_2) : null;
        }

        private final void showActionKeyPopupExtended(JTextPane textPane, Point point, int height, String actionId) {
            ActionKeyPopupKt.showActionKeyPopup((Component)textPane, (Point)point, (int)height, (String)actionId, arg_0 -> IftShortcutTextPart.showActionKeyPopupExtended$lambda$0(actionId, arg_0));
        }

        private static final Unit _get_onClickAction_$lambda$0(IftShortcutTextPart this$0, JTextPane textPane, Point point, int height) {
            Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            String actionId = this$0.getText();
            this$0.showActionKeyPopupExtended(textPane, point, height, actionId);
            StatisticBase.INSTANCE.logShortcutClicked(actionId);
            return Unit.INSTANCE;
        }

        private static final Unit showActionKeyPopupExtended$lambda$0$0(String $actionId, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AnAction action = ActionManager.getInstance().getAction($actionId);
            Intrinsics.checkNotNull((Object)action);
            UtilsKt.invokeActionForFocusContext(action);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit showActionKeyPopupExtended$lambda$0(String $actionId, JPanel panel) {
            void it;
            ActionLink actionLink;
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            ActionLink actionLink2 = actionLink = new ActionLink(LearnBundle.INSTANCE.message("shortcut.balloon.apply.this.action", new Object[0]), arg_0 -> IftShortcutTextPart.showActionKeyPopupExtended$lambda$0$0($actionId, arg_0));
            JPanel jPanel = panel;
            boolean bl = false;
            it.setForeground((Color)JBColor.namedColor((String)"ToolTip.linkForeground", (Color)JBUI.CurrentTheme.Link.Foreground.ENABLED));
            jPanel.add((Component)actionLink);
            return Unit.INSTANCE;
        }
    }
}

