/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.dataframe;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.scientific.tables.nestedTable.ColumnTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001b\u001a\u00020\u0018*\u00020\u0019\u001a\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u0001*\u00020\u0019H\u0002\u001a\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0019*\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a\b\u0010 \u001a\u00020!H\u0002\u001a\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u0016\u0010\u0014\"\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a8\u0006#"}, d2={"SERIALIZED_DATAFRAME_FIELD", "", "COLUMNS_FIELD", "TYPES_FIELD", "NUM_ROWS_FIELD", "NUM_COLS_FIELD", "VERSION_FIELD", "DATA_FIELD", "METADATA_FIELD", "COLUMN_KIND_FIELD", "VALUE_COLUMN", "COLUMN_GROUP", "FRAME_COLUMN", "FRAME_CONVERTABLE", "NULL", "newKDFObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "jsonMaxStringLength", "jsonMaxLength", "", "ColumnValues", "", "", "isFrame", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "isFrameLike", "isColumnGroup", "pathToColumnKind", "columnKind", "getByPath", "path", "createRoot", "Lcom/intellij/scientific/tables/nestedTable/ColumnTreeNode;", "childrenNames", "intellij.notebooks.dataframe"})
public final class KotlinDataframeParsingBaseKt {
    @NotNull
    public static final String SERIALIZED_DATAFRAME_FIELD = "kotlin_dataframe";
    @NotNull
    public static final String COLUMNS_FIELD = "columns";
    @NotNull
    public static final String TYPES_FIELD = "types";
    @NotNull
    public static final String NUM_ROWS_FIELD = "nrow";
    @NotNull
    public static final String NUM_COLS_FIELD = "ncol";
    @NotNull
    public static final String VERSION_FIELD = "$version";
    @NotNull
    public static final String DATA_FIELD = "data";
    @NotNull
    public static final String METADATA_FIELD = "metadata";
    @NotNull
    public static final String COLUMN_KIND_FIELD = "kind";
    @NotNull
    public static final String VALUE_COLUMN = "ValueColumn";
    @NotNull
    public static final String COLUMN_GROUP = "ColumnGroup";
    @NotNull
    public static final String FRAME_COLUMN = "FrameColumn";
    @NotNull
    public static final String FRAME_CONVERTABLE = "DataFrameConvertable";
    @NotNull
    public static final String NULL = "null";
    @NotNull
    private static final List<String> pathToColumnKind;

    @NotNull
    public static final ObjectMapper newKDFObjectMapper(@NotNull String jsonMaxStringLength, int jsonMaxLength) {
        Intrinsics.checkNotNullParameter((Object)jsonMaxStringLength, (String)"jsonMaxStringLength");
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(Registry.Companion.intValue(jsonMaxStringLength, jsonMaxLength)).build());
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        JsonParser.Feature[] featureArray = new JsonParser.Feature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature()};
        mapper.enable(featureArray);
        return mapper;
    }

    public static final boolean isFrame(@NotNull JsonNode $this$isFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrame, (String)"<this>");
        return Intrinsics.areEqual((Object)KotlinDataframeParsingBaseKt.columnKind($this$isFrame), (Object)FRAME_COLUMN);
    }

    public static final boolean isFrameLike(@NotNull JsonNode $this$isFrameLike) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrameLike, (String)"<this>");
        return Intrinsics.areEqual((Object)KotlinDataframeParsingBaseKt.columnKind($this$isFrameLike), (Object)FRAME_CONVERTABLE);
    }

    public static final boolean isColumnGroup(@NotNull JsonNode $this$isColumnGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$isColumnGroup, (String)"<this>");
        return Intrinsics.areEqual((Object)KotlinDataframeParsingBaseKt.columnKind($this$isColumnGroup), (Object)COLUMN_GROUP);
    }

    private static final String columnKind(JsonNode $this$columnKind) {
        JsonNode jsonNode = KotlinDataframeParsingBaseKt.getByPath($this$columnKind, pathToColumnKind);
        return jsonNode != null ? jsonNode.asText() : null;
    }

    private static final JsonNode getByPath(JsonNode $this$getByPath, List<String> path) {
        JsonNode result = $this$getByPath;
        for (String field : path) {
            if (result.get(field) != null) continue;
            return null;
        }
        return result;
    }

    private static final ColumnTreeNode createRoot() {
        return new ColumnTreeNode("root", -1, 0, (List)new ArrayList());
    }

    @NotNull
    public static final ColumnTreeNode createRoot(@NotNull List<String> childrenNames) {
        Intrinsics.checkNotNullParameter(childrenNames, (String)"childrenNames");
        ColumnTreeNode root = KotlinDataframeParsingBaseKt.createRoot();
        Iterator iterator = ((Iterable)childrenNames).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String column = (String)iterator.next();
            root.getColumnChildren().add(new ColumnTreeNode(column, index, index, (List)new ArrayList()));
        }
        return root;
    }

    public static final /* synthetic */ JsonNode access$getByPath(JsonNode $receiver, List path) {
        return KotlinDataframeParsingBaseKt.getByPath($receiver, path);
    }

    public static final /* synthetic */ ColumnTreeNode access$createRoot() {
        return KotlinDataframeParsingBaseKt.createRoot();
    }

    static {
        Object[] objectArray = new String[]{METADATA_FIELD, COLUMN_KIND_FIELD};
        pathToColumnKind = CollectionsKt.listOf((Object[])objectArray);
    }
}

