/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.messaging.jms;

import com.intellij.javaee.messaging.JmsConstants;
import com.intellij.javaee.messaging.JmsMQUtilsKt;
import com.intellij.microservices.jvm.mq.MQReferenceRegistrarKt;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.microservices.jvm.mq.MQTypes;
import com.intellij.microservices.jvm.mq.NamedMQType;
import com.intellij.microservices.jvm.mq.references.MQReference;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceByUsageAdapterKt;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javaee/messaging/jms/JmsMQReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "<init>", "()V", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "registerJms", "registerRabbit", "registerActive", "intellij.javaee.extensions"})
public final class JmsMQReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        this.registerJms(registrar);
        this.registerActive(registrar);
        this.registerRabbit(registrar);
    }

    private final void registerJms(PsiReferenceRegistrar registrar) {
        Function1 psiFilter = JmsMQReferenceContributor::registerJms$lambda$0;
        UExpressionPattern singleInjectionHostVariable = (UExpressionPattern)UastReferenceByUsageAdapterKt.uInjectionHostInVariable().sourcePsiFilter(psiFilter);
        UExpressionPattern.Capture injectionHostOrReferenceExpression = (UExpressionPattern.Capture)UastPatterns.injectionHostOrReferenceExpression().sourcePsiFilter(psiFilter);
        ElementPattern elementPattern = (ElementPattern)singleInjectionHostVariable;
        UCallExpressionPattern uCallExpressionPattern = UastPatterns.callExpression().withMethodName("createQueue");
        String[] stringArray = new String[]{JmsConstants.JMS_SESSION.javax(), JmsConstants.JMS_XA_SESSION.javax(), JmsConstants.JMS_QUEUE_SESSION.javax(), JmsConstants.JMS_XA_QUEUE_SESSION.javax(), JmsConstants.JMS_CONTEXT.javax(), JmsConstants.JMS_SESSION.jakarta(), JmsConstants.JMS_XA_SESSION.jakarta(), JmsConstants.JMS_QUEUE_SESSION.jakarta(), JmsConstants.JMS_XA_QUEUE_SESSION.jakarta(), JmsConstants.JMS_CONTEXT.jakarta()};
        PsiClassPattern psiClassPattern = PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)psiClassPattern, (String)"withQualifiedName(...)");
        UastReferenceRegistrar.registerReferenceProviderByUsage$default((PsiReferenceRegistrar)registrar, (ElementPattern)elementPattern, (ElementPattern)((ElementPattern)injectionHostOrReferenceExpression.callParameter(0, (ElementPattern)uCallExpressionPattern.withReceiver((ElementPattern)psiClassPattern))), (UastReferenceProvider)((UastReferenceProvider)MQReferenceRegistrarKt.uastMqReferenceProvider((MQType)((MQType)MQTypes.QUEUE_EXCHANGE_TYPE))), (double)0.0, (int)8, null);
        ElementPattern elementPattern2 = (ElementPattern)singleInjectionHostVariable;
        UCallExpressionPattern uCallExpressionPattern2 = UastPatterns.callExpression().withMethodName("createTopic");
        stringArray = new String[]{JmsConstants.JMS_SESSION.javax(), JmsConstants.JMS_XA_SESSION.javax(), JmsConstants.JMS_TOPIC_SESSION.javax(), JmsConstants.JMS_XA_TOPIC_SESSION.javax(), JmsConstants.JMS_CONTEXT.javax(), JmsConstants.JMS_SESSION.jakarta(), JmsConstants.JMS_XA_SESSION.jakarta(), JmsConstants.JMS_TOPIC_SESSION.jakarta(), JmsConstants.JMS_XA_TOPIC_SESSION.jakarta(), JmsConstants.JMS_CONTEXT.jakarta()};
        PsiClassPattern psiClassPattern2 = PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)psiClassPattern2, (String)"withQualifiedName(...)");
        UastReferenceRegistrar.registerReferenceProviderByUsage$default((PsiReferenceRegistrar)registrar, (ElementPattern)elementPattern2, (ElementPattern)((ElementPattern)injectionHostOrReferenceExpression.callParameter(0, (ElementPattern)uCallExpressionPattern2.withReceiver((ElementPattern)psiClassPattern2))), (UastReferenceProvider)((UastReferenceProvider)MQReferenceRegistrarKt.uastMqReferenceProvider((MQType)((MQType)MQTypes.TOPIC_EXCHANGE_TYPE))), (double)0.0, (int)8, null);
    }

    private final void registerRabbit(PsiReferenceRegistrar registrar) {
        Function1 psiFilter = JmsMQReferenceContributor::registerRabbit$lambda$0;
        UExpressionPattern singleInjectionHostVariable = (UExpressionPattern)UastReferenceByUsageAdapterKt.uInjectionHostInVariable().sourcePsiFilter(psiFilter);
        UExpressionPattern.Capture injectionHostOrReferenceExpression = (UExpressionPattern.Capture)UastPatterns.injectionHostOrReferenceExpression().sourcePsiFilter(psiFilter);
        UastReferenceRegistrar.registerReferenceProviderByUsage((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)singleInjectionHostVariable), (ElementPattern)((ElementPattern)injectionHostOrReferenceExpression.callParameter(0, (ElementPattern)UastPatterns.callExpression().constructor("com.rabbitmq.jms.admin.RMQDestination"))), (UastReferenceProvider)MQReferenceRegistrarKt.uastMqReferenceProviderByUsage(JmsMQReferenceContributor::registerRabbit$lambda$1), (double)100.0);
    }

    private final void registerActive(PsiReferenceRegistrar registrar) {
        Function1 psiFilter = JmsMQReferenceContributor::registerActive$lambda$0;
        UExpressionPattern singleInjectionHostVariable = (UExpressionPattern)UastReferenceByUsageAdapterKt.uInjectionHostInVariable().sourcePsiFilter(psiFilter);
        UExpressionPattern.Capture injectionHostOrReferenceExpression = (UExpressionPattern.Capture)UastPatterns.injectionHostOrReferenceExpression().sourcePsiFilter(psiFilter);
        UastReferenceRegistrar.registerReferenceProviderByUsage((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)singleInjectionHostVariable), (ElementPattern)((ElementPattern)injectionHostOrReferenceExpression.callParameter(0, (ElementPattern)UastPatterns.callExpression().constructor("org.apache.activemq.command.ActiveMQQueue"))), (UastReferenceProvider)((UastReferenceProvider)MQReferenceRegistrarKt.uastMqReferenceProvider((MQType)((MQType)MQTypes.ACTIVE_MQ_QUEUE_TYPE))), (double)100.0);
        UastReferenceRegistrar.registerReferenceProviderByUsage((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)singleInjectionHostVariable), (ElementPattern)((ElementPattern)injectionHostOrReferenceExpression.callParameter(0, (ElementPattern)UastPatterns.callExpression().constructor("org.apache.activemq.command.ActiveMQTopic"))), (UastReferenceProvider)((UastReferenceProvider)MQReferenceRegistrarKt.uastMqReferenceProvider((MQType)((MQType)MQTypes.ACTIVE_MQ_TOPIC_TYPE))), (double)100.0);
    }

    private static final boolean registerJms$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project = it.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JmsMQUtilsKt.isJmsAvailable(project);
    }

    private static final boolean registerRabbit$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project = it.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JmsMQUtilsKt.isRabbitAvailable(project);
    }

    private static final PsiReference[] registerRabbit$lambda$1(UExpression uExpression, PsiLanguageInjectionHost psi, PsiElement usagePsi) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)usagePsi, (String)"usagePsi");
        UCallExpression callExpr = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)usagePsi, UCallExpression.class, (boolean)false);
        NamedMQType type = JmsMQUtilsKt.isRabbitQueueExpression(callExpr) ? MQTypes.RABBIT_MQ_QUEUE_TYPE : MQTypes.RABBIT_MQ_EXCHANGE_TYPE;
        PsiReference[] psiReferenceArray = new PsiReference[]{new MQReference((MQType)type, (PsiElement)psi)};
        return psiReferenceArray;
    }

    private static final boolean registerActive$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project = it.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JmsMQUtilsKt.isActiveAvailable(project);
    }
}

