/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BaseCompletionParameters;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingService;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCompletionService
extends CompletionService {
    private static final Logger LOG = Logger.getInstance(BaseCompletionService.class);
    @Nullable
    protected CompletionProcess apiCompletionProcess;
    @ApiStatus.Internal
    public static final Key<CompletionContributor> LOOKUP_ELEMENT_CONTRIBUTOR = Key.create((String)"lookup element contributor");
    public static final Key<Long> LOOKUP_ELEMENT_RESULT_ADD_TIMESTAMP_MILLIS = Key.create((String)"lookup element add time");
    public static final Key<Integer> LOOKUP_ELEMENT_RESULT_SET_ORDER = Key.create((String)"lookup element result set order");
    public static final Key<Boolean> FORBID_WORD_COMPLETION = new Key("ForbidWordCompletion");

    public void performCompletion(@NotNull CompletionParameters parameters, @NotNull Consumer<? super CompletionResult> consumer) {
        if (parameters == null) {
            BaseCompletionService.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            BaseCompletionService.$$$reportNull$$$0(1);
        }
        this.apiCompletionProcess = parameters.getProcess();
        try {
            super.performCompletion(parameters, consumer);
        }
        finally {
            this.apiCompletionProcess = null;
        }
    }

    public void setAdvertisementText(@NlsContexts.PopupAdvertisement @Nullable String text) {
        if (text == null) {
            return;
        }
        CompletionProcess completionProcess = this.apiCompletionProcess;
        if (completionProcess instanceof CompletionProcessEx) {
            CompletionProcessEx processEx = (CompletionProcessEx)completionProcess;
            processEx.addAdvertisement(text, null);
        }
    }

    @NotNull
    protected String suggestPrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            BaseCompletionService.$$$reportNull$$$0(2);
        }
        PsiElement position = parameters.getPosition();
        int offset = parameters.getOffset();
        TextRange range = position.getTextRange();
        assert (range.containsOffset(offset)) : String.valueOf(position) + "; " + offset + " not in " + String.valueOf(range);
        String string = CompletionData.findPrefixStatic(position, offset);
        if (string == null) {
            BaseCompletionService.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected PrefixMatcher createMatcher(String prefix, boolean typoTolerant) {
        return BaseCompletionService.createMatcher(prefix, true, typoTolerant);
    }

    @NotNull
    private static CamelHumpMatcher createMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        return new CamelHumpMatcher(prefix, caseSensitive, typoTolerant);
    }

    @ApiStatus.Internal
    @NotNull
    public CompletionResultSet createResultSet(@NotNull CompletionParameters parameters, @NotNull Consumer<? super CompletionResult> consumer, @NotNull CompletionContributor contributor, @NotNull PrefixMatcher matcher) {
        if (parameters == null) {
            BaseCompletionService.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            BaseCompletionService.$$$reportNull$$$0(5);
        }
        if (contributor == null) {
            BaseCompletionService.$$$reportNull$$$0(6);
        }
        if (matcher == null) {
            BaseCompletionService.$$$reportNull$$$0(7);
        }
        return new BaseCompletionResultSet((java.util.function.Consumer<? super CompletionResult>)consumer, matcher, contributor, parameters, null, null);
    }

    @Nullable
    public CompletionProcess getCurrentCompletion() {
        return this.apiCompletionProcess;
    }

    @NotNull
    protected CompletionSorterImpl addWeighersBefore(@NotNull CompletionSorterImpl sorter) {
        if (sorter == null) {
            BaseCompletionService.$$$reportNull$$$0(8);
        }
        CompletionSorterImpl completionSorterImpl = sorter;
        if (completionSorterImpl == null) {
            BaseCompletionService.$$$reportNull$$$0(9);
        }
        return completionSorterImpl;
    }

    @NotNull
    protected CompletionSorterImpl processStatsWeigher(@NotNull CompletionSorterImpl sorter, @NotNull Weigher weigher, @NotNull CompletionLocation location) {
        if (sorter == null) {
            BaseCompletionService.$$$reportNull$$$0(10);
        }
        if (weigher == null) {
            BaseCompletionService.$$$reportNull$$$0(11);
        }
        if (location == null) {
            BaseCompletionService.$$$reportNull$$$0(12);
        }
        CompletionSorterImpl completionSorterImpl = sorter;
        if (completionSorterImpl == null) {
            BaseCompletionService.$$$reportNull$$$0(13);
        }
        return completionSorterImpl;
    }

    @NotNull
    public CompletionSorter defaultSorter(@NotNull BaseCompletionParameters parameters, @NotNull PrefixMatcher matcher) {
        if (parameters == null) {
            BaseCompletionService.$$$reportNull$$$0(14);
        }
        if (matcher == null) {
            BaseCompletionService.$$$reportNull$$$0(15);
        }
        final CompletionLocation location = new CompletionLocation(parameters);
        CompletionSorterImpl sorter = this.emptySorter();
        sorter = this.addWeighersBefore(sorter);
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new PreferStartMatching()));
        for (final Weigher weigher : WeighingService.getWeighers((Key)RELEVANCE_KEY)) {
            String id = weigher.toString();
            if ("prefix".equals(id)) {
                sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new RealPrefixMatchingWeigher()));
                continue;
            }
            if ("stats".equals(id)) {
                sorter = this.processStatsWeigher(sorter, weigher, location);
                continue;
            }
            sorter = sorter.weigh(new LookupElementWeigher(this, id, true, false){

                @Nullable
                public Comparable weigh(@NotNull LookupElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return weigher.weigh((Object)element, (Object)location);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/BaseCompletionService$1", "weigh"));
                }
            });
        }
        CompletionSorterImpl completionSorterImpl = sorter.withClassifier("priority", true, new ClassifierFactory<LookupElement>(this, "liftShorter"){

            @Override
            @NotNull
            public Classifier<LookupElement> createClassifier(@NotNull Classifier<LookupElement> next) {
                if (next == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/codeInsight/completion/BaseCompletionService$2", "createClassifier"));
            }
        });
        if (completionSorterImpl == null) {
            BaseCompletionService.$$$reportNull$$$0(16);
        }
        return completionSorterImpl;
    }

    @NotNull
    public CompletionSorterImpl emptySorter() {
        return new CompletionSorterImpl(new ArrayList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weigher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeighersBefore";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processStatsWeigher";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultSorter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performCompletion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestPrefix";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createResultSet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addWeighersBefore";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processStatsWeigher";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "defaultSorter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 13, 16 -> new IllegalStateException(string);
        };
    }

    protected static class BaseCompletionResultSet
    extends CompletionResultSet {
        protected final CompletionParameters parameters;
        protected CompletionSorter sorter;
        @Nullable
        protected final BaseCompletionResultSet myOriginal;
        private int itemCounter;

        protected BaseCompletionResultSet(@NotNull java.util.function.Consumer<? super CompletionResult> consumer, @NotNull PrefixMatcher prefixMatcher, @Nullable CompletionContributor contributor, @NotNull CompletionParameters parameters, @Nullable CompletionSorter sorter, @Nullable BaseCompletionResultSet original) {
            if (consumer == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(0);
            }
            if (prefixMatcher == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(2);
            }
            super(prefixMatcher, consumer, contributor);
            this.itemCounter = 0;
            this.parameters = parameters;
            this.sorter = sorter;
            this.myOriginal = original;
        }

        public void addElement(@NotNull LookupElement element) {
            if (element == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(3);
            }
            ProgressManager.checkCanceled();
            if (!element.isValid()) {
                LOG.error("Invalid lookup element: " + String.valueOf(element) + " of " + String.valueOf(element.getClass()) + " in " + String.valueOf(this.parameters.getOriginalFile()) + " of " + String.valueOf(this.parameters.getOriginalFile().getClass()));
                return;
            }
            this.sorter = this.sorter == null ? CompletionService.getCompletionService().defaultSorter(this.parameters, this.getPrefixMatcher()) : this.sorter;
            CompletionResult matched = CompletionResult.wrap((LookupElement)element, (PrefixMatcher)this.getPrefixMatcher(), (CompletionSorter)this.sorter);
            if (matched != null) {
                this.passResult(matched);
            }
        }

        public void passResult(@NotNull CompletionResult result) {
            if (result == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(4);
            }
            LookupElement element = result.getLookupElement();
            element.putUserDataIfAbsent(LOOKUP_ELEMENT_CONTRIBUTOR, (Object)this.contributor);
            element.putUserData(LOOKUP_ELEMENT_RESULT_ADD_TIMESTAMP_MILLIS, (Object)System.currentTimeMillis());
            element.putUserData(LOOKUP_ELEMENT_RESULT_SET_ORDER, (Object)this.itemCounter);
            ++this.itemCounter;
            super.passResult(result);
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(5);
            }
            if (matcher.equals(this.getPrefixMatcher())) {
                BaseCompletionResultSet baseCompletionResultSet = this;
                if (baseCompletionResultSet == null) {
                    BaseCompletionResultSet.$$$reportNull$$$0(6);
                }
                return baseCompletionResultSet;
            }
            return new BaseCompletionResultSet(this.getConsumer(), matcher, this.contributor, this.parameters, this.sorter, this);
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(7);
            }
            CompletionResultSet completionResultSet = this.withPrefixMatcher(this.getPrefixMatcher().cloneWithPrefix(prefix));
            if (completionResultSet == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(8);
            }
            return completionResultSet;
        }

        public void stopHere() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Completion stopped\n" + DebugUtil.currentStackTrace());
            }
            super.stopHere();
            if (this.myOriginal != null) {
                this.myOriginal.stopHere();
            }
        }

        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(9);
            }
            return new BaseCompletionResultSet(this.getConsumer(), this.getPrefixMatcher(), this.contributor, this.parameters, sorter, this);
        }

        public void addLookupAdvertisement(@NlsContexts.PopupAdvertisement @NotNull String text) {
            if (text == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(10);
            }
            CompletionService.getCompletionService().setAdvertisementText(text);
        }

        @NotNull
        public CompletionResultSet caseInsensitive() {
            CamelHumpMatcher camelHumpMatcher;
            PrefixMatcher matcher = this.getPrefixMatcher();
            boolean typoTolerant = matcher instanceof CamelHumpMatcher && (camelHumpMatcher = (CamelHumpMatcher)matcher).isTypoTolerant();
            CompletionResultSet completionResultSet = this.withPrefixMatcher(BaseCompletionService.createMatcher(matcher.getPrefix(), false, typoTolerant));
            if (completionResultSet == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(11);
            }
            return completionResultSet;
        }

        public void restartCompletionOnPrefixChange(@NotNull ElementPattern<String> prefixCondition) {
            if (prefixCondition == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(12);
            }
        }

        public void restartCompletionWhenNothingMatches() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 8, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 6: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionService$BaseCompletionResultSet";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionService$BaseCompletionResultSet";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixMatcher";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "caseInsensitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "passResult";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixMatcher";
                    break;
                }
                case 6: 
                case 8: 
                case 11: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelevanceSorter";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupAdvertisement";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "restartCompletionOnPrefixChange";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 8, 11 -> new IllegalStateException(string);
            };
        }
    }
}

