/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorClientUtils;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class CanISilentlyChange {
    CanISilentlyChange() {
    }

    private static boolean canUndo(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            CanISilentlyChange.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CanISilentlyChange.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        List editors = FileEditorManager.getInstance((Project)project).getAllEditorList(virtualFile);
        if (editors.isEmpty()) {
            return false;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        for (FileEditor editor : editors) {
            ClientId clientId = FileEditorClientUtils.getClientId((FileEditor)editor);
            AccessToken ignored = ClientId.withExplicitClientId((ClientId)clientId);
            try {
                if (!undoManager.isUndoAvailable(editor)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return false;
    }

    @RequiresEdt
    @ApiStatus.Internal
    @NotNull
    static Result thisFile(@NotNull PsiFileSystemItem file) {
        if (file == null) {
            CanISilentlyChange.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            Result result = Result.UH_UH;
            if (result == null) {
                CanISilentlyChange.$$$reportNull$$$0(3);
            }
            return result;
        }
        if (file instanceof PsiCodeFragment) {
            Result result = Result.UH_HUH;
            if (result == null) {
                CanISilentlyChange.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
            Result result = CanISilentlyChange.canUndo(virtualFile, project) ? Result.UH_HUH : Result.UH_UH;
            if (result == null) {
                CanISilentlyChange.$$$reportNull$$$0(5);
            }
            return result;
        }
        Result result = CanISilentlyChange.canUndo(virtualFile, project) ? Result.ONLY_WHEN_IN_CONTENT : Result.UH_UH;
        if (result == null) {
            CanISilentlyChange.$$$reportNull$$$0(6);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/CanISilentlyChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/CanISilentlyChange";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "thisFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canUndo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "thisFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    static enum Result {
        UH_HUH,
        UH_UH,
        ONLY_WHEN_IN_CONTENT;


        boolean canIReally(boolean isInContent, @NotNull ThreeState extensionsAllowToChangeFileSilently) {
            if (extensionsAllowToChangeFileSilently == null) {
                Result.$$$reportNull$$$0(0);
            }
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (extensionsAllowToChangeFileSilently != ThreeState.NO) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> false;
                case 2 -> extensionsAllowToChangeFileSilently != ThreeState.NO && isInContent;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionsAllowToChangeFileSilently", "com/intellij/codeInsight/daemon/impl/CanISilentlyChange$Result", "canIReally"));
        }
    }
}

