/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
final class InjectedLanguageFragmentSyntaxUtil {
    InjectedLanguageFragmentSyntaxUtil() {
    }

    @Contract(pure=true)
    @NotNull
    static @NotNull @Unmodifiable List<@NotNull HighlightInfo> addSyntaxInjectedFragmentInfo(@NotNull EditorColorsScheme scheme, @NotNull TextRange hostRange, TextAttributesKey @NotNull [] keys, @Nullable Object toolId) {
        LayeredTextAttributes injectedAttributes;
        if (scheme == null) {
            InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(0);
        }
        if (hostRange == null) {
            InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(1);
        }
        if (keys == null) {
            InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(2);
        }
        if (hostRange.isEmpty()) {
            List<HighlightInfo> list = List.of();
            if (list == null) {
                InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        HighlightInfo eraseInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(hostRange).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
        eraseInfo.toolId = toolId;
        eraseInfo.markFromInjection();
        if (toolId != null) {
            eraseInfo.setGroup(-6);
        }
        if ((injectedAttributes = LayeredTextAttributes.create((EditorColorsScheme)scheme, (TextAttributesKey[])keys)).isEmpty() || keys.length == 1 && keys[0] == HighlighterColors.TEXT) {
            List<HighlightInfo> list = List.of(eraseInfo);
            if (list == null) {
                InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        HighlightInfo injectedInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(hostRange).textAttributes((TextAttributes)injectedAttributes).createUnconditionally();
        injectedInfo.toolId = toolId;
        injectedInfo.markFromInjection();
        if (toolId != null) {
            injectedInfo.setGroup(-6);
        }
        List<HighlightInfo> list = List.of(eraseInfo, injectedInfo);
        if (list == null) {
            InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InjectedLanguageFragmentSyntaxUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InjectedLanguageFragmentSyntaxUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addSyntaxInjectedFragmentInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSyntaxInjectedFragmentInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

