/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.interpreter;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StateQueue;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardDataFlowInterpreter
implements DataFlowInterpreter {
    public static final int DEFAULT_MAX_STATES_PER_BRANCH = 300;
    private static final Logger LOG = Logger.getInstance(StandardDataFlowInterpreter.class);
    @NotNull
    final ControlFlow myFlow;
    private final Instruction @NotNull [] myInstructions;
    @NotNull
    private final DfaListener myListener;
    @NotNull
    private final MultiMap<PsiElement, DfaMemoryState> myNestedClosures;
    @NotNull
    private final PsiElement myPsiAnchor;
    @NotNull
    private final DfaValueFactory myValueFactory;
    private final boolean myStopOnNull;
    private final boolean myStopOnCast;
    private boolean myCancelled;
    private boolean myWasForciblyMerged;

    public StandardDataFlowInterpreter(@NotNull ControlFlow flow, @NotNull DfaListener listener2) {
        if (flow == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(1);
        }
        this(flow, listener2, false);
    }

    public StandardDataFlowInterpreter(@NotNull ControlFlow flow, @NotNull DfaListener listener2, boolean stopOnNull) {
        if (flow == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(3);
        }
        this(flow, listener2, stopOnNull, false);
    }

    public StandardDataFlowInterpreter(@NotNull ControlFlow flow, @NotNull DfaListener listener2, boolean stopOnNull, boolean stopOnCast) {
        if (flow == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(5);
        }
        this.myNestedClosures = new MultiMap();
        this.myCancelled = false;
        this.myWasForciblyMerged = false;
        this.myFlow = flow;
        this.myInstructions = flow.getInstructions();
        this.myListener = listener2;
        this.myPsiAnchor = flow.getPsiAnchor();
        this.myValueFactory = flow.getFactory();
        this.myStopOnNull = stopOnNull;
        this.myStopOnCast = stopOnCast;
    }

    @Override
    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myValueFactory;
        if (dfaValueFactory == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(6);
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public final RunnerResult interpret(@NotNull DfaMemoryState startingState) {
        if (startingState == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(7);
        }
        return this.interpret(List.of(new DfaInstructionState(this.getInstruction(0), startingState)));
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public final RunnerResult interpret(@NotNull List<? extends DfaInstructionState> startingStates) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private Set<Instruction> getJoinInstructions() {
        HashSet<Instruction> joinInstructions = new HashSet<Instruction>();
        ((StreamEx)StreamEx.of((Object[])this.myInstructions).remove(Instruction::isLinear)).flatMap(inst -> IntStreamEx.of((int[])inst.getSuccessorIndexes()).elements((Object[])this.myInstructions)).into(joinInstructions);
        for (int index = 0; index < this.myInstructions.length - 1; ++index) {
            FinishElementInstruction finishInstruction;
            Instruction instruction = this.myInstructions[index];
            if (!(instruction instanceof FinishElementInstruction) || (finishInstruction = (FinishElementInstruction)instruction).mayFlushSomething()) continue;
            joinInstructions.add(this.myInstructions[index + 1]);
        }
        HashSet<Instruction> hashSet = joinInstructions;
        if (hashSet == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    @NotNull
    public @NotNull MultiMap<@NotNull PsiElement, @NotNull DfaMemoryState> getClosures() {
        MultiMap<PsiElement, DfaMemoryState> multiMap = this.myNestedClosures;
        if (multiMap == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(16);
        }
        return multiMap;
    }

    private static boolean containsState(Collection<? extends DfaMemoryState> processed, DfaInstructionState instructionState) {
        if (processed.contains(instructionState.getMemoryState())) {
            return true;
        }
        for (DfaMemoryState dfaMemoryState : processed) {
            if (!dfaMemoryState.isSuperStateOf(instructionState.getMemoryState())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void cancel() {
        this.myCancelled = true;
    }

    @Override
    public void createClosureState(PsiElement anchor, DfaMemoryState state) {
        this.myNestedClosures.putValue((Object)anchor, (Object)state.createClosureState());
    }

    @Override
    public int getComplexityLimit() {
        return 300;
    }

    @Override
    @NotNull
    public Instruction getInstruction(int index) {
        Instruction instruction = this.myInstructions[index];
        if (instruction == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(17);
        }
        return instruction;
    }

    @Override
    @NotNull
    public DfaListener getListener() {
        DfaListener dfaListener = this.myListener;
        if (dfaListener == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(18);
        }
        return dfaListener;
    }

    private void handleStepOutOfLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, int @NotNull [] loopNumber, @NotNull MultiMap<Instruction, DfaMemoryState> processedStates, @NotNull MultiMap<Instruction, DfaMemoryState> incomingStates, @NotNull List<? extends DfaInstructionState> inFlightStates, DfaInstructionState @NotNull [] afterStates, @NotNull StateQueue queue) {
        if (prevInstruction == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(19);
        }
        if (nextInstruction == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(20);
        }
        if (processedStates == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(21);
        }
        if (incomingStates == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(22);
        }
        if (inFlightStates == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(23);
        }
        if (queue == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(24);
        }
        if (loopNumber == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(25);
        }
        if (afterStates == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(26);
        }
        if (loopNumber[prevInstruction.getIndex()] == 0 || StandardDataFlowInterpreter.inSameLoop(prevInstruction, nextInstruction, loopNumber)) {
            return;
        }
        for (DfaInstructionState dfaInstructionState : inFlightStates) {
            Instruction instruction = dfaInstructionState.getInstruction();
            if (!StandardDataFlowInterpreter.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        for (DfaInstructionState state3 : afterStates) {
            Instruction instruction = state3.getInstruction();
            if (!StandardDataFlowInterpreter.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        if (!queue.processAll((Processor<? super DfaInstructionState>)((Processor)state -> {
            Instruction instruction = state.getInstruction();
            return !StandardDataFlowInterpreter.inSameLoop(prevInstruction, instruction, loopNumber);
        }))) {
            return;
        }
        HashSet<Instruction> mayRemoveStatesFor = new HashSet<Instruction>();
        for (Instruction instruction : this.myInstructions) {
            if (!StandardDataFlowInterpreter.inSameLoop(prevInstruction, instruction, loopNumber) || instruction.isLinear()) continue;
            mayRemoveStatesFor.add(instruction);
        }
        for (Instruction instruction : mayRemoveStatesFor) {
            processedStates.remove((Object)instruction);
            incomingStates.remove((Object)instruction);
        }
    }

    private static boolean inSameLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, int @NotNull [] loopNumber) {
        if (prevInstruction == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(27);
        }
        if (nextInstruction == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(28);
        }
        if (loopNumber == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(29);
        }
        return loopNumber[nextInstruction.getIndex()] == loopNumber[prevInstruction.getIndex()];
    }

    @NotNull
    private DfaInstructionState mergeBackBranches(DfaInstructionState instructionState, Collection<? extends DfaMemoryState> processed) {
        DfaMemoryStateImpl curState = (DfaMemoryStateImpl)instructionState.getMemoryState();
        int curStateStackSize = curState.getStackSize();
        if (processed.size() > 10 && curStateStackSize > 10) {
            for (DfaMemoryState dfaMemoryState : processed) {
                int diff = curStateStackSize - dfaMemoryState.getStackSize();
                if (diff <= 10) continue;
                throw new IllegalStateException("Stack for instruction %d increased by %d; it's likely that IR was built incorrectly".formatted(instructionState.getInstruction().getIndex(), diff));
            }
        }
        Object key = curState.getMergeabilityKey();
        DfaMemoryStateImpl dfaMemoryStateImpl = (DfaMemoryStateImpl)StreamEx.of(processed).filterBy(DfaMemoryState::getMergeabilityKey, key).foldLeft((Object)curState, (s1, s2) -> {
            s1.merge((DfaMemoryState)s2);
            return s1;
        });
        dfaMemoryStateImpl.widen();
        instructionState = new DfaInstructionState(instructionState.getInstruction(), dfaMemoryStateImpl);
        this.myWasForciblyMerged = true;
        DfaInstructionState dfaInstructionState = instructionState;
        if (dfaInstructionState == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(30);
        }
        return dfaInstructionState;
    }

    protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull DfaInstructionState instructionState) {
        if (instructionState == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(31);
        }
        Instruction instruction = instructionState.getInstruction();
        DfaInstructionState[] dfaInstructionStateArray = instruction.accept(this, instructionState.getMemoryState());
        if (dfaInstructionStateArray == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(32);
        }
        return dfaInstructionStateArray;
    }

    protected void beforeInstruction(Instruction instruction) {
    }

    protected void afterInstruction(Instruction instruction) {
    }

    public boolean wasForciblyMerged() {
        return this.myWasForciblyMerged;
    }

    public boolean stopOnNull() {
        return this.myStopOnNull;
    }

    public boolean stopOnCast() {
        return this.myStopOnCast;
    }

    private void reportDfaProblem(@Nullable DfaInstructionState lastInstructionState, @NotNull Throwable e) {
        if (e == null) {
            StandardDataFlowInterpreter.$$$reportNull$$$0(33);
        }
        Object[] attachments = new Attachment[]{new Attachment("method_body.txt", this.myPsiAnchor.getText())};
        try {
            String flowText = this.myFlow.toString();
            if (lastInstructionState != null) {
                int index = lastInstructionState.getInstruction().getIndex();
                flowText = flowText.replaceAll("(?m)^", "  ");
                flowText = flowText.replaceFirst("(?m)^ {2}" + index + ": ", "* " + index + ": ");
            }
            attachments = (Attachment[])ArrayUtil.append((Object[])attachments, (Object)new Attachment("flow.txt", flowText));
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception ex) {
            ex.addSuppressed(e);
            LOG.error("While gathering flow text", (Throwable)ex);
        }
        if (lastInstructionState != null) {
            DfaMemoryState memoryState = lastInstructionState.getMemoryState();
            String memStateText = null;
            try {
                memStateText = memoryState.toString();
            }
            catch (RuntimeException second) {
                e.addSuppressed(second);
            }
            if (memStateText != null) {
                attachments = (Attachment[])ArrayUtil.append((Object[])attachments, (Object)new Attachment("memory_state.txt", memStateText));
            }
        }
        LOG.error("Dataflow interpretation error (wasForciblyMerged = " + this.myWasForciblyMerged + ")", e, (Attachment[])attachments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 30, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/interpreter/StandardDataFlowInterpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingStates";
                break;
            }
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevInstruction";
                break;
            }
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextInstruction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedStates";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incomingStates";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inFlightStates";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopNumber";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterStates";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionState";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/interpreter/StandardDataFlowInterpreter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "interpret";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinInstructions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosures";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstruction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeBackBranches";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 30: 
            case 32: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "interpret";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleStepOutOfLoop";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "inSameLoop";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "acceptInstruction";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "reportDfaProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 30, 32 -> new IllegalStateException(string);
        };
    }
}

