/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.ngrams;

import com.intellij.find.ngrams.TrigramIndexFilter;
import com.intellij.find.ngrams.TrigramTextSearchService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.storage.sharding.ShardableIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TrigramIndex
extends ScalarIndexExtension<Integer>
implements CustomInputsIndexFileBasedIndexExtension<Integer>,
ShardableIndexExtension {
    public static final ID<Integer, Void> INDEX_ID = ID.create((String)"Trigram.Index");
    @ApiStatus.Internal
    public static final int SHARDS = ShardableIndexExtension.determineShardsCount(SystemProperties.getIntProperty((String)"idea.indexes.trigram-index-shards", (int)0));
    private static final ThreadLocalCachedIntArray SPARE_BUFFER_LOCAL = new ThreadLocalCachedIntArray();

    @ApiStatus.Internal
    public TrigramIndex() {
    }

    @ApiStatus.Internal
    public static boolean isEnabled() {
        return TrigramTextSearchService.useIndexingSearchExtensions();
    }

    public int getCacheSize() {
        return 64 * super.getCacheSize();
    }

    @NotNull
    public ID<Integer, Void> getName() {
        ID<Integer, Void> iD = INDEX_ID;
        if (iD == null) {
            TrigramIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        return new DataIndexer<Integer, Void, FileContent>(this){

            @NotNull
            public Map<Integer, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map map = TrigramBuilder.getTrigramsAsMap((CharSequence)inputData.getContentAsText());
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/ngrams/TrigramIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/ngrams/TrigramIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            TrigramIndex.$$$reportNull$$$0(1);
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = (FileBasedIndex.InputFilter)ApplicationManager.getApplication().getService(TrigramIndexFilter.class);
        if (inputFilter == null) {
            TrigramIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    @ApiStatus.Internal
    public int shardlessVersion() {
        return 4;
    }

    public int getVersion() {
        return this.shardlessVersion() + (SHARDS - 1);
    }

    @Override
    @ApiStatus.Internal
    public int shardsCount() {
        return SHARDS;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    @ApiStatus.Internal
    @NotNull
    public DataExternalizer<Collection<Integer>> createExternalizer() {
        return new DataExternalizer<Collection<Integer>>(this){

            public void save(@NotNull DataOutput out, @NotNull Collection<Integer> value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    2.$$$reportNull$$$0(1);
                }
                int numberOfValues = value.size();
                int[] buffer = SPARE_BUFFER_LOCAL.getBuffer(numberOfValues);
                int ptr = 0;
                if (value instanceof IntCollection) {
                    IntCollection intCollection = (IntCollection)value;
                    buffer = intCollection.toArray(buffer);
                } else {
                    for (Integer i : value) {
                        buffer[ptr++] = i;
                    }
                }
                Arrays.sort(buffer, 0, numberOfValues);
                DataInputOutputUtil.writeDiffCompressed((DataOutput)out, (int[])buffer, (int)numberOfValues);
            }

            @NotNull
            public Collection<Integer> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(2);
                }
                int size = DataInputOutputUtil.readINT((DataInput)in);
                IntArrayList result = new IntArrayList(size);
                int prev = 0;
                while (size-- > 0) {
                    int l = (int)(DataInputOutputUtil.readLONG((DataInput)in) + (long)prev);
                    result.add(l);
                    prev = l;
                }
                IntArrayList intArrayList = result;
                if (intArrayList == null) {
                    2.$$$reportNull$$$0(3);
                }
                return intArrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/ngrams/TrigramIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/ngrams/TrigramIndex$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "read";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "save";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "read";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/find/ngrams/TrigramIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

