/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ArrayUtilRt;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TodoFilter
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(TodoFilter.class);
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_PATTERN = "pattern";
    private static final String ATTRIBUTE_INDEX = "index";
    @NlsSafe
    private String myName;
    private Set<TodoPattern> myTodoPatterns;

    public TodoFilter() {
        this.setName("");
        this.myTodoPatterns = new HashSet<TodoPattern>();
    }

    @ApiStatus.Internal
    public TodoFilter(@NotNull Element element, @NotNull List<TodoPattern> patterns) {
        if (element == null) {
            TodoFilter.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            TodoFilter.$$$reportNull$$$0(1);
        }
        this.setName("");
        this.myTodoPatterns = new HashSet<TodoPattern>();
        this.readExternal(element, patterns);
    }

    public boolean accept(PsiTodoSearchHelper searchHelper, PsiFile psiFile) {
        Iterator<TodoPattern> i = this.iterator();
        while (i.hasNext()) {
            TodoPattern todoPattern = i.next();
            if (searchHelper.getTodoItemsCount(psiFile, todoPattern) <= 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TodoFilter.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setName(@NotNull @NlsSafe String name) {
        if (name == null) {
            TodoFilter.$$$reportNull$$$0(3);
        }
        this.myName = name;
    }

    public boolean contains(TodoPattern pattern) {
        return this.myTodoPatterns.contains(pattern);
    }

    public void addTodoPattern(TodoPattern pattern) {
        LOG.assertTrue(!this.myTodoPatterns.contains(pattern));
        this.myTodoPatterns.add(pattern);
    }

    public void removeTodoPattern(TodoPattern pattern) {
        LOG.assertTrue(this.myTodoPatterns.contains(pattern));
        this.myTodoPatterns.remove(pattern);
    }

    public Iterator<TodoPattern> iterator() {
        return this.myTodoPatterns.iterator();
    }

    public boolean isEmpty() {
        return this.myTodoPatterns.isEmpty();
    }

    private void readExternal(@NotNull Element element, @NotNull List<TodoPattern> patterns) {
        if (element == null) {
            TodoFilter.$$$reportNull$$$0(4);
        }
        if (patterns == null) {
            TodoFilter.$$$reportNull$$$0(5);
        }
        this.myName = element.getAttributeValue(ATTRIBUTE_NAME);
        if (this.myName == null) {
            throw new IllegalArgumentException();
        }
        this.myTodoPatterns.clear();
        for (Element child : element.getChildren(ELEMENT_PATTERN)) {
            try {
                TodoPattern pattern;
                int index = Integer.parseInt(child.getAttributeValue(ATTRIBUTE_INDEX));
                if (index < 0 || index > patterns.size() - 1 || this.myTodoPatterns.contains(pattern = patterns.get(index))) continue;
                this.myTodoPatterns.add(pattern);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void writeExternal(Element element, TodoPattern[] patterns) {
        element.setAttribute(ATTRIBUTE_NAME, this.myName);
        for (TodoPattern pattern : this.myTodoPatterns) {
            int index = ArrayUtilRt.find((Object[])patterns, (Object)pattern);
            LOG.assertTrue(index != -1);
            Element child = new Element(ELEMENT_PATTERN);
            child.setAttribute(ATTRIBUTE_INDEX, Integer.toString(index));
            element.addContent(child);
        }
    }

    public int hashCode() {
        return this.myName.hashCode() * 31 + this.myTodoPatterns.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TodoFilter)) return false;
        TodoFilter filter = (TodoFilter)obj;
        if (!this.myName.equals(filter.myName)) return false;
        if (this.myTodoPatterns.size() != filter.myTodoPatterns.size()) return false;
        if (!filter.myTodoPatterns.containsAll(this.myTodoPatterns)) return false;
        return true;
    }

    public TodoFilter clone() {
        TodoFilter filter = new TodoFilter();
        filter.myName = this.myName;
        filter.myTodoPatterns = new HashSet<TodoPattern>(this.myTodoPatterns);
        return filter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

