/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.durablemap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLog;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLogFactory;
import com.intellij.platform.util.io.storages.durablemap.DefaultEntryExternalizer;
import com.intellij.platform.util.io.storages.durablemap.DurableMapOverAppendOnlyLog;
import com.intellij.platform.util.io.storages.durablemap.EntryExternalizer;
import com.intellij.platform.util.io.storages.durablemap.FixedSizeKeyEntryExternalizer;
import com.intellij.platform.util.io.storages.intmultimaps.DurableIntToMultiIntMap;
import com.intellij.platform.util.io.storages.intmultimaps.HashUtils;
import com.intellij.platform.util.io.storages.intmultimaps.NonDurableNonParallelIntToMultiIntMap;
import com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap.ExtendibleMapFactory;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.io.CorruptedException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DurableMapFactory<K, V>
implements StorageFactory<DurableMapOverAppendOnlyLog<K, V>> {
    private static final Logger LOG = Logger.getInstance(DurableMapFactory.class);
    public static final int DEFAULT_PAGE_SIZE = 0x800000;
    public static final String MAP_FILE_SUFFIX = ".map";
    public static final StorageFactory<? extends AppendOnlyLog> DEFAULT_VALUES_LOG_FACTORY = AppendOnlyLogFactory.withDefaults().pageSize(0x800000).cleanIfFileIncompatible().failIfDataFormatVersionNotMatch(1);
    public static final StorageFactory<? extends DurableIntToMultiIntMap> DEFAULT_MAP_FACTORY = ExtendibleMapFactory.mediumSize().cleanIfFileIncompatible().ifNotClosedProperly(ExtendibleMapFactory.NotClosedProperlyAction.IGNORE_AND_HOPE_FOR_THE_BEST);
    private final StorageFactory<? extends AppendOnlyLog> logFactory;
    private final StorageFactory<? extends DurableIntToMultiIntMap> mapFactory;
    @NotNull
    private final EqualityPolicy<? super K> keyEquality;
    @Nullable
    private final EqualityPolicy<? super V> valueEquality;
    @NotNull
    private final EntryExternalizer<K, V> entryExternalizer;
    private final boolean rebuildMapFromLogIfInconsistent;

    private DurableMapFactory(@NotNull StorageFactory<? extends AppendOnlyLog> logFactory, @NotNull StorageFactory<? extends DurableIntToMultiIntMap> mapFactory, @NotNull EqualityPolicy<? super K> keyEquality, @Nullable EqualityPolicy<? super V> valueEquality, @NotNull EntryExternalizer<K, V> entryExternalizer, boolean rebuildMapFromLogIfInconsistent) {
        if (logFactory == null) {
            DurableMapFactory.$$$reportNull$$$0(0);
        }
        if (mapFactory == null) {
            DurableMapFactory.$$$reportNull$$$0(1);
        }
        if (keyEquality == null) {
            DurableMapFactory.$$$reportNull$$$0(2);
        }
        if (entryExternalizer == null) {
            DurableMapFactory.$$$reportNull$$$0(3);
        }
        this.logFactory = logFactory;
        this.mapFactory = mapFactory;
        this.keyEquality = keyEquality;
        this.valueEquality = valueEquality;
        this.entryExternalizer = entryExternalizer;
        this.rebuildMapFromLogIfInconsistent = rebuildMapFromLogIfInconsistent;
    }

    @NotNull
    public static <K, V> DurableMapFactory<K, V> withDefaults(@NotNull KeyDescriptorEx<K> keyDescriptor, @NotNull KeyDescriptorEx<V> valueDescriptor) {
        if (keyDescriptor == null) {
            DurableMapFactory.$$$reportNull$$$0(4);
        }
        if (valueDescriptor == null) {
            DurableMapFactory.$$$reportNull$$$0(5);
        }
        return new DurableMapFactory<K, V>(DEFAULT_VALUES_LOG_FACTORY, DEFAULT_MAP_FACTORY, keyDescriptor, valueDescriptor, DurableMapFactory.entryExternalizerFor(keyDescriptor, valueDescriptor), true);
    }

    @NotNull
    public static <K, V> DurableMapFactory<K, V> withDefaults(@NotNull KeyDescriptorEx<K> keyDescriptor, @NotNull DataExternalizerEx<V> valueExternalizer) {
        if (keyDescriptor == null) {
            DurableMapFactory.$$$reportNull$$$0(6);
        }
        if (valueExternalizer == null) {
            DurableMapFactory.$$$reportNull$$$0(7);
        }
        return new DurableMapFactory<K, V>(DEFAULT_VALUES_LOG_FACTORY, DEFAULT_MAP_FACTORY, keyDescriptor, null, DurableMapFactory.entryExternalizerFor(keyDescriptor, valueExternalizer), true);
    }

    @NotNull
    public static <K, V> DurableMapFactory<K, V> withDefaults(@NotNull EqualityPolicy<? super K> keyEquality, @NotNull EqualityPolicy<? super V> valueEquality, @NotNull EntryExternalizer<K, V> entryExternalizer) {
        if (keyEquality == null) {
            DurableMapFactory.$$$reportNull$$$0(8);
        }
        if (valueEquality == null) {
            DurableMapFactory.$$$reportNull$$$0(9);
        }
        if (entryExternalizer == null) {
            DurableMapFactory.$$$reportNull$$$0(10);
        }
        return new DurableMapFactory<K, V>(DEFAULT_VALUES_LOG_FACTORY, DEFAULT_MAP_FACTORY, keyEquality, valueEquality, entryExternalizer, true);
    }

    @NotNull
    public static <K, V> DurableMapFactory<K, V> withDefaults(@NotNull EqualityPolicy<? super K> keyEquality, @NotNull EntryExternalizer<K, V> entryExternalizer) {
        if (keyEquality == null) {
            DurableMapFactory.$$$reportNull$$$0(11);
        }
        if (entryExternalizer == null) {
            DurableMapFactory.$$$reportNull$$$0(12);
        }
        return new DurableMapFactory<K, V>(DEFAULT_VALUES_LOG_FACTORY, DEFAULT_MAP_FACTORY, keyEquality, null, entryExternalizer, true);
    }

    public DurableMapFactory<K, V> logFactory(@NotNull StorageFactory<? extends AppendOnlyLog> logFactory) {
        if (logFactory == null) {
            DurableMapFactory.$$$reportNull$$$0(13);
        }
        return new DurableMapFactory<K, V>(logFactory, this.mapFactory, this.keyEquality, this.valueEquality, this.entryExternalizer, this.rebuildMapFromLogIfInconsistent);
    }

    public DurableMapFactory<K, V> mapFactory(@NotNull StorageFactory<? extends DurableIntToMultiIntMap> mapFactory) {
        if (mapFactory == null) {
            DurableMapFactory.$$$reportNull$$$0(14);
        }
        return new DurableMapFactory<K, V>(this.logFactory, mapFactory, this.keyEquality, this.valueEquality, this.entryExternalizer, this.rebuildMapFromLogIfInconsistent);
    }

    public DurableMapFactory<K, V> rebuildMapIfInconsistent(boolean rebuildMapFromLogIfInconsistent) {
        return new DurableMapFactory<K, V>(this.logFactory, this.mapFactory, this.keyEquality, this.valueEquality, this.entryExternalizer, rebuildMapFromLogIfInconsistent);
    }

    @Override
    @NotNull
    public DurableMapOverAppendOnlyLog<K, V> open(@NotNull Path storagePath) throws IOException {
        if (storagePath == null) {
            DurableMapFactory.$$$reportNull$$$0(15);
        }
        String name = storagePath.getFileName().toString();
        Path mapPath = storagePath.resolveSibling(name + MAP_FILE_SUFFIX);
        boolean mapFileExists = Files.exists(mapPath, new LinkOption[0]);
        DurableMapOverAppendOnlyLog durableMapOverAppendOnlyLog = (DurableMapOverAppendOnlyLog)this.logFactory.wrapStorageSafely(storagePath, entriesLog -> {
            try {
                return (DurableMapOverAppendOnlyLog)this.mapFactory.wrapStorageSafely(mapPath, keyHashToEntryOffsetMap -> {
                    if (!entriesLog.isEmpty() && keyHashToEntryOffsetMap.isEmpty()) {
                        if (keyHashToEntryOffsetMap instanceof NonDurableNonParallelIntToMultiIntMap) {
                            DurableMapFactory.fillValueHashToIdMap(entriesLog, this.keyEquality, this.entryExternalizer, keyHashToEntryOffsetMap);
                            LOG.info("[" + name + "]: keyToOffsetMap (in memory) was filled from entriesLog (" + keyHashToEntryOffsetMap.size() + " records)");
                        } else if (!mapFileExists) {
                            DurableMapFactory.fillValueHashToIdMap(entriesLog, this.keyEquality, this.entryExternalizer, keyHashToEntryOffsetMap);
                            LOG.info("[" + name + "]: keyToOffsetMap (in memory) was filled from entriesLog (" + keyHashToEntryOffsetMap.size() + " records)");
                        }
                    }
                    return new DurableMapOverAppendOnlyLog<K, V>((AppendOnlyLog)entriesLog, (DurableIntToMultiIntMap)keyHashToEntryOffsetMap, this.keyEquality, this.valueEquality, this.entryExternalizer);
                });
            }
            catch (CorruptedException e) {
                if (!this.rebuildMapFromLogIfInconsistent) {
                    throw e;
                }
                FileUtil.delete((Path)mapPath);
                return (DurableMapOverAppendOnlyLog)this.mapFactory.wrapStorageSafely(mapPath, keyHashToEntryOffsetMap -> {
                    if (!entriesLog.isEmpty()) {
                        LOG.warn("[" + name + "]: .keyToOffsetMap map corrupted -> try recovering the map from entriesLog (impl: " + String.valueOf(keyHashToEntryOffsetMap.getClass()) + ")", (Throwable)e);
                        DurableMapFactory.fillValueHashToIdMap(entriesLog, this.keyEquality, this.entryExternalizer, keyHashToEntryOffsetMap);
                        LOG.info("[" + name + "]: keyToOffsetMap (durable) was recovered from entriesLog (" + keyHashToEntryOffsetMap.size() + " records)");
                    }
                    return new DurableMapOverAppendOnlyLog<K, V>((AppendOnlyLog)entriesLog, (DurableIntToMultiIntMap)keyHashToEntryOffsetMap, this.keyEquality, this.valueEquality, this.entryExternalizer);
                });
            }
        });
        if (durableMapOverAppendOnlyLog == null) {
            DurableMapFactory.$$$reportNull$$$0(16);
        }
        return durableMapOverAppendOnlyLog;
    }

    @NotNull
    public static <K, V> EntryExternalizer<K, V> entryExternalizerFor(@NotNull KeyDescriptorEx<K> keyDescriptor, @NotNull DataExternalizerEx<V> valueExternalizer) {
        if (keyDescriptor == null) {
            DurableMapFactory.$$$reportNull$$$0(17);
        }
        if (valueExternalizer == null) {
            DurableMapFactory.$$$reportNull$$$0(18);
        }
        if (keyDescriptor.isRecordSizeConstant()) {
            return new FixedSizeKeyEntryExternalizer<K, V>(keyDescriptor, valueExternalizer);
        }
        return new DefaultEntryExternalizer<K, V>(keyDescriptor, valueExternalizer);
    }

    private static <K, V> void fillValueHashToIdMap(@NotNull AppendOnlyLog valuesLog, @NotNull EqualityPolicy<? super K> keyEquality, @NotNull EntryExternalizer<K, V> entryExternalizer, @NotNull DurableIntToMultiIntMap keyHashToEntryOffsetMap) throws IOException {
        if (valuesLog == null) {
            DurableMapFactory.$$$reportNull$$$0(19);
        }
        if (keyEquality == null) {
            DurableMapFactory.$$$reportNull$$$0(20);
        }
        if (entryExternalizer == null) {
            DurableMapFactory.$$$reportNull$$$0(21);
        }
        if (keyHashToEntryOffsetMap == null) {
            DurableMapFactory.$$$reportNull$$$0(22);
        }
        valuesLog.forEachRecord((logId, entryBuffer) -> {
            boolean keyRecordExists;
            Object entry = entryExternalizer.read(entryBuffer);
            Object key = ((EntryExternalizer.Entry)entry).key();
            int adjustedHash = HashUtils.adjustHash(keyEquality.getHashCode(key));
            int storedId = DurableMapOverAppendOnlyLog.convertLogIdToStoredId(logId);
            int foundRecordId = keyHashToEntryOffsetMap.lookup(adjustedHash, candidateRecordId -> {
                long logRecordId = DurableMapOverAppendOnlyLog.convertStoredIdToLogId(candidateRecordId);
                EntryExternalizer.Entry entryWithSameKey = (EntryExternalizer.Entry)valuesLog.read(logRecordId, _entryBuffer -> entryExternalizer.readIfKeyMatch(_entryBuffer, key));
                return entryWithSameKey != null;
            });
            boolean bl = keyRecordExists = foundRecordId != 0;
            if (keyRecordExists) {
                keyHashToEntryOffsetMap.replace(adjustedHash, foundRecordId, storedId);
            } else {
                keyHashToEntryOffsetMap.put(adjustedHash, storedId);
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFactory";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFactory";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyEquality";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryExternalizer";
                break;
            }
            case 4: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueEquality";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/durablemap/DurableMapFactory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesLog";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyHashToEntryOffsetMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/DurableMapFactory";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withDefaults";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logFactory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mapFactory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 16: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "entryExternalizerFor";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fillValueHashToIdMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

