/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.durablemap.dev;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.durablemap.Compactable;
import com.intellij.platform.util.io.storages.durablemap.DurableMap;
import com.intellij.platform.util.io.storages.durablemap.DurableMapFactory;
import com.intellij.platform.util.io.storages.durablemap.EntryExternalizer;
import com.intellij.platform.util.io.storages.intmultimaps.DurableIntToMultiIntMap;
import com.intellij.platform.util.io.storages.intmultimaps.HashUtils;
import com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap.ExtendibleHashMap;
import com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap.ExtendibleMapFactory;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import com.intellij.util.io.blobstorage.StreamlinedBlobStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DurableMapOverBlobStorage<K, V>
implements DurableMap<K, V>,
Unmappable {
    public static final int DATA_FORMAT_VERSION = 1;
    private final StreamlinedBlobStorage keyValuesStorage;
    private final DurableIntToMultiIntMap keyHashToIdMap;
    private final EqualityPolicy<? super K> keyEquality;
    @Nullable
    private final EqualityPolicy<? super V> valueEquality;
    private final EntryExternalizer<K, V> entryExternalizer;

    public DurableMapOverBlobStorage(@NotNull StreamlinedBlobStorage keyValuesStorage, @NotNull DurableIntToMultiIntMap keyHashToIdMap, @NotNull EqualityPolicy<? super K> keyEquality, @Nullable EqualityPolicy<? super V> valueEquality, @NotNull EntryExternalizer<K, V> entryExternalizer) {
        if (keyValuesStorage == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(0);
        }
        if (keyHashToIdMap == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(1);
        }
        if (keyEquality == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(2);
        }
        if (entryExternalizer == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(3);
        }
        this.keyValuesStorage = keyValuesStorage;
        this.keyHashToIdMap = keyHashToIdMap;
        this.keyEquality = keyEquality;
        this.valueEquality = valueEquality;
        this.entryExternalizer = entryExternalizer;
    }

    @Override
    public boolean containsMapping(@NotNull K key) throws IOException {
        int keyHash;
        int adjustedHash;
        int foundRecordId;
        if (key == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(4);
        }
        return (foundRecordId = this.keyHashToIdMap.lookup(adjustedHash = HashUtils.adjustHash(keyHash = this.keyEquality.getHashCode(key)), recordId -> {
            int logRecordId = DurableMapOverBlobStorage.convertStoredIdToLogId(recordId);
            return (Boolean)this.keyValuesStorage.readRecord(logRecordId, recordBuffer -> {
                K recordKey = this.entryExternalizer.readKey(recordBuffer);
                return recordKey != null;
            });
        })) != 0;
    }

    @Override
    public V get(@NotNull K key) throws IOException {
        if (key == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(5);
        }
        int keyHash = this.keyEquality.getHashCode(key);
        int adjustedHash = HashUtils.adjustHash(keyHash);
        Ref resultRef = new Ref();
        this.keyHashToIdMap.lookup(adjustedHash, recordId -> {
            int logRecordId = DurableMapOverBlobStorage.convertStoredIdToLogId(recordId);
            EntryExternalizer.Entry<Object, V> entry = this.readEntryIfKeyMatch(logRecordId, key);
            if (entry != null) {
                resultRef.set(entry);
                return true;
            }
            return false;
        });
        EntryExternalizer.Entry entry = (EntryExternalizer.Entry)resultRef.get();
        if (entry == null) {
            return null;
        }
        return entry.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NotNull K key, @Nullable V value) throws IOException {
        if (key == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(6);
        }
        int keyHash = this.keyEquality.getHashCode(key);
        int adjustedHash = HashUtils.adjustHash(keyHash);
        DurableIntToMultiIntMap durableIntToMultiIntMap = this.keyHashToIdMap;
        synchronized (durableIntToMultiIntMap) {
            Ref valueIsSameRef = new Ref((Object)Boolean.FALSE);
            int foundRecordId = this.keyHashToIdMap.lookup(adjustedHash, candidateRecordId -> {
                int logRecordId = DurableMapOverBlobStorage.convertStoredIdToLogId(candidateRecordId);
                if (this.valueEquality != null) {
                    EntryExternalizer.Entry<Object, V> entryWithSameKey = this.readEntryIfKeyMatch(logRecordId, key);
                    if (entryWithSameKey == null) {
                        return false;
                    }
                    boolean valueIsSame = this.valuesEqualNullSafe(value, entryWithSameKey.value());
                    valueIsSameRef.set((Object)valueIsSame);
                } else {
                    K candidateKey = this.readKey(logRecordId);
                    if (candidateKey == null || !this.keyEquality.isEqual(key, candidateKey)) {
                        return false;
                    }
                    valueIsSameRef.set((Object)Boolean.FALSE);
                }
                return true;
            });
            boolean keyRecordExists = foundRecordId != 0;
            boolean valueIsSame = (Boolean)valueIsSameRef.get();
            if (keyRecordExists && valueIsSame) {
                return;
            }
            long newLogRecordId = this.updateOrWriteEntry(foundRecordId, key, value);
            if (newLogRecordId == (long)foundRecordId) {
                if (value == null) {
                    this.keyHashToIdMap.remove(adjustedHash, foundRecordId);
                }
                return;
            }
            int storedRecordId = DurableMapOverBlobStorage.convertLogIdToStoredId(newLogRecordId);
            if (keyRecordExists) {
                if (value != null) {
                    this.keyHashToIdMap.replace(adjustedHash, foundRecordId, storedRecordId);
                } else {
                    this.keyHashToIdMap.remove(adjustedHash, foundRecordId);
                }
            } else if (value != null) {
                this.keyHashToIdMap.put(adjustedHash, storedRecordId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(@NotNull K key, @NotNull DataExternalizerEx.KnownSizeRecordWriter appender) throws IOException {
        if (key == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(7);
        }
        if (appender == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(8);
        }
        int keyHash = this.keyEquality.getHashCode(key);
        int adjustedHash = HashUtils.adjustHash(keyHash);
        DurableIntToMultiIntMap durableIntToMultiIntMap = this.keyHashToIdMap;
        synchronized (durableIntToMultiIntMap) {
            int foundRecordId = this.keyHashToIdMap.lookup(adjustedHash, candidateRecordId -> {
                int logRecordId = DurableMapOverBlobStorage.convertStoredIdToLogId(candidateRecordId);
                K candidateKey = this.readKey(logRecordId);
                return candidateKey != null && this.keyEquality.isEqual(key, candidateKey);
            });
            boolean keyRecordExisted = foundRecordId != 0;
            long potentiallyNewLogRecordId = this.appendToEntry(foundRecordId, key, appender);
            if (potentiallyNewLogRecordId == (long)foundRecordId) {
                return;
            }
            int newStoredRecordId = DurableMapOverBlobStorage.convertLogIdToStoredId(potentiallyNewLogRecordId);
            if (keyRecordExisted) {
                this.keyHashToIdMap.replace(adjustedHash, foundRecordId, newStoredRecordId);
            } else {
                this.keyHashToIdMap.put(adjustedHash, newStoredRecordId);
            }
        }
    }

    @Override
    public void remove(@NotNull K key) throws IOException {
        if (key == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(9);
        }
        this.put(key, null);
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super K> processor) throws IOException {
        if (processor == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(10);
        }
        return this.keyHashToIdMap.forEach((keyHash, recordId) -> {
            K key = this.readKey(DurableMapOverBlobStorage.convertStoredIdToLogId(recordId));
            if (key == null) {
                throw new AssertionError((Object)("(keyHash: " + keyHash + ", recordId: " + recordId + "): key can't be null, removed records must NOT be in keyHashToIdMap"));
            }
            return processor.process(key);
        });
    }

    @Override
    public boolean forEachEntry(@NotNull BiPredicate<? super K, ? super V> processor) throws IOException {
        if (processor == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(11);
        }
        return this.keyHashToIdMap.forEach((keyHash, recordId) -> {
            EntryExternalizer.Entry<K, V> entry = this.readEntry(DurableMapOverBlobStorage.convertStoredIdToLogId(recordId));
            K key = entry.key();
            if (!entry.isValueVoid()) {
                V value = entry.value();
                return processor.test((K)key, (V)value);
            }
            return true;
        });
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.keyHashToIdMap.isEmpty();
    }

    @Override
    public int size() throws IOException {
        return this.keyHashToIdMap.size();
    }

    @Override
    @NotNull
    public Compactable.CompactionScore compactionScore() throws IOException {
        int activeRecords = this.keyHashToIdMap.size();
        int totalRecords = this.keyValuesStorage.liveRecordsCount();
        if (totalRecords == 0) {
            return new Compactable.CompactionScore(0.0);
        }
        double score = 1.0 - (double)activeRecords * 1.0 / (double)totalRecords;
        if (totalRecords < 512) {
            return new Compactable.CompactionScore(Math.max(score, 0.1));
        }
        return new Compactable.CompactionScore(score);
    }

    @Override
    @NotNull
    public <M extends DurableMap<K, V>> M compact(@NotNull ThrowableComputable<M, ? extends IOException> compactedMapFactory) throws IOException {
        if (compactedMapFactory == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(12);
        }
        DurableMap durableMap = (DurableMap)IOUtil.wrapSafely((AutoCloseable)((DurableMap)compactedMapFactory.compute()), compactedMap -> {
            this.keyHashToIdMap.forEach((keyHash, recordId) -> {
                EntryExternalizer.Entry<K, V> entry = this.readEntry(DurableMapOverBlobStorage.convertStoredIdToLogId(recordId));
                if (!entry.isValueVoid()) {
                    compactedMap.put(entry.key(), entry.value());
                }
                return true;
            });
            return compactedMap;
        });
        if (durableMap == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(13);
        }
        return (M)durableMap;
    }

    @Override
    public void force() throws IOException {
        this.keyValuesStorage.force();
        this.keyHashToIdMap.flush();
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.keyHashToIdMap.isClosed();
    }

    @Override
    public void close() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = () -> ((StreamlinedBlobStorage)this.keyValuesStorage).close();
        throwableRunnableArray[1] = this.keyHashToIdMap::close;
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't close " + String.valueOf(this.keyValuesStorage) + "/" + String.valueOf(this.keyHashToIdMap)), (ThrowableRunnable[])throwableRunnableArray);
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't unmap " + String.valueOf(this.keyValuesStorage) + "/" + String.valueOf(this.keyHashToIdMap)), (ThrowableRunnable[])new ThrowableRunnable[]{() -> {
            StreamlinedBlobStorage patt0$temp = this.keyValuesStorage;
            if (patt0$temp instanceof Unmappable) {
                Unmappable unmappable = (Unmappable)patt0$temp;
                unmappable.closeAndUnsafelyUnmap();
            } else {
                this.keyValuesStorage.close();
            }
        }, () -> {
            DurableIntToMultiIntMap patt0$temp = this.keyHashToIdMap;
            if (patt0$temp instanceof Unmappable) {
                Unmappable unmappable = (Unmappable)patt0$temp;
                unmappable.closeAndUnsafelyUnmap();
            } else {
                this.keyHashToIdMap.close();
            }
        }});
    }

    public void closeAndClean() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = () -> ((StreamlinedBlobStorage)this.keyValuesStorage).closeAndClean();
        throwableRunnableArray[1] = () -> ((DurableIntToMultiIntMap)this.keyHashToIdMap).closeAndClean();
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't closeAndClean " + String.valueOf(this.keyValuesStorage) + "/" + String.valueOf(this.keyHashToIdMap)), (ThrowableRunnable[])throwableRunnableArray);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.keyValuesStorage) + "]";
    }

    static int convertLogIdToStoredId(long logRecordId) {
        int intStoredId = (int)logRecordId;
        if ((long)intStoredId != logRecordId) {
            throw new AssertionError((Object)("Overflow: logRecordId(=" + logRecordId + ") > MAX_INT(2147483647)"));
        }
        return intStoredId;
    }

    static int convertStoredIdToLogId(int storedRecordId) {
        return storedRecordId;
    }

    private boolean valuesEqualNullSafe(@Nullable V value, @Nullable V anotherValue) {
        if (anotherValue == null && value == null) {
            return true;
        }
        if (this.valueEquality == null) {
            return false;
        }
        return anotherValue != null && value != null && this.valueEquality.isEqual(value, anotherValue);
    }

    private EntryExternalizer.Entry<K, V> readEntryIfKeyMatch(int logRecordId, @NotNull K expectedKey) throws IOException {
        if (expectedKey == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(14);
        }
        return (EntryExternalizer.Entry)this.keyValuesStorage.readRecord(logRecordId, recordBuffer -> this.entryExternalizer.readIfKeyMatch(recordBuffer, expectedKey));
    }

    private EntryExternalizer.Entry<K, V> readEntry(int logRecordId) throws IOException {
        return (EntryExternalizer.Entry)this.keyValuesStorage.readRecord(logRecordId, this.entryExternalizer::read);
    }

    @Nullable
    private K readKey(int logRecordId) throws IOException {
        return (K)this.keyValuesStorage.readRecord(logRecordId, this.entryExternalizer::readKey);
    }

    private int updateOrWriteEntry(int foundRecordId, @NotNull K key, @Nullable V value) throws IOException {
        int maxPayloadSupported;
        DataExternalizerEx.KnownSizeRecordWriter entryWriter;
        int recordSize;
        if (key == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(15);
        }
        if ((recordSize = (entryWriter = this.entryExternalizer.writerFor(key, value)).recordSize()) > (maxPayloadSupported = this.keyValuesStorage.maxPayloadSupported())) {
            throw new IOException("[" + String.valueOf(key) + "].recordSize(=" + recordSize + ") > max supported payload size(=" + maxPayloadSupported + ")");
        }
        return this.keyValuesStorage.writeToRecord(foundRecordId, buffer -> {
            ByteBuffer toWrite = buffer.capacity() < recordSize ? ByteBuffer.allocate(recordSize).order(buffer.order()) : buffer;
            toWrite.position(0).limit(recordSize);
            entryWriter.write(toWrite);
            toWrite.position(recordSize).limit(recordSize);
            return toWrite;
        }, recordSize, false);
    }

    private int appendToEntry(int foundRecordId, @NotNull K key, @NotNull DataExternalizerEx.KnownSizeRecordWriter valueAppender) throws IOException {
        int maxPayloadSupported;
        int valueAdditionalSize;
        if (key == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(16);
        }
        if (valueAppender == null) {
            DurableMapOverBlobStorage.$$$reportNull$$$0(17);
        }
        if ((valueAdditionalSize = valueAppender.recordSize()) > (maxPayloadSupported = this.keyValuesStorage.maxPayloadSupported())) {
            throw new IOException("[" + String.valueOf(key) + "].recordSize(=" + valueAdditionalSize + ") > max supported payload size(=" + maxPayloadSupported + ")");
        }
        if (foundRecordId == 0) {
            DataExternalizerEx.KnownSizeRecordWriter headerAndKeyWriter = this.entryExternalizer.writerForEntryHeader(key);
            int headerAndKeySize = headerAndKeyWriter.recordSize();
            int totalRecordSize = headerAndKeySize + valueAdditionalSize;
            return this.keyValuesStorage.writeToRecord(foundRecordId, buffer -> {
                buffer.position(0).limit(headerAndKeySize);
                headerAndKeyWriter.write(buffer);
                buffer.position(headerAndKeySize).limit(totalRecordSize);
                valueAppender.write(buffer);
                buffer.position(totalRecordSize).limit(totalRecordSize);
                return buffer;
            }, totalRecordSize);
        }
        return this.keyValuesStorage.writeToRecord(foundRecordId, buffer -> {
            ByteBuffer toWrite;
            int currentRecordSize = buffer.limit();
            int newRecordSize = currentRecordSize + valueAdditionalSize;
            if (newRecordSize > buffer.capacity()) {
                toWrite = ByteBuffer.allocate(newRecordSize).order(buffer.order());
                toWrite.put(buffer);
            } else {
                toWrite = buffer;
            }
            toWrite.position(currentRecordSize).limit(newRecordSize);
            valueAppender.write(toWrite);
            toWrite.position(newRecordSize).limit(newRecordSize);
            return toWrite;
        }, -1, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValuesStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyHashToIdMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyEquality";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryExternalizer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactedMapFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/durablemap/dev/DurableMapOverBlobStorage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueAppender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/dev/DurableMapOverBlobStorage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "compact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsMapping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forEachEntry";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compact";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readEntryIfKeyMatch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateOrWriteEntry";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendToEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    public static class Factory<K, V>
    implements StorageFactory<DurableMapOverBlobStorage<K, V>> {
        private final StorageFactory<? extends StreamlinedBlobStorage> keyValuesStorageFactory;
        private final StorageFactory<? extends ExtendibleHashMap> mapFactory;
        private final EqualityPolicy<? super K> keyEquality;
        private final EntryExternalizer<K, V> entryExternalizer;

        private Factory(@NotNull StorageFactory<? extends StreamlinedBlobStorage> keyValuesStorageFactory, @NotNull StorageFactory<? extends ExtendibleHashMap> mapFactory, @NotNull EqualityPolicy<? super K> keyEquality, @NotNull EntryExternalizer<K, V> entryExternalizer) {
            if (keyValuesStorageFactory == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (mapFactory == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (keyEquality == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (entryExternalizer == null) {
                Factory.$$$reportNull$$$0(3);
            }
            this.keyValuesStorageFactory = keyValuesStorageFactory;
            this.mapFactory = mapFactory;
            this.keyEquality = keyEquality;
            this.entryExternalizer = entryExternalizer;
        }

        public static <K, V> Factory<K, V> defaults(@NotNull StorageFactory<? extends StreamlinedBlobStorage> keyValuesStorageFactory, @NotNull KeyDescriptorEx<K> keyDescriptor, @NotNull DataExternalizerEx<V> valueExternalizer) {
            if (keyValuesStorageFactory == null) {
                Factory.$$$reportNull$$$0(4);
            }
            if (keyDescriptor == null) {
                Factory.$$$reportNull$$$0(5);
            }
            if (valueExternalizer == null) {
                Factory.$$$reportNull$$$0(6);
            }
            ExtendibleMapFactory mapFactory = ExtendibleMapFactory.mediumSize().cleanIfFileIncompatible().ifNotClosedProperly(ExtendibleMapFactory.NotClosedProperlyAction.IGNORE_AND_HOPE_FOR_THE_BEST);
            return new Factory<K, V>(keyValuesStorageFactory, mapFactory, keyDescriptor, DurableMapFactory.entryExternalizerFor(keyDescriptor, valueExternalizer));
        }

        @Override
        @NotNull
        public DurableMapOverBlobStorage<K, V> open(@NotNull Path storagePath) throws IOException {
            if (storagePath == null) {
                Factory.$$$reportNull$$$0(7);
            }
            Path mapPath = storagePath.resolveSibling(String.valueOf(storagePath.getFileName()) + ".map");
            DurableMapOverBlobStorage durableMapOverBlobStorage = (DurableMapOverBlobStorage)this.mapFactory.wrapStorageSafely(mapPath, keyHashToIdsMap -> (DurableMapOverBlobStorage)this.keyValuesStorageFactory.wrapStorageSafely(storagePath, keyValuesStorage -> new DurableMapOverBlobStorage<K, V>((StreamlinedBlobStorage)keyValuesStorage, (DurableIntToMultiIntMap)keyHashToIdsMap, this.keyEquality, null, this.entryExternalizer)));
            if (durableMapOverBlobStorage == null) {
                Factory.$$$reportNull$$$0(8);
            }
            return durableMapOverBlobStorage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyValuesStorageFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyEquality";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryExternalizer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueExternalizer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storagePath";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/util/io/storages/durablemap/dev/DurableMapOverBlobStorage$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/dev/DurableMapOverBlobStorage$Factory";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "open";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "defaults";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "open";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }
}

