/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.storage.sharding;

import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayoutProviderKt;
import com.intellij.util.indexing.impl.storage.StorageRef;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.indexing.storage.sharding.ShardableIndexExtension;
import com.intellij.util.indexing.storage.sharding.ShardedForwardIndex;
import com.intellij.util.indexing.storage.sharding.ShardedIndexStorage;
import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShardedStorageLayout<Key, Value>
implements VfsAwareIndexStorageLayout<Key, Value> {
    private final FileBasedIndexExtension<Key, Value> extension;
    private final MapForwardIndexAccessor<Key, Value> forwardIndexAccessor;
    private final StorageRef<ShardedForwardIndex, IOException> forwardIndexRef;
    private final StorageRef<ShardedIndexStorage<Key, Value>, IOException> indexStorageRef;

    public ShardedStorageLayout(@NotNull FileBasedIndexExtension<Key, Value> extension, @NotNull ThrowableNotNullFunction<Integer, ForwardIndex, IOException> forwardIndexFactory, @NotNull ThrowableNotNullFunction<Integer, VfsAwareIndexStorage<Key, Value>, IOException> indexStorageFactory) {
        if (extension == null) {
            ShardedStorageLayout.$$$reportNull$$$0(0);
        }
        if (forwardIndexFactory == null) {
            ShardedStorageLayout.$$$reportNull$$$0(1);
        }
        if (indexStorageFactory == null) {
            ShardedStorageLayout.$$$reportNull$$$0(2);
        }
        if (!(extension instanceof ShardableIndexExtension)) {
            throw new IllegalArgumentException("Extension(" + String.valueOf(extension) + ") must be ShardableIndexExtension");
        }
        this.extension = extension;
        DataExternalizer<Map<Key, Value>> inputMapExternalizer = ShardedStorageLayout.inputMapExternalizerFor(extension);
        this.forwardIndexAccessor = new MapForwardIndexAccessor(inputMapExternalizer);
        this.indexStorageRef = new StorageRef("IndexStorage[" + String.valueOf(extension.getName()) + "]", () -> new ShardedIndexStorage(extension, indexStorageFactory), IndexStorage::isClosed, !VfsAwareIndexStorageLayout.WARN_IF_CLEANING_UNCLOSED_STORAGE);
        this.forwardIndexRef = new StorageRef("ForwardIndex[" + String.valueOf(extension.getName()) + "]", () -> new ShardedForwardIndex(extension, forwardIndexFactory), ForwardIndex::isClosed, !VfsAwareIndexStorageLayout.WARN_IF_CLEANING_UNCLOSED_STORAGE);
    }

    @NotNull
    private static <Key, Value> DataExternalizer<Map<Key, Value>> inputMapExternalizerFor(@NotNull FileBasedIndexExtension<Key, Value> extension) {
        if (extension == null) {
            ShardedStorageLayout.$$$reportNull$$$0(3);
        }
        DataExternalizer dataExternalizer = DefaultIndexStorageLayoutProviderKt.defaultMapExternalizerFor(extension);
        if (dataExternalizer == null) {
            ShardedStorageLayout.$$$reportNull$$$0(4);
        }
        return dataExternalizer;
    }

    @NotNull
    public IndexStorage<Key, Value> openIndexStorage() throws IOException {
        IndexStorage indexStorage = this.indexStorageRef.reopen();
        if (indexStorage == null) {
            ShardedStorageLayout.$$$reportNull$$$0(5);
        }
        return indexStorage;
    }

    @Nullable
    public ForwardIndex openForwardIndex() throws IOException {
        return this.forwardIndexRef.reopen();
    }

    @Nullable
    public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() {
        return this.forwardIndexAccessor;
    }

    @Override
    public void clearIndexData() {
        try {
            this.indexStorageRef.ensureClosed();
            this.forwardIndexRef.ensureClosed();
            FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(this.extension.getName()).toFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndexFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorageFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/storage/sharding/ShardedStorageLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/storage/sharding/ShardedStorageLayout";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "inputMapExternalizerFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "openIndexStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inputMapExternalizerFor";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

