/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel;

import com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel.GradleDependencyNodeDeserializer;
import com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel.GradleDependencyReportGenerator;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GradleDependencyReportTask
extends DefaultTask {
    private Path outputPath;
    final Provider<String> reportContent = this.getProject().getProviders().provider(() -> this.collectDependencies(this.getProject()));

    @OutputFile
    public Path getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(Path outputPath) {
        this.outputPath = outputPath;
    }

    @TaskAction
    public void generate() throws IOException {
        byte[] content = ((String)this.reportContent.get()).getBytes(StandardCharsets.UTF_8);
        Files.write(this.outputPath, content, new OpenOption[0]);
    }

    public String collectDependencies(Project project) {
        GradleDependencyReportGenerator generator = new GradleDependencyReportGenerator();
        ArrayList<DependencyScopeNode> dependencyScopes = new ArrayList<DependencyScopeNode>();
        project.getConfigurations().all(configuration -> {
            if (configuration.isCanBeResolved()) {
                try {
                    DependencyScopeNode dependencyScope = generator.buildDependencyGraph((Configuration)configuration, project);
                    dependencyScopes.add(dependencyScope);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return GradleDependencyNodeDeserializer.toJson(dependencyScopes);
    }
}

