/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.FetchModelResult;
import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DefaultBuildController
implements BuildController {
    @NotNull
    private final BuildController myDelegate;
    @NotNull
    private final GradleBuild myMainGradleBuild;
    @NotNull
    private final Model myMyMainGradleBuildRootProject;
    @NotNull
    private final GradleVersion myGradleVersion;

    public DefaultBuildController(@NotNull BuildController buildController, @NotNull GradleBuild mainGradleBuild, @NotNull GradleVersion gradleVersion) {
        if (buildController == null) {
            DefaultBuildController.$$$reportNull$$$0(0);
        }
        if (mainGradleBuild == null) {
            DefaultBuildController.$$$reportNull$$$0(1);
        }
        if (gradleVersion == null) {
            DefaultBuildController.$$$reportNull$$$0(2);
        }
        this.myDelegate = buildController;
        this.myMainGradleBuild = mainGradleBuild;
        this.myMyMainGradleBuildRootProject = this.myMainGradleBuild.getRootProject();
        this.myGradleVersion = gradleVersion;
    }

    private boolean isMainBuild(Model model) {
        return model == null || model == this.myMainGradleBuild;
    }

    public <T> T getModel(Class<T> aClass) throws UnknownModelException {
        if (aClass == GradleBuild.class) {
            return (T)this.myMainGradleBuild;
        }
        return (T)this.myDelegate.getModel(this.myMyMainGradleBuildRootProject, aClass);
    }

    public <T> T findModel(Class<T> aClass) {
        if (aClass == GradleBuild.class) {
            return (T)this.myMainGradleBuild;
        }
        return (T)this.myDelegate.findModel(this.myMyMainGradleBuildRootProject, aClass);
    }

    public GradleBuild getBuildModel() {
        return this.myMainGradleBuild;
    }

    public <T> T getModel(Model model, Class<T> aClass) throws UnknownModelException {
        if (this.isMainBuild(model)) {
            return this.getModel(aClass);
        }
        return (T)this.myDelegate.getModel(model, aClass);
    }

    public <T> T findModel(Model model, Class<T> aClass) {
        if (this.isMainBuild(model)) {
            return this.findModel(aClass);
        }
        return (T)this.myDelegate.findModel(model, aClass);
    }

    public <T, P> T getModel(Class<T> aClass, Class<P> aClass1, Action<? super P> action) throws UnsupportedVersionException {
        return (T)this.myDelegate.getModel(this.myMyMainGradleBuildRootProject, aClass, aClass1, action);
    }

    public <T, P> T findModel(Class<T> aClass, Class<P> aClass1, Action<? super P> action) {
        return (T)this.myDelegate.findModel(this.myMyMainGradleBuildRootProject, aClass, aClass1, action);
    }

    public <T, P> T getModel(Model model, Class<T> aClass, Class<P> aClass1, Action<? super P> action) throws UnsupportedVersionException {
        if (this.isMainBuild(model)) {
            return this.getModel(aClass, aClass1, action);
        }
        return (T)this.myDelegate.getModel(model, aClass, aClass1, action);
    }

    public <T, P> T findModel(Model model, Class<T> aClass, Class<P> aClass1, Action<? super P> action) {
        if (this.isMainBuild(model)) {
            return this.findModel(aClass, aClass1, action);
        }
        return (T)this.myDelegate.findModel(model, aClass, aClass1, action);
    }

    private boolean isParallelModelFetchSupported() {
        return GradleVersionUtil.isGradleAtLeast((GradleVersion)this.myGradleVersion, (String)"7.4.2");
    }

    public void send(Object value) {
        this.myDelegate.send(value);
    }

    public <T> List<T> run(Collection<? extends BuildAction<? extends T>> collection) {
        if (this.isParallelModelFetchSupported()) {
            return this.myDelegate.run(collection);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (BuildAction<T> buildAction : collection) {
            result.add(buildAction.execute((BuildController)this));
        }
        return result;
    }

    public boolean getCanQueryProjectModelInParallel(Class<?> aClass) {
        return this.isParallelModelFetchSupported() && this.myDelegate.getCanQueryProjectModelInParallel(aClass);
    }

    public <M> FetchModelResult<M> fetch(Class<M> aClass) {
        return this.myDelegate.fetch(this.myMyMainGradleBuildRootProject, aClass);
    }

    public <M> FetchModelResult<M> fetch(Model model, Class<M> aClass) {
        if (this.isMainBuild(model)) {
            return this.fetch(aClass);
        }
        return this.myDelegate.fetch(model, aClass);
    }

    public <M, P> FetchModelResult<M> fetch(Class<M> aClass, Class<P> aClass1, Action<? super P> action) {
        return this.myDelegate.fetch(this.myMyMainGradleBuildRootProject, aClass, aClass1, action);
    }

    public <M, P> FetchModelResult<M> fetch(Model model, Class<M> aClass, Class<P> aClass1, Action<? super P> action) {
        if (this.isMainBuild(model)) {
            return this.fetch(aClass, aClass1, action);
        }
        return this.myDelegate.fetch(model, aClass, aClass1, action);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "buildController";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "mainGradleBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "gradleVersion";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/model/DefaultBuildController";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

