/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.impl.util.GradleConventionUtil;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import groovy.lang.Closure;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtensionsSchema;
import org.gradle.api.reflect.HasPublicType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultGradleConfiguration;
import org.jetbrains.plugins.gradle.model.DefaultGradleConvention;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtension;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.DefaultGradleProperty;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectExtensionsDataBuilderImpl;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService;", "<init>", "()V", "canBuild", "", "modelName", "", "buildAll", "", "project", "Lorg/gradle/api/Project;", "extractKeys", "", "extension", "Lorg/gradle/api/plugins/ExtensionContainer;", "reportErrorMessage", "", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "intellij.gradle.toolingExtension.impl"})
@SourceDebugExtension(value={"SMAP\nProjectExtensionsDataBuilderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectExtensionsDataBuilderImpl.kt\norg/jetbrains/plugins/gradle/tooling/builder/ProjectExtensionsDataBuilderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1915#2,2:139\n*S KotlinDebug\n*F\n+ 1 ProjectExtensionsDataBuilderImpl.kt\norg/jetbrains/plugins/gradle/tooling/builder/ProjectExtensionsDataBuilderImpl\n*L\n42#1:139,2\n*E\n"})
public final class ProjectExtensionsDataBuilderImpl
implements ModelBuilderService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)GradleExtensions.class.getName());
    }

    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DefaultGradleExtensions result = new DefaultGradleExtensions();
        Project project2 = project.getParent();
        result.setParentProjectPath(project2 != null ? project2.getPath() : null);
        List<DefaultGradleConfiguration> list = result.getConfigurations();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        list.addAll(ProjectExtensionsDataBuilderImpl.Companion.collectConfigurations(configurationContainer, false));
        List<DefaultGradleConfiguration> list2 = result.getConfigurations();
        ConfigurationContainer configurationContainer2 = project.getBuildscript().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer2, (String)"getConfigurations(...)");
        list2.addAll(ProjectExtensionsDataBuilderImpl.Companion.collectConfigurations(configurationContainer2, true));
        result.getConventions().addAll(ProjectExtensionsDataBuilderImpl.Companion.collectConventions(project));
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
        ExtensionContainer extensions = extensionContainer;
        Iterable $this$forEach$iv = extensions.getExtraProperties().getProperties().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(entry.getKey(), (Object)"extraModelBuilder")) continue;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            if (StringsKt.contains$default((CharSequence)((CharSequence)k), (CharSequence)".", (boolean)false, (int)2, null)) continue;
            String typeFqn = Companion.getType(entry.getValue());
            result.getGradleProperties().add(new DefaultGradleProperty((String)entry.getKey(), typeFqn));
        }
        List<String> keyList = this.extractKeys(extensions);
        for (String name : keyList) {
            Object value = extensions.findByName(name);
            if (value == null) continue;
            String rootTypeFqn = Companion.getType(value);
            result.getExtensions().add(new DefaultGradleExtension(name, rootTypeFqn));
        }
        return result;
    }

    private final List<String> extractKeys(ExtensionContainer extension) {
        List result = new ArrayList();
        for (Object e : extension.getExtensionsSchema()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            ExtensionsSchema.ExtensionSchema schema = (ExtensionsSchema.ExtensionSchema)e;
            String string = schema.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            result.add(string);
        }
        return result;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.projectExtensionModel.group").withKind(Message.Kind.WARNING).withTitle("Project extensions data import failure").withText("Unable to resolve some context data of gradle scripts. Some codeInsight features inside *.gradle files can be unavailable.").withException(exception).reportMessage(project);
    }

    @JvmStatic
    @Nullable
    public static final String getType(@Nullable Object obj) {
        return Companion.getType(obj);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ProjectExtensionsDataBuilderImpl$Companion;", "", "<init>", "()V", "collectConfigurations", "", "Lorg/jetbrains/plugins/gradle/model/DefaultGradleConfiguration;", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "scriptClasspathConfiguration", "", "getDeclarationAlternatives", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "collectConventions", "Lorg/jetbrains/plugins/gradle/model/DefaultGradleConvention;", "project", "Lorg/gradle/api/Project;", "getType", "obj", "intellij.gradle.toolingExtension.impl"})
    @SourceDebugExtension(value={"SMAP\nProjectExtensionsDataBuilderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectExtensionsDataBuilderImpl.kt\norg/jetbrains/plugins/gradle/tooling/builder/ProjectExtensionsDataBuilderImpl$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,138:1\n221#2,2:139\n*S KotlinDebug\n*F\n+ 1 ProjectExtensionsDataBuilderImpl.kt\norg/jetbrains/plugins/gradle/tooling/builder/ProjectExtensionsDataBuilderImpl$Companion\n*L\n119#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<DefaultGradleConfiguration> collectConfigurations(ConfigurationContainer configurations, boolean scriptClasspathConfiguration) {
            List result = new ArrayList();
            for (String configurationName : configurations.getNames()) {
                Configuration configuration;
                Intrinsics.checkNotNullExpressionValue((Object)configurations.getByName(configurationName), (String)"getByName(...)");
                String description = configuration.getDescription();
                boolean visible = GradleVersionUtil.isCurrentGradleOlderThan((String)"9.1") ? configuration.isVisible() : true;
                List<String> declarationAlternatives = this.getDeclarationAlternatives(configuration);
                result.add(new DefaultGradleConfiguration(configurationName, description, visible, scriptClasspathConfiguration, declarationAlternatives));
            }
            return result;
        }

        private final List<String> getDeclarationAlternatives(Configuration configuration) {
            try {
                Method method = configuration.getClass().getMethod("getDeclarationAlternatives", new Class[0]);
                Object object = method.invoke((Object)configuration, new Object[0]);
                List list = object instanceof List ? (List)object : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
            catch (NoSuchMethodException e) {
                return CollectionsKt.emptyList();
            }
            catch (SecurityException e) {
                return CollectionsKt.emptyList();
            }
        }

        private final List<DefaultGradleConvention> collectConventions(Project project) {
            if (GradleVersionUtil.isCurrentGradleAtLeast((String)"8.2")) {
                return CollectionsKt.emptyList();
            }
            List result = new ArrayList();
            if (GradleConventionUtil.isGradleConventionsSupported()) {
                Map<String, Object> map = GradleConventionUtil.getConventionPlugins(project);
                Intrinsics.checkNotNullExpressionValue(map, (String)"getConventionPlugins(...)");
                Map<String, Object> $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> element$iv;
                    Map.Entry<String, Object> entry = element$iv = iterator.next();
                    boolean bl = false;
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    result.add(new DefaultGradleConvention(key, Companion.getType(value)));
                }
            }
            return result;
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final String getType(@Nullable Object obj) {
            if (obj instanceof HasPublicType) {
                return ((HasPublicType)obj).getPublicType().toString();
            }
            v0 = obj;
            v1 = clazz = v0 != null && (v0 = v0.getClass()) != null ? v0.getCanonicalName() : null;
            v2 = decorIndex = v1 != null ? Integer.valueOf(StringsKt.lastIndexOf$default((CharSequence)v1, (String)"_Decorated", (int)0, (boolean)false, (int)6, null)) : null;
            if (decorIndex == null) ** GOTO lbl-1000
            var5_4 = -1;
            if (decorIndex == var5_4) lbl-1000:
            // 2 sources

            {
                v3 = clazz;
            } else {
                v4 = clazz.substring(0, decorIndex);
                v3 = v4;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"substring(...)");
            }
            result = v3;
            if (result == null && obj instanceof Closure) {
                return "groovy.lang.Closure";
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

