/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.core.structure.model;

import com.intellij.liquibase.core.dom.DatabaseChangeLog;
import com.intellij.liquibase.core.dom.IncludeAll;
import com.intellij.liquibase.core.dom.IncludeFile;
import com.intellij.liquibase.core.structure.model.LiquibaseFileLogicalModel;
import com.intellij.liquibase.core.structure.model.LiquibaseTagLogicalModel;
import com.intellij.liquibase.core.structure.model.LiquibaseXmlTagLogicalModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/liquibase/core/structure/model/LiquibaseXmlFileLogicalModel;", "Lcom/intellij/liquibase/core/structure/model/LiquibaseFileLogicalModel;", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "<init>", "(Lcom/intellij/psi/xml/XmlFile;)V", "getXmlFile", "()Lcom/intellij/psi/xml/XmlFile;", "getSubTags", "", "Lcom/intellij/psi/xml/XmlTag;", "()[Lcom/intellij/psi/xml/XmlTag;", "getProperties", "", "Lcom/intellij/liquibase/core/structure/model/LiquibaseTagLogicalModel;", "getIncludes", "Lcom/intellij/liquibase/core/structure/model/LiquibaseFileLogicalModel$IncludeInfo;", "getChanges", "intellij.liquibase.core"})
@SourceDebugExtension(value={"SMAP\nLiquibaseXmlFileLogicalModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseXmlFileLogicalModel.kt\ncom/intellij/liquibase/core/structure/model/LiquibaseXmlFileLogicalModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1#2:80\n1#2:92\n1642#3,10:81\n1915#3:91\n1916#3:93\n1652#3:94\n*S KotlinDebug\n*F\n+ 1 LiquibaseXmlFileLogicalModel.kt\ncom/intellij/liquibase/core/structure/model/LiquibaseXmlFileLogicalModel\n*L\n39#1:92\n39#1:81,10\n39#1:91\n39#1:93\n39#1:94\n*E\n"})
public final class LiquibaseXmlFileLogicalModel
extends LiquibaseFileLogicalModel {
    public LiquibaseXmlFileLogicalModel(@NotNull XmlFile xmlFile) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        super((PsiFile)xmlFile);
    }

    private final XmlFile getXmlFile() {
        PsiElement psiElement = this.getNavigationElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        return (XmlFile)psiElement;
    }

    private final XmlTag[] getSubTags() {
        PsiElement psiElement = this.getNavigationElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        XmlTag[] xmlTagArray = ((XmlFile)psiElement).getRootTag();
        if (xmlTagArray == null || (xmlTagArray = xmlTagArray.getSubTags()) == null) {
            xmlTagArray = new XmlTag[]{};
        }
        return xmlTagArray;
    }

    @Override
    @NotNull
    public List<LiquibaseTagLogicalModel> getProperties() {
        List result = new ArrayList();
        for (XmlTag subTag : this.getSubTags()) {
            if (!Intrinsics.areEqual((Object)subTag.getLocalName(), (Object)"property")) continue;
            result.add(new LiquibaseXmlTagLogicalModel(subTag, null));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LiquibaseFileLogicalModel.IncludeInfo> getIncludes() {
        DomManager domManager = DomManager.getDomManager((Project)this.getXmlFile().getProject());
        Object object = domManager.getFileElement(this.getXmlFile(), DatabaseChangeLog.class);
        if (object == null || (object = (DatabaseChangeLog)object.getRootElement()) == null) {
            return CollectionsKt.emptyList();
        }
        Object databaseChangeLog = object;
        Set alreadyUsedFiles = new LinkedHashSet();
        List result = new ArrayList();
        for (XmlTag subTag : this.getSubTags()) {
            GenericAttributeValue<DatabaseChangeLog> genericAttributeValue;
            PsiFile includeDbChangeLogFile;
            Object v6;
            XmlTag xmlTag;
            Object object2;
            block11: {
                Object it;
                Object t;
                String tagName;
                Intrinsics.checkNotNullExpressionValue((Object)subTag.getLocalName(), (String)"getLocalName(...)");
                if (Intrinsics.areEqual((Object)"includeAll", (Object)tagName)) {
                    List list;
                    IncludeAll includeChangeLogs;
                    Object v1;
                    block10: {
                        object2 = databaseChangeLog.getIncludedDirectories();
                        xmlTag = object2.iterator();
                        while (xmlTag.hasNext()) {
                            t = xmlTag.next();
                            it = (IncludeAll)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getXmlTag(), (Object)subTag)) continue;
                            v1 = t;
                            break block10;
                        }
                        v1 = null;
                    }
                    if ((IncludeAll)v1 == null) continue;
                    List list2 = (List)includeChangeLogs.getIncludedChangeLogs().getValue();
                    if (list2 != null) {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = list2;
                        boolean $i$f$mapNotNull = false;
                        it = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object object3;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            DatabaseChangeLog it2 = (DatabaseChangeLog)element$iv$iv;
                            boolean bl2 = false;
                            XmlTag xmlTag2 = it2.getXmlTag();
                            if (xmlTag2 != null && (xmlTag2 = xmlTag2.getContainingFile()) != null) {
                                XmlTag xmlTag3;
                                XmlTag file = xmlTag3 = xmlTag2;
                                boolean bl3 = false;
                                object3 = alreadyUsedFiles.add(file) ? xmlTag3 : null;
                            } else {
                                object3 = null;
                            }
                            if (object3 == null) continue;
                            XmlTag it$iv$iv = object3;
                            boolean bl4 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        list = (List)destination$iv$iv;
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List includedFiles = list;
                    result.add(new LiquibaseFileLogicalModel.IncludeInfo((PsiElement)subTag, subTag.getAttributeValue("path"), includedFiles, true));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)"include", (Object)tagName)) continue;
                object2 = databaseChangeLog.getIncludedFiles();
                xmlTag = object2.iterator();
                while (xmlTag.hasNext()) {
                    t = xmlTag.next();
                    it = (IncludeFile)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getXmlTag(), (Object)subTag)) continue;
                    v6 = t;
                    break block11;
                }
                v6 = null;
            }
            IncludeFile includeFile = v6;
            PsiFile psiFile = includeDbChangeLogFile = includeFile != null && (genericAttributeValue = includeFile.getIncludedChangeLog()) != null && (object2 = (DatabaseChangeLog)genericAttributeValue.getValue()) != null && (xmlTag = object2.getXmlTag()) != null ? xmlTag.getContainingFile() : null;
            if (includeDbChangeLogFile == null || !alreadyUsedFiles.add(includeDbChangeLogFile)) continue;
            result.add(new LiquibaseFileLogicalModel.IncludeInfo((PsiElement)subTag, subTag.getAttributeValue("file"), CollectionsKt.listOf((Object)includeDbChangeLogFile), false));
        }
        return result;
    }

    @Override
    @NotNull
    public List<LiquibaseTagLogicalModel> getChanges() {
        List result = new ArrayList();
        for (XmlTag subTag : this.getSubTags()) {
            String tagName;
            Intrinsics.checkNotNullExpressionValue((Object)subTag.getLocalName(), (String)"getLocalName(...)");
            Object[] objectArray = new String[]{"includeAll", "include", "property"};
            if (ArraysKt.contains((Object[])objectArray, (Object)tagName)) continue;
            if (Intrinsics.areEqual((Object)"changeSet", (Object)tagName)) {
                XmlTag[] xmlTagArray;
                String changeSetId = subTag.getAttributeValue("id");
                Intrinsics.checkNotNullExpressionValue((Object)subTag.getSubTags(), (String)"getSubTags(...)");
                for (XmlTag changeSetChildTag : xmlTagArray) {
                    Intrinsics.checkNotNull((Object)changeSetChildTag);
                    result.add(new LiquibaseXmlTagLogicalModel(changeSetChildTag, changeSetId));
                }
                continue;
            }
            result.add(new LiquibaseXmlTagLogicalModel(subTag, null));
        }
        return result;
    }
}

