/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.common.browser;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.common.browser.FailedToStartSessionException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.util.NlsContexts;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\n\b\u0001\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/common/browser/BrowserNotFoundOnTheClientException;", "Lcom/intellij/javascript/debugger/common/browser/FailedToStartSessionException;", "Lcom/intellij/openapi/diagnostic/ExceptionWithAttachments;", "message", "", "cause", "", "clientBrowsers", "", "Lcom/intellij/ide/browsers/WebBrowser;", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/util/List;)V", "getAttachments", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "()[Lcom/intellij/openapi/diagnostic/Attachment;", "intellij.javascript.debugger.common"})
@ApiStatus.Internal
public final class BrowserNotFoundOnTheClientException
extends FailedToStartSessionException
implements ExceptionWithAttachments {
    @NotNull
    private final List<WebBrowser> clientBrowsers;

    public BrowserNotFoundOnTheClientException(@NlsContexts.DialogMessage @Nullable String message, @Nullable Throwable cause, @NotNull List<? extends WebBrowser> clientBrowsers) {
        Intrinsics.checkNotNullParameter(clientBrowsers, (String)"clientBrowsers");
        super(message, cause);
        this.clientBrowsers = clientBrowsers;
    }

    @NotNull
    public Attachment[] getAttachments() {
        String browsers = CollectionsKt.joinToString$default((Iterable)this.clientBrowsers, (CharSequence)"\n", null, null, (int)0, null, BrowserNotFoundOnTheClientException::getAttachments$lambda$0, (int)30, null);
        Attachment[] attachmentArray = new Attachment[]{new Attachment("client-browsers.txt", browsers)};
        return attachmentArray;
    }

    private static final CharSequence getAttachments$lambda$0(WebBrowser it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.trimIndent((String)("\n        " + it.getName() + "\n          family: " + it.getFamily() + "\n          id: " + it.getId() + "\n          path: " + it.getPath() + "\n      "));
    }
}

