/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.impl.FeedbackRequestData;
import com.intellij.platform.feedback.impl.FeedbackRequestDataHolder;
import com.intellij.platform.feedback.impl.FeedbackRequestType;
import com.intellij.platform.feedback.impl.GeneralFeedbackSubmitKt;
import com.intellij.util.xmlb.annotations.XMap;
import java.time.Instant;
import java.util.Calendar;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.TimeZone;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@com.intellij.openapi.components.State(name="TipsFeedback", storages={@Storage(value="tips-feedback.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/util/TipsFeedback;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/ide/util/TipsFeedback$State;", "<init>", "()V", "timeScopeForResultCollectionInDays", "", "getLikenessState", "", "tipId", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "setLikenessState", "", "likenessState", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "scheduleFeedbackSending", "getFeedbackRequestType", "Lcom/intellij/platform/feedback/impl/FeedbackRequestType;", "State", "Companion", "intellij.platform.tips"})
@SourceDebugExtension(value={"SMAP\nTipsFeedback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipsFeedback.kt\ncom/intellij/ide/util/TipsFeedback\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,79:1\n29#2,3:80\n*S KotlinDebug\n*F\n+ 1 TipsFeedback.kt\ncom/intellij/ide/util/TipsFeedback\n*L\n50#1:80,3\n*E\n"})
public final class TipsFeedback
extends SimplePersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int timeScopeForResultCollectionInDays;
    @NotNull
    private static final String FEEDBACK_REPORT_ID = "tips_of_the_day";
    private static final int FEEDBACK_FORMAT_VERSION = 1;

    public TipsFeedback() {
        super((BaseState)new State());
        this.timeScopeForResultCollectionInDays = 120;
    }

    @Nullable
    public final Boolean getLikenessState(@NotNull String tipId) {
        Intrinsics.checkNotNullParameter((Object)tipId, (String)"tipId");
        return ((State)this.getState()).getTipToLikeness().get(tipId);
    }

    public final void setLikenessState(@NotNull String tipId, @Nullable Boolean likenessState) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)tipId, (String)"tipId");
                if (likenessState == null) break block0;
                ((State)this.getState()).getTipToLikeness().put(tipId, likenessState);
                ((State)this.getState()).intIncrementModificationCount();
                break block1;
            }
            Boolean bl = ((State)this.getState()).getTipToLikeness().remove(tipId);
            if (bl == null) break block1;
            Boolean bl2 = bl;
            boolean it = bl2;
            boolean bl3 = false;
            ((State)this.getState()).intIncrementModificationCount();
        }
    }

    public final void scheduleFeedbackSending(@NotNull String tipId, boolean likenessState) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)tipId, (String)"tipId");
        Calendar buildDate = ApplicationInfo.getInstance().getBuildDate();
        Instant instant = buildDate.toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        DateTimePeriod buildToCurrentPeriod = InstantJvmKt.periodUntil((kotlinx.datetime.Instant)ConvertersKt.toKotlinInstant((Instant)instant), (kotlinx.datetime.Instant)Clock.System.INSTANCE.now(), (TimeZone)TimeZone.Companion.currentSystemDefault());
        if (buildToCurrentPeriod.getDays() > this.timeScopeForResultCollectionInDays) {
            return;
        }
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$scheduleFeedbackSending_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$scheduleFeedbackSending_u24lambda_u240, (String)"format_version", (Number)1);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$scheduleFeedbackSending_u24lambda_u240, (String)"tip_id", (String)tipId);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$scheduleFeedbackSending_u24lambda_u240, (String)"like", (Boolean)likenessState);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$scheduleFeedbackSending_u24lambda_u240, (String)"ide_name", (String)ApplicationNamesInfo.getInstance().getFullProductName());
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$scheduleFeedbackSending_u24lambda_u240, (String)"ide_build", (String)ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode());
        JsonObject dataJsonObject = builder$iv.build();
        FeedbackRequestData feedbackData = new FeedbackRequestData(FEEDBACK_REPORT_ID, dataJsonObject);
        GeneralFeedbackSubmitKt.submitFeedback((FeedbackRequestDataHolder)((FeedbackRequestDataHolder)feedbackData), TipsFeedback::scheduleFeedbackSending$lambda$1, TipsFeedback::scheduleFeedbackSending$lambda$2, (FeedbackRequestType)this.getFeedbackRequestType());
    }

    private final FeedbackRequestType getFeedbackRequestType() {
        String string = Registry.Companion.stringValue("tips.of.the.day.feedback");
        return Intrinsics.areEqual((Object)string, (Object)"production") ? FeedbackRequestType.PRODUCTION_REQUEST : (Intrinsics.areEqual((Object)string, (Object)"staging") ? FeedbackRequestType.TEST_REQUEST : FeedbackRequestType.NO_REQUEST);
    }

    private static final Unit scheduleFeedbackSending$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final Unit scheduleFeedbackSending$lambda$2() {
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final TipsFeedback getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/util/TipsFeedback$Companion;", "", "<init>", "()V", "FEEDBACK_REPORT_ID", "", "FEEDBACK_FORMAT_VERSION", "", "getInstance", "Lcom/intellij/ide/util/TipsFeedback;", "intellij.platform.tips"})
    @SourceDebugExtension(value={"SMAP\nTipsFeedback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipsFeedback.kt\ncom/intellij/ide/util/TipsFeedback$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,79:1\n42#2,3:80\n*S KotlinDebug\n*F\n+ 1 TipsFeedback.kt\ncom/intellij/ide/util/TipsFeedback$Companion\n*L\n77#1:80,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TipsFeedback getInstance() {
            boolean $i$f$service = false;
            Class<TipsFeedback> serviceClass$iv = TipsFeedback.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TipsFeedback)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R'\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/util/TipsFeedback$State;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "tipToLikeness", "", "", "", "getTipToLikeness", "()Ljava/util/Map;", "tipToLikeness$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.platform.tips"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty tipToLikeness$delegate = this.linkedMap().provideDelegate((Object)this, $$delegatedProperties[0]);

        @XMap
        @NotNull
        public final Map<String, Boolean> getTipToLikeness() {
            return (Map)this.tipToLikeness$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(State.class, "tipToLikeness", "getTipToLikeness()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

