/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.shared;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.XSourcePositionNavigatable;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/debugger/impl/shared/XDebuggerUtilImplShared;", "", "<init>", "()V", "createNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "createOpenFileDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "wrapKeepEditorAreaFocusNavigatable", "navigatable", "intellij.platform.debugger.impl.shared"})
@ApiStatus.Internal
public final class XDebuggerUtilImplShared {
    @NotNull
    public static final XDebuggerUtilImplShared INSTANCE = new XDebuggerUtilImplShared();

    private XDebuggerUtilImplShared() {
    }

    @JvmStatic
    @NotNull
    public static final Navigatable createNavigatable(@NotNull Project project, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return new XSourcePositionNavigatable(project, position);
    }

    @JvmStatic
    @NotNull
    public static final OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return position.getOffset() != -1 ? new OpenFileDescriptor(project, position.getFile(), position.getOffset()) : new OpenFileDescriptor(project, position.getFile(), position.getLine(), 0);
    }

    @JvmStatic
    @NotNull
    public static final Navigatable wrapKeepEditorAreaFocusNavigatable(@NotNull Project project, @NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        return new Navigatable(project, navigatable){
            final /* synthetic */ Project $project;
            final /* synthetic */ Navigatable $navigatable;
            {
                this.$project = $project;
                this.$navigatable = $navigatable;
            }

            public void navigate(boolean requestFocus) {
                boolean isEditorAreaFocused = FileEditorManager.getInstance((Project)this.$project).getFocusedEditor() != null;
                this.$navigatable.navigate(requestFocus && isEditorAreaFocused);
            }

            public boolean canNavigate() {
                return this.$navigatable.canNavigate();
            }

            public boolean canNavigateToSource() {
                return this.$navigatable.canNavigateToSource();
            }
        };
    }
}

