/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.NonExtendable
public class XValueMarkers<V extends XValue, M> {
    private final XValueMarkerProvider<V, M> myProvider;
    private final Map<M, ValueMarkup> myMarkers;

    @ApiStatus.Internal
    public XValueMarkers() {
        this.myProvider = null;
        this.myMarkers = Collections.emptyMap();
    }

    private XValueMarkers(@NotNull XValueMarkerProvider<V, M> provider) {
        if (provider == null) {
            XValueMarkers.$$$reportNull$$$0(0);
        }
        this.myProvider = provider;
        this.myMarkers = Collections.synchronizedMap(new HashMap());
    }

    public static <V extends XValue, M> XValueMarkers<V, M> createValueMarkers(@NotNull XValueMarkerProvider<V, M> provider) {
        if (provider == null) {
            XValueMarkers.$$$reportNull$$$0(1);
        }
        return new XValueMarkers<V, M>(provider);
    }

    @Nullable
    public ValueMarkup getMarkup(@NotNull XValue value) {
        Class valueClass;
        if (value == null) {
            XValueMarkers.$$$reportNull$$$0(2);
        }
        if (!(valueClass = this.myProvider.getValueClass()).isInstance(value)) {
            return null;
        }
        XValue v = (XValue)valueClass.cast(value);
        if (!this.myProvider.canMark(v)) {
            return null;
        }
        Object m = this.myProvider.getMarker(v);
        if (m == null) {
            return null;
        }
        return this.myMarkers.get(m);
    }

    public boolean canMarkValue(@NotNull XValue value) {
        Class valueClass;
        if (value == null) {
            XValueMarkers.$$$reportNull$$$0(3);
        }
        if (!(valueClass = this.myProvider.getValueClass()).isInstance(value)) {
            return false;
        }
        return this.myProvider.canMark((XValue)valueClass.cast(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<Object> markValue(@NotNull XValue value, @NotNull ValueMarkup markup) {
        if (value == null) {
            XValueMarkers.$$$reportNull$$$0(4);
        }
        if (markup == null) {
            XValueMarkers.$$$reportNull$$$0(5);
        }
        Map<M, ValueMarkup> map2 = this.myMarkers;
        synchronized (map2) {
            this.myMarkers.entrySet().stream().filter(entry -> markup.getText().equals(((ValueMarkup)entry.getValue()).getText())).findFirst().ifPresent(entry -> this.myMarkers.remove(entry.getKey()));
        }
        Promise promise = this.myProvider.markValueAsync(value);
        return promise.then(m -> {
            this.myMarkers.put(m, markup);
            return null;
        });
    }

    public Promise<Object> unmarkValue(@NotNull XValue value) {
        XValue v;
        Object m;
        if (value == null) {
            XValueMarkers.$$$reportNull$$$0(6);
        }
        if ((m = this.myProvider.getMarker(v = value)) != null) {
            return this.myProvider.unmarkValueAsync(v, m).onSuccess(__ -> this.myMarkers.remove(m));
        }
        return Promises.resolvedPromise();
    }

    public Map<M, ValueMarkup> getAllMarkers() {
        return Collections.unmodifiableMap(this.myMarkers);
    }

    public void clear() {
        this.myMarkers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XValueMarkers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createValueMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMarkup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canMarkValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "markValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "unmarkValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

