/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core;

import com.intellij.swagger.core.ErrorType;
import com.intellij.swagger.core.SwaggerFailure;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u0013*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0013B\u001d\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0011\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0005R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/swagger/core/SwaggerResult;", "T", "", "success", "swaggerFailure", "Lcom/intellij/swagger/core/SwaggerFailure;", "<init>", "(Ljava/lang/Object;Lcom/intellij/swagger/core/SwaggerFailure;)V", "getSuccess", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSwaggerFailure", "()Lcom/intellij/swagger/core/SwaggerFailure;", "isFailure", "", "()Z", "getSuccessOrThrow", "getSuccessOrNull", "getFailureOrThrow", "Companion", "intellij.swagger.core"})
public final class SwaggerResult<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final T success;
    @Nullable
    private final SwaggerFailure swaggerFailure;

    private SwaggerResult(T success, SwaggerFailure swaggerFailure) {
        this.success = success;
        this.swaggerFailure = swaggerFailure;
        if (this.success == null && this.swaggerFailure == null) {
            throw new RuntimeException("Both success and failure can not be null");
        }
        if (this.success != null && this.swaggerFailure != null) {
            throw new RuntimeException("Both success and failure can not be not null");
        }
    }

    @Nullable
    public final T getSuccess() {
        return this.success;
    }

    @Nullable
    public final SwaggerFailure getSwaggerFailure() {
        return this.swaggerFailure;
    }

    public final boolean isFailure() {
        return this.swaggerFailure != null;
    }

    public final T getSuccessOrThrow() {
        T t = this.success;
        if (t == null) {
            throw new RuntimeException("Success result is null");
        }
        return t;
    }

    @Nullable
    public final T getSuccessOrNull() {
        return this.success;
    }

    @NotNull
    public final SwaggerFailure getFailureOrThrow() {
        SwaggerFailure swaggerFailure = this.swaggerFailure;
        if (swaggerFailure == null) {
            throw new RuntimeException("Failure result is null");
        }
        return swaggerFailure;
    }

    public /* synthetic */ SwaggerResult(Object success, SwaggerFailure swaggerFailure, DefaultConstructorMarker $constructor_marker) {
        this(success, swaggerFailure);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0003\u0010\u000b\u001a\u00020\nJ\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\f\u001a\u00020\rJ\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u000f\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/swagger/core/SwaggerResult$Companion;", "", "<init>", "()V", "failure", "Lcom/intellij/swagger/core/SwaggerResult;", "T", "errorType", "Lcom/intellij/swagger/core/ErrorType;", "message", "", "internalMessage", "swaggerFailure", "Lcom/intellij/swagger/core/SwaggerFailure;", "success", "value", "(Ljava/lang/Object;)Lcom/intellij/swagger/core/SwaggerResult;", "intellij.swagger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> SwaggerResult<T> failure(@NotNull ErrorType errorType, @Nls @NotNull String message, @NonNls @NotNull String internalMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)errorType), (String)"errorType");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)internalMessage, (String)"internalMessage");
            SwaggerFailure swaggerFailure = new SwaggerFailure(errorType, message, internalMessage, null, 8, null);
            return new SwaggerResult(null, swaggerFailure, null);
        }

        public static /* synthetic */ SwaggerResult failure$default(Companion companion, ErrorType errorType, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = string;
            }
            return companion.failure(errorType, string, string2);
        }

        @NotNull
        public final <T> SwaggerResult<T> failure(@NotNull SwaggerFailure swaggerFailure) {
            Intrinsics.checkNotNullParameter((Object)swaggerFailure, (String)"swaggerFailure");
            return new SwaggerResult(null, swaggerFailure, null);
        }

        @NotNull
        public final <T> SwaggerResult<T> success(T value) {
            return new SwaggerResult(value, null, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

