/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.inspections;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.actions.SwMarkFileAsSpecificationUndoableAction;
import com.intellij.swagger.core.model.SwUserDefinedSpecifications;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J(\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/swagger/core/inspections/SwMarkAsSpecificationFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "fixName", "", "givenPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "lastKnownSpecificationType", "Lcom/intellij/swagger/core/SwSpecificationType;", "givenSpecificationType", "<init>", "(Ljava/lang/String;Lcom/intellij/codeInsight/intention/PriorityAction$Priority;Lcom/intellij/swagger/core/SwSpecificationType;Lcom/intellij/swagger/core/SwSpecificationType;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "applyFix", "", "descriptor", "getPriority", "markFileWithUndoSupport", "virtualFilePointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "previousType", "newType", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwMarkAsSpecificationFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwMarkAsSpecificationFix.kt\ncom/intellij/swagger/core/inspections/SwMarkAsSpecificationFix\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,72:1\n30#2,2:73\n*S KotlinDebug\n*F\n+ 1 SwMarkAsSpecificationFix.kt\ncom/intellij/swagger/core/inspections/SwMarkAsSpecificationFix\n*L\n40#1:73,2\n*E\n"})
public final class SwMarkAsSpecificationFix
implements LocalQuickFix,
PriorityAction {
    @NotNull
    private final String fixName;
    @NotNull
    private final PriorityAction.Priority givenPriority;
    @NotNull
    private final SwSpecificationType lastKnownSpecificationType;
    @NotNull
    private final SwSpecificationType givenSpecificationType;

    public SwMarkAsSpecificationFix(@IntentionName @NotNull String fixName, @NotNull PriorityAction.Priority givenPriority, @NotNull SwSpecificationType lastKnownSpecificationType, @NotNull SwSpecificationType givenSpecificationType) {
        Intrinsics.checkNotNullParameter((Object)fixName, (String)"fixName");
        Intrinsics.checkNotNullParameter((Object)givenPriority, (String)"givenPriority");
        Intrinsics.checkNotNullParameter((Object)lastKnownSpecificationType, (String)"lastKnownSpecificationType");
        Intrinsics.checkNotNullParameter((Object)givenSpecificationType, (String)"givenSpecificationType");
        this.fixName = fixName;
        this.givenPriority = givenPriority;
        this.lastKnownSpecificationType = lastKnownSpecificationType;
        this.givenSpecificationType = givenSpecificationType;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public String getFamilyName() {
        return SwaggerBundle.message("inspection.maybe.specification.name", new Object[0]);
    }

    @NotNull
    public String getName() {
        return this.fixName;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        VirtualFile virtualFile = descriptor.getPsiElement().getContainingFile().getVirtualFile();
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SwUserDefinedSpecifications> serviceClass$iv = SwUserDefinedSpecifications.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VirtualFilePointer virtualFilePointer = VirtualFilePointerManager.getInstance().create(virtualFile, (Disposable)object, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointer, (String)"create(...)");
        VirtualFilePointer virtualFilePointer2 = virtualFilePointer;
        this.markFileWithUndoSupport(virtualFilePointer2, this.lastKnownSpecificationType, this.givenSpecificationType, project);
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.givenPriority;
    }

    private final void markFileWithUndoSupport(VirtualFilePointer virtualFilePointer, SwSpecificationType previousType, SwSpecificationType newType, Project project) {
        String commandText = previousType instanceof SwSpecificationType.NONE ? SwaggerBundle.message("action.SwMarkFileAsSpecificationAction.text", new Object[0]) : SwaggerBundle.message("actions.unmark.as.specification.title", new Object[0]);
        CommandProcessor.getInstance().executeCommand(project, () -> SwMarkAsSpecificationFix.markFileWithUndoSupport$lambda$0(virtualFilePointer, previousType, newType, project), commandText, (Object)"swagger.markAsSecondarySpecification");
        DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)this);
    }

    private static final void markFileWithUndoSupport$lambda$0(VirtualFilePointer $virtualFilePointer, SwSpecificationType $previousType, SwSpecificationType $newType, Project $project) {
        SwMarkFileAsSpecificationUndoableAction undoableAction = new SwMarkFileAsSpecificationUndoableAction($virtualFilePointer, $previousType, $newType, $project);
        undoableAction.redo();
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)undoableAction);
    }
}

