/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.reference;

import com.intellij.microservices.url.parameters.DefaultPathVariableUsagesProvider;
import com.intellij.microservices.url.parameters.PathVariableDeclarationUtils;
import com.intellij.microservices.url.parameters.PathVariableUsagesProvider;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Server;
import com.intellij.swagger.core.providers.resolve.SwUrlPathSpecification;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/reference/SwPathVariableDeclarationReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.swagger.core"})
public final class SwPathVariableDeclarationReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = new Class[]{SwUrl.class, Openapi3Server.class};
        SwModelElement swModelElement = (SwModelElement)SequencesKt.firstOrNull(SwTreeUtil.INSTANCE.getParentsOfTypes(element, (Class<? extends SwModelElement>)object));
        if (swModelElement == null) {
            return new PsiReference[0];
        }
        SwModelElement urlOrServer = swModelElement;
        object = urlOrServer;
        if (object instanceof SwUrl) {
            string = ((SwUrl)urlOrServer).getUrlString();
        } else if (object instanceof Openapi3Server) {
            string = ((Openapi3Server)urlOrServer).getUrlValue().getValue();
        } else {
            return new PsiReference[0];
        }
        String urlValue2 = string;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange valueTextRange = textRange;
        PartiallyKnownString partiallyKnownString = new PartiallyKnownString(urlValue2, element, valueTextRange);
        PsiReference[] psiReferenceArray = PathVariableDeclarationUtils.createPathVariableReferencesForPks((PsiElement)element, (PartiallyKnownString)partiallyKnownString, (UrlPksParser)SwUrlPathSpecification.INSTANCE.getParser(), (PathVariableUsagesProvider)((PathVariableUsagesProvider)new DefaultPathVariableUsagesProvider()));
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"createPathVariableReferencesForPks(...)");
        return psiReferenceArray;
    }
}

