/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAspect;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.jam.AopAspectImpl;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.facet.FacetConfiguration;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.aop.SpringAopProvider;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringAopEffectiveTypesProvider
extends SpringBeanEffectiveTypeProvider {
    public boolean processEffectiveTypes(@NotNull CommonSpringBean bean, @NotNull Processor<PsiType> processor) {
        Module module;
        if (bean == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)bean.getContainingFile())) == null) {
            return true;
        }
        PsiType psiType = bean.getBeanType();
        if (psiType instanceof PsiClassType) {
            if (!SpringAopEffectiveTypesProvider.processAspects(SpringAopEffectiveTypesProvider.getJamAspects(module), processor, psiType)) {
                return false;
            }
            if (!SpringAopEffectiveTypesProvider.processAspects(SpringAopEffectiveTypesProvider.getXmlAspects(module), processor, psiType)) {
                return false;
            }
        }
        return true;
    }

    private static boolean processAspects(@NotNull Collection<? extends AopAspect> aspects, @NotNull Processor<PsiType> processor, @NotNull PsiType psiType) {
        if (aspects == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(3);
        }
        if (psiType == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(4);
        }
        for (AopAspect aopAspect : aspects) {
            for (AopIntroduction introduction : aopAspect.getIntroductions()) {
                PsiClass value;
                AopReferenceHolder holder = (AopReferenceHolder)introduction.getTypesMatching().getValue();
                if (holder == null || holder.accepts(psiType) != PointcutMatchDegree.TRUE || (value = (PsiClass)introduction.getImplementInterface().getValue()) == null || !value.isValid() || processor.process((Object)PsiTypesUtil.getClassType((PsiClass)value))) continue;
                return false;
            }
        }
        return true;
    }

    private static Collection<AopAspectImpl> getJamAspects(@NotNull Module module) {
        if (module == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(5);
        }
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List aspects = JamService.getJamService((Project)module.getProject()).getJamClassElements((JamMemberMeta)AopAspectImpl.ASPECT_META, "org.aspectj.lang.annotation.Aspect", SpringGlobalSearchScopes.runtime((Module)module, (boolean)true));
            Set cacheDependencies = aspects.stream().map(aspect -> aspect.getPsiClass().getContainingFile()).filter(Objects::nonNull).collect(Collectors.toSet());
            ContainerUtil.addAll(cacheDependencies, (Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies());
            return CachedValueProvider.Result.create((Object)aspects, (Object[])cacheDependencies.toArray());
        });
    }

    public static Set<? extends AopAspect> getXmlAspects(@NotNull Module module) {
        if (module == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(6);
        }
        if (!SpringCommonUtils.isSpringConfigured((Module)module)) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<AopAspect> set = new HashSet<AopAspect>();
            Set<DomFileElement<Beans>> fileElements = SpringAopEffectiveTypesProvider.getAopNamespacedFileElements(module);
            for (DomFileElement<Beans> element : fileElements) {
                SpringAopProvider.addAopAspects(set, element.getRootElement());
            }
            return new CachedValueProvider.Result(set, SpringAopEffectiveTypesProvider.getDependencies(module, fileElements));
        });
    }

    private static Object @NotNull [] getDependencies(@NotNull Module module, @NotNull Set<DomFileElement<Beans>> fileElements) {
        if (module == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(7);
        }
        if (fileElements == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(8);
        }
        ArrayList<FacetConfiguration> dependencies = new ArrayList<FacetConfiguration>(6);
        Collections.addAll(dependencies, fileElements.stream().map(DomFileElement::getFile).distinct().toArray());
        ContainerUtil.addAll(dependencies, (Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies());
        SpringFacet facet = SpringFacet.getInstance((Module)module);
        if (facet != null) {
            dependencies.add(facet.getConfiguration());
        }
        Object[] objectArray = dependencies.toArray();
        if (objectArray == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(9);
        }
        return objectArray;
    }

    @NotNull
    private static Set<DomFileElement<Beans>> getAopNamespacedFileElements(@NotNull Module module) {
        if (module == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(10);
        }
        Project project = module.getProject();
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, SpringGlobalSearchScopes.moduleWithDependencies((Module)module));
        Set<DomFileElement<Beans>> set = springXmlCandidates.stream().filter(vf -> ApplicationManager.getApplication().isUnitTestMode() || !SpringAopEffectiveTypesProvider.isInTestSourceContent(project, vf)).map(file -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            return psiFile instanceof XmlFile ? SpringDomUtils.getSpringDomFileElement((XmlFile)((XmlFile)psiFile)) : null;
        }).filter(Objects::nonNull).filter(element -> SpringDomUtils.hasNamespace((DomFileElement)element, (String)"Spring AOP namespace key")).collect(Collectors.toSet());
        if (set == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static boolean isInTestSourceContent(@NotNull Project project, @Nullable VirtualFile vf) {
        if (project == null) {
            SpringAopEffectiveTypesProvider.$$$reportNull$$$0(12);
        }
        return vf != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(vf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aspects";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElements";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/SpringAopEffectiveTypesProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/SpringAopEffectiveTypesProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAopNamespacedFileElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processEffectiveTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAspects";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getJamAspects";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getXmlAspects";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAopNamespacedFileElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11 -> new IllegalStateException(string);
        };
    }
}

