/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.highlighting;

import com.intellij.aop.jam.utils.AopModelUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiClass;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.model.xml.SpringAspect;
import com.intellij.spring.aop.model.xml.SpringPointcut;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NotNull;

public final class SpringAopWarningsInspection
extends BasicDomElementsInspection<Beans> {
    public SpringAopWarningsInspection() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(@NotNull DomFileElement<Beans> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        if (domFileElement == null) {
            SpringAopWarningsInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringAopWarningsInspection.$$$reportNull$$$0(1);
        }
        if (!SpringDomUtils.hasNamespace(domFileElement, (String)"Spring AOP namespace key")) {
            return;
        }
        super.checkFileElement(domFileElement, holder);
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (element == null) {
            SpringAopWarningsInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringAopWarningsInspection.$$$reportNull$$$0(3);
        }
        if (helper == null) {
            SpringAopWarningsInspection.$$$reportNull$$$0(4);
        }
        if (element instanceof SpringPointcut) {
            GenericAttributeValue<String> id = ((SpringPointcut)element).getId();
            if (!DomUtil.hasXml(id)) {
                holder.createProblem(element, HighlightSeverity.WARNING, SpringAopBundle.message("warning.pointcut.should.have.id", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("id")});
            }
        } else if (element instanceof SpringAspect) {
            PsiClass beanClass;
            GenericAttributeValue<SpringBeanPointer<?>> ref = ((SpringAspect)element).getRef();
            if (!DomUtil.hasXml(ref)) {
                holder.createProblem(element, HighlightSeverity.WARNING, XmlDomBundle.message((String)"dom.inspections.attribute.0.should.be.defined", (Object[])new Object[]{"ref"}), new LocalQuickFix[]{new DefineAttributeQuickFix("ref")});
                return;
            }
            SpringBeanPointer pointer = (SpringBeanPointer)ref.getValue();
            if (!(pointer == null || (beanClass = pointer.getBeanClass()) == null || AopModelUtils.getBoundAdvices((PsiClass)beanClass).isEmpty() && AopModelUtils.getBoundIntroductions((PsiClass)beanClass).isEmpty())) {
                holder.createProblem(ref, HighlightSeverity.WARNING, SpringAopBundle.message("aop.advice.matching.aspect.bean", new Object[0]));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/aop/highlighting/SpringAopWarningsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFileElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDomElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

