/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef;

import com.jetbrains.cef.JCefVersionDetails;
import com.jetbrains.cef.remote.NativeServerManager;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.misc.Utils;

public abstract class JCefAppConfig {
    protected final CefSettings cefSettings = new CefSettings();
    protected final List<String> appArgs = new ArrayList<String>();
    protected SystemBootstrap.Loader loader = null;
    private String cefFrameworkPathOSX = null;
    private static final AtomicReference<Double> forceDeviceScaleFactor = new AtomicReference<Double>(0.0);
    private String nativeBundlePath = null;

    public String[] getAppArgs() {
        return this.appArgs.toArray(new String[0]);
    }

    public List<String> getAppArgsAsList() {
        return this.appArgs;
    }

    public CefSettings getCefSettings() {
        return this.cefSettings;
    }

    public String getCefFrameworkPathOSX() {
        return this.cefFrameworkPathOSX;
    }

    public String getNativeBundlePath() {
        return this.nativeBundlePath;
    }

    public SystemBootstrap.Loader getLoader() {
        return this.loader;
    }

    public static JCefAppConfig getInstance(String nativeBundlePath) {
        return JCefAppConfig.getInstance(nativeBundlePath, false);
    }

    public static JCefAppConfig getInstance(final String nativeBundlePath, boolean outOfProcess) {
        JCefAppConfig appConfig = new JCefAppConfig(){};
        appConfig.nativeBundlePath = nativeBundlePath;
        if (OS.isMacintosh()) {
            appConfig.cefFrameworkPathOSX = Utils.pathOf(nativeBundlePath, "Frameworks/Chromium Embedded Framework.framework");
            if (!outOfProcess) {
                appConfig.appArgs.add("--framework-dir-path=" + appConfig.cefFrameworkPathOSX);
                appConfig.appArgs.add("--main-bundle-path=" + Utils.pathOf(nativeBundlePath, "Frameworks/jcef Helper.app"));
                appConfig.appArgs.add("--browser-subprocess-path=" + Utils.pathOf(nativeBundlePath, "Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper"));
            }
            appConfig.appArgs.add("--disable-in-process-stack-traces");
            appConfig.appArgs.add("--use-mock-keychain");
            appConfig.appArgs.add("--disable-features=SpareRendererForSitePerProcess");
            appConfig.appArgs.add("--disable-notifications");
            appConfig.loader = new SystemBootstrap.Loader(){

                @Override
                public void loadLibrary(String libname) {
                    libname = Utils.pathOf(nativeBundlePath, "lib" + libname + ".dylib");
                    System.load(libname);
                }
            };
        } else if (OS.isLinux()) {
            if (!outOfProcess) {
                appConfig.cefSettings.browser_subprocess_path = Utils.pathOf(nativeBundlePath, "jcef_helper");
            }
            appConfig.cefSettings.resources_dir_path = Utils.pathOf(nativeBundlePath, new String[0]);
            appConfig.cefSettings.locales_dir_path = Utils.pathOf(nativeBundlePath, "locales");
            appConfig.loader = new SystemBootstrap.Loader(){

                @Override
                public void loadLibrary(String libname) {
                    libname = Utils.pathOf(nativeBundlePath, "lib" + libname + ".so");
                    System.load(libname);
                }
            };
        } else if (OS.isWindows()) {
            if (!outOfProcess) {
                appConfig.cefSettings.browser_subprocess_path = Utils.pathOf(nativeBundlePath, "jcef_helper.exe");
            }
            appConfig.loader = new SystemBootstrap.Loader(){
                private final Set<String> bundledLibs = new HashSet<String>(Arrays.asList("chrome_elf", "jcef", "libcef", "shared_mem_helper"));

                @Override
                public void loadLibrary(String libname) {
                    if (this.bundledLibs.contains(libname)) {
                        System.load(Utils.pathOf(nativeBundlePath, libname + ".dll"));
                    } else {
                        System.loadLibrary(libname);
                    }
                }
            };
        } else {
            throw new IllegalStateException("JCEF is not supported on this platform: " + System.getProperty("os.name", "unknown"));
        }
        return appConfig;
    }

    public static JCefAppConfig getInstance() {
        JCefAppConfig appConfig = new JCefAppConfig(){};
        if (OS.isMacintosh()) {
            String javaRoot = Utils.pathOf(System.getProperty("java.home"), "/..");
            String frameworkPath = Utils.pathOf(javaRoot, "/Frameworks/Chromium Embedded Framework.framework");
            String cefHelperPath = Utils.pathOf(javaRoot, "/Frameworks/jcef Helper.app");
            String subprocessPath = Utils.pathOf(cefHelperPath, "/Contents/MacOS/jcef Helper");
            appConfig.appArgs.add("--framework-dir-path=" + frameworkPath);
            appConfig.appArgs.add("--browser-subprocess-path=" + subprocessPath);
            appConfig.appArgs.add("--main-bundle-path=" + cefHelperPath);
            appConfig.appArgs.add("--disable-in-process-stack-traces");
            appConfig.appArgs.add("--use-mock-keychain");
            appConfig.appArgs.add("--disable-features=SpareRendererForSitePerProcess");
            appConfig.appArgs.add("--disable-notifications");
        } else if (OS.isLinux()) {
            String libPath;
            appConfig.cefSettings.resources_dir_path = libPath = Utils.pathOf(System.getProperty("java.home"), "lib");
            appConfig.cefSettings.locales_dir_path = Utils.pathOf(libPath, "locales");
            appConfig.cefSettings.browser_subprocess_path = Utils.pathOf(libPath, "jcef_helper");
            double scale = JCefAppConfig.getDeviceScaleFactor(null);
            appConfig.appArgs.add("--force-device-scale-factor=" + scale);
            appConfig.appArgs.add("--disable-features=SpareRendererForSitePerProcess");
        } else if (OS.isWindows()) {
            String binPath = System.getProperty("java.home") + "/bin";
            String libPath = System.getProperty("java.home") + "/lib";
            appConfig.cefSettings.browser_subprocess_path = binPath + "/jcef_helper.exe";
            appConfig.appArgs.add("--disable-features=SpareRendererForSitePerProcess");
        } else {
            throw new IllegalStateException("JCEF is not supported on this platform: " + System.getProperty("os.name", "unknown"));
        }
        appConfig.loader = new SystemBootstrap.Loader(){

            @Override
            public void loadLibrary(String libname) {
                System.loadLibrary(libname);
            }
        };
        return appConfig;
    }

    @Deprecated
    public static String getJbrFrameworkPathOSX() {
        if (OS.isMacintosh()) {
            return Utils.pathOf(System.getProperty("java.home"), "../Frameworks/Chromium Embedded Framework.framework");
        }
        return null;
    }

    private static String getVersionEx() throws IOException {
        try (InputStream inputStream = JCefAppConfig.class.getResourceAsStream("version.info");){
            String string = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            return string;
        }
    }

    public static String getVersion() {
        try {
            return JCefAppConfig.getVersionEx();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JCefVersionDetails getVersionDetails() throws JCefVersionDetails.VersionUnavailableException {
        try {
            return new JCefVersionDetails(JCefAppConfig.getVersionEx());
        }
        catch (IOException e) {
            throw new JCefVersionDetails.VersionUnavailableException("Unable to load version information", e);
        }
    }

    public static double getDeviceScaleFactor(Component component) {
        GraphicsConfiguration gc;
        if (GraphicsEnvironment.isHeadless()) {
            return 1.0;
        }
        double scale = JCefAppConfig.getForceDeviceScaleFactor();
        if (scale > 0.0) {
            return scale;
        }
        GraphicsDevice device = null;
        try {
            device = component != null && component.getGraphicsConfiguration() != null ? component.getGraphicsConfiguration().getDevice() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (device != null && (gc = device.getDefaultConfiguration()) != null) {
            scale = gc.getDefaultTransform().getScaleX();
        }
        return scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static double getForceDeviceScaleFactor() {
        if (forceDeviceScaleFactor.get() == 0.0) {
            AtomicReference<Double> atomicReference = forceDeviceScaleFactor;
            synchronized (atomicReference) {
                String prop = System.getProperty("jcef.forceDeviceScaleFactor");
                if (prop != null) {
                    try {
                        forceDeviceScaleFactor.set(Double.parseDouble(prop));
                    }
                    catch (NumberFormatException e) {
                        forceDeviceScaleFactor.set(-1.0);
                        e.printStackTrace();
                    }
                } else {
                    forceDeviceScaleFactor.set(-1.0);
                }
            }
        }
        return forceDeviceScaleFactor.get();
    }

    public boolean isRemoteSupported() {
        return this.nativeBundlePath != null || NativeServerManager.isRemoteSupported();
    }

    public boolean isRemoteEnabled() {
        return this.isRemoteSupported() && Boolean.getBoolean("jcef.remote.enabled");
    }

    public File getServerExe() {
        if (this.nativeBundlePath == null) {
            return null;
        }
        if (OS.isMacintosh()) {
            return new File(this.nativeBundlePath, "Frameworks/cef_server.app/Contents/MacOS/cef_server");
        }
        if (OS.isLinux()) {
            return new File(this.nativeBundlePath, "cef_server");
        }
        if (OS.isWindows()) {
            return new File(this.nativeBundlePath, "cef_server.exe");
        }
        throw new IllegalStateException("Unsupported platform: " + System.getProperty("os.name", "unknown"));
    }
}

