/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.CharacterUtilsKt;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.util.IntPair;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005\u001a6\u0010\t\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001aN\u0010\t\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005\u001a>\u0010\u001c\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u001d2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a>\u0010\u001e\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u001d2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a>\u0010\u001f\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u001d2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001ab\u0010\u001c\u001a\u00020\u0011\"\u0004\b\u0000\u0010 2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H 0\u001d2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H 0\u001d2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\u00010\"\u001a6\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a6\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a6\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a6\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a6\u0010$\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a6\u0010%\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001aN\u0010#\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005\u001aN\u0010$\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005\u001aN\u0010%\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005\u001ah\u0010&\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(\u001a\u001e\u0010\t\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0011\u001a&\u0010\t\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0018\u001a\u001e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0011\u001a\u001e\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0011\u001a&\u0010#\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0018\u001a\u001e\u0010+\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0011\u001a\u001e\u0010,\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0011\u001a&\u0010+\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0018\u001a&\u0010,\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0018\u001aQ\u0010\t\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001au\u0010\t\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001a,\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0007\u001a-\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001a-\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001aC\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"H\u0082\b\u001aC\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"H\u0082\b\u001aC\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"H\u0082\b\u001aW\u0010/\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001aW\u00100\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001aW\u00101\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001a\u0081\u0001\u0010/\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001a\u0081\u0001\u00100\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001a\u0081\u0001\u00101\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001aj\u00104\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0007\u001ak\u00105\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001ak\u00106\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(H\u0082\b\u001a\f\u00107\u001a\u00020\u0001*\u00020\u0003H\u0000\u00a8\u00068"}, d2={"isPunctuation", "", "c", "", "b", "", "isAlpha", "isWhiteSpaceCodePoint", "isContinuousScript", "trim", "Lcom/intellij/util/IntPair;", "text", "", "start", "end", "trimStart", "trimEnd", "Lcom/intellij/diff/util/Range;", "text1", "text2", "start1", "start2", "end1", "end2", "Lcom/intellij/diff/util/MergeRange;", "text3", "start3", "end3", "expand", "", "expandForward", "expandBackward", "T", "equals", "Lkotlin/Function2;", "expandWhitespaces", "expandWhitespacesForward", "expandWhitespacesBackward", "trimExpandRange", "ignored1", "Lkotlin/Function1;", "ignored2", "range", "isEquals", "isEqualsIgnoreWhitespaces", "ignored3", "ignored", "expandIgnored", "expandIgnoredForward", "expandIgnoredBackward", "equals12", "equals13", "trimExpand", "trimExpandForward", "trimExpandBackward", "isSpaceEnterOrTab", "intellij.platform.util.diff"})
@JvmName(name="TrimUtil")
@SourceDebugExtension(value={"SMAP\nTrimUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrimUtil.kt\ncom/intellij/diff/comparison/TrimUtil\n*L\n1#1,584:1\n299#1,7:585\n310#1,7:592\n251#1,6:599\n299#1,7:605\n257#1:612\n310#1,7:613\n258#1:620\n299#1,7:621\n259#1:628\n310#1,7:629\n261#1:636\n268#1,8:637\n299#1,7:645\n276#1:652\n310#1,7:653\n277#1:660\n299#1,7:661\n278#1:668\n310#1,7:669\n279#1:676\n299#1,7:677\n280#1:684\n310#1,7:685\n282#1:692\n325#1,6:693\n343#1,11:699\n331#1,4:710\n358#1,11:714\n335#1,4:725\n343#1,11:729\n358#1,11:740\n325#1,6:751\n343#1,11:757\n331#1,4:768\n358#1,11:772\n335#1,4:783\n325#1,6:787\n343#1,11:793\n331#1,4:804\n358#1,11:808\n335#1,4:819\n343#1,11:823\n358#1,11:834\n378#1,6:845\n397#1,12:851\n384#1,4:863\n414#1,12:867\n388#1,4:879\n397#1,12:883\n414#1,12:895\n432#1,8:907\n456#1,15:915\n440#1,5:930\n477#1,15:935\n445#1,5:950\n456#1,15:955\n477#1,15:970\n299#1,7:985\n310#1,7:992\n299#1,7:999\n310#1,7:1006\n299#1,7:1013\n310#1,7:1020\n299#1,7:1027\n310#1,7:1034\n299#1,7:1041\n310#1,7:1048\n299#1,7:1055\n310#1,7:1062\n343#1,11:1069\n358#1,11:1080\n397#1,12:1091\n414#1,12:1103\n456#1,15:1115\n477#1,15:1130\n523#1,23:1145\n299#1,7:1168\n546#1:1175\n299#1,7:1176\n548#1:1183\n555#1,23:1184\n310#1,7:1207\n578#1:1214\n310#1,7:1215\n580#1:1222\n299#1,7:1223\n299#1,7:1230\n310#1,7:1237\n310#1,7:1244\n*S KotlinDebug\n*F\n+ 1 TrimUtil.kt\ncom/intellij/diff/comparison/TrimUtil\n*L\n54#1:585,7\n59#1:592,7\n66#1:599,6\n66#1:605,7\n66#1:612\n66#1:613,7\n66#1:620\n66#1:621,7\n66#1:628\n66#1:629,7\n66#1:636\n73#1:637,8\n73#1:645,7\n73#1:652\n73#1:653,7\n73#1:660\n73#1:661,7\n73#1:668\n73#1:669,7\n73#1:676\n73#1:677,7\n73#1:684\n73#1:685,7\n73#1:692\n82#1:693,6\n82#1:699,11\n82#1:710,4\n82#1:714,11\n82#1:725,4\n88#1:729,11\n94#1:740,11\n102#1:751,6\n102#1:757,11\n102#1:768,4\n102#1:772,11\n102#1:783,4\n109#1:787,6\n109#1:793,11\n109#1:804,4\n109#1:808,11\n109#1:819,4\n115#1:823,11\n121#1:834,11\n128#1:845,6\n128#1:851,12\n128#1:863,4\n128#1:867,12\n128#1:879,4\n136#1:883,12\n144#1:895,12\n152#1:907,8\n152#1:915,15\n152#1:930,5\n152#1:935,15\n152#1:950,5\n160#1:955,15\n168#1:970,15\n256#1:985,7\n257#1:992,7\n258#1:999,7\n259#1:1006,7\n275#1:1013,7\n276#1:1020,7\n277#1:1027,7\n278#1:1034,7\n279#1:1041,7\n280#1:1048,7\n291#1:1055,7\n292#1:1062,7\n330#1:1069,11\n334#1:1080,11\n383#1:1091,12\n387#1:1103,12\n439#1:1115,15\n444#1:1130,15\n508#1:1145,23\n508#1:1168,7\n508#1:1175\n508#1:1176,7\n508#1:1183\n512#1:1184,23\n512#1:1207,7\n512#1:1214\n512#1:1215,7\n512#1:1222\n545#1:1223,7\n546#1:1230,7\n577#1:1237,7\n578#1:1244,7\n*E\n"})
public final class TrimUtil {
    public static final boolean isPunctuation(char c) {
        return TrimUtil.isPunctuation((int)c);
    }

    public static final boolean isPunctuation(int b) {
        if (b == 95) {
            return false;
        }
        return b >= 33 && b <= 47 || b >= 58 && b <= 64 || b >= 91 && b <= 96 || b >= 123 && b <= 126;
    }

    public static final boolean isAlpha(int c) {
        if (TrimUtil.isWhiteSpaceCodePoint(c)) {
            return false;
        }
        return !TrimUtil.isPunctuation(c);
    }

    public static final boolean isWhiteSpaceCodePoint(int c) {
        return c < 128 && TrimUtil.isSpaceEnterOrTab((char)c);
    }

    public static final boolean isContinuousScript(int c) {
        if (c < 128) {
            return false;
        }
        if (CharacterUtilsKt.isDecimalDigit(c)) {
            return false;
        }
        if (!CharacterUtilsKt.isBmpCodePoint(c)) {
            return true;
        }
        if (CharacterUtilsKt.isIdeographic(c)) {
            return true;
        }
        if (!CharacterUtilsKt.isAlphabetic(c)) {
            return true;
        }
        return CharacterUtilsKt.isHiraganaScript(c) || CharacterUtilsKt.isKatakanaScript(c) || CharacterUtilsKt.isThaiScript(c) || CharacterUtilsKt.isJavaneseScript(c);
    }

    @NotNull
    public static final IntPair trim(@NotNull CharSequence text, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return TrimUtil.trim(start, end, (Function1<? super Integer, Boolean>)((Function1)arg_0 -> TrimUtil.trim$lambda$0(text, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public static final int trimStart(@NotNull CharSequence text, int start, int end) {
        void start$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = start;
        int end$iv = end;
        boolean $i$f$trimStart = false;
        void start$iv2 = start$iv;
        while (start$iv2 < end$iv) {
            void index = start$iv2++;
            boolean bl = false;
            if (TrimUtil.isSpaceEnterOrTab(text.charAt((int)index))) continue;
        }
        return (int)start$iv2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int trimEnd(@NotNull CharSequence text, int start, int end) {
        void start$iv;
        int end$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = start;
        int end$iv2 = end;
        boolean $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv < end$iv; --end$iv) {
            int index = end$iv - 1;
            boolean bl = false;
            if (!TrimUtil.isSpaceEnterOrTab(text.charAt(index))) break;
        }
        return end$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Range trim(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        boolean bl;
        int end$iv$iv;
        boolean bl2;
        int index;
        void start$iv$iv;
        void end1$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        int n = start1;
        int n2 = start2;
        int n3 = end1;
        int end2$iv = end2;
        boolean $i$f$trim = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void end1$iv2 = end1$iv;
        int end2$iv2 = end2$iv;
        void var15_15 = start1$iv2;
        int end$iv$iv2 = end1$iv2;
        boolean $i$f$trimStart = false;
        void start$iv$iv2 = start$iv$iv;
        while (start$iv$iv2 < end$iv$iv2) {
            index = start$iv$iv2++;
            bl2 = false;
            if (TrimUtil.isSpaceEnterOrTab(text1.charAt(index))) continue;
        }
        start$iv$iv = start1$iv2 = start$iv$iv2;
        end$iv$iv2 = end1$iv2;
        boolean $i$f$trimEnd = false;
        for (end$iv$iv = end$iv$iv2; start$iv$iv < end$iv$iv; --end$iv$iv) {
            index = end$iv$iv - true;
            bl2 = false;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt(index))) break;
        }
        end1$iv2 = end$iv$iv;
        start$iv$iv = start2$iv2;
        end$iv$iv2 = end2$iv2;
        $i$f$trimStart = false;
        start$iv$iv2 = start$iv$iv;
        while (start$iv$iv2 < end$iv$iv2) {
            index = start$iv$iv2++;
            bl = false;
            if (TrimUtil.isSpaceEnterOrTab(text2.charAt(index))) continue;
        }
        start$iv$iv = start2$iv2 = start$iv$iv2;
        end$iv$iv2 = end2$iv2;
        $i$f$trimEnd = false;
        for (end$iv$iv = end$iv$iv2; start$iv$iv < end$iv$iv; --end$iv$iv) {
            index = end$iv$iv - 1;
            bl = false;
            if (!TrimUtil.isSpaceEnterOrTab(text2.charAt(index))) break;
        }
        end2$iv2 = end$iv$iv;
        return new Range((int)start1$iv2, (int)end1$iv2, (int)start2$iv2, end2$iv2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MergeRange trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        boolean bl;
        boolean bl2;
        int end$iv$iv;
        boolean bl3;
        int index;
        void start$iv$iv;
        void end2$iv;
        void end1$iv;
        void start3$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        int n = start1;
        int n2 = start2;
        int n3 = start3;
        int n4 = end1;
        int n5 = end2;
        int end3$iv = end3;
        boolean $i$f$trim = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void start3$iv2 = start3$iv;
        void end1$iv2 = end1$iv;
        void end2$iv2 = end2$iv;
        int end3$iv2 = end3$iv;
        void var22_22 = start1$iv2;
        int end$iv$iv2 = end1$iv2;
        boolean $i$f$trimStart = false;
        void start$iv$iv2 = start$iv$iv;
        while (start$iv$iv2 < end$iv$iv2) {
            index = start$iv$iv2++;
            bl3 = false;
            if (TrimUtil.isSpaceEnterOrTab(text1.charAt(index))) continue;
        }
        start$iv$iv = start1$iv2 = start$iv$iv2;
        end$iv$iv2 = end1$iv2;
        boolean $i$f$trimEnd = false;
        for (end$iv$iv = end$iv$iv2; start$iv$iv < end$iv$iv; --end$iv$iv) {
            index = end$iv$iv - true;
            bl3 = false;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt(index))) break;
        }
        end1$iv2 = end$iv$iv;
        start$iv$iv = start2$iv2;
        end$iv$iv2 = end2$iv2;
        $i$f$trimStart = false;
        start$iv$iv2 = start$iv$iv;
        while (start$iv$iv2 < end$iv$iv2) {
            index = start$iv$iv2++;
            bl2 = false;
            if (TrimUtil.isSpaceEnterOrTab(text2.charAt(index))) continue;
        }
        start$iv$iv = start2$iv2 = start$iv$iv2;
        end$iv$iv2 = end2$iv2;
        $i$f$trimEnd = false;
        for (end$iv$iv = end$iv$iv2; start$iv$iv < end$iv$iv; --end$iv$iv) {
            index = end$iv$iv - true;
            bl2 = false;
            if (!TrimUtil.isSpaceEnterOrTab(text2.charAt(index))) break;
        }
        end2$iv2 = end$iv$iv;
        start$iv$iv = start3$iv2;
        end$iv$iv2 = end3$iv2;
        $i$f$trimStart = false;
        start$iv$iv2 = start$iv$iv;
        while (start$iv$iv2 < end$iv$iv2) {
            index = start$iv$iv2++;
            bl = false;
            if (TrimUtil.isSpaceEnterOrTab(text3.charAt(index))) continue;
        }
        start$iv$iv = start3$iv2 = start$iv$iv2;
        end$iv$iv2 = end3$iv2;
        $i$f$trimEnd = false;
        for (end$iv$iv = end$iv$iv2; start$iv$iv < end$iv$iv; --end$iv$iv) {
            index = end$iv$iv - 1;
            bl = false;
            if (!TrimUtil.isSpaceEnterOrTab(text3.charAt(index))) break;
        }
        end3$iv2 = end$iv$iv;
        return new MergeRange((int)start1$iv2, (int)end1$iv2, (int)start2$iv2, (int)end2$iv2, (int)start3$iv2, end3$iv2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Range expand(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        void start2$iv$iv;
        void start1$iv$iv;
        void end1$iv$iv;
        int n;
        void end1$iv$iv2;
        void start2$iv$iv2;
        void start1$iv$iv2;
        void end1$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter(text1, (String)"text1");
        Intrinsics.checkNotNullParameter(text2, (String)"text2");
        int n2 = start1;
        int n3 = start2;
        int n4 = end1;
        int end2$iv = end2;
        boolean $i$f$expand = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void end1$iv2 = end1$iv;
        int end2$iv2 = end2$iv;
        void var15_15 = start1$iv2;
        void var16_16 = start2$iv2;
        void var17_17 = end1$iv2;
        int end2$iv$iv = end2$iv2;
        boolean $i$f$expandForward = false;
        void start1$iv$iv3 = start1$iv$iv2;
        void start2$iv$iv3 = start2$iv$iv2;
        void oldStart1$iv$iv = start1$iv$iv3;
        while (start1$iv$iv3 < end1$iv$iv2 && start2$iv$iv3 < end2$iv$iv) {
            void index2;
            void var23_23 = start2$iv$iv3++;
            void index1 = start1$iv$iv3++;
            n = 0;
            if (Intrinsics.areEqual(text1.get((int)index1), text2.get((int)index2))) continue;
        }
        void count1$iv = start1$iv$iv3 - oldStart1$iv$iv;
        start2$iv$iv2 = start1$iv2 += count1$iv;
        end1$iv$iv2 = start2$iv2 += count1$iv;
        end2$iv$iv = end1$iv2;
        int end2$iv$iv2 = end2$iv2;
        boolean $i$f$expandBackward = false;
        void end1$iv$iv3 = end1$iv$iv;
        void oldEnd1$iv$iv = end1$iv$iv3;
        for (int end2$iv$iv3 = end2$iv$iv2; start1$iv$iv < end1$iv$iv3 && start2$iv$iv < end2$iv$iv3; --end1$iv$iv3, --end2$iv$iv3) {
            void index2;
            n = end2$iv$iv3 - 1;
            void index1 = end1$iv$iv3 - true;
            boolean $i$a$-expand-TrimUtil$expand$2 = false;
            if (!Intrinsics.areEqual(text1.get((int)index1), text2.get((int)index2))) break;
        }
        void count2$iv = oldEnd1$iv$iv - end1$iv$iv3;
        return new Range((int)start1$iv2, (int)(end1$iv2 -= count2$iv), (int)start2$iv2, end2$iv2 -= count2$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int expandForward(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        void end1$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter(text1, (String)"text1");
        Intrinsics.checkNotNullParameter(text2, (String)"text2");
        int n = start1;
        int n2 = start2;
        int n3 = end1;
        int end2$iv = end2;
        boolean $i$f$expandForward = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void oldStart1$iv = start1$iv2;
        while (start1$iv2 < end1$iv && start2$iv2 < end2$iv) {
            void index2;
            void var14_14 = start2$iv2++;
            void index1 = start1$iv2++;
            boolean bl = false;
            if (Intrinsics.areEqual(text1.get((int)index1), text2.get((int)index2))) continue;
        }
        return (int)(start1$iv2 - oldStart1$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int expandBackward(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        void start2$iv;
        void start1$iv;
        void end1$iv;
        Intrinsics.checkNotNullParameter(text1, (String)"text1");
        Intrinsics.checkNotNullParameter(text2, (String)"text2");
        int n = start1;
        int n2 = start2;
        int n3 = end1;
        int end2$iv = end2;
        boolean $i$f$expandBackward = false;
        void end1$iv2 = end1$iv;
        void oldEnd1$iv = end1$iv2;
        for (int end2$iv2 = end2$iv; start1$iv < end1$iv2 && start2$iv < end2$iv2; --end1$iv2, --end2$iv2) {
            void index2;
            int n4 = end2$iv2 - 1;
            void index1 = end1$iv2 - true;
            boolean bl = false;
            if (!Intrinsics.areEqual(text1.get((int)index1), text2.get((int)index2))) break;
        }
        return (int)(oldEnd1$iv - end1$iv2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Range expand(@NotNull List<? extends T> text1, @NotNull List<? extends T> text2, int start1, int start2, int end1, int end2, @NotNull Function2<? super T, ? super T, Boolean> equals) {
        void start2$iv$iv;
        void start1$iv$iv;
        void end1$iv$iv;
        int index2;
        boolean bl;
        void index1;
        void end1$iv$iv2;
        void start2$iv$iv2;
        void start1$iv$iv2;
        void end1$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter(text1, (String)"text1");
        Intrinsics.checkNotNullParameter(text2, (String)"text2");
        Intrinsics.checkNotNullParameter(equals, (String)"equals");
        int n = start1;
        int n2 = start2;
        int n3 = end1;
        int end2$iv = end2;
        boolean $i$f$expand = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void end1$iv2 = end1$iv;
        int end2$iv2 = end2$iv;
        void var16_16 = start1$iv2;
        void var17_17 = start2$iv2;
        void var18_18 = end1$iv2;
        int end2$iv$iv = end2$iv2;
        boolean $i$f$expandForward = false;
        void start1$iv$iv3 = start1$iv$iv2;
        void start2$iv$iv3 = start2$iv$iv2;
        void oldStart1$iv$iv = start1$iv$iv3;
        while (start1$iv$iv3 < end1$iv$iv2 && start2$iv$iv3 < end2$iv$iv) {
            void var24_24 = start2$iv$iv3++;
            index1 = start1$iv$iv3++;
            bl = false;
            if (((Boolean)equals.invoke(text1.get((int)index1), text2.get(index2))).booleanValue()) continue;
        }
        void count1$iv = start1$iv$iv3 - oldStart1$iv$iv;
        start2$iv$iv2 = start1$iv2 += count1$iv;
        end1$iv$iv2 = start2$iv2 += count1$iv;
        end2$iv$iv = end1$iv2;
        int end2$iv$iv2 = end2$iv2;
        boolean $i$f$expandBackward = false;
        void end1$iv$iv3 = end1$iv$iv;
        void oldEnd1$iv$iv = end1$iv$iv3;
        for (int end2$iv$iv3 = end2$iv$iv2; start1$iv$iv < end1$iv$iv3 && start2$iv$iv < end2$iv$iv3; --end1$iv$iv3, --end2$iv$iv3) {
            index2 = end2$iv$iv3 - 1;
            index1 = end1$iv$iv3 - true;
            bl = false;
            if (!((Boolean)equals.invoke(text1.get((int)index1), text2.get(index2))).booleanValue()) break;
        }
        void count2$iv = oldEnd1$iv$iv - end1$iv$iv3;
        return new Range((int)start1$iv2, (int)(end1$iv2 -= count2$iv), (int)start2$iv2, end2$iv2 -= count2$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Range expand(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        void start2$iv$iv;
        void start1$iv$iv;
        void end1$iv$iv;
        int n;
        void end1$iv$iv2;
        void start1$iv$iv2;
        void end1$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        int n2 = start1;
        int n3 = start2;
        int n4 = end1;
        int end2$iv = end2;
        boolean $i$f$expand = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void end1$iv2 = end1$iv;
        int end2$iv2 = end2$iv;
        void var15_15 = start1$iv2;
        void var16_16 = start2$iv2;
        void var17_17 = end1$iv2;
        int end2$iv$iv = end2$iv2;
        boolean $i$f$expandForward = false;
        void start1$iv$iv3 = start1$iv$iv2;
        void oldStart1$iv$iv = start1$iv$iv3;
        for (void start2$iv$iv2 = start2$iv$iv3; start1$iv$iv3 < end1$iv$iv2 && start2$iv$iv2 < end2$iv$iv; ++start1$iv$iv3, ++start2$iv$iv2) {
            void index2;
            void var23_23 = start2$iv$iv2;
            void index1 = start1$iv$iv3;
            n = 0;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
        }
        void count1$iv = start1$iv$iv3 - oldStart1$iv$iv;
        void start2$iv$iv3 = start1$iv2 += count1$iv;
        end1$iv$iv2 = start2$iv2 += count1$iv;
        end2$iv$iv = end1$iv2;
        int end2$iv$iv2 = end2$iv2;
        boolean $i$f$expandBackward = false;
        void end1$iv$iv3 = end1$iv$iv;
        void oldEnd1$iv$iv = end1$iv$iv3;
        for (int end2$iv$iv3 = end2$iv$iv2; start1$iv$iv < end1$iv$iv3 && start2$iv$iv < end2$iv$iv3; --end1$iv$iv3, --end2$iv$iv3) {
            void index2;
            n = end2$iv$iv3 - 1;
            void index1 = end1$iv$iv3 - true;
            boolean $i$a$-expand-TrimUtil$expand$4 = false;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
        }
        void count2$iv = oldEnd1$iv$iv - end1$iv$iv3;
        return new Range((int)start1$iv2, (int)(end1$iv2 -= count2$iv), (int)start2$iv2, end2$iv2 -= count2$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int expandForward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        void end1$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        int n = start1;
        int n2 = start2;
        int n3 = end1;
        int end2$iv = end2;
        boolean $i$f$expandForward = false;
        void start1$iv2 = start1$iv;
        void oldStart1$iv = start1$iv2;
        for (void start2$iv = start2$iv; start1$iv2 < end1$iv && start2$iv < end2$iv; ++start1$iv2, ++start2$iv) {
            void index2;
            void var14_14 = start2$iv;
            void index1 = start1$iv2;
            boolean bl = false;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
        }
        return (int)(start1$iv2 - oldStart1$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int expandBackward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        void start2$iv;
        void start1$iv;
        void end1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        int n = start1;
        int n2 = start2;
        int n3 = end1;
        int end2$iv = end2;
        boolean $i$f$expandBackward = false;
        void end1$iv2 = end1$iv;
        void oldEnd1$iv = end1$iv2;
        for (int end2$iv2 = end2$iv; start1$iv < end1$iv2 && start2$iv < end2$iv2; --end1$iv2, --end2$iv2) {
            void index2;
            int n4 = end2$iv2 - 1;
            void index1 = end1$iv2 - true;
            boolean bl = false;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
        }
        return (int)(oldEnd1$iv - end1$iv2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Range expandWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        void start2$iv$iv;
        void start1$iv$iv;
        void end1$iv$iv;
        int n;
        void index;
        void index2;
        boolean bl;
        void index1;
        void end1$iv$iv2;
        void start1$iv$iv2;
        void end1$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        int n2 = start1;
        int n3 = start2;
        int n4 = end1;
        int end2$iv = end2;
        boolean $i$f$expandIgnored = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void end1$iv2 = end1$iv;
        int end2$iv2 = end2$iv;
        void var15_15 = start1$iv2;
        void var16_16 = start2$iv2;
        void var17_17 = end1$iv2;
        int end2$iv$iv = end2$iv2;
        boolean $i$f$expandIgnoredForward = false;
        void start1$iv$iv3 = start1$iv$iv2;
        void oldStart1$iv$iv = start1$iv$iv3;
        for (void start2$iv$iv2 = start2$iv$iv3; start1$iv$iv3 < end1$iv$iv2 && start2$iv$iv2 < end2$iv$iv; ++start2$iv$iv2) {
            void var23_23 = start2$iv$iv2;
            index1 = start1$iv$iv3;
            bl = false;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
            index = start1$iv$iv3++;
            n = 0;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt((int)index))) break;
        }
        void count1$iv = start1$iv$iv3 - oldStart1$iv$iv;
        void start2$iv$iv3 = start1$iv2 += count1$iv;
        end1$iv$iv2 = start2$iv2 += count1$iv;
        end2$iv$iv = end1$iv2;
        int end2$iv$iv2 = end2$iv2;
        boolean $i$f$expandIgnoredBackward = false;
        void end1$iv$iv3 = end1$iv$iv;
        void oldEnd1$iv$iv = end1$iv$iv3;
        for (int end2$iv$iv3 = end2$iv$iv2; start1$iv$iv < end1$iv$iv3 && start2$iv$iv < end2$iv$iv3; --end1$iv$iv3, --end2$iv$iv3) {
            n = end2$iv$iv3 - 1;
            index1 = end1$iv$iv3 - true;
            bl = false;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
            index = end1$iv$iv3 - true;
            n = 0;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt((int)index))) break;
        }
        void count2$iv = oldEnd1$iv$iv - end1$iv$iv3;
        return new Range((int)start1$iv2, (int)(end1$iv2 -= count2$iv), (int)start2$iv2, end2$iv2 -= count2$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int expandWhitespacesForward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        void end1$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        int n = start1;
        int n2 = start2;
        int n3 = end1;
        int end2$iv = end2;
        boolean $i$f$expandIgnoredForward = false;
        void start1$iv2 = start1$iv;
        void oldStart1$iv = start1$iv2;
        for (void start2$iv = start2$iv; start1$iv2 < end1$iv && start2$iv < end2$iv; ++start2$iv) {
            void index2;
            void var14_14 = start2$iv;
            void index1 = start1$iv2;
            boolean bl = false;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
            void index = start1$iv2++;
            boolean bl2 = false;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt((int)index))) break;
        }
        return (int)(start1$iv2 - oldStart1$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int expandWhitespacesBackward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        void start2$iv;
        void start1$iv;
        void end1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        int n = start1;
        int n2 = start2;
        int n3 = end1;
        int end2$iv = end2;
        boolean $i$f$expandIgnoredBackward = false;
        void end1$iv2 = end1$iv;
        void oldEnd1$iv = end1$iv2;
        for (int end2$iv2 = end2$iv; start1$iv < end1$iv2 && start2$iv < end2$iv2; --end1$iv2, --end2$iv2) {
            void index2;
            int n4 = end2$iv2 - 1;
            void index1 = end1$iv2 - true;
            boolean bl = false;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
            void index = end1$iv2 - true;
            boolean bl2 = false;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt((int)index))) break;
        }
        return (int)(oldEnd1$iv - end1$iv2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MergeRange expandWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        void start3$iv$iv;
        void start2$iv$iv;
        void start1$iv$iv;
        void end2$iv$iv;
        void end1$iv$iv;
        boolean bl;
        void index;
        void index3;
        boolean bl2;
        int index2;
        boolean bl3;
        void index1;
        void end2$iv$iv2;
        void end1$iv$iv2;
        void start2$iv$iv2;
        void start1$iv$iv2;
        void end2$iv;
        void end1$iv;
        void start3$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        int n = start1;
        int n2 = start2;
        int n3 = start3;
        int n4 = end1;
        int n5 = end2;
        int end3$iv = end3;
        boolean $i$f$expandIgnored = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void start3$iv2 = start3$iv;
        void end1$iv2 = end1$iv;
        void end2$iv2 = end2$iv;
        int end3$iv2 = end3$iv;
        void var22_22 = start1$iv2;
        void var23_23 = start2$iv2;
        void var24_24 = start3$iv2;
        void var25_25 = end1$iv2;
        void var26_26 = end2$iv2;
        int end3$iv$iv = end3$iv2;
        boolean $i$f$expandIgnoredForward = false;
        void start1$iv$iv3 = start1$iv$iv2;
        void start2$iv$iv3 = start2$iv$iv2;
        void oldStart1$iv$iv = start1$iv$iv3;
        for (void start3$iv$iv2 = start3$iv$iv3; start1$iv$iv3 < end1$iv$iv2 && start2$iv$iv3 < end2$iv$iv2 && start3$iv$iv2 < end3$iv$iv; ++start2$iv$iv3, ++start3$iv$iv2) {
            void var33_33 = start2$iv$iv3;
            index1 = start1$iv$iv3;
            bl3 = false;
            if (!(text1.charAt((int)index1) == text2.charAt(index2))) break;
            index2 = start3$iv$iv2;
            index1 = start1$iv$iv3;
            bl2 = false;
            if (!(text1.charAt((int)index1) == text3.charAt((int)index3))) break;
            index = start1$iv$iv3++;
            bl = false;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt((int)index))) break;
        }
        void count1$iv = start1$iv$iv3 - oldStart1$iv$iv;
        start2$iv$iv2 = start1$iv2 += count1$iv;
        void start3$iv$iv3 = start2$iv2 += count1$iv;
        end1$iv$iv2 = start3$iv2 += count1$iv;
        end2$iv$iv2 = end1$iv2;
        end3$iv$iv = end2$iv2;
        int end3$iv$iv2 = end3$iv2;
        boolean $i$f$expandIgnoredBackward = false;
        void end1$iv$iv3 = end1$iv$iv;
        void end2$iv$iv3 = end2$iv$iv;
        void oldEnd1$iv$iv = end1$iv$iv3;
        for (int end3$iv$iv3 = end3$iv$iv2; start1$iv$iv < end1$iv$iv3 && start2$iv$iv < end2$iv$iv3 && start3$iv$iv < end3$iv$iv3; --end1$iv$iv3, --end2$iv$iv3, --end3$iv$iv3) {
            bl = end2$iv$iv3 - true;
            index1 = end1$iv$iv3 - true;
            bl3 = false;
            if (!(text1.charAt((int)index1) == text2.charAt(index2))) break;
            index2 = end3$iv$iv3 - 1;
            index1 = end1$iv$iv3 - true;
            bl2 = false;
            if (!(text1.charAt((int)index1) == text3.charAt((int)index3))) break;
            index = end1$iv$iv3 - true;
            bl = false;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt((int)index))) break;
        }
        void count2$iv = oldEnd1$iv$iv - end1$iv$iv3;
        return new MergeRange((int)start1$iv2, (int)(end1$iv2 -= count2$iv), (int)start2$iv2, (int)(end2$iv2 -= count2$iv), (int)start3$iv2, end3$iv2 -= count2$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int expandWhitespacesForward(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        void end2$iv;
        void end1$iv;
        void start2$iv;
        void start1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        int n = start1;
        int n2 = start2;
        int n3 = start3;
        int n4 = end1;
        int n5 = end2;
        int end3$iv = end3;
        boolean $i$f$expandIgnoredForward = false;
        void start1$iv2 = start1$iv;
        void start2$iv2 = start2$iv;
        void oldStart1$iv = start1$iv2;
        for (void start3$iv = start3$iv; start1$iv2 < end1$iv && start2$iv2 < end2$iv && start3$iv < end3$iv; ++start2$iv2, ++start3$iv) {
            void index3;
            void index2;
            void var20_20 = start2$iv2;
            void index1 = start1$iv2;
            boolean bl = false;
            if (!(text1.charAt((int)index1) == text2.charAt((int)index2))) break;
            index2 = start3$iv;
            index1 = start1$iv2;
            boolean bl2 = false;
            if (!(text1.charAt((int)index1) == text3.charAt((int)index3))) break;
            void index = start1$iv2++;
            boolean bl3 = false;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt((int)index))) break;
        }
        return (int)(start1$iv2 - oldStart1$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int expandWhitespacesBackward(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        void start3$iv;
        void start2$iv;
        void start1$iv;
        void end2$iv;
        void end1$iv;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        int n = start1;
        int n2 = start2;
        int n3 = start3;
        int n4 = end1;
        int n5 = end2;
        int end3$iv = end3;
        boolean $i$f$expandIgnoredBackward = false;
        void end1$iv2 = end1$iv;
        void end2$iv2 = end2$iv;
        void oldEnd1$iv = end1$iv2;
        for (int end3$iv2 = end3$iv; start1$iv < end1$iv2 && start2$iv < end2$iv2 && start3$iv < end3$iv2; --end1$iv2, --end2$iv2, --end3$iv2) {
            void index3;
            int index2;
            void var20_20 = end2$iv2 - true;
            void index1 = end1$iv2 - true;
            boolean bl = false;
            if (!(text1.charAt((int)index1) == text2.charAt(index2))) break;
            index2 = end3$iv2 - 1;
            index1 = end1$iv2 - true;
            boolean bl2 = false;
            if (!(text1.charAt((int)index1) == text3.charAt((int)index3))) break;
            void index = end1$iv2 - true;
            boolean bl3 = false;
            if (!TrimUtil.isSpaceEnterOrTab(text1.charAt((int)index))) break;
        }
        return (int)(oldEnd1$iv - end1$iv2);
    }

    @NotNull
    public static final Range trimExpandRange(int start1, int start2, int end1, int end2, @NotNull Function2<? super Integer, ? super Integer, Boolean> equals, @NotNull Function1<? super Integer, Boolean> ignored1, @NotNull Function1<? super Integer, Boolean> ignored2) {
        Intrinsics.checkNotNullParameter(equals, (String)"equals");
        Intrinsics.checkNotNullParameter(ignored1, (String)"ignored1");
        Intrinsics.checkNotNullParameter(ignored2, (String)"ignored2");
        return TrimUtil.trimExpand(start1, start2, end1, end2, (Function2<? super Integer, ? super Integer, Boolean>)((Function2)(arg_0, arg_1) -> TrimUtil.trimExpandRange$lambda$0(equals, arg_0, arg_1)), (Function1<? super Integer, Boolean>)((Function1)arg_0 -> TrimUtil.trimExpandRange$lambda$1(ignored1, arg_0)), (Function1<? super Integer, Boolean>)((Function1)arg_0 -> TrimUtil.trimExpandRange$lambda$2(ignored2, arg_0)));
    }

    @NotNull
    public static final Range trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return TrimUtil.trim(text1, text2, range.start1, range.start2, range.end1, range.end2);
    }

    @NotNull
    public static final MergeRange trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull MergeRange range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return TrimUtil.trim(text1, text2, text3, range.start1, range.start2, range.start3, range.end1, range.end2, range.end3);
    }

    @NotNull
    public static final Range expand(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return TrimUtil.expand(text1, text2, range.start1, range.start2, range.end1, range.end2);
    }

    @NotNull
    public static final Range expandWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return TrimUtil.expandWhitespaces(text1, text2, range.start1, range.start2, range.end1, range.end2);
    }

    @NotNull
    public static final MergeRange expandWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull MergeRange range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return TrimUtil.expandWhitespaces(text1, text2, text3, range.start1, range.start2, range.start3, range.end1, range.end2, range.end3);
    }

    public static final boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        CharSequence sequence1 = text1.subSequence(range.start1, range.end1);
        CharSequence sequence2 = text2.subSequence(range.start2, range.end2);
        return ComparisonUtil.isEqualTexts(sequence1, sequence2, ComparisonPolicy.DEFAULT);
    }

    public static final boolean isEqualsIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        CharSequence sequence1 = text1.subSequence(range.start1, range.end1);
        CharSequence sequence2 = text2.subSequence(range.start2, range.end2);
        return ComparisonUtil.isEqualTexts(sequence1, sequence2, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    public static final boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull MergeRange range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        CharSequence sequence1 = text1.subSequence(range.start1, range.end1);
        CharSequence sequence2 = text2.subSequence(range.start2, range.end2);
        CharSequence sequence3 = text3.subSequence(range.start3, range.end3);
        return ComparisonUtil.isEqualTexts(sequence2, sequence1, ComparisonPolicy.DEFAULT) && ComparisonUtil.isEqualTexts(sequence2, sequence3, ComparisonPolicy.DEFAULT);
    }

    public static final boolean isEqualsIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull MergeRange range) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        CharSequence sequence1 = text1.subSequence(range.start1, range.end1);
        CharSequence sequence2 = text2.subSequence(range.start2, range.end2);
        CharSequence sequence3 = text3.subSequence(range.start3, range.end3);
        return ComparisonUtil.isEqualTexts(sequence2, sequence1, ComparisonPolicy.IGNORE_WHITESPACES) && ComparisonUtil.isEqualTexts(sequence2, sequence3, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    private static final Range trim(int start1, int start2, int end1, int end2, Function1<? super Integer, Boolean> ignored1, Function1<? super Integer, Boolean> ignored2) {
        int end$iv;
        int start$iv;
        boolean $i$f$trim = false;
        int start12 = start1;
        int start22 = start2;
        int end12 = end1;
        int end22 = end2;
        int n = start12;
        int end$iv2 = end12;
        boolean $i$f$trimStart = false;
        for (start$iv = start$iv2; start$iv < end$iv2 && ((Boolean)ignored1.invoke((Object)start$iv)).booleanValue(); ++start$iv) {
        }
        int start$iv2 = start12 = start$iv;
        end$iv2 = end12;
        boolean $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv2 < end$iv && ((Boolean)ignored1.invoke((Object)(end$iv - 1))).booleanValue(); --end$iv) {
        }
        end12 = end$iv;
        start$iv2 = start22;
        end$iv2 = end22;
        $i$f$trimStart = false;
        for (start$iv = start$iv2; start$iv < end$iv2 && ((Boolean)ignored2.invoke((Object)start$iv)).booleanValue(); ++start$iv) {
        }
        start$iv2 = start22 = start$iv;
        end$iv2 = end22;
        $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv2 < end$iv && ((Boolean)ignored2.invoke((Object)(end$iv - 1))).booleanValue(); --end$iv) {
        }
        end22 = end$iv;
        return new Range(start12, end12, start22, end22);
    }

    private static final MergeRange trim(int start1, int start2, int start3, int end1, int end2, int end3, Function1<? super Integer, Boolean> ignored1, Function1<? super Integer, Boolean> ignored2, Function1<? super Integer, Boolean> ignored3) {
        int end$iv;
        int start$iv;
        boolean $i$f$trim = false;
        int start12 = start1;
        int start22 = start2;
        int start32 = start3;
        int end12 = end1;
        int end22 = end2;
        int end32 = end3;
        int n = start12;
        int end$iv2 = end12;
        boolean $i$f$trimStart = false;
        for (start$iv = start$iv2; start$iv < end$iv2 && ((Boolean)ignored1.invoke((Object)start$iv)).booleanValue(); ++start$iv) {
        }
        int start$iv2 = start12 = start$iv;
        end$iv2 = end12;
        boolean $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv2 < end$iv && ((Boolean)ignored1.invoke((Object)(end$iv - 1))).booleanValue(); --end$iv) {
        }
        end12 = end$iv;
        start$iv2 = start22;
        end$iv2 = end22;
        $i$f$trimStart = false;
        for (start$iv = start$iv2; start$iv < end$iv2 && ((Boolean)ignored2.invoke((Object)start$iv)).booleanValue(); ++start$iv) {
        }
        start$iv2 = start22 = start$iv;
        end$iv2 = end22;
        $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv2 < end$iv && ((Boolean)ignored2.invoke((Object)(end$iv - 1))).booleanValue(); --end$iv) {
        }
        end22 = end$iv;
        start$iv2 = start32;
        end$iv2 = end32;
        $i$f$trimStart = false;
        for (start$iv = start$iv2; start$iv < end$iv2 && ((Boolean)ignored3.invoke((Object)start$iv)).booleanValue(); ++start$iv) {
        }
        start$iv2 = start32 = start$iv;
        end$iv2 = end32;
        $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv2 < end$iv && ((Boolean)ignored3.invoke((Object)(end$iv - 1))).booleanValue(); --end$iv) {
        }
        end32 = end$iv;
        return new MergeRange(start12, end12, start22, end22, start32, end32);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final IntPair trim(int start, int end, @NotNull Function1<? super Integer, Boolean> ignored) {
        int end$iv;
        void start$iv;
        Intrinsics.checkNotNullParameter(ignored, (String)"ignored");
        int start2 = start;
        int end2 = end;
        int n = start2;
        int end$iv2 = end2;
        boolean $i$f$trimStart = false;
        for (start$iv = start$iv2; start$iv < end$iv2 && ((Boolean)ignored.invoke((Object)((int)start$iv))).booleanValue(); ++start$iv) {
        }
        int start$iv2 = start2 = start$iv;
        end$iv2 = end2;
        boolean $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv2 < end$iv && ((Boolean)ignored.invoke((Object)(end$iv - 1))).booleanValue(); --end$iv) {
        }
        end2 = end$iv;
        return new IntPair(start2, end2);
    }

    private static final int trimStart(int start, int end, Function1<? super Integer, Boolean> ignored) {
        int start2;
        boolean $i$f$trimStart = false;
        for (start2 = start; start2 < end && ((Boolean)ignored.invoke((Object)start2)).booleanValue(); ++start2) {
        }
        return start2;
    }

    private static final int trimEnd(int start, int end, Function1<? super Integer, Boolean> ignored) {
        int end2;
        boolean $i$f$trimEnd = false;
        for (end2 = end; start < end2 && ((Boolean)ignored.invoke((Object)(end2 - 1))).booleanValue(); --end2) {
        }
        return end2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Range expand(int start1, int start2, int end1, int end2, Function2<? super Integer, ? super Integer, Boolean> equals) {
        void start2$iv;
        void start1$iv;
        void end1$iv;
        int end1$iv2;
        void start1$iv2;
        boolean $i$f$expand = false;
        int start12 = start1;
        int start22 = start2;
        int end12 = end1;
        int end22 = end2;
        int n = start12;
        int n2 = start22;
        int n3 = end12;
        int end2$iv = end22;
        boolean $i$f$expandForward = false;
        void start1$iv3 = start1$iv2;
        void oldStart1$iv = start1$iv3;
        for (void start2$iv2 = start2$iv3; start1$iv3 < end1$iv2 && start2$iv2 < end2$iv && ((Boolean)equals.invoke((Object)((int)start1$iv3), (Object)((int)start2$iv2))).booleanValue(); ++start1$iv3, ++start2$iv2) {
        }
        void count1 = start1$iv3 - oldStart1$iv;
        int start2$iv3 = start12 += count1;
        end1$iv2 = start22 += count1;
        end2$iv = end12;
        int end2$iv2 = end22;
        boolean $i$f$expandBackward = false;
        void end1$iv3 = end1$iv;
        void oldEnd1$iv = end1$iv3;
        for (int end2$iv3 = end2$iv2; start1$iv < end1$iv3 && start2$iv < end2$iv3 && ((Boolean)equals.invoke((Object)((int)(end1$iv3 - true)), (Object)(end2$iv3 - 1))).booleanValue(); --end1$iv3, --end2$iv3) {
        }
        void count2 = oldEnd1$iv - end1$iv3;
        return new Range(start12, end12 -= count2, start22, end22 -= count2);
    }

    private static final int expandForward(int start1, int start2, int end1, int end2, Function2<? super Integer, ? super Integer, Boolean> equals) {
        boolean $i$f$expandForward = false;
        int start12 = start1;
        int oldStart1 = start12;
        for (int start22 = start2; start12 < end1 && start22 < end2 && ((Boolean)equals.invoke((Object)start12, (Object)start22)).booleanValue(); ++start12, ++start22) {
        }
        return start12 - oldStart1;
    }

    private static final int expandBackward(int start1, int start2, int end1, int end2, Function2<? super Integer, ? super Integer, Boolean> equals) {
        boolean $i$f$expandBackward = false;
        int end12 = end1;
        int oldEnd1 = end12;
        for (int end22 = end2; start1 < end12 && start2 < end22 && ((Boolean)equals.invoke((Object)(end12 - 1), (Object)(end22 - 1))).booleanValue(); --end12, --end22) {
        }
        return oldEnd1 - end12;
    }

    /*
     * WARNING - void declaration
     */
    private static final Range expandIgnored(int start1, int start2, int end1, int end2, Function2<? super Integer, ? super Integer, Boolean> equals, Function1<? super Integer, Boolean> ignored1) {
        void start2$iv;
        void start1$iv;
        void end1$iv;
        int end1$iv2;
        void start1$iv2;
        boolean $i$f$expandIgnored = false;
        int start12 = start1;
        int start22 = start2;
        int end12 = end1;
        int end22 = end2;
        int n = start12;
        int n2 = start22;
        int n3 = end12;
        int end2$iv = end22;
        boolean $i$f$expandIgnoredForward = false;
        void start1$iv3 = start1$iv2;
        void oldStart1$iv = start1$iv3;
        for (void start2$iv2 = start2$iv3; start1$iv3 < end1$iv2 && start2$iv2 < end2$iv && ((Boolean)equals.invoke((Object)((int)start1$iv3), (Object)((int)start2$iv2))).booleanValue() && ((Boolean)ignored1.invoke((Object)((int)start1$iv3))).booleanValue(); ++start1$iv3, ++start2$iv2) {
        }
        void count1 = start1$iv3 - oldStart1$iv;
        int start2$iv3 = start12 += count1;
        end1$iv2 = start22 += count1;
        end2$iv = end12;
        int end2$iv2 = end22;
        boolean $i$f$expandIgnoredBackward = false;
        void end1$iv3 = end1$iv;
        void oldEnd1$iv = end1$iv3;
        for (int end2$iv3 = end2$iv2; start1$iv < end1$iv3 && start2$iv < end2$iv3 && ((Boolean)equals.invoke((Object)((int)(end1$iv3 - true)), (Object)(end2$iv3 - 1))).booleanValue() && ((Boolean)ignored1.invoke((Object)((int)(end1$iv3 - true)))).booleanValue(); --end1$iv3, --end2$iv3) {
        }
        void count2 = oldEnd1$iv - end1$iv3;
        return new Range(start12, end12 -= count2, start22, end22 -= count2);
    }

    private static final int expandIgnoredForward(int start1, int start2, int end1, int end2, Function2<? super Integer, ? super Integer, Boolean> equals, Function1<? super Integer, Boolean> ignored1) {
        boolean $i$f$expandIgnoredForward = false;
        int start12 = start1;
        int oldStart1 = start12;
        for (int start22 = start2; start12 < end1 && start22 < end2 && ((Boolean)equals.invoke((Object)start12, (Object)start22)).booleanValue() && ((Boolean)ignored1.invoke((Object)start12)).booleanValue(); ++start12, ++start22) {
        }
        return start12 - oldStart1;
    }

    private static final int expandIgnoredBackward(int start1, int start2, int end1, int end2, Function2<? super Integer, ? super Integer, Boolean> equals, Function1<? super Integer, Boolean> ignored1) {
        boolean $i$f$expandIgnoredBackward = false;
        int end12 = end1;
        int oldEnd1 = end12;
        for (int end22 = end2; start1 < end12 && start2 < end22 && ((Boolean)equals.invoke((Object)(end12 - 1), (Object)(end22 - 1))).booleanValue() && ((Boolean)ignored1.invoke((Object)(end12 - 1))).booleanValue(); --end12, --end22) {
        }
        return oldEnd1 - end12;
    }

    /*
     * WARNING - void declaration
     */
    private static final MergeRange expandIgnored(int start1, int start2, int start3, int end1, int end2, int end3, Function2<? super Integer, ? super Integer, Boolean> equals12, Function2<? super Integer, ? super Integer, Boolean> equals13, Function1<? super Integer, Boolean> ignored1) {
        void start3$iv;
        void start2$iv;
        void start1$iv;
        void end2$iv;
        void end1$iv;
        int end2$iv2;
        int end1$iv2;
        int start2$iv2;
        void start1$iv2;
        boolean $i$f$expandIgnored = false;
        int start12 = start1;
        int start22 = start2;
        int start32 = start3;
        int end12 = end1;
        int end22 = end2;
        int end32 = end3;
        int n = start12;
        int n2 = start22;
        int n3 = start32;
        int n4 = end12;
        int n5 = end22;
        int end3$iv = end32;
        boolean $i$f$expandIgnoredForward = false;
        void start1$iv3 = start1$iv2;
        void start2$iv3 = start2$iv2;
        void oldStart1$iv = start1$iv3;
        for (void start3$iv2 = start3$iv3; start1$iv3 < end1$iv2 && start2$iv3 < end2$iv2 && start3$iv2 < end3$iv && ((Boolean)equals12.invoke((Object)((int)start1$iv3), (Object)((int)start2$iv3))).booleanValue() && ((Boolean)equals13.invoke((Object)((int)start1$iv3), (Object)((int)start3$iv2))).booleanValue() && ((Boolean)ignored1.invoke((Object)((int)start1$iv3))).booleanValue(); ++start1$iv3, ++start2$iv3, ++start3$iv2) {
        }
        void count1 = start1$iv3 - oldStart1$iv;
        start2$iv2 = start12 += count1;
        int start3$iv3 = start22 += count1;
        end1$iv2 = start32 += count1;
        end2$iv2 = end12;
        end3$iv = end22;
        int end3$iv2 = end32;
        boolean $i$f$expandIgnoredBackward = false;
        void end1$iv3 = end1$iv;
        void end2$iv3 = end2$iv;
        void oldEnd1$iv = end1$iv3;
        for (int end3$iv3 = end3$iv2; start1$iv < end1$iv3 && start2$iv < end2$iv3 && start3$iv < end3$iv3 && ((Boolean)equals12.invoke((Object)((int)(end1$iv3 - true)), (Object)((int)(end2$iv3 - true)))).booleanValue() && ((Boolean)equals13.invoke((Object)((int)(end1$iv3 - true)), (Object)(end3$iv3 - 1))).booleanValue() && ((Boolean)ignored1.invoke((Object)((int)(end1$iv3 - true)))).booleanValue(); --end1$iv3, --end2$iv3, --end3$iv3) {
        }
        void count2 = oldEnd1$iv - end1$iv3;
        return new MergeRange(start12, end12 -= count2, start22, end22 -= count2, start32, end32 -= count2);
    }

    private static final int expandIgnoredForward(int start1, int start2, int start3, int end1, int end2, int end3, Function2<? super Integer, ? super Integer, Boolean> equals12, Function2<? super Integer, ? super Integer, Boolean> equals13, Function1<? super Integer, Boolean> ignored1) {
        boolean $i$f$expandIgnoredForward = false;
        int start12 = start1;
        int start22 = start2;
        int oldStart1 = start12;
        for (int start32 = start3; start12 < end1 && start22 < end2 && start32 < end3 && ((Boolean)equals12.invoke((Object)start12, (Object)start22)).booleanValue() && ((Boolean)equals13.invoke((Object)start12, (Object)start32)).booleanValue() && ((Boolean)ignored1.invoke((Object)start12)).booleanValue(); ++start12, ++start22, ++start32) {
        }
        return start12 - oldStart1;
    }

    private static final int expandIgnoredBackward(int start1, int start2, int start3, int end1, int end2, int end3, Function2<? super Integer, ? super Integer, Boolean> equals12, Function2<? super Integer, ? super Integer, Boolean> equals13, Function1<? super Integer, Boolean> ignored1) {
        boolean $i$f$expandIgnoredBackward = false;
        int end12 = end1;
        int end22 = end2;
        int oldEnd1 = end12;
        for (int end32 = end3; start1 < end12 && start2 < end22 && start3 < end32 && ((Boolean)equals12.invoke((Object)(end12 - 1), (Object)(end22 - 1))).booleanValue() && ((Boolean)equals13.invoke((Object)(end12 - 1), (Object)(end32 - 1))).booleanValue() && ((Boolean)ignored1.invoke((Object)(end12 - 1))).booleanValue(); --end12, --end22, --end32) {
        }
        return oldEnd1 - end12;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final Range trimExpand(int start1, int start2, int end1, int end2, @NotNull Function2<? super Integer, ? super Integer, Boolean> equals, @NotNull Function1<? super Integer, Boolean> ignored1, @NotNull Function1<? super Integer, Boolean> ignored2) {
        void start$iv$iv;
        int end$iv$iv;
        boolean skipped$iv;
        void start2$iv;
        void start1$iv;
        void end1$iv;
        void start$iv$iv2;
        boolean skipped$iv2;
        int end1$iv2;
        int start2$iv2;
        void start1$iv2;
        Intrinsics.checkNotNullParameter(equals, (String)"equals");
        Intrinsics.checkNotNullParameter(ignored1, (String)"ignored1");
        Intrinsics.checkNotNullParameter(ignored2, (String)"ignored2");
        int start12 = start1;
        int start22 = start2;
        int end12 = end1;
        int end22 = end2;
        int n = start12;
        int n2 = start22;
        int n3 = end12;
        int end2$iv = end22;
        boolean $i$f$trimExpandForward = false;
        void start1$iv3 = start1$iv2;
        void start2$iv3 = start2$iv2;
        while (start1$iv3 < end1$iv2 && start2$iv3 < end2$iv) {
            if (((Boolean)equals.invoke((Object)((int)start1$iv3), (Object)((int)start2$iv3))).booleanValue()) {
                ++start1$iv3;
                ++start2$iv3;
                continue;
            }
            skipped$iv2 = false;
            if (((Boolean)ignored1.invoke((Object)((int)start1$iv3))).booleanValue()) {
                skipped$iv2 = true;
                ++start1$iv3;
            }
            if (((Boolean)ignored2.invoke((Object)((int)start2$iv3))).booleanValue()) {
                skipped$iv2 = true;
                ++start2$iv3;
            }
            if (skipped$iv2) continue;
        }
        skipped$iv2 = start1$iv3;
        int end$iv$iv2 = end1$iv2;
        boolean $i$f$trimStart = false;
        for (start$iv$iv2 = start$iv$iv3; start$iv$iv2 < end$iv$iv2 && ((Boolean)ignored1.invoke((Object)((int)start$iv$iv2))).booleanValue(); ++start$iv$iv2) {
        }
        start1$iv3 = start$iv$iv2;
        void start$iv$iv3 = start2$iv3;
        end$iv$iv2 = end2$iv;
        $i$f$trimStart = false;
        for (start$iv$iv2 = start$iv$iv3; start$iv$iv2 < end$iv$iv2 && ((Boolean)ignored2.invoke((Object)((int)start$iv$iv2))).booleanValue(); ++start$iv$iv2) {
        }
        start2$iv3 = start$iv$iv2;
        IntPair starts = new IntPair((int)start1$iv3, (int)start2$iv3);
        start12 = starts.first;
        start22 = starts.second;
        start2$iv2 = start12;
        end1$iv2 = start22;
        end2$iv = end12;
        int end2$iv2 = end22;
        boolean $i$f$trimExpandBackward = false;
        void end1$iv3 = end1$iv;
        int end2$iv3 = end2$iv2;
        while (start1$iv < end1$iv3 && start2$iv < end2$iv3) {
            if (((Boolean)equals.invoke((Object)((int)(end1$iv3 - true)), (Object)(end2$iv3 - 1))).booleanValue()) {
                --end1$iv3;
                --end2$iv3;
                continue;
            }
            skipped$iv = false;
            if (((Boolean)ignored1.invoke((Object)((int)(end1$iv3 - true)))).booleanValue()) {
                skipped$iv = true;
                --end1$iv3;
            }
            if (((Boolean)ignored2.invoke((Object)(end2$iv3 - 1))).booleanValue()) {
                skipped$iv = true;
                --end2$iv3;
            }
            if (skipped$iv) continue;
        }
        skipped$iv = start1$iv;
        int end$iv$iv3 = end1$iv3;
        boolean $i$f$trimEnd = false;
        for (end$iv$iv = end$iv$iv3; start$iv$iv < end$iv$iv && ((Boolean)ignored1.invoke((Object)((int)(end$iv$iv - true)))).booleanValue(); --end$iv$iv) {
        }
        end1$iv3 = end$iv$iv;
        start$iv$iv = start2$iv;
        end$iv$iv3 = end2$iv3;
        $i$f$trimEnd = false;
        for (end$iv$iv = end$iv$iv3; start$iv$iv < end$iv$iv && ((Boolean)ignored2.invoke((Object)(end$iv$iv - 1))).booleanValue(); --end$iv$iv) {
        }
        end2$iv3 = end$iv$iv;
        IntPair ends = new IntPair((int)end1$iv3, end2$iv3);
        end12 = ends.first;
        end22 = ends.second;
        return new Range(start12, end12, start22, end22);
    }

    private static final IntPair trimExpandForward(int start1, int start2, int end1, int end2, Function2<? super Integer, ? super Integer, Boolean> equals, Function1<? super Integer, Boolean> ignored1, Function1<? super Integer, Boolean> ignored2) {
        int start$iv;
        int skipped;
        boolean $i$f$trimExpandForward = false;
        int start12 = start1;
        int start22 = start2;
        while (start12 < end1 && start22 < end2) {
            if (((Boolean)equals.invoke((Object)start12, (Object)start22)).booleanValue()) {
                ++start12;
                ++start22;
                continue;
            }
            skipped = 0;
            if (((Boolean)ignored1.invoke((Object)start12)).booleanValue()) {
                skipped = 1;
                ++start12;
            }
            if (((Boolean)ignored2.invoke((Object)start22)).booleanValue()) {
                skipped = 1;
                ++start22;
            }
            if (skipped != 0) continue;
        }
        skipped = start12;
        int end$iv = end1;
        boolean $i$f$trimStart = false;
        for (start$iv = start$iv2; start$iv < end$iv && ((Boolean)ignored1.invoke((Object)start$iv)).booleanValue(); ++start$iv) {
        }
        start12 = start$iv;
        int start$iv2 = start22;
        end$iv = end2;
        $i$f$trimStart = false;
        for (start$iv = start$iv2; start$iv < end$iv && ((Boolean)ignored2.invoke((Object)start$iv)).booleanValue(); ++start$iv) {
        }
        start22 = start$iv;
        return new IntPair(start12, start22);
    }

    private static final IntPair trimExpandBackward(int start1, int start2, int end1, int end2, Function2<? super Integer, ? super Integer, Boolean> equals, Function1<? super Integer, Boolean> ignored1, Function1<? super Integer, Boolean> ignored2) {
        int start$iv;
        int end$iv;
        int skipped;
        boolean $i$f$trimExpandBackward = false;
        int end12 = end1;
        int end22 = end2;
        while (start1 < end12 && start2 < end22) {
            if (((Boolean)equals.invoke((Object)(end12 - 1), (Object)(end22 - 1))).booleanValue()) {
                --end12;
                --end22;
                continue;
            }
            skipped = 0;
            if (((Boolean)ignored1.invoke((Object)(end12 - 1))).booleanValue()) {
                skipped = 1;
                --end12;
            }
            if (((Boolean)ignored2.invoke((Object)(end22 - 1))).booleanValue()) {
                skipped = 1;
                --end22;
            }
            if (skipped != 0) continue;
        }
        skipped = start1;
        int end$iv2 = end12;
        boolean $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv < end$iv && ((Boolean)ignored1.invoke((Object)(end$iv - 1))).booleanValue(); --end$iv) {
        }
        end12 = end$iv;
        start$iv = start2;
        end$iv2 = end22;
        $i$f$trimEnd = false;
        for (end$iv = end$iv2; start$iv < end$iv && ((Boolean)ignored2.invoke((Object)(end$iv - 1))).booleanValue(); --end$iv) {
        }
        end22 = end$iv;
        return new IntPair(end12, end22);
    }

    public static final boolean isSpaceEnterOrTab(char $this$isSpaceEnterOrTab) {
        return $this$isSpaceEnterOrTab == '\n' || $this$isSpaceEnterOrTab == '\t' || $this$isSpaceEnterOrTab == ' ';
    }

    private static final boolean trim$lambda$0(CharSequence $text, int index) {
        return TrimUtil.isSpaceEnterOrTab($text.charAt(index));
    }

    private static final boolean trimExpandRange$lambda$0(Function2 $equals, int index1, int index2) {
        return (Boolean)$equals.invoke((Object)index1, (Object)index2);
    }

    private static final boolean trimExpandRange$lambda$1(Function1 $ignored1, int index) {
        return (Boolean)$ignored1.invoke((Object)index);
    }

    private static final boolean trimExpandRange$lambda$2(Function1 $ignored2, int index) {
        return (Boolean)$ignored2.invoke((Object)index);
    }
}

