/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.requests;

import com.google.protobuf.DescriptorProtos;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.grpc.requests.ExpirableFutureTaskCache;
import com.intellij.httpClient.grpc.requests.GrpcReflectionServiceKt;
import com.intellij.httpClient.grpc.requests.GrpcRequestManager;
import com.intellij.httpClient.grpc.requests.MethodsByServiceKey;
import com.intellij.httpClient.grpc.requests.ServicesKey;
import com.intellij.httpClient.grpc.requests.execution.GrpcReflectionResponse;
import com.intellij.httpClient.grpc.requests.execution.KnownReflectionRequestsKt;
import com.intellij.httpClient.grpc.requests.execution.LazyParseableReflectionResponse;
import com.intellij.httpClient.grpc.restClient.execution.GrpcReflectionWrappingRequest;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00122\u0006\u0010\u000b\u001a\u00020\bJ\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00122\u0006\u0010\u000b\u001a\u00020\u000fJ\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\f0\u00122\u0006\u0010\u000b\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0006\u001a#\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u000e\u001a#\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/grpc/requests/GrpcReflectionService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "expirableServicesCache", "Lcom/intellij/httpClient/grpc/requests/ExpirableFutureTaskCache;", "Lcom/intellij/httpClient/grpc/requests/ServicesKey;", "Lkotlin/ParameterName;", "name", "key", "", "", "expirableDescriptorsCache", "Lcom/intellij/httpClient/grpc/requests/MethodsByServiceKey;", "Lcom/google/protobuf/DescriptorProtos$FileDescriptorProto;", "retrieveServicesFuture", "Ljava/util/concurrent/CompletableFuture;", "retrieveMethodsForServiceFuture", "retrieveAllProtoDescriptorsFuture", "retrieveServices", "retrieveAllProtoDescriptors", "Companion", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcReflectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcReflectionService.kt\ncom/intellij/httpClient/grpc/requests/GrpcReflectionService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n30#2,2:86\n30#2,2:92\n18#3:88\n18#3:94\n777#4:89\n873#4,2:90\n1586#4:95\n1661#4,3:96\n*S KotlinDebug\n*F\n+ 1 GrpcReflectionService.kt\ncom/intellij/httpClient/grpc/requests/GrpcReflectionService\n*L\n43#1:86,2\n59#1:92,2\n51#1:88\n67#1:94\n55#1:89\n55#1:90,2\n34#1:95\n34#1:96,3\n*E\n"})
public final class GrpcReflectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ExpirableFutureTaskCache<ServicesKey, List<String>> expirableServicesCache;
    @NotNull
    private final ExpirableFutureTaskCache<MethodsByServiceKey, List<DescriptorProtos.FileDescriptorProto>> expirableDescriptorsCache;

    public GrpcReflectionService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.expirableServicesCache = new ExpirableFutureTaskCache(0L, 0L, (Function1)new Function1<ServicesKey, List<? extends String>>((Object)this){

            public final List<String> invoke(ServicesKey p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcReflectionService.access$retrieveServices((GrpcReflectionService)this.receiver, p0);
            }
        }, 3, null);
        this.expirableDescriptorsCache = new ExpirableFutureTaskCache(0L, 0L, (Function1)new Function1<MethodsByServiceKey, List<? extends DescriptorProtos.FileDescriptorProto>>((Object)this){

            public final List<DescriptorProtos.FileDescriptorProto> invoke(MethodsByServiceKey p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcReflectionService.access$retrieveAllProtoDescriptors((GrpcReflectionService)this.receiver, p0);
            }
        }, 3, null);
    }

    @NotNull
    public final CompletableFuture<List<String>> retrieveServicesFuture(@NotNull ServicesKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.expirableServicesCache.get(key);
    }

    @NotNull
    public final CompletableFuture<List<String>> retrieveMethodsForServiceFuture(@NotNull MethodsByServiceKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CompletionStage completionStage = this.retrieveAllProtoDescriptorsFuture(key).handle((arg_0, arg_1) -> GrpcReflectionService.retrieveMethodsForServiceFuture$lambda$1((arg_0, arg_1) -> GrpcReflectionService.retrieveMethodsForServiceFuture$lambda$0(key, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"handle(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<List<DescriptorProtos.FileDescriptorProto>> retrieveAllProtoDescriptorsFuture(@NotNull MethodsByServiceKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.expirableDescriptorsCache.get(key);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> retrieveServices(ServicesKey key) {
        void $this$filterTo$iv$iv;
        GrpcReflectionResponse grpcReflectionResponse;
        List<String> list;
        Object $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service22 = false;
        Class<GrpcRequestManager> serviceClass$iv22 = GrpcRequestManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv22);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv22);
        }
        $this$service$iv = key.getScheme();
        String $i$f$service22 = key.getHost();
        int serviceClass$iv22 = key.getPort();
        ServerReflectionRequest serverReflectionRequest = KnownReflectionRequestsKt.listServicesRequest();
        Object $this$asSafely$iv = ((GrpcRequestManager)object).executeCallSynchronouslySafe(new GrpcReflectionWrappingRequest($i$f$service22, serviceClass$iv22, (String)$this$service$iv, serverReflectionRequest), true);
        boolean $i$f$asSafely22 = false;
        Object object2 = $this$asSafely$iv;
        if (!(object2 instanceof GrpcReflectionResponse)) {
            object2 = null;
        }
        if ((list = (grpcReflectionResponse = (GrpcReflectionResponse)object2) != null && ($this$asSafely$iv = grpcReflectionResponse.getLazyParseableReflectionResponse()) != null ? ((LazyParseableReflectionResponse)$this$asSafely$iv).allServicesList() : null) == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable $i$f$asSafely22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"grpc.reflection.v1alpha.ServerReflection"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<DescriptorProtos.FileDescriptorProto> retrieveAllProtoDescriptors(MethodsByServiceKey key) {
        LazyParseableReflectionResponse lazyParseableReflectionResponse;
        GrpcReflectionResponse grpcReflectionResponse;
        List<DescriptorProtos.FileDescriptorProto> list;
        Object $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service22 = false;
        Class<GrpcRequestManager> serviceClass$iv = GrpcRequestManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        $this$service$iv = key.getScheme();
        String $i$f$service22 = key.getHost();
        int n = key.getPort();
        ServerReflectionRequest serverReflectionRequest = KnownReflectionRequestsKt.findProtoDescriptorsWithSymbolRequest(key.getServiceFqn());
        CommonClientResponse $this$asSafely$iv = ((GrpcRequestManager)object).executeCallSynchronouslySafe(new GrpcReflectionWrappingRequest($i$f$service22, n, (String)$this$service$iv, serverReflectionRequest), true);
        boolean $i$f$asSafely = false;
        CommonClientResponse commonClientResponse = $this$asSafely$iv;
        if (!(commonClientResponse instanceof GrpcReflectionResponse)) {
            commonClientResponse = null;
        }
        if ((list = (grpcReflectionResponse = (GrpcReflectionResponse)commonClientResponse) != null && (lazyParseableReflectionResponse = grpcReflectionResponse.getLazyParseableReflectionResponse()) != null ? lazyParseableReflectionResponse.allProtoDescriptors() : null) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List retrieveMethodsForServiceFuture$lambda$0(MethodsByServiceKey $key, List descriptors, Throwable throwable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)descriptors);
        Iterable $this$map$iv = GrpcReflectionServiceKt.mapMethodsByServices(descriptors, $key);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DescriptorProtos.MethodDescriptorProto methodDescriptorProto = (DescriptorProtos.MethodDescriptorProto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    private static final List retrieveMethodsForServiceFuture$lambda$1(Function2 $tmp0, Object p0, Throwable p1) {
        return (List)$tmp0.invoke(p0, (Object)p1);
    }

    public static final /* synthetic */ List access$retrieveServices(GrpcReflectionService $this, ServicesKey key) {
        return $this.retrieveServices(key);
    }

    public static final /* synthetic */ List access$retrieveAllProtoDescriptors(GrpcReflectionService $this, MethodsByServiceKey key) {
        return $this.retrieveAllProtoDescriptors(key);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/grpc/requests/GrpcReflectionService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/httpClient/grpc/requests/GrpcReflectionService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.httpClient.grpc"})
    @SourceDebugExtension(value={"SMAP\nGrpcReflectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcReflectionService.kt\ncom/intellij/httpClient/grpc/requests/GrpcReflectionService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,85:1\n30#2,2:86\n*S KotlinDebug\n*F\n+ 1 GrpcReflectionService.kt\ncom/intellij/httpClient/grpc/requests/GrpcReflectionService$Companion\n*L\n21#1:86,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GrpcReflectionService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GrpcReflectionService> serviceClass$iv = GrpcReflectionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GrpcReflectionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

