/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.generator.gradle;

import com.jetbrains.rd.generator.gradle.GradleGenerationSpec;
import com.jetbrains.rd.generator.gradle.RdGenExtension;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J#\u0010\r\u001a\u00020)2\u0016\u0010*\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010+\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0002J\u001f\u00100\u001a\u00020\u001c2\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020)02\u00a2\u0006\u0002\b3J\u0014\u00100\u001a\u00020\u001c2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c04J.\u00105\u001a\b\u0012\u0004\u0012\u00020/062\u0006\u00107\u001a\u00020\u00002\u0016\u00108\u001a\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t02H\u0002J3\u00109\u001a\u0004\u0018\u0001H:\"\u0004\b\u0000\u0010:2\b\u0010;\u001a\u0004\u0018\u00010\u00002\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H:02H\u0002\u00a2\u0006\u0002\u0010<J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0000J\u0018\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\b\u0010?\u001a\u0004\u0018\u00010/R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u001c\u0010#\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0018\"\u0004\b%\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b'\u0010\u0012\"\u0004\b(\u0010\u0014\u00a8\u0006@"}, d2={"Lcom/jetbrains/rd/generator/gradle/RdGenExtension;", "", "task", "Lorg/gradle/api/Task;", "(Lorg/gradle/api/Task;)V", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "classPathEntries", "", "", "getClassPathEntries", "()Ljava/util/List;", "classpath", "", "clearOutput", "", "getClearOutput", "()Ljava/lang/Boolean;", "setClearOutput", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "filter", "getFilter", "()Ljava/lang/String;", "setFilter", "(Ljava/lang/String;)V", "generators", "Lcom/jetbrains/rd/generator/gradle/GradleGenerationSpec;", "hasGenerators", "getHasGenerators", "()Z", "lineNumbersInComments", "getLineNumbersInComments", "setLineNumbersInComments", "packages", "getPackages", "setPackages", "verbose", "getVerbose", "setVerbose", "", "paths", "", "([Ljava/lang/Object;)V", "fillGeneratorsFile", "file", "Ljava/io/File;", "generator", "closure", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Lgroovy/lang/Closure;", "mergeFiles", "", "global", "getter", "mergeObject", "T", "defaults", "(Lcom/jetbrains/rd/generator/gradle/RdGenExtension;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "mergeWith", "toArguments", "generatorsFile", "rd-gen_gradlePlugin"})
public class RdGenExtension {
    @NotNull
    private final Project project;
    @Nullable
    private Boolean clearOutput;
    @Nullable
    private String packages;
    @Nullable
    private String filter;
    @Nullable
    private Boolean verbose;
    @Nullable
    private Boolean lineNumbersInComments;
    @NotNull
    private final List<GradleGenerationSpec> generators;
    @NotNull
    private final List<Object> classpath;

    public RdGenExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.generators = new ArrayList();
        this.classpath = new ArrayList();
    }

    public RdGenExtension(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Project project = task.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.project");
        this(project);
    }

    @NotNull
    public final RdGenExtension mergeWith(@NotNull RdGenExtension defaults) {
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        RdGenExtension result = new RdGenExtension(this.project);
        Object[] objectArray = new Object[]{this.mergeFiles(defaults, mergeWith.1.INSTANCE)};
        result.classpath(objectArray);
        result.packages = (String)this.mergeObject(defaults, mergeWith.2.INSTANCE);
        result.filter = (String)this.mergeObject(defaults, mergeWith.3.INSTANCE);
        result.verbose = (Boolean)this.mergeObject(defaults, mergeWith.4.INSTANCE);
        result.lineNumbersInComments = (Boolean)this.mergeObject(defaults, mergeWith.5.INSTANCE);
        result.clearOutput = (Boolean)this.mergeObject(defaults, mergeWith.6.INSTANCE);
        List list = (List)this.mergeObject(defaults, mergeWith.7.INSTANCE);
        result.generators.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        return result;
    }

    private final <T> T mergeObject(RdGenExtension defaults, Function1<? super RdGenExtension, ? extends T> getter) {
        Object value = getter.invoke((Object)this);
        if (defaults == null) {
            return (T)value;
        }
        if (value == null) {
            return (T)getter.invoke((Object)defaults);
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return (T)getter.invoke((Object)defaults);
        }
        return (T)(value instanceof Map && ((Map)value).isEmpty() ? getter.invoke((Object)defaults) : value);
    }

    private final Set<File> mergeFiles(RdGenExtension global, Function1<? super RdGenExtension, ? extends List<?>> getter) {
        List<?> list = this.mergeObject(global, getter);
        Intrinsics.checkNotNull(list);
        List<?> mergedFiles = list;
        Object[] objectArray = new Object[]{mergedFiles};
        Set set = this.project.files(objectArray).getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.files(mergedFiles).files");
        return set;
    }

    @NotNull
    public final List<String> toArguments(@Nullable File generatorsFile) {
        boolean generateLineNumbersInComments;
        ArrayList<String> arguments = new ArrayList<String>();
        if (CollectionsKt.any((Iterable)this.getClassPathEntries())) {
            arguments.add("-c");
            arguments.add(String.join((CharSequence)System.getProperty("path.separator"), (Iterable<? extends CharSequence>)this.getClassPathEntries()));
        }
        if (Intrinsics.areEqual((Object)this.clearOutput, (Object)true)) {
            arguments.add("-x");
        }
        if (this.packages != null) {
            arguments.add("-p");
            arguments.add(this.packages);
        }
        if (this.filter != null) {
            arguments.add("--filter");
            arguments.add(this.filter);
        }
        if (Intrinsics.areEqual((Object)this.verbose, (Object)true)) {
            arguments.add("-v");
        }
        Boolean bl = this.lineNumbersInComments;
        boolean bl2 = generateLineNumbersInComments = bl != null ? bl : true;
        if (!generateLineNumbersInComments) {
            arguments.add("--no-line-numbers");
        }
        if (!((Collection)this.generators).isEmpty()) {
            if (generatorsFile == null) {
                throw new IllegalStateException("generatorsFile should be passed if generators collection is not empty".toString());
            }
            this.fillGeneratorsFile(generatorsFile);
            arguments.add("-g");
            arguments.add(generatorsFile.getPath());
        }
        return arguments;
    }

    @Nullable
    public final Boolean getClearOutput() {
        return this.clearOutput;
    }

    public final void setClearOutput(@Nullable Boolean bl) {
        this.clearOutput = bl;
    }

    @Nullable
    public final String getPackages() {
        return this.packages;
    }

    public final void setPackages(@Nullable String string2) {
        this.packages = string2;
    }

    @Nullable
    public final String getFilter() {
        return this.filter;
    }

    public final void setFilter(@Nullable String string2) {
        this.filter = string2;
    }

    @Nullable
    public final Boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(@Nullable Boolean bl) {
        this.verbose = bl;
    }

    @Nullable
    public final Boolean getLineNumbersInComments() {
        return this.lineNumbersInComments;
    }

    public final void setLineNumbersInComments(@Nullable Boolean bl) {
        this.lineNumbersInComments = bl;
    }

    public final boolean getHasGenerators() {
        return !((Collection)this.generators).isEmpty();
    }

    @NotNull
    public final GradleGenerationSpec generator(@NotNull Closure<GradleGenerationSpec> closure) {
        GradleGenerationSpec gradleGenerationSpec;
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        GradleGenerationSpec $this$generator_u24lambda_u240 = gradleGenerationSpec = new GradleGenerationSpec();
        boolean bl = false;
        this.project.configure((Object)$this$generator_u24lambda_u240, closure);
        this.generators.add($this$generator_u24lambda_u240);
        return gradleGenerationSpec;
    }

    @NotNull
    public final GradleGenerationSpec generator(@NotNull Function1<? super GradleGenerationSpec, Unit> closure) {
        GradleGenerationSpec gradleGenerationSpec;
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        GradleGenerationSpec $this$generator_u24lambda_u241 = gradleGenerationSpec = new GradleGenerationSpec();
        boolean bl = false;
        closure.invoke((Object)$this$generator_u24lambda_u241);
        this.generators.add($this$generator_u24lambda_u241);
        return gradleGenerationSpec;
    }

    public final void classpath(Object ... paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        CollectionsKt.addAll((Collection)this.classpath, (Object[])paths);
    }

    private final List<String> getClassPathEntries() {
        Object[] objectArray = new Object[]{this.classpath};
        List<String> list = this.project.files(objectArray).getFiles().stream().map(arg_0 -> RdGenExtension._get_classPathEntries_$lambda$2(classPathEntries.1.INSTANCE, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"project.files(classpath)\u2026lect(Collectors.toList())");
        return list;
    }

    private final void fillGeneratorsFile(File file2) {
        StringBuilder sb = new StringBuilder();
        for (GradleGenerationSpec generator : this.generators) {
            sb.append(generator.toString());
            sb.append("\n");
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        FilesKt.writeText$default((File)file2, (String)string2, null, (int)2, null);
    }

    private static final String _get_classPathEntries_$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getClasspath$p(RdGenExtension $this) {
        return $this.classpath;
    }

    public static final /* synthetic */ List access$getGenerators$p(RdGenExtension $this) {
        return $this.generators;
    }
}

