/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.hints.BooleanHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.ClassHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.DoubleHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.EncodingHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.EnumHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.FloatHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.microservices.jvm.config.hints.HintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.HintReferenceProviderBase;
import com.intellij.microservices.jvm.config.hints.IntegerHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.LocaleHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.LoggerNameReferenceProvider;
import com.intellij.microservices.jvm.config.hints.LongHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.ShortHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.StaticValuesHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.defaultHint.DefaultHintReferenceProviderKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.BeanReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ConfigReferenceProvider;
import com.intellij.spring.boot.application.config.hints.DataSizeReferenceProvider;
import com.intellij.spring.boot.application.config.hints.DurationReferenceProvider;
import com.intellij.spring.boot.application.config.hints.LoggingGroupReferenceProvider;
import com.intellij.spring.boot.application.config.hints.RegExReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ResourceReferenceProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootCustomHintReferenceProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryInfo;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryKey;
import com.intellij.spring.boot.application.config.hints.SpringSpiClassesProvider;
import com.intellij.spring.boot.application.config.hints.ValueHintReferenceProvider;
import com.intellij.spring.boot.application.metadata.SpringBootValueProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.converters.PatternFileReferenceSet;
import com.intellij.spring.profiles.SpringProfilePsiReference;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xml.util.documentation.MimeTypeDictionary;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBootHintReferencesProviderImpl
extends SpringBootHintReferencesProvider
implements Disposable {
    private static final String STATIC = "static";
    private static final String ENUM_VALUES = "enumValues";
    private static final String REGEX = "regex";
    private static final String RESOURCE = "resource";
    private static final String PATH_PATTERN = "pathPattern";
    private static final String CONTENT_TYPE = "contentType";
    private static final String SPRING_PROFILE_NAME = SpringBootValueProvider.SPRING_PROFILE_NAME.getId();
    private static final String SPRING_PROFILE_EXPRESSION = "spring-profile-expression";
    private static final String SPRING_SPI_CLASSES = "springSpiClasses";
    private static final String CONFIG = "config";
    private static final String CLASS_REFERENCE_VALUE_SEPARATOR = ";";
    private static final ExtensionPointName<SpringBootCustomHintReferenceProvider> CUSTOM_HINT_REFERENCE_PROVIDER_EP_NAME = new ExtensionPointName("com.intellij.spring.boot.customHintReferenceProvider");
    private final HintReferenceProvider mySpringProfileNameHintReferenceProvider = new HintReferenceProviderBase(this){

        protected boolean canProcess(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (textRanges == null) {
                1.$$$reportNull$$$0(1);
            }
            if (context == null) {
                1.$$$reportNull$$$0(2);
            }
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)element) != null;
        }

        @NotNull
        protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
            String elementText = element.getText();
            String tokenText = textRange.substring(elementText);
            if (StringUtil.startsWithChar((CharSequence)tokenText, (char)'!')) {
                textRange = textRange.shiftRight(1).grown(-1);
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            assert (module != null);
            return new SpringProfilePsiReference(element, textRange, module, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textRanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1";
            objectArray[2] = "canProcess";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final HintReferenceProvider myDummyProvider = new HintReferenceProvider(this){

        public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if (textRanges == null) {
                2.$$$reportNull$$$0(1);
            }
            if (context == null) {
                2.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textRanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$2";
            objectArray[2] = "getReferences";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final StaticValuesHintReferenceProvider myLocaleProvider = new LocaleHintReferenceProvider();
    private final StaticValuesHintReferenceProvider myContentTypeProvider = new StaticValuesHintReferenceProvider(true, true, null, MimeTypeDictionary.HTML_CONTENT_TYPES);
    private final EncodingHintReferenceProvider myEncodingProvider = new EncodingHintReferenceProvider();
    private final Map<String, HintReferenceProvider> myExplicitKeyProviders = new HashMap<String, HintReferenceProvider>();
    private final Map<String, String> myExplicitMappings = new HashMap<String, String>();
    private final Map<String, HintReferenceProvider> myExplicitProviders = new HashMap<String, HintReferenceProvider>();
    private final Map<String, HintReferenceProvider> myBuiltinProviders = new HashMap<String, HintReferenceProvider>();
    private final Set<String> myOverrideKeys = new HashSet<String>();
    private final Set<String> myForcedKeys = new HashSet<String>();
    private final Map<String, HintReferenceProvider> myByTypeProviders = Map.ofEntries(Map.entry("java.lang.Boolean", new BooleanHintReferenceProvider()), Map.entry("java.lang.Integer", new IntegerHintReferenceProvider()), Map.entry("java.lang.Long", new LongHintReferenceProvider()), Map.entry("java.lang.Short", new ShortHintReferenceProvider()), Map.entry("java.lang.Float", new FloatHintReferenceProvider()), Map.entry("java.lang.Double", new DoubleHintReferenceProvider()), Map.entry("java.nio.charset.Charset", this.myEncodingProvider), Map.entry("org.springframework.util.MimeType", this.myContentTypeProvider), Map.entry("org.springframework.http.MediaType", this.myContentTypeProvider), Map.entry("org.springframework.core.io.Resource", new ResourceReferenceProvider()), Map.entry("java.util.Locale", this.myLocaleProvider), Map.entry("java.time.Duration", new DurationReferenceProvider()), Map.entry("org.springframework.util.unit.DataSize", new DataSizeReferenceProvider()));

    private SpringBootHintReferencesProviderImpl() {
        this.myBuiltinProviders.put(SPRING_PROFILE_NAME, this.mySpringProfileNameHintReferenceProvider);
        this.myBuiltinProviders.put(SPRING_PROFILE_EXPRESSION, new HintReferenceProvider(this){

            public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
                Module module;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (textRanges == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
                SmartList result = new SmartList();
                String elementText = element.getText();
                int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
                for (TextRange textRange : textRanges) {
                    String profile = textRange.substring(elementText);
                    try {
                        SpringProfilesFactory.getInstance().parseProfileExpressions((Collection)new SmartList((Object)profile));
                        Object[] references = SpringProfilesFactory.getInstance().getProfilesReferences(module, element, profile, textRange.getStartOffset() - offset, "()&|", false);
                        ContainerUtil.addAll((Collection)result, (Object[])references);
                    }
                    catch (SpringProfilesFactory.MalformedProfileExpressionException e) {
                        SpringProfilePsiReference delegate = new SpringProfilePsiReference(element, textRange, module, false);
                        result.add(new MalformedProfileExpressionReference(element, textRange, e.getMessage(), (PsiReference)delegate));
                    }
                }
                return result.toArray(PsiReference.EMPTY_ARRAY);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "textRanges";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$3";
                objectArray[2] = "getReferences";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myBuiltinProviders.put(RESOURCE, new ResourceReferenceProvider());
        this.myBuiltinProviders.put(PATH_PATTERN, new HintReferenceProvider(this){

            public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (textRanges == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(2);
                }
                String valueText = element.getText();
                Object[] allReferences = PsiReference.EMPTY_ARRAY;
                for (TextRange range : textRanges) {
                    Object[] references = new PatternFileReferenceSet(range.substring(valueText), element, range.getStartOffset(), true).getAllReferences();
                    allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])references);
                }
                return allReferences;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "textRanges";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$4";
                objectArray[2] = "getReferences";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myBuiltinProviders.put(CONTENT_TYPE, (HintReferenceProvider)this.myContentTypeProvider);
        this.myBuiltinProviders.put(CONFIG, new ConfigReferenceProvider());
        this.loadExplicitMappings();
        CUSTOM_HINT_REFERENCE_PROVIDER_EP_NAME.addChangeListener(() -> {
            this.myOverrideKeys.clear();
            this.myExplicitProviders.clear();
            this.myExplicitMappings.clear();
            this.loadExplicitMappings();
        }, (Disposable)this);
    }

    private void loadExplicitMappings() {
        URL url = SpringBootHintReferencesProviderImpl.class.getResource("spring-boot-hint-registry.xml");
        SpringBootHintRegistryInfo info = (SpringBootHintRegistryInfo)XmlSerializer.deserialize((URL)url, SpringBootHintRegistryInfo.class);
        HashMap<String, SpringBootCustomHintReferenceProvider> customProviders = new HashMap<String, SpringBootCustomHintReferenceProvider>();
        for (SpringBootCustomHintReferenceProvider customProvider : CUSTOM_HINT_REFERENCE_PROVIDER_EP_NAME.getExtensionList()) {
            customProviders.put(customProvider.getId(), customProvider);
        }
        for (SpringBootHintRegistryKey key : Objects.requireNonNull(info).myKeys) {
            Map<String, HintReferenceProvider> explicitProviders;
            String providerId = key.myProvider;
            if (key.myOverride) {
                this.myOverrideKeys.add(key.myId);
            }
            Map<String, HintReferenceProvider> map = explicitProviders = key.myKeyHint ? this.myExplicitKeyProviders : this.myExplicitProviders;
            if (providerId.equals(STATIC) || providerId.equals(ENUM_VALUES)) {
                explicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createStaticOrEnumReferenceProvider(key));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.SPRING_BEAN_REFERENCE.getId())) {
                explicitProviders.put(key.myId, new BeanReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.CLASS_REFERENCE.getId())) {
                explicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createClassReferenceProvider(key.myValue, key.myAllowOtherValues, true));
                continue;
            }
            if (providerId.equals(REGEX)) {
                explicitProviders.put(key.myId, (HintReferenceProvider)new RegExReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(RESOURCE) || providerId.equals(PATH_PATTERN) || providerId.equals(SPRING_PROFILE_NAME) || providerId.equals(SPRING_PROFILE_EXPRESSION) || providerId.equals(CONTENT_TYPE)) {
                if (key.myKeyHint) {
                    throw new IllegalArgumentException(providerId + " used for key hint");
                }
                this.myExplicitMappings.put(key.myId, providerId);
                continue;
            }
            if (providerId.equals(CONFIG)) {
                if (key.myKeyHint) {
                    throw new IllegalArgumentException(providerId + " used for key hint");
                }
                this.myForcedKeys.add(key.myId);
                this.myExplicitMappings.put(key.myId, providerId);
                continue;
            }
            if (providerId.equals(SPRING_SPI_CLASSES)) {
                List spiKeys = StringUtil.split((String)key.myValue, (String)CLASS_REFERENCE_VALUE_SEPARATOR);
                String spiKey = (String)spiKeys.get(0);
                String importKey = spiKeys.size() == 2 ? (String)spiKeys.get(1) : null;
                explicitProviders.put(key.myId, (HintReferenceProvider)new SpringSpiClassesProvider(spiKey, importKey));
                continue;
            }
            SpringBootCustomHintReferenceProvider customProvider = (SpringBootCustomHintReferenceProvider)customProviders.get(providerId);
            if (customProvider != null) {
                explicitProviders.put(key.myId, (HintReferenceProvider)customProvider);
                continue;
            }
            if (key.myOptional) {
                if (!key.myOverride) continue;
                this.myOverrideKeys.remove(key.myId);
                continue;
            }
            throw new IllegalArgumentException(providerId);
        }
    }

    public PsiReference @NotNull [] getKeyReferences(MetaConfigKey configKey, PsiElement keyPsiElement, TextRange textRange, ProcessingContext context) {
        if (configKey.getKeyItemHint() != MetaConfigKey.ItemHint.NONE) {
            context.put(HINT_REFERENCES_CONFIG_KEY, (Object)configKey);
            return this.getItemHintReferences(configKey, ItemHintType.KEY, keyPsiElement, Collections.singletonList(textRange), context);
        }
        HintReferenceProvider explicitProvider = this.myExplicitKeyProviders.get(configKey.getName());
        if (explicitProvider != null) {
            PsiReference[] psiReferenceArray = explicitProvider.getReferences(keyPsiElement, Collections.singletonList(textRange), context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public PsiReference @NotNull [] getValueReferences(Module module, MetaConfigKey configKey, @Nullable PsiElement keyPsiElement, PsiElement valuePsiElement, List<TextRange> valueTextRanges, ProcessingContext context) {
        context.put(HINT_REFERENCES_CONFIG_KEY, (Object)configKey);
        if (SpringBootLibraryUtil.isBelowVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            PsiReference[] psiReferenceArray = this.getFallbackProvider(configKey).getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (configKey.getItemHint() != MetaConfigKey.ItemHint.NONE) {
            return this.getItemHintReferences(configKey, ItemHintType.VALUE, valuePsiElement, valueTextRanges, context);
        }
        HintReferenceProvider byTypeOrExplicitProvider = this.getByTypeOrExplicitProvider(configKey);
        if (byTypeOrExplicitProvider != this.myDummyProvider) {
            PsiReference[] psiReferenceArray = byTypeOrExplicitProvider.getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (keyPsiElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (!MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
            return SpringBootHintReferencesProviderImpl.getEraseOtherReferences(valuePsiElement);
        }
        HintReferenceProvider pojoReferenceProvider = this.getPojoValueProvider(keyPsiElement);
        if (pojoReferenceProvider != null) {
            PsiReference[] psiReferenceArray = pojoReferenceProvider.getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        return SpringBootHintReferencesProviderImpl.getEraseOtherReferences(valuePsiElement);
    }

    private static PsiReference @NotNull [] getEraseOtherReferences(PsiElement valuePsiElement) {
        String valueText;
        if (WebReference.isWebReferenceWorthy((PsiElement)valuePsiElement) && valuePsiElement.textContains(':') && GlobalPathReferenceProvider.isWebReferenceUrl((String)(valueText = ElementManipulators.getValueText((PsiElement)valuePsiElement)))) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{PsiReferenceBase.createSelfReference((PsiElement)valuePsiElement, (PsiElement)valuePsiElement)};
        if (psiReferenceArray == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    @Nullable
    private HintReferenceProvider getPojoValueProvider(@NotNull PsiElement keyPsiElement) {
        PsiReference lastReference;
        if (keyPsiElement == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(8);
        }
        if (!((lastReference = (PsiReference)ArrayUtil.getLastElement((Object[])keyPsiElement.getReferences())) instanceof ConfigKeyPathReference)) {
            return null;
        }
        return this.getByTypeProvider(((ConfigKeyPathReference)lastReference).getValueElementType());
    }

    @NotNull
    private HintReferenceProvider getByTypeOrExplicitProvider(MetaConfigKey configKey) {
        HintReferenceProvider explicitValuesProvider = this.getExplicitProvider(configKey, true);
        if (explicitValuesProvider != null) {
            HintReferenceProvider hintReferenceProvider = explicitValuesProvider;
            if (hintReferenceProvider == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(9);
            }
            return hintReferenceProvider;
        }
        HintReferenceProvider byTypeProvider = DefaultHintReferenceProviderKt.getDefaultValueDecorator((HintReferenceProvider)this.getByTypeProvider(configKey.getEffectiveValueElementType()), (String)configKey.getDefaultValue());
        if (byTypeProvider != null) {
            HintReferenceProvider hintReferenceProvider = byTypeProvider;
            if (hintReferenceProvider == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(10);
            }
            return hintReferenceProvider;
        }
        HintReferenceProvider hintReferenceProvider = this.myDummyProvider;
        if (hintReferenceProvider == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(11);
        }
        return hintReferenceProvider;
    }

    private PsiReference @NotNull [] getItemHintReferences(MetaConfigKey configKey, ItemHintType itemHintType, PsiElement element, List<TextRange> valueTextRanges, ProcessingContext context) {
        List<HintReferenceProvider> providers = this.getItemHintProviders(element, configKey, itemHintType, context);
        if (providers.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(12);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] allReferences = PsiReference.EMPTY_ARRAY;
        for (HintReferenceProvider provider : providers) {
            HintReferenceProvider providerWithDefault = DefaultHintReferenceProviderKt.getDefaultValueDecorator((HintReferenceProvider)provider, (String)configKey.getDefaultValue());
            if (providerWithDefault == null) continue;
            Object[] references = providerWithDefault.getReferences(element, valueTextRanges, context);
            allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])references);
        }
        if (allReferences == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(13);
        }
        return allReferences;
    }

    private List<HintReferenceProvider> getItemHintProviders(PsiElement element, MetaConfigKey configKey, ItemHintType itemHintType, ProcessingContext context) {
        List valueHints;
        MetaConfigKey.ItemHint keyOrValueHint = itemHintType == ItemHintType.VALUE ? configKey.getItemHint() : configKey.getKeyItemHint();
        List valueProviders = keyOrValueHint.getValueProviders();
        SmartList providers = new SmartList();
        if (this.myForcedKeys.contains(configKey.getName())) {
            ContainerUtil.addIfNotNull((Collection)providers, (Object)this.getExplicitProvider(configKey, true));
        }
        if (!(valueHints = keyOrValueHint.getValueHints()).isEmpty() && providers.isEmpty()) {
            boolean hasValueProviders;
            boolean bl = hasValueProviders = !valueProviders.isEmpty();
            if (StringUtil.isEmpty((String)((String)context.get(HintReferenceProvider.HINT_REFERENCES_MAP_KEY_PREFIX)))) {
                providers.add(new ValueHintReferenceProvider(configKey, valueHints, hasValueProviders));
            }
        }
        if (valueProviders.isEmpty()) {
            return providers;
        }
        SpringBootValueProvider valueProvider = null;
        Map parameters = null;
        for (MetaConfigKey.ValueProvider provider : valueProviders) {
            valueProvider = SpringBootValueProvider.findById((String)provider.getName());
            if (valueProvider == null) continue;
            parameters = provider.getParameters();
            break;
        }
        if (valueProvider == null) {
            return providers;
        }
        if (itemHintType == ItemHintType.VALUE) {
            if (valueProvider == SpringBootValueProvider.CLASS_REFERENCE) {
                target = (String)parameters.get("target");
                String concreteParameter = (String)parameters.get("concrete");
                Boolean concrete = concreteParameter == null ? Boolean.TRUE : Boolean.valueOf(concreteParameter);
                providers.add(SpringBootHintReferencesProviderImpl.createClassReferenceProvider(target, false, concrete));
            } else if (valueProvider == SpringBootValueProvider.SPRING_PROFILE_NAME) {
                providers.add(this.mySpringProfileNameHintReferenceProvider);
            } else if (valueProvider == SpringBootValueProvider.SPRING_BEAN_REFERENCE) {
                target = (String)parameters.get("target");
                providers.add(new BeanReferenceProvider(target));
            } else if (valueProvider == SpringBootValueProvider.HANDLE_AS && parameters.containsKey("target")) {
                target = (String)parameters.get("target");
                PsiType targetType = JavaPsiFacade.getElementFactory((Project)element.getProject()).createTypeFromText(target.replace('$', '.'), null);
                MetaConfigKey.AccessType targetAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)targetType);
                PsiType effectiveTargetType = targetAccessType.getEffectiveValueType(targetType);
                if ((targetAccessType == MetaConfigKey.AccessType.MAP || targetAccessType == MetaConfigKey.AccessType.ENUM_MAP) && effectiveTargetType != null) {
                    MetaConfigKey.AccessType valueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)effectiveTargetType);
                    effectiveTargetType = valueAccessType.getEffectiveValueType(effectiveTargetType);
                }
                if (effectiveTargetType != null) {
                    targetType = effectiveTargetType;
                }
                ContainerUtil.addIfNotNull((Collection)providers, (Object)this.getByTypeProvider(targetType));
            }
        }
        if (valueProvider == SpringBootValueProvider.LOGGER_NAME) {
            boolean resolveGroups;
            providers.add(new LoggerNameReferenceProvider());
            String group = (String)parameters.get("group");
            boolean bl = resolveGroups = group == null || Boolean.parseBoolean(group);
            if (resolveGroups) {
                providers.add(new LoggingGroupReferenceProvider());
            }
        }
        return providers;
    }

    @Nullable
    private HintReferenceProvider getByTypeProvider(@Nullable PsiType valueType) {
        if (valueType == null) {
            return null;
        }
        if (valueType instanceof PsiPrimitiveType) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)valueType;
            String fqn = primitiveType.getBoxedTypeName();
            return fqn == null ? null : this.myByTypeProviders.get(fqn);
        }
        PsiClass typeClass = SpringBootHintReferencesProviderImpl.getTypePsiClass(valueType);
        if (typeClass == null) {
            return null;
        }
        if (typeClass.isEnum()) {
            return new EnumHintReferenceProvider(typeClass);
        }
        String typeFqn = typeClass.getQualifiedName();
        if (typeFqn == null) {
            return null;
        }
        if ("java.lang.Class".equals(typeFqn)) {
            PsiType[] parameters = ((PsiClassType)valueType).getParameters();
            if (parameters.length != 1) {
                return SpringBootHintReferencesProviderImpl.createClassReferenceProvider(null, false, Boolean.TRUE);
            }
            PsiType typeParameter = parameters[0];
            if (!(typeParameter instanceof PsiWildcardType)) {
                return null;
            }
            PsiWildcardType parameter = (PsiWildcardType)typeParameter;
            return SpringBootHintReferencesProviderImpl.createClassReferenceProvider(parameter.getExtendsBound().getCanonicalText(), false, Boolean.TRUE);
        }
        return this.myByTypeProviders.get(typeFqn);
    }

    @Nullable
    private static PsiClass getTypePsiClass(PsiType psiType) {
        if (psiType instanceof PsiWildcardType) {
            PsiWildcardType psiWildcardType = (PsiWildcardType)psiType;
            return PsiTypesUtil.getPsiClass((PsiType)psiWildcardType.getBound());
        }
        return PsiTypesUtil.getPsiClass((PsiType)psiType);
    }

    @Nullable
    private HintReferenceProvider getExplicitProvider(MetaConfigKey configKey, boolean isSpringBoot13OrHigher) {
        String configKeyName = configKey.getName();
        if (isSpringBoot13OrHigher && !this.myOverrideKeys.contains(configKeyName)) {
            return null;
        }
        HintReferenceProvider byKey = this.myExplicitProviders.get(configKeyName);
        if (byKey != null) {
            return byKey;
        }
        String explicitProviderId = this.myExplicitMappings.get(configKeyName);
        if (explicitProviderId == null) {
            return null;
        }
        HintReferenceProvider provider = this.myBuiltinProviders.get(explicitProviderId);
        if (provider == null) {
            throw new IllegalStateException("provider id '" + explicitProviderId + "' not found, configured for " + String.valueOf(configKey));
        }
        return provider;
    }

    private HintReferenceProvider getFallbackProvider(MetaConfigKey configKey) {
        HintReferenceProvider byTypeProvider = this.getByTypeProvider(configKey.getEffectiveValueElementType());
        if (byTypeProvider != null) {
            return byTypeProvider;
        }
        HintReferenceProvider explicitReferenceProvider = this.getExplicitProvider(configKey, false);
        if (explicitReferenceProvider != null) {
            return explicitReferenceProvider;
        }
        String configKeyName = configKey.getName();
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"encoding") || StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"charset")) {
            return this.myEncodingProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"content-type") || StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"mime-types")) {
            return this.myContentTypeProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"locale")) {
            return this.myLocaleProvider;
        }
        return this.myDummyProvider;
    }

    public void dispose() {
    }

    private static HintReferenceProvider createStaticOrEnumReferenceProvider(SpringBootHintRegistryKey key) {
        String[] values = (String[])ContainerUtil.map2Array((Collection)StringUtil.split((String)key.myValue, (String)","), String.class, StringUtil::trim);
        return new StaticValuesHintReferenceProvider(key.myAllowOtherValues, key.myProvider.equals(ENUM_VALUES), null, values);
    }

    @NotNull
    private static HintReferenceProvider createClassReferenceProvider(String baseClass, boolean allowOtherValues, Boolean concrete) {
        if (baseClass != null && baseClass.contains(CLASS_REFERENCE_VALUE_SEPARATOR)) {
            return new ClassHintReferenceProvider(StringUtil.split((String)baseClass, (String)CLASS_REFERENCE_VALUE_SEPARATOR), allowOtherValues, concrete);
        }
        return new ClassHintReferenceProvider(baseClass, allowOtherValues, concrete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueReferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEraseOtherReferences";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getByTypeOrExplicitProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemHintReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPojoValueProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 8 -> new IllegalArgumentException(string);
        };
    }

    private static enum ItemHintType {
        VALUE,
        KEY;

    }

    private static final class MalformedProfileExpressionReference
    extends HintReferenceBase {
        private final String myMessage;
        private final PsiReference myDelegate;

        private MalformedProfileExpressionReference(@NotNull PsiElement element, TextRange rangeInElement, String message, PsiReference delegate) {
            if (element == null) {
                MalformedProfileExpressionReference.$$$reportNull$$$0(0);
            }
            super(element, rangeInElement);
            this.myMessage = message;
            this.myDelegate = delegate;
        }

        @Nullable
        protected PsiElement doResolve() {
            return null;
        }

        public Object @NotNull [] getHintVariants() {
            Object[] objectArray = this.myDelegate.getVariants();
            if (objectArray == null) {
                MalformedProfileExpressionReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = this.myMessage;
            if (string == null) {
                MalformedProfileExpressionReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$MalformedProfileExpressionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$MalformedProfileExpressionReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHintVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

