/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.structure;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.application.structure.SpringBootAppConfigurationLogicalModel;
import com.intellij.spring.boot.application.structure.SpringBootApplicationConfigurationsPresentationProvider;
import com.intellij.spring.boot.application.structure.SpringBootConfiguredPropertiesPresentationProvider;
import com.intellij.spring.boot.application.structure.SpringBootMetaKey;
import com.intellij.spring.boot.application.structure.SpringConfigurationLibGroup;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassCollector;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContextBase;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringBootApplicationConfigurationsPresentationProvider.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\b\u001a\u00020\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/boot/application/structure/SpringBootApplicationConfigurationsProvider;", "Lcom/intellij/ide/structureView/logical/ContainerElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/spring/boot/application/structure/SpringConfigurationLibGroup;", "<init>", "()V", "isApplicable", "", "parent", "getJarsWithConfiguredProperties", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getElements", "getAllElements", "Lcom/intellij/spring/boot/application/structure/SpringBootAppConfigurationLogicalModel;", "intellij.spring.boot.core"})
@SourceDebugExtension(value={"SMAP\nSpringBootApplicationConfigurationsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootApplicationConfigurationsProvider.kt\ncom/intellij/spring/boot/application/structure/SpringBootApplicationConfigurationsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,120:1\n1#2:121\n1#2:133\n1#2:150\n1#2:168\n1642#3,10:122\n1915#3:132\n1916#3:134\n1652#3:135\n777#3:136\n873#3,2:137\n1642#3,10:139\n1915#3:149\n1916#3:151\n1652#3:152\n1642#3,10:157\n1915#3:167\n1916#3:169\n1652#3:170\n1068#3:171\n1586#3:172\n1661#3,3:173\n129#4:153\n158#4,3:154\n*S KotlinDebug\n*F\n+ 1 SpringBootApplicationConfigurationsProvider.kt\ncom/intellij/spring/boot/application/structure/SpringBootApplicationConfigurationsProvider\n*L\n37#1:133\n38#1:150\n82#1:168\n37#1:122,10\n37#1:132\n37#1:134\n37#1:135\n38#1:136\n38#1:137,2\n38#1:139,10\n38#1:149\n38#1:151\n38#1:152\n82#1:157,10\n82#1:167\n82#1:169\n82#1:170\n83#1:171\n83#1:172\n83#1:173,3\n67#1:153\n67#1:154,3\n*E\n"})
public final class SpringBootApplicationConfigurationsProvider
implements ContainerElementsProvider<SpringBeanLogicalModel, SpringConfigurationLibGroup> {
    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        CommonSpringBean springBean = parent.getSpringBean();
        return springBean instanceof SpringConfiguration && SpringBootApplicationService.getInstance().isSpringApplication(((SpringConfiguration)springBean).getPsiElement());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<VirtualFile> getJarsWithConfiguredProperties(Module module) {
        List list;
        block6: {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterator iterator;
            Collection destination$iv$iv;
            block5: {
                block4: {
                    void $this$mapNotNullTo$iv$iv2;
                    Object object = module;
                    if (object == null) break block4;
                    MultiMap<PsiClass, SpringBootMetaKey> it = object;
                    boolean bl = false;
                    MultiMap<PsiClass, SpringBootMetaKey> multiMap = SpringBootConfiguredPropertiesPresentationProvider.Companion.collectAllConfigProperties((Module)it);
                    object = multiMap;
                    if (multiMap == null || (object = object.keySet()) == null) break block4;
                    Iterable $this$mapNotNull$iv2 = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv2;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    break block5;
                }
                list = null;
                break block6;
            }
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PsiClass it = (PsiClass)element$iv$iv;
                boolean bl2 = false;
                PsiFile psiFile = it.getContainingFile();
                if ((psiFile != null ? psiFile.getVirtualFile() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $i$f$mapNotNull = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(it.getFileSystem() instanceof JarFileSystem)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull2 = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl4 = false;
                VirtualFileSystem virtualFileSystem = it.getFileSystem();
                Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.JarFileSystem");
                if (((JarFileSystem)virtualFileSystem).getVirtualFileForJar(it) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        }
        List list2 = list;
        if (list == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SpringConfigurationLibGroup> getElements(@NotNull SpringBeanLogicalModel parent) {
        void $this$mapTo$iv$iv;
        Map virtualJarFile;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LinkedHashMap result = new LinkedHashMap();
        ArrayList<SpringBootAppConfigurationLogicalModel> nonInLibraries = new ArrayList<SpringBootAppConfigurationLogicalModel>();
        for (SpringBootAppConfigurationLogicalModel t : this.getAllElements(parent)) {
            PsiElement psiElement = t.getSpringBean().getIdentifyingPsiElement();
            VirtualFile vf = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null;
            if (vf == null) continue;
            if (vf.getFileSystem() instanceof JarFileSystem) {
                VirtualFileSystem virtualFileSystem = vf.getFileSystem();
                Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.JarFileSystem");
                JarFileSystem jarFileSystem = (JarFileSystem)virtualFileSystem;
                virtualJarFile = jarFileSystem.getVirtualFileForJar(vf);
                if (virtualJarFile == null) continue;
                if (!result.containsKey(virtualJarFile)) {
                    ((Map)result).put(virtualJarFile, (List)new ArrayList());
                }
                Object v = result.get(virtualJarFile);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.spring.boot.application.structure.SpringBootAppConfigurationLogicalModel>");
                TypeIntrinsics.asMutableList(v).add(t);
                continue;
            }
            nonInLibraries.add(t);
        }
        if (result.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Module module = parent.getSpringBean().getModule();
        List<VirtualFile> jarsWithConfiguredProperties = this.getJarsWithConfiguredProperties(module);
        Map $this$map$iv = result;
        boolean $i$f$map = false;
        virtualJarFile = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SpringConfigurationLibGroup((VirtualFile)it.getKey(), jarsWithConfiguredProperties.contains(it.getKey()), module, (List)it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SpringBootAppConfigurationLogicalModel> getAllElements(@NotNull SpringBeanLogicalModel parent) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        CommonSpringBean commonSpringBean = parent.getSpringBean();
        Intrinsics.checkNotNull((Object)commonSpringBean, (String)"null cannot be cast to non-null type com.intellij.spring.model.jam.stereotype.SpringConfiguration");
        SpringConfiguration configuration = (SpringConfiguration)commonSpringBean;
        PsiClass psiClass = configuration.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getPsiElement(...)");
        PsiClass psiClass2 = psiClass;
        EnableAutoConfiguration enableAutoConfiguration = (EnableAutoConfiguration)JamService.getJamService((Project)psiClass2.getProject()).getJamElement(EnableAutoConfiguration.JAM_KEY, (PsiElement)psiClass2);
        if (enableAutoConfiguration == null) {
            return CollectionsKt.emptyList();
        }
        EnableAutoConfiguration autoConfiguration = enableAutoConfiguration;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)configuration.getPsiElement()));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        ConditionalOnEvaluationContextBase context = new ConditionalOnEvaluationContextBase(psiClass2, module2, SetsKt.emptySet(), NotNullLazyValue.lazy(() -> SpringBootApplicationConfigurationsProvider.getAllElements$lambda$0(module2)), null);
        List<PsiClass> configurationClasses = AutoConfigClassCollector.collectConfigurationClasses(autoConfiguration, (ConditionalOnEvaluationContext)context);
        Intrinsics.checkNotNull(configurationClasses);
        Iterable $this$mapNotNull$iv = configurationClasses;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        SpringConfiguration springConfiguration = $this$forEach$iv$iv$iv.iterator();
        while (springConfiguration.hasNext()) {
            SpringConfiguration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = springConfiguration.next();
            boolean bl = false;
            PsiClass it = (PsiClass)element$iv$iv;
            boolean bl2 = false;
            if ((SpringConfiguration)JamService.getJamService((Project)it.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List configurations = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = configurations;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SpringConfiguration it = (SpringConfiguration)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getBeanName());
                it = (SpringConfiguration)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getBeanName())));
            }
        });
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            springConfiguration = (SpringConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SpringBootAppConfigurationLogicalModel(it.getIdentifyingPsiElement(), (SpringConfiguration)it, module2));
        }
        return (List)destination$iv$iv;
    }

    private static final List getAllElements$lambda$0(Module $module) {
        return SpringBootConfigurationFileService.getInstance().findConfigFiles($module, false);
    }
}

