/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.facet.FacetFinder;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.application.config.hints.ConfigReferenceProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigFileDetector;
import com.intellij.spring.boot.model.SpringBootConfigFileModificationTracker;
import com.intellij.spring.boot.model.SpringBootConfigImport;
import com.intellij.spring.boot.model.SpringBootConfigImportStatement;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.jam.stereotype.SpringJamPropertySource;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootConfigurationFileServiceImpl
implements SpringBootConfigurationFileService {
    public boolean isApplicationConfigurationFile(@NotNull PsiFile file) {
        if (file == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(0);
        }
        return this.getApplicationConfigurationFileIcon(file) != null || SpringBootConfigurationFileServiceImpl.isDetectedConfigFile(file) || this.isPropertySource(file) || SpringBootConfigurationFileServiceImpl.isMarkedAsConfigurationFile(file);
    }

    private static boolean isDetectedConfigFile(PsiFile file) {
        for (SpringBootConfigFileDetector detector : (SpringBootConfigFileDetector[])SpringBootConfigFileDetector.EP_NAME.getExtensions()) {
            if (!detector.isSpringBootConfigFile(file)) continue;
            return true;
        }
        return false;
    }

    private boolean isPropertySource(PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || module.isDisposed() || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
            return false;
        }
        return this.findPropertySources(module).contains(file.getVirtualFile());
    }

    private static boolean isMarkedAsConfigurationFile(PsiFile file) {
        return Boolean.TRUE == file.getUserData(CONFIGURATION_FILE_MARKER_KEY);
    }

    @Nullable
    public Icon getApplicationConfigurationFileIcon(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(1);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || module.isDisposed() || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
            return null;
        }
        boolean includeTestScope = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(virtualFile);
        for (SpringBootModelConfigFileNameContributor fileNameContributor : SpringBootModelConfigFileNameContributor.EP_NAME.getExtensionList()) {
            List<VirtualFile> files = this.findConfigFiles(module, includeTestScope, (Condition<? super SpringBootModelConfigFileNameContributor>)((Condition)contributor -> contributor == fileNameContributor && contributor.accept(module)));
            if (files.contains(virtualFile)) {
                return fileNameContributor.getFileIcon();
            }
            List<VirtualFile> imports = this.collectImports(module, files);
            if (!imports.contains(virtualFile)) continue;
            return fileNameContributor.getFileIcon();
        }
        return null;
    }

    public List<VirtualFile> findConfigFiles(@NotNull Module module, boolean includeTestScope) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(2);
        }
        return this.findConfigFiles(module, includeTestScope, (Condition<? super SpringBootModelConfigFileNameContributor>)((Condition)contributor -> contributor.accept(module)));
    }

    public List<VirtualFile> findConfigFiles(@NotNull Module module, @NotNull Set<String> profiles, boolean includeTestScope, boolean includeDefault) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(3);
        }
        if (profiles == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(4);
        }
        return SpringBootConfigurationFileServiceImpl.findConfigFiles(module, profiles, includeTestScope, includeDefault, (Condition<? super SpringBootModelConfigFileNameContributor>)((Condition)contributor -> contributor.accept(module)));
    }

    public List<VirtualFile> findConfigFiles(@NotNull Module module, boolean includeTestScope, @NotNull Condition<? super SpringBootModelConfigFileNameContributor> filter) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(6);
        }
        SmartList result = new SmartList();
        for (SpringBootModelConfigFileNameContributor fileNameContributor : SpringBootModelConfigFileNameContributor.EP_NAME.getExtensionList()) {
            if (!filter.value((Object)fileNameContributor)) continue;
            result.addAll(SpringBootConfigurationFileServiceImpl.findConfigFiles(module, includeTestScope, fileNameContributor));
        }
        return result;
    }

    public List<VirtualFile> findConfigFilesWithImports(@NotNull Module module, boolean includeTestScope) {
        List<VirtualFile> configFiles;
        List<VirtualFile> importedFiles;
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(7);
        }
        if ((importedFiles = this.collectImports(module, configFiles = this.findConfigFiles(module, includeTestScope))).isEmpty()) {
            return configFiles;
        }
        return ContainerUtil.concat(configFiles, importedFiles);
    }

    public List<VirtualFile> findPropertySources(@NotNull Module module) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(8);
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List propertySources = SpringCommonUtils.getPropertySources((Module)module);
            HashSet<VirtualFile> result = new HashSet<VirtualFile>();
            for (SpringJamPropertySource propertySource : propertySources) {
                for (PropertiesFile propertiesFile : propertySource.getPropertiesFiles()) {
                    result.add(propertiesFile.getVirtualFile());
                }
            }
            return CachedValueProvider.Result.create(result.isEmpty() ? Collections.emptyList() : new ArrayList(result), (Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies());
        });
    }

    private static List<VirtualFile> findConfigFiles(@NotNull Module module, boolean includeTestScope, @NotNull SpringBootModelConfigFileNameContributor fileNameContributor) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(9);
        }
        if (fileNameContributor == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(10);
        }
        return (List)((Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            Map map = FactoryMap.create(key -> SpringBootConfigurationFileServiceImpl.doFindConfigFile(module, key.isIncludeTestSources(), key.getNameContributor()));
            return CachedValueProvider.Result.create((Object)map, SpringBootConfigurationFileServiceImpl.getConfigFilesDependencies(module));
        })).get(new ConfigFileCacheKey(fileNameContributor, includeTestScope));
    }

    private static List<VirtualFile> findConfigFiles(@NotNull Module module, @NotNull Set<String> profiles, boolean includeTestScope, boolean includeDefault, @NotNull Condition<? super SpringBootModelConfigFileNameContributor> filter) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(11);
        }
        if (profiles == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(12);
        }
        if (filter == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(13);
        }
        SmartList result = new SmartList();
        for (SpringBootModelConfigFileNameContributor fileNameContributor : SpringBootModelConfigFileNameContributor.EP_NAME.getExtensionList()) {
            if (!filter.value((Object)fileNameContributor)) continue;
            result.addAll(SpringBootConfigurationFileServiceImpl.findConfigFiles(module, profiles, includeTestScope, includeDefault, fileNameContributor));
        }
        return result;
    }

    private static List<VirtualFile> findConfigFiles(@NotNull Module module, @NotNull Set<String> activeProfiles, boolean includeTestScope, boolean includeDefault, @NotNull SpringBootModelConfigFileNameContributor fileNameContributor) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(14);
        }
        if (activeProfiles == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(15);
        }
        if (fileNameContributor == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(16);
        }
        return (List)((Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            Map map = FactoryMap.create(key -> SpringBootConfigurationFileServiceImpl.doFindConfigFile(module, key.getActiveProfiles(), key.isIncludeTestSources(), key.isIncludeDefault(), key.getNameContributor()));
            return CachedValueProvider.Result.create((Object)map, SpringBootConfigurationFileServiceImpl.getConfigFilesDependencies(module));
        })).get(new ConfigFileCacheKey(fileNameContributor, activeProfiles, includeTestScope, includeDefault));
    }

    @NotNull
    private static List<Object> getConfigFilesDependencies(@NotNull Module module) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(17);
        }
        List dependencies = List.of(module.getProject().getService(SpringBootConfigFileModificationTracker.class), FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID), JavaLibraryModificationTracker.getInstance((Project)module.getProject()));
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet != null) {
            dependencies = ContainerUtil.append(dependencies, (Object[])new Object[]{springFacet.getConfiguration()});
        }
        List list = dependencies;
        if (list == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static List<VirtualFile> doFindConfigFile(@NotNull Module module, boolean includeTestScope, @NotNull SpringBootModelConfigFileNameContributor fileNameContributor) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(19);
        }
        if (fileNameContributor == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(20);
        }
        SmartList result = new SmartList();
        List fileTypes = ContainerUtil.map((Collection)SpringBootModelConfigFileContributor.EP_NAME.getExtensionList(), SpringBootModelConfigFileContributor::getFileType);
        String springConfigName = fileNameContributor.getSpringConfigName(module);
        SmartList profileConfigFiles = new SmartList();
        SmartList baseNameConfigFiles = new SmartList();
        List directories = SpringBootModelConfigFileContributor.getConfigFileDirectories((Module)module, (boolean)includeTestScope);
        for (VirtualFile directory : directories) {
            for (FileType fileType : fileTypes) {
                Pair allConfigs = SpringBootModelConfigFileContributor.findConfigFiles((VirtualFile)directory, (FileType)fileType, (String)springConfigName);
                profileConfigFiles.addAll((Collection)allConfigs.first);
                baseNameConfigFiles.addAll((Collection)allConfigs.second);
            }
        }
        result.addAll(profileConfigFiles);
        result.addAll(fileNameContributor.findCustomConfigFiles(module));
        result.addAll(baseNameConfigFiles);
        return result;
    }

    private static List<VirtualFile> doFindConfigFile(@NotNull Module module, @NotNull Set<String> profiles, boolean includeTestScope, boolean includeDefault, @NotNull SpringBootModelConfigFileNameContributor fileNameContributor) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(21);
        }
        if (profiles == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(22);
        }
        if (fileNameContributor == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(23);
        }
        List fileTypes = ContainerUtil.map((Collection)SpringBootModelConfigFileContributor.EP_NAME.getExtensionList(), SpringBootModelConfigFileContributor::getFileType);
        String springConfigName = fileNameContributor.getSpringConfigName(module);
        List directories = SpringBootModelConfigFileContributor.getConfigFileDirectories((Module)module, (boolean)includeTestScope);
        return ContainerUtil.flatMap((Iterable)directories, directory -> ContainerUtil.flatMap((Iterable)fileTypes, fileType -> SpringBootModelConfigFileContributor.findConfigFiles((VirtualFile)directory, (Set)profiles, (boolean)includeDefault, (FileType)fileType, (String)springConfigName)));
    }

    public List<VirtualFile> collectImports(@NotNull Module module, @NotNull List<VirtualFile> configFiles) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(24);
        }
        if (configFiles == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(25);
        }
        if (SpringBootConfigurationFileServiceImpl.getSpringConfigImportKey(module) == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ArrayDeque<VirtualFile> filesToProcess = new ArrayDeque<VirtualFile>(configFiles);
        while (!filesToProcess.isEmpty()) {
            VirtualFile configFile = (VirtualFile)filesToProcess.poll();
            List<SpringBootConfigImport> imports = this.getImports(module, configFile);
            for (SpringBootConfigImport configImport : imports) {
                VirtualFile importedFile = configImport.getVirtualFile();
                if (result.contains(importedFile) || configFiles.contains(importedFile)) continue;
                result.add(importedFile);
                filesToProcess.add(importedFile);
            }
        }
        return result;
    }

    public List<SpringBootConfigImport> getImports(@NotNull Module module, @NotNull VirtualFile virtualFile) {
        SpringBootModelConfigFileContributor contributor;
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(26);
        }
        if (virtualFile == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(27);
        }
        if ((contributor = SpringBootModelConfigFileContributor.getContributor((VirtualFile)virtualFile)) == null) {
            return Collections.emptyList();
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
        if (psiFile == null) {
            return Collections.emptyList();
        }
        return (List)((Map)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
            Map result = FactoryMap.create(m -> {
                if (!SpringBootLibraryUtil.isAtLeastVersion((Module)m, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_4_0)) {
                    return Collections.emptyList();
                }
                List imports = SpringBootConfigurationFileServiceImpl.doGetImports(m, psiFile, contributor);
                if (!imports.isEmpty()) {
                    List fileTypes = ContainerUtil.map((Collection)SpringBootModelConfigFileContributor.EP_NAME.getExtensionList(), SpringBootModelConfigFileContributor::getFileType);
                    imports = ContainerUtil.filter(imports, configImport -> fileTypes.contains(configImport.getVirtualFile().getFileType()));
                }
                return imports;
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{psiFile, psiFile.getProject().getService(SpringBootConfigFileModificationTracker.class), JavaLibraryModificationTracker.getInstance((Project)psiFile.getProject())});
        })).get(module);
    }

    private static List<SpringBootConfigImport> doGetImports(@NotNull Module module, @NotNull PsiFile psiFile, @NotNull SpringBootModelConfigFileContributor contributor) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(28);
        }
        if (psiFile == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(29);
        }
        if (contributor == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(30);
        }
        SmartList result = new SmartList();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        NotNullLazyValue includeTestScope = NotNullLazyValue.lazy(() -> ProjectFileIndex.getInstance((Project)module.getProject()).isInTestSourceContent(virtualFile));
        for (SpringBootConfigImportStatement importStatement : contributor.getImportStatements(psiFile.getProject(), virtualFile)) {
            String valueText = importStatement.filePointerText();
            if (StringUtil.isEmpty((String)valueText)) continue;
            List values = StringUtil.split((String)valueText, (String)",");
            for (String value : values) {
                VirtualFile importedFile = SpringBootConfigurationFileServiceImpl.findImport(value, module, virtualFile, (NotNullLazyValue<Boolean>)includeTestScope);
                if (importedFile == null) continue;
                result.add(new SpringBootConfigImportImpl(importedFile, importStatement.documentId()));
            }
        }
        return result;
    }

    private static VirtualFile findImport(String value, Module module, VirtualFile virtualFile, NotNullLazyValue<Boolean> includeTestScope) {
        Object roots;
        value = value.trim();
        if ((value = StringUtil.trimStart((String)value, (String)"optional:")).startsWith("configtree:")) {
            return null;
        }
        if (value.startsWith("file:")) {
            PsiDirectory psiDirectory;
            value = value.substring("file:".length());
            VirtualFile contentRoot = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getContentRootForFile(virtualFile);
            PsiDirectory psiDirectory2 = psiDirectory = contentRoot == null ? null : PsiManager.getInstance((Project)module.getProject()).findDirectory(contentRoot);
            roots = psiDirectory == null ? Collections.emptyList() : new SmartList((Object)psiDirectory);
        } else {
            value = StringUtil.trimStart((String)value, (String)"classpath:");
            roots = ConfigReferenceProvider.getClasspathRoots(module, (Boolean)includeTestScope.getValue());
        }
        value = StringUtil.trimStart((String)value, (String)"/");
        List segments = StringUtil.split((String)value, (String)"/");
        for (PsiDirectory root : roots) {
            VirtualFile file = SpringBootConfigurationFileServiceImpl.findFile(root, segments);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static VirtualFile findFile(PsiDirectory root, List<String> segments) {
        ArrayDeque<String> queue = new ArrayDeque<String>(segments);
        while (!queue.isEmpty()) {
            String segment = (String)queue.poll();
            if (queue.isEmpty()) {
                PsiFile file = root.findFile(segment);
                return file == null ? null : file.getVirtualFile();
            }
            if ((root = root.findSubdirectory(segment)) != null) continue;
            return null;
        }
        return null;
    }

    @Nullable
    private static MetaConfigKey getSpringConfigImportKey(@NotNull Module module) {
        if (module == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(31);
        }
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_4_0)) {
            return null;
        }
        return SpringBootApplicationMetaConfigKeyManager.getInstance().createFakeConfigKey(module, "spring.config.import");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameContributor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootConfigurationFileServiceImpl";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootConfigurationFileServiceImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFilesDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicationConfigurationFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationConfigurationFileIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findConfigFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findConfigFilesWithImports";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFilesDependencies";
                break;
            }
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doFindConfigFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectImports";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImports";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doGetImports";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSpringConfigImportKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }

    private static class ConfigFileCacheKey {
        private final SpringBootModelConfigFileNameContributor nameContributor;
        private final Set<String> activeProfiles;
        private final boolean includeTestSources;
        private final boolean includeDefault;

        private ConfigFileCacheKey(SpringBootModelConfigFileNameContributor nameContributor, Set<String> activeProfiles, boolean includeTestSources, boolean includeDefault) {
            this.nameContributor = nameContributor;
            this.activeProfiles = activeProfiles;
            this.includeTestSources = includeTestSources;
            this.includeDefault = includeDefault;
        }

        private ConfigFileCacheKey(SpringBootModelConfigFileNameContributor nameContributor, boolean includeTestSources) {
            this.nameContributor = nameContributor;
            this.includeTestSources = includeTestSources;
            this.includeDefault = true;
            this.activeProfiles = Collections.emptySet();
        }

        private SpringBootModelConfigFileNameContributor getNameContributor() {
            return this.nameContributor;
        }

        private Set<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        private boolean isIncludeTestSources() {
            return this.includeTestSources;
        }

        private boolean isIncludeDefault() {
            return this.includeDefault;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof ConfigFileCacheKey)) {
                return false;
            }
            ConfigFileCacheKey key = (ConfigFileCacheKey)o;
            return this.isIncludeTestSources() == key.isIncludeTestSources() && this.getNameContributor().equals(key.getNameContributor()) && this.getActiveProfiles().equals(key.getActiveProfiles());
        }

        public int hashCode() {
            int result = this.getNameContributor().hashCode();
            result = 31 * result + this.getActiveProfiles().hashCode();
            result = 31 * result + Boolean.hashCode(this.isIncludeTestSources());
            return result;
        }
    }

    private static class SpringBootConfigImportImpl
    implements SpringBootConfigImport {
        private final VirtualFile myVirtualFile;
        private final int myDocumentId;

        SpringBootConfigImportImpl(@NotNull VirtualFile virtualFile, int documentId) {
            if (virtualFile == null) {
                SpringBootConfigImportImpl.$$$reportNull$$$0(0);
            }
            this.myVirtualFile = virtualFile;
            this.myDocumentId = documentId;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                SpringBootConfigImportImpl.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        public int getDocumentId() {
            return this.myDocumentId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/model/SpringBootConfigurationFileServiceImpl$SpringBootConfigImportImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/model/SpringBootConfigurationFileServiceImpl$SpringBootConfigImportImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

