/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnProperty;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnPropertyEvaluator;", "", "myConditionalOnProperty", "Lcom/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnProperty;", "myContext", "Lcom/intellij/spring/boot/model/autoconfigure/conditions/ConditionalOnEvaluationContext;", "<init>", "(Lcom/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnProperty;Lcom/intellij/spring/boot/model/autoconfigure/conditions/ConditionalOnEvaluationContext;)V", "matches", "Lcom/intellij/spring/boot/model/autoconfigure/conditions/ConditionOutcome;", "valueMatches", "", "configurationValue", "", "intellij.spring.boot.core"})
public final class ConditionalOnPropertyEvaluator {
    @NotNull
    private final ConditionalOnProperty myConditionalOnProperty;
    @NotNull
    private final ConditionalOnEvaluationContext myContext;

    public ConditionalOnPropertyEvaluator(@NotNull ConditionalOnProperty myConditionalOnProperty, @NotNull ConditionalOnEvaluationContext myContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)myConditionalOnProperty), (String)"myConditionalOnProperty");
        Intrinsics.checkNotNullParameter((Object)myContext, (String)"myContext");
        this.myConditionalOnProperty = myConditionalOnProperty;
        this.myContext = myContext;
    }

    @NotNull
    public final ConditionOutcome matches() {
        ConditionOutcome conditionOutcome;
        String message;
        Module module = this.myContext.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        Module module2 = module;
        List<MetaConfigKey> keys = this.myConditionalOnProperty.getResolvedMetaConfigKeys(module2);
        if (keys.isEmpty()) {
            if (this.myConditionalOnProperty.isMatchIfMissing()) {
                ConditionOutcome conditionOutcome2 = ConditionOutcome.match((String)"Could not resolve property");
                Intrinsics.checkNotNullExpressionValue((Object)conditionOutcome2, (String)"match(...)");
                return conditionOutcome2;
            }
            ConditionOutcome conditionOutcome3 = ConditionOutcome.noMatch((String)"Could not resolve property");
            Intrinsics.checkNotNullExpressionValue((Object)conditionOutcome3, (String)"noMatch(...)");
            return conditionOutcome3;
        }
        int keysCount = keys.size();
        Ref.IntRef foundKeys = new Ref.IntRef();
        Ref matched = new Ref((Object)false);
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref conditionMessage = ref;
        Processor processor = arg_0 -> ConditionalOnPropertyEvaluator.matches$lambda$0(foundKeys, matched, this, conditionMessage, arg_0);
        for (MetaConfigKey key : keys) {
            matched.set((Object)false);
            boolean result = this.myContext.processConfigurationValues(processor, this.myConditionalOnProperty.isRelaxedNames(), key);
            if (result || ((Boolean)matched.get()).booleanValue()) continue;
            ConditionOutcome conditionOutcome4 = ConditionOutcome.noMatch((ConditionMessage)((ConditionMessage)conditionMessage.get()));
            Intrinsics.checkNotNullExpressionValue((Object)conditionOutcome4, (String)"noMatch(...)");
            return conditionOutcome4;
        }
        if (keys.size() == 1 && conditionMessage.get() != null) {
            ConditionOutcome conditionOutcome5;
            if (((Boolean)matched.get()).booleanValue()) {
                ConditionOutcome conditionOutcome6 = ConditionOutcome.match((ConditionMessage)((ConditionMessage)conditionMessage.get()));
                conditionOutcome5 = conditionOutcome6;
                Intrinsics.checkNotNullExpressionValue((Object)conditionOutcome6, (String)"match(...)");
            } else {
                ConditionOutcome conditionOutcome7 = ConditionOutcome.noMatch((ConditionMessage)((ConditionMessage)conditionMessage.get()));
                conditionOutcome5 = conditionOutcome7;
                Intrinsics.checkNotNullExpressionValue((Object)conditionOutcome7, (String)"noMatch(...)");
            }
            return conditionOutcome5;
        }
        if (keysCount == foundKeys.element) {
            ConditionOutcome conditionOutcome8 = ConditionOutcome.match((String)"All properties matched");
            Intrinsics.checkNotNullExpressionValue((Object)conditionOutcome8, (String)"match(...)");
            return conditionOutcome8;
        }
        String string = message = foundKeys.element == 0 ? "No properties defined" : foundKeys.element + " properties matched, " + (keysCount - foundKeys.element) + " properties not defined";
        if (this.myConditionalOnProperty.isMatchIfMissing()) {
            ConditionOutcome conditionOutcome9 = ConditionOutcome.match((String)message);
            conditionOutcome = conditionOutcome9;
            Intrinsics.checkNotNullExpressionValue((Object)conditionOutcome9, (String)"match(...)");
        } else {
            ConditionOutcome conditionOutcome10 = ConditionOutcome.noMatch((String)message);
            conditionOutcome = conditionOutcome10;
            Intrinsics.checkNotNullExpressionValue((Object)conditionOutcome10, (String)"noMatch(...)");
        }
        return conditionOutcome;
    }

    private final boolean valueMatches(String configurationValue) {
        String havingValue = this.myConditionalOnProperty.getHavingValue();
        CharSequence charSequence = havingValue;
        if (charSequence == null || charSequence.length() == 0) {
            return !StringsKt.equals((String)"false", (String)configurationValue, (boolean)true);
        }
        return StringsKt.equals((String)havingValue, (String)configurationValue, (boolean)true);
    }

    private static final boolean matches$lambda$0(Ref.IntRef $foundKeys, Ref $matched, ConditionalOnPropertyEvaluator this$0, Ref $conditionMessage, List configurationValues) {
        Intrinsics.checkNotNull((Object)configurationValues);
        if (!((Collection)configurationValues).isEmpty()) {
            int n = $foundKeys.element;
            $foundKeys.element = n + 1;
            ConfigurationValueResult configurationValueResult = (ConfigurationValueResult)configurationValues.get(0);
            $matched.set((Object)this$0.valueMatches(configurationValueResult.getValueText()));
            $conditionMessage.set((Object)ConditionMessage.foundConfigKeyWithValue((String)configurationValueResult.getConfigKey().getName(), (String)configurationValueResult.getValueText()));
            return false;
        }
        return true;
    }
}

