/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringCustomBeanScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ConditionalOnWebApplication
implements ConditionalOnJamElement {
    private static final JamEnumAttributeMeta.Single<Type> TYPE_ATTRIBUTE_META = JamAttributeMeta.singleEnum((String)"type", Type.class);
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication").addAttribute(TYPE_ATTRIBUTE_META);
    private static final SemKey<ConditionalOnWebApplication> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnWebApplication", new SemKey[0]);
    public static final JamClassMeta<ConditionalOnWebApplication> CLASS_META = new JamClassMeta(null, ConditionalOnWebApplication::new, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnWebApplication> METHOD_META = new JamMethodMeta(null, ConditionalOnWebApplication::new, SEM_KEY).addAnnotation(ANNOTATION_META);
    private static final String WEB_APPLICATION_CONTEXT = "org.springframework.web.context.support.GenericWebApplicationContext";
    private static final Condition<SpringBeanScope> SESSION_SCOPE = scope -> scope.getValue().equals("session");
    private static final Key<ConditionOutcome> SERVLET_CONDITION_KEY = Key.create((String)"servlet");
    private static final Function<ConditionalOnEvaluationContext, ConditionOutcome> SERVLET_CONDITION = context -> {
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)WEB_APPLICATION_CONTEXT) != null) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.foundClass((String)WEB_APPLICATION_CONTEXT));
        }
        boolean hasSessionScope = ConditionalOnWebApplication.hasSessionScope(context.getAutoConfigClass());
        if (hasSessionScope) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.found((String)"scope", (String[])new String[]{"session"}));
        }
        return ConditionOutcome.noMatch((String)"Not a web application");
    };
    @NonNls
    private static final String WEB_FLUX_CONFIGURER = "org.springframework.web.reactive.config.WebFluxConfigurer";
    @NonNls
    private static final String WEB_MVC_CONFIGURER = "org.springframework.web.servlet.config.annotation.WebMvcConfigurer";
    @NonNls
    private static final String WEB_APPLICATION_TYPE_KEY = "spring.main.web-application-type";
    private static final Key<ConditionOutcome> REACTIVE_CONDITION_KEY = Key.create((String)"reactive");
    private static final Function<ConditionalOnEvaluationContext, ConditionOutcome> REACTIVE_CONDITION = context -> {
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)"reactor.core.publisher.Flux") == null || SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)WEB_FLUX_CONFIGURER) == null) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.didNotFind((String)"library", (String[])new String[]{"Flux/Reactor"}));
        }
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)WEB_MVC_CONFIGURER) == null) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.found((String)"library", (String[])new String[]{"Flux/Reactor"}));
        }
        boolean exists = !context.processConfigurationValues(results -> !ContainerUtil.exists((Iterable)results, result -> Comparing.strEqual((String)Type.REACTIVE.name(), (String)result.getValueText(), (boolean)false)), true, WEB_APPLICATION_TYPE_KEY);
        return exists ? ConditionOutcome.match((ConditionMessage)ConditionMessage.foundConfigKeyWithValue((String)WEB_APPLICATION_TYPE_KEY, (String)"reactive")) : ConditionOutcome.noMatch((String)"Not a reactive web application");
    };
    private final PsiElementRef<PsiAnnotation> myAnnotationRef;

    private static boolean hasSessionScope(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ConditionalOnWebApplication.$$$reportNull$$$0(0);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)aClass.getProject());
        for (SpringCustomBeanScope customBeanScope : (SpringCustomBeanScope[])SpringCustomBeanScope.EP_NAME.getExtensions()) {
            PsiClass scopeClass = javaPsiFacade.findClass(customBeanScope.getScopeClassName(), aClass.getResolveScope());
            if (scopeClass == null) continue;
            ArrayList customScopes = new ArrayList();
            customBeanScope.process(customScopes, Collections.emptySet(), scopeClass, (PsiElement)aClass);
            if (!ContainerUtil.exists(customScopes, SESSION_SCOPE)) continue;
            return true;
        }
        return false;
    }

    private ConditionalOnWebApplication(PsiElementRef<?> psiRef) {
        PsiModifierListOwner owner = (PsiModifierListOwner)Objects.requireNonNull(psiRef.getPsiElement());
        this.myAnnotationRef = ANNOTATION_META.getAnnotationRef(owner);
    }

    @NotNull
    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        if (this.getType() == Type.ANY) {
            ConditionOutcome servletOutcome = ConditionalOnWebApplication.getServletOutcome(context);
            if (servletOutcome.isMatch() || SpringBootLibraryUtil.isBelowVersion((Module)context.getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0)) {
                ConditionOutcome conditionOutcome = servletOutcome;
                if (conditionOutcome == null) {
                    ConditionalOnWebApplication.$$$reportNull$$$0(1);
                }
                return conditionOutcome;
            }
            ConditionOutcome reactiveOutcome = ConditionalOnWebApplication.getReactiveOutcome(context);
            if (reactiveOutcome.isMatch()) {
                ConditionOutcome conditionOutcome = reactiveOutcome;
                if (conditionOutcome == null) {
                    ConditionalOnWebApplication.$$$reportNull$$$0(2);
                }
                return conditionOutcome;
            }
            ConditionOutcome conditionOutcome = ConditionOutcome.noMatch((String)"Not a (reactive) web application");
            if (conditionOutcome == null) {
                ConditionalOnWebApplication.$$$reportNull$$$0(3);
            }
            return conditionOutcome;
        }
        if (this.getType() == Type.REACTIVE) {
            return ConditionalOnWebApplication.getReactiveOutcome(context);
        }
        return ConditionalOnWebApplication.getServletOutcome(context);
    }

    @NotNull
    static ConditionOutcome getServletOutcome(ConditionalOnEvaluationContext context) {
        return ConditionalOnWebApplication.calcOrGetCached(context, SERVLET_CONDITION_KEY, SERVLET_CONDITION);
    }

    @NotNull
    static ConditionOutcome getReactiveOutcome(ConditionalOnEvaluationContext context) {
        return ConditionalOnWebApplication.calcOrGetCached(context, REACTIVE_CONDITION_KEY, REACTIVE_CONDITION);
    }

    @NotNull
    private static ConditionOutcome calcOrGetCached(ConditionalOnEvaluationContext context, Key<ConditionOutcome> key, Function<ConditionalOnEvaluationContext, ConditionOutcome> condition) {
        ConditionOutcome conditionOutcome = (ConditionOutcome)ConcurrencyUtil.computeIfAbsent((UserDataHolder)context, key, () -> (ConditionOutcome)condition.fun((Object)context));
        if (conditionOutcome == null) {
            ConditionalOnWebApplication.$$$reportNull$$$0(4);
        }
        return conditionOutcome;
    }

    @NotNull
    public Type getType() {
        Type type = (Type)TYPE_ATTRIBUTE_META.getJam(this.myAnnotationRef).getValue();
        if (type != null) {
            Type type2 = type;
            if (type2 == null) {
                ConditionalOnWebApplication.$$$reportNull$$$0(5);
            }
            return type2;
        }
        Type type3 = Type.ANY;
        if (type3 == null) {
            ConditionalOnWebApplication.$$$reportNull$$$0(6);
        }
        return type3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnWebApplication";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnWebApplication";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "matches";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcOrGetCached";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasSessionScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static enum Type {
        ANY,
        SERVLET,
        REACTIVE;

    }
}

