/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.spi;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.spring.boot.spi.SpringBootImportsFileIndexKt;
import com.intellij.spring.boot.spi.SpringBootImportsFileType;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootImportsReferencesSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "p", "consumer", "Lcom/intellij/util/Processor;", "intellij.spring.boot.core"})
public final class SpringBootImportsReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SpringBootImportsReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiElement psiElement = p.getElementToSearch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
        PsiElement element = psiElement;
        if (!element.isValid()) {
            return;
        }
        SearchScope searchScope = p.getEffectiveSearchScope();
        GlobalSearchScope globalSearchScope = searchScope instanceof GlobalSearchScope ? (GlobalSearchScope)searchScope : null;
        if (globalSearchScope == null) {
            return;
        }
        GlobalSearchScope scope = globalSearchScope;
        SmartList names = new SmartList();
        if (element instanceof PsiClass) {
            String string = ((PsiClass)element).getQualifiedName();
            if (string == null) {
                return;
            }
            String name = string;
            names.add((Object)name);
            String string2 = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element));
            if (string2 == null) {
                return;
            }
            String jvmClassName = string2;
            if (!Intrinsics.areEqual((Object)jvmClassName, (Object)name)) {
                names.add((Object)jvmClassName);
            }
        } else if (element instanceof PsiPackage) {
            names.add((Object)((PsiPackage)element).getQualifiedName());
        }
        if (names.isEmpty()) {
            return;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GlobalSearchScope globalSearchScope2 = SpringBootImportsFileIndexKt.adjustSpringBootImportsScope(project, scope);
        if (globalSearchScope2 == null) {
            return;
        }
        GlobalSearchScope adjustedScope = globalSearchScope2;
        FileTypeIndex.processFiles((FileType)((FileType)SpringBootImportsFileType.INSTANCE), arg_0 -> SpringBootImportsReferencesSearcher.processQuery$lambda$0(names, element, consumer, arg_0), (GlobalSearchScope)adjustedScope);
    }

    private static final boolean processQuery$lambda$0(SmartList $names, PsiElement $element, Processor $consumer, VirtualFile it) {
        Iterator iterator = $names.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            PsiReference[] psiReferenceArray;
            PsiFile psiFile;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String name = (String)e;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)name, (boolean)false, (int)2, null)) continue;
            if ($element.getManager().findFile(it) == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile.getReferences(), (String)"getReferences(...)");
            for (PsiReference reference : psiReferenceArray) {
                if (!Intrinsics.areEqual((Object)reference.getCanonicalText(), (Object)name) || $consumer.process((Object)reference)) continue;
                return false;
            }
        }
        return true;
    }
}

