/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.agent.documentation.DockerDocumentationElement;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.docker.composeFile.dsl.YamlModelBuilder;
import com.intellij.docker.composeFile.model.ComposeMetaTypeProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlDocumentationProviderBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0015J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/composeFile/ComposeDocumentationProvider;", "Lorg/jetbrains/yaml/meta/impl/YamlDocumentationProviderBase;", "<init>", "()V", "isRelevant", "", "element", "Lcom/intellij/psi/PsiElement;", "getDocumentation", "", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "field", "Lorg/jetbrains/yaml/meta/model/Field;", "getMetaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "intellij.clouds.docker.compose"})
public final class ComposeDocumentationProvider
extends YamlDocumentationProviderBase {
    protected boolean isRelevant(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
        if (yAMLFile == null) {
            return false;
        }
        return ComposeFileUtil.isDockerComposeYamlFile(yAMLFile);
    }

    @NlsSafe
    @Nullable
    protected String getDocumentation(@NotNull Project project, @NotNull YamlMetaType type, @Nullable Field field) {
        DockerDocumentationElement description;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        YamlModelBuilder.FieldWithDescription fieldWithDescription = field instanceof YamlModelBuilder.FieldWithDescription ? (YamlModelBuilder.FieldWithDescription)field : null;
        DockerDocumentationElement dockerDocumentationElement = description = fieldWithDescription != null ? fieldWithDescription.getDescription() : null;
        if (description != null) {
            DockerDocumentationElement it = description;
            boolean bl = false;
            List<String> list = it.getExamples();
            List examples = list != null ? UtilKt.nullize(list) : null;
            String examplesElement = examples == null ? "" : StringsKt.trimIndent((String)("\n          <br>\n          <blockquote>" + CollectionsKt.joinToString$default((Iterable)examples, (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null) + "</blockquote>\n        "));
            return "\n        <p>" + it.getDescription() + "</p>\n        " + examplesElement + "\n      ";
        }
        return null;
    }

    @Nullable
    protected YamlMetaTypeProvider getMetaTypeProvider(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ComposeMetaTypeProvider.getInstance();
    }
}

