/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.kubernetes;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\b\u001a\u00020\tH\u0002\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"KUBERNETES_PLUGIN_ID", "", "KUBERNETES_PLUGIN_NAME", "KUBERNETES_FILES", "KUBERNETES_SUGGESTION_DISMISSED_KEY", "KUBERNETES_SUGGESTION_ADD_MENU_DISMISSED_KEY", "IDE_CODES_FOR_PROMOTION", "", "dismissPluginSuggestion", "", "isPluginSuggestionDismissed", "", "detectKubernetesResource", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isKubernetesYaml", "Lcom/intellij/psi/PsiFile;", "computeKubernetesYaml", "isKubernetesDocument", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "getKeyValueByKeyIgnoreSpaces", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "keyText", "intellij.clouds.docker.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSuggestionProvider.kt\ncom/intellij/docker/kubernetes/KubernetesSuggestionProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n296#2,2:149\n*S KotlinDebug\n*F\n+ 1 KubernetesSuggestionProvider.kt\ncom/intellij/docker/kubernetes/KubernetesSuggestionProviderKt\n*L\n147#1:149,2\n*E\n"})
public final class KubernetesSuggestionProviderKt {
    @NotNull
    public static final String KUBERNETES_PLUGIN_ID = "com.intellij.kubernetes";
    @NotNull
    private static final String KUBERNETES_PLUGIN_NAME = "Kubernetes";
    @NotNull
    private static final String KUBERNETES_FILES = "Kubernetes";
    @NotNull
    private static final String KUBERNETES_SUGGESTION_DISMISSED_KEY = "promo.kubernetes.suggestion.dismissed";
    @NotNull
    public static final String KUBERNETES_SUGGESTION_ADD_MENU_DISMISSED_KEY = "promo.kubernetes.suggestion.dummy.node.dismissed";
    @NotNull
    private static final Set<String> IDE_CODES_FOR_PROMOTION;

    private static final void dismissPluginSuggestion() {
        PropertiesComponent.getInstance().setValue(KUBERNETES_SUGGESTION_DISMISSED_KEY, true);
    }

    private static final boolean isPluginSuggestionDismissed() {
        return PropertiesComponent.getInstance().isTrueValue(KUBERNETES_SUGGESTION_DISMISSED_KEY);
    }

    private static final boolean detectKubernetesResource(Project project, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return KubernetesSuggestionProviderKt.isKubernetesYaml(psiFile);
    }

    private static final boolean isKubernetesYaml(PsiFile file) {
        if (!(file instanceof YAMLFile)) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> KubernetesSuggestionProviderKt.isKubernetesYaml$lambda$0(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean computeKubernetesYaml(PsiFile file) {
        if (!(file instanceof YAMLFile)) return false;
        List list = ((YAMLFile)file).getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
        if (!KubernetesSuggestionProviderKt.isKubernetesDocument((YAMLDocument)CollectionsKt.firstOrNull((List)list))) return false;
        return true;
    }

    private static final boolean isKubernetesDocument(YAMLDocument document) {
        YAMLDocument yAMLDocument = document;
        YAMLValue yAMLValue = yAMLDocument != null ? yAMLDocument.getTopLevelValue() : null;
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return false;
        }
        YAMLMapping topMapping = yAMLMapping;
        YAMLKeyValue kindKeyVal = KubernetesSuggestionProviderKt.getKeyValueByKeyIgnoreSpaces(topMapping, "kind");
        YAMLKeyValue apiVersionKeyVal = KubernetesSuggestionProviderKt.getKeyValueByKeyIgnoreSpaces(topMapping, "apiVersion");
        return kindKeyVal != null && apiVersionKeyVal != null;
    }

    private static final YAMLKeyValue getKeyValueByKeyIgnoreSpaces(YAMLMapping $this$getKeyValueByKeyIgnoreSpaces, String keyText) {
        Object v2;
        block1: {
            Collection collection = $this$getKeyValueByKeyIgnoreSpaces.getKeyValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeyValues(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YAMLKeyValue it = (YAMLKeyValue)element$iv;
                boolean bl = false;
                String string = it.getKeyText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
                if (!(keyText.compareTo(((Object)StringsKt.trim((CharSequence)string)).toString()) == 0)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final CachedValueProvider.Result isKubernetesYaml$lambda$0(PsiFile $file) {
        Object[] objectArray = new Object[]{$file};
        return new CachedValueProvider.Result((Object)KubernetesSuggestionProviderKt.computeKubernetesYaml($file), objectArray);
    }

    public static final /* synthetic */ boolean access$isPluginSuggestionDismissed() {
        return KubernetesSuggestionProviderKt.isPluginSuggestionDismissed();
    }

    public static final /* synthetic */ Set access$getIDE_CODES_FOR_PROMOTION$p() {
        return IDE_CODES_FOR_PROMOTION;
    }

    public static final /* synthetic */ boolean access$detectKubernetesResource(Project project, VirtualFile file) {
        return KubernetesSuggestionProviderKt.detectKubernetesResource(project, file);
    }

    public static final /* synthetic */ void access$dismissPluginSuggestion() {
        KubernetesSuggestionProviderKt.dismissPluginSuggestion();
    }

    static {
        Object[] objectArray = new String[]{"WS", "RM", "PY", "PS", "GO", "CL", "RD", "IU", "IC", "PC", "AS"};
        IDE_CODES_FOR_PROMOTION = SetsKt.setOf((Object[])objectArray);
    }
}

